/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.spark.historyserver;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.util.DKUNetUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dip.webapps.backend.NginxUtils;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.CloseableHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;

public class SparkHistoryServerHandle {
    public final String id;
    private final String folder;
    private final String password;
    private final File nginxConfigFile;
    private final int port;
    private final String locationPath;
    private final String accessCheckURL;
    private DKUtils.ExecWaitingThread monitorThread;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.spark.history");

    public SparkHistoryServerHandle(String projectKey, String jobId, String activityId, String historyServerId, String folder) throws IOException {
        this.id = historyServerId;
        this.folder = folder;
        this.password = SecretKeyGenerator.generate((int)16);
        this.locationPath = "/spark-history-server-proxy/" + historyServerId;
        this.port = DKUNetUtils.findUnusedPort();
        this.nginxConfigFile = DKUApp.getFile((String)("install-support/backends.d/" + projectKey + "/sparkhistory-" + historyServerId + ".conf"));
        this.accessCheckURL = "http://127.0.0.1:" + RemoteRunNetworkingUtils.getBackendPortForLocalAccess() + "/dip/api/spark/check-history-server-access/" + projectKey + "/" + jobId + "/" + activityId;
    }

    public void start() throws InterruptedException, IOException {
        File sparkClassFile = new File(System.getenv("DKU_SPARK_HOME"), "bin/spark-class");
        if (!sparkClassFile.exists()) {
            throw new IllegalArgumentException("No spark-class found at " + sparkClassFile.getAbsolutePath());
        }
        ProcessBuilder pb = new ProcessBuilder(sparkClassFile.getAbsolutePath(), "org.apache.spark.deploy.history.HistoryServer");
        ArrayList jars = Lists.newArrayList((Object[])new String[]{"dataiku-app-platform.jar", "dataiku-core.jar", "dataiku-spark-authentication-filter.jar"});
        List jarPaths = jars.stream().map(n -> DKUApp.getInstallFile((String[])new String[]{"dist", n}).getAbsolutePath()).collect(Collectors.toList());
        pb.environment().put("SPARK_DAEMON_CLASSPATH", jarPaths.stream().collect(Collectors.joining(File.pathSeparator)));
        ArrayList opts = Lists.newArrayList();
        opts.add("-Dspark.ui.filters=com.dataiku.dip.security.EnvironmentBasedBasicAuthFilter");
        opts.add("-Dspark.history.fs.logDirectory=" + this.folder);
        opts.add("-Dspark.history.ui.port=" + this.port);
        opts.add("-Dspark.ui.proxyBase=" + this.locationPath);
        if (DKUApp.getParams().getBoolParam("dku.spark.historyServer.fixupRedirectURI", true) && StringUtils.isNotBlank((CharSequence)ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().studioExternalUrl)) {
            opts.add("-Dspark.ui.proxyRedirectUri=" + ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().studioExternalUrl);
        }
        pb.environment().put("SPARK_HISTORY_OPTS", opts.stream().collect(Collectors.joining(" ")));
        pb.environment().put("SPARK_DAEMON_MEMORY", DKUApp.getParams().getParam("dku.spark.historyServer.xmx", "128m"));
        pb.environment().put("DKU_BASIC_AUTH_FILTER_USER", "dataiku");
        pb.environment().put("DKU_BASIC_AUTH_FILTER_PASSWORD", this.password);
        DKUtils.ExecBuilder builder = new DKUtils.ExecBuilder().withProcessBuilder(pb).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.WARN));
        this.monitorThread = new DKUtils.ExecWaitingThread(builder);
        this.monitorThread.start();
        try (CloseableHttpClient client = HttpClientBuilder.create().addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR).build();){
            for (int i = 0; i < 50; ++i) {
                try {
                    client.execute((HttpUriRequest)new HttpGet("http://127.0.0.1:" + this.port));
                    break;
                }
                catch (IOException e) {
                    logger.info((Object)("Spark history server not up yet: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                    Thread.sleep(500L);
                    continue;
                }
            }
        }
    }

    public void stop() throws IOException, InterruptedException {
        this.monitorThread.abort();
        DKUFileUtils.mkdirsParent((File)this.nginxConfigFile);
        DKUFileUtils.forceDelete((File)this.nginxConfigFile);
        NginxUtils.hupNginx();
    }

    public void enableProxy() throws IOException, InterruptedException {
        String authorizationHeader = "Basic " + Base64.encodeBase64String((byte[])("dataiku:" + this.password).getBytes(StandardCharsets.UTF_8));
        String proxyTarget = "http://127.0.0.1:" + this.port;
        com.dataiku.dip.utils.NginxUtils.ensureSafe((String)this.id);
        String authId = "auth_" + SecretKeyGenerator.generate((int)6);
        String protectedLocation = "location ^~ " + this.locationPath + "/ {\n  resolver 127.0.0.1;\n  proxy_pass " + proxyTarget + "/;\n  proxy_set_header Authorization \"" + authorizationHeader + "\";\n  proxy_next_upstream off; # Don't retry\n  proxy_read_timeout 3600; # We have long queries\n  auth_request /" + authId + ";\n  auth_request_set $auth_studiourl $upstream_http_x_dku_studiourl;\n  error_page 502 /spark-history-server-error-502.html;\n  error_page 401 /spark-history-server-error-401.html;\n  error_page 403 /spark-history-server-error-403.html;\n}\n\n";
        String authLocation = "location = /" + authId + " {\n  proxy_pass " + this.accessCheckURL + ";\n  proxy_pass_request_body off;\n  proxy_set_header Content-Type \"\";\n  proxy_set_header X-Original-URI $request_uri;\n}";
        ArrayList configs = Lists.newArrayList((Object[])new String[]{protectedLocation, authLocation});
        DKUFileUtils.mkdirsParent((File)this.nginxConfigFile);
        DKUFileUtils.writeFileUTF8((File)this.nginxConfigFile, (String)Joiner.on((String)"\n\n").join((Iterable)configs));
        NginxUtils.hupNginx();
    }
}

