/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.eda.compute.filtering.AllFilter;
import com.dataiku.dip.eda.compute.filtering.AnumFilter;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.filtering.IntervalFilter;
import com.dataiku.dip.eda.compute.filtering.MissingValueFilter;
import com.dataiku.dip.recipes.eda.FilterFormatter;
import java.util.Objects;

public class SplitByFilterRowFiller {
    private final ColumnFactory cf;

    public SplitByFilterRowFiller(ColumnFactory cf) {
        this.cf = cf;
    }

    public void fill(Row row, Filter filter) {
        if (filter instanceof AllFilter) {
            row.put(this.cf.column("split_mode"), "ALL_ROWS");
            return;
        }
        if (filter instanceof AnumFilter) {
            AnumFilter anumFilter = (AnumFilter)filter;
            row.put(this.cf.column("split_mode"), "CATEGORY");
            row.put(this.cf.column("split_by"), anumFilter.column);
            row.put(this.cf.column("split_value"), FilterFormatter.formatValue(anumFilter));
            return;
        }
        if (filter instanceof IntervalFilter) {
            IntervalFilter intervalFilter = (IntervalFilter)filter;
            row.put(this.cf.column("split_mode"), "INTERVAL");
            row.put(this.cf.column("split_by"), intervalFilter.column);
            row.put(this.cf.column("split_value"), FilterFormatter.formatValue(intervalFilter));
            return;
        }
        if (filter instanceof MissingValueFilter) {
            MissingValueFilter missingValueFilter = (MissingValueFilter)filter;
            row.put(this.cf.column("split_mode"), "MISSING_VALUES");
            row.put(this.cf.column("split_by"), missingValueFilter.column);
            return;
        }
        if (Objects.equals(filter.name, "Others")) {
            row.put(this.cf.column("split_mode"), "OTHER_ROWS");
            return;
        }
        throw new IllegalArgumentException(String.format("Unexpected filter resulting from split-by: %s", ((Object)((Object)filter)).getClass().getSimpleName()));
    }
}

