/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.merge_folder;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.merge_folder.MergeFolderRecipeExecutor;
import com.dataiku.dip.recipes.merge_folder.MergeFolderRecipeParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.DKUIOUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class MergeFolderRecipeStreamExecutor
implements MergeFolderRecipeExecutor {
    @Autowired
    private JobAuthCtxService authCtxService;
    private final JobActivity activity;
    protected MergeFolderRecipeParams params;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.flow.recipe.executor.stream.merge_folder");

    public MergeFolderRecipeStreamExecutor(JobActivity activity, MergeFolderRecipeParams params) {
        SpringUtils.getInstance().autowire((Object)this);
        this.activity = activity;
        this.params = params;
    }

    @Override
    public void run() throws Exception {
        RunnableSubgraph subgraph = this.activity.getSubgraph();
        FlowRecipe recipe = ((RecipeRunnableSubgraph)subgraph).getRecipe();
        ArrayList<FlowManagedFolder> inputFolders = new ArrayList<FlowManagedFolder>();
        for (FlowComputable input : recipe.getSources()) {
            if (input.getType() != FlowComputable.FCType.MANAGED_FOLDER) {
                throw new IllegalStateException("Merge Folder recipe only accepts folder as input");
            }
            inputFolders.add((FlowManagedFolder)input);
        }
        FlowComputable output = recipe.getTargets().get(0);
        if (output.getType() != FlowComputable.FCType.MANAGED_FOLDER) {
            throw new IllegalStateException("Merge Folder recipe requires a managed folder as output");
        }
        FlowManagedFolder outputFolder = (FlowManagedFolder)output;
        AuthCtx authCtx = this.authCtxService.getAuthCtx();
        this.activity.setStatusMessage("Copying files...");
        this.copyFiles(subgraph, inputFolders, outputFolder, authCtx);
        this.activity.setAllSourcesCompletelyRead();
        this.activity.setStatusMessage("Done");
    }

    private void copyFiles(RunnableSubgraph subgraph, List<FlowManagedFolder> inputFolders, FlowManagedFolder flowOutputFolder, AuthCtx authCtx) throws Exception {
        try (ManagedFolderHandler outputHandler = (ManagedFolderHandler)flowOutputFolder.getManagedFolder().buildHandler(authCtx);){
            Partition target = subgraph.getTargetPartition(flowOutputFolder);
            if (this.params.clearBeforeCopy) {
                outputHandler.delete(outputHandler.ensurePartitionFolder(target));
            }
            for (FlowComputable flowComputable : inputFolders) {
                ManagedFolder inputFolder = ((FlowManagedFolder)flowComputable).getManagedFolder();
                ManagedFolderHandler inputHandler = (ManagedFolderHandler)inputFolder.buildHandler(authCtx);
                try {
                    List<Partition> sources = subgraph.getSourcePartitions(flowComputable);
                    this.writePartition(inputHandler, outputHandler, sources, target);
                }
                finally {
                    if (inputHandler == null) continue;
                    inputHandler.close();
                }
            }
        }
    }

    private void writePartition(ManagedFolderHandler inputHandler, ManagedFolderHandler outputHandler, List<Partition> sources, Partition target) throws Exception {
        List<String> existingFiles = this.listExistingFiles(outputHandler, target);
        for (Partition source : sources) {
            ManagedFolderHandler.ManagedFolderListing sourceFiles = inputHandler.listFS(source, true, true);
            for (ManagedFolderHandler.ManagedFolderListingItem item : sourceFiles.items) {
                logger.info((Object)("Copying partition " + source.toString()));
                String inputPartitionPath = inputHandler.getFolder().isPartitioned() ? sourceFiles.partitionPrefix : "";
                String outputPartitionPath = outputHandler.getFolder().isPartitioned() ? outputHandler.ensurePartitionFolder(target) : "";
                String inputPath = inputPartitionPath + item.path;
                String outputPath = outputPartitionPath + this.buildOutputFileName(existingFiles, item.path);
                try (InputStream iStream = inputHandler.getInputStream(inputPath).rawStream();
                     OutputStream oStream = outputHandler.getOutputStream(outputPath);){
                    logger.info((Object)("Copying " + inputPath + " to " + outputPath));
                    DKUIOUtils.copyLarge(iStream, oStream, new ProgressCopyCallback(item.size));
                }
                existingFiles.add(this.getAsPath(outputPath));
            }
        }
    }

    private String buildOutputFileName(List<String> existingFiles, String path) throws Exception {
        if (existingFiles.contains(this.getAsPath(path))) {
            switch (this.params.conflictHandling) {
                case SUFFIX: {
                    return this.buildUniqueFileName(existingFiles, path);
                }
                case FAIL: {
                    throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, String.format("file %s already exists in output folder or in another input folder.", path));
                }
            }
        }
        return path;
    }

    private String buildUniqueFileName(List<String> existingFiles, String path) {
        int index = 1;
        String newPath = path;
        while (existingFiles.contains(this.getAsPath(newPath))) {
            newPath = this.addIndexToName(path, index);
            ++index;
        }
        return newPath;
    }

    private String addIndexToName(String path, int index) {
        String baseName = FilenameUtils.removeExtension((String)path);
        Object extension = FilenameUtils.getExtension((String)path);
        if (((String)extension).equals("gz") && !FilenameUtils.getExtension((String)baseName).isEmpty()) {
            extension = FilenameUtils.getExtension((String)baseName) + ".gz";
            baseName = FilenameUtils.removeExtension((String)baseName);
        } else if (((String)extension).isEmpty()) {
            return baseName + "_" + index;
        }
        return baseName + "_" + index + "." + (String)extension;
    }

    private List<String> listExistingFiles(ManagedFolderHandler outputHandler, Partition partition) throws DKUSecurityException, CodedException, IOException {
        ArrayList<String> existingFiles = new ArrayList<String>();
        partition = outputHandler.getFolder().isPartitioned() ? partition : Partition.newNP();
        for (ManagedFolderHandler.ManagedFolderListingItem item : outputHandler.listFS((Partition)partition, (boolean)true, (boolean)true).items) {
            existingFiles.add(this.getAsPath(item.path));
        }
        return existingFiles;
    }

    private String getAsPath(String str) {
        if (str.startsWith("/")) {
            return str;
        }
        return "/" + str;
    }

    @Override
    public void notifyBeforeAborting() {
    }

    protected static class ProgressCopyCallback
    implements DKUIOUtils.CopyCallback {
        private final long filesize;
        private long lastUpdate;

        public ProgressCopyCallback(long filesize) {
            this.filesize = filesize;
        }

        @Override
        public boolean update(long copied) {
            if (this.lastUpdate == 0L || copied - this.lastUpdate > 1000000L) {
                logger.info((Object)(copied + "/" + this.filesize + " bytes copied"));
                this.lastUpdate = copied;
            }
            return true;
        }
    }
}

