/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.python;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Objects;

public class FunctionCheckpoint
implements Comparable<FunctionCheckpoint> {
    public long run;
    public long idx;
    public Map<String, JsonElement> offsets = Maps.newHashMap();
    public FunctionCheckpoint min;

    public FunctionCheckpoint(long run, long idx) {
        this.run = run;
        this.idx = idx;
    }

    public FunctionCheckpoint(FunctionCheckpoint other) {
        this.run = other.run;
        this.idx = other.idx;
        this.offsets.putAll(other.offsets);
    }

    public FunctionCheckpoint withOffset(String fullId, long offset) {
        this.offsets.put(fullId, (JsonElement)new JsonPrimitive((Number)offset));
        return this;
    }

    public FunctionCheckpoint withOffset(String fullId, String offset) {
        this.offsets.put(fullId, (JsonElement)new JsonPrimitive(offset));
        return this;
    }

    public FunctionCheckpoint withOffset(String fullId, JsonElement offset) {
        this.offsets.put(fullId, offset);
        return this;
    }

    public FunctionCheckpoint withMin(FunctionCheckpoint min) {
        this.min = min;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.run, this.idx);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionCheckpoint other = (FunctionCheckpoint)obj;
        return this.idx == other.idx && this.run == other.run;
    }

    @Override
    public int compareTo(FunctionCheckpoint o) {
        if (o == null) {
            return 1;
        }
        if (o.run != this.run) {
            return (int)(this.run - o.run);
        }
        return (int)(this.idx - o.idx);
    }
}

