/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.sanitycheck.SanityCheckDetectorBase;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import com.dataiku.dip.sanitycheck.detectors.ExecutionException;
import com.dataiku.dip.sanitycheck.detectors.InstallationInformation;
import com.dataiku.dip.sanitycheck.detectors.PythonEnvironmentInformation;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.html.HtmlEscapers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class PythonCodeEnvDetector
implements SanityCheckDetectorBase {
    private final DesignNodeCodeEnvsService designNodeCodeEnvsService;
    private final AutomationNodeCodeEnvsService automationNodeCodeEnvsService;
    private final PythonEnvironmentInformation pythonEnvironmentInformation;
    private final InstallationInformation installationInformation;
    private final Map<Codes, Function<CodeEnvFacade, Stream<InfoMessage>>> codeToCheckFunctionMap = Map.of(Codes.WARN_MISC_CODE_ENV_USES_PYSPARK, this::generateManualPySparkInstallationMessages, Codes.WARN_MISC_CODE_ENV_DEPRECATED_INTERPRETER, this::generatePythonDeprecatedMessages);
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.sanitycheck.codeenvdetector");

    @Autowired
    PythonCodeEnvDetector(DesignNodeCodeEnvsService designNodeCodeEnvsService, AutomationNodeCodeEnvsService automationNodeCodeEnvsService, PythonEnvironmentInformation pythonEnvironmentInformation, InstallationInformation installationInformation) {
        this.designNodeCodeEnvsService = designNodeCodeEnvsService;
        this.automationNodeCodeEnvsService = automationNodeCodeEnvsService;
        this.pythonEnvironmentInformation = pythonEnvironmentInformation;
        this.installationInformation = installationInformation;
    }

    public List<InfoMessage.MessageCode> getCodes() {
        return Arrays.asList(Codes.values());
    }

    public SanityCheckInfoMessages runAnalysis(Set<String> exclusionList) {
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        if (exclusionList.containsAll(Arrays.stream(Codes.values()).map(InfoMessage.MessageCode::getCode).collect(Collectors.toList()))) {
            return messages;
        }
        try {
            List<Function<CodeEnvFacade, Stream<InfoMessage>>> checkList = this.buildChecksList(exclusionList);
            this.generateCodeEnvFacadesToBeChecked().flatMap(codeEnvFacade -> checkList.stream().flatMap(checkFunction -> (Stream)checkFunction.apply(codeEnvFacade))).forEach(arg_0 -> ((SanityCheckInfoMessages)messages).addMessage(arg_0));
        }
        catch (InternalException e) {
            messages.addMessage(this.createFatalMessage(e.getCause()));
        }
        messages.mergeFrom((InfoMessage.InfoMessages)this.analyzeBuiltinCodeEnv(exclusionList));
        return messages;
    }

    private List<Function<CodeEnvFacade, Stream<InfoMessage>>> buildChecksList(Set<String> exclusionList) {
        return this.codeToCheckFunctionMap.entrySet().stream().filter(entry -> !exclusionList.contains(((Codes)((Object)((Object)entry.getKey()))).getCode())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private Stream<CodeEnvFacade> generateCodeEnvFacadesToBeChecked() {
        try {
            switch (this.installationInformation.getNodeType()) {
                case DESIGN: {
                    return this.designNodeCodeEnvsService.listCodeEnvs().stream().filter(codEnv -> codEnv.envLang.equals((Object)CodeEnvModel.EnvLang.PYTHON)).map(this::buildDesignerNodeCodeEnvFacade);
                }
                case AUTOMATION: {
                    return this.automationNodeCodeEnvsService.listCodeEnvs().stream().filter(codEnv -> codEnv.envLang.equals((Object)CodeEnvModel.EnvLang.PYTHON)).flatMap(this::buildAutomationNodeCodeEnvFacades);
                }
            }
            return Stream.empty();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    private CodeEnvFacade buildDesignerNodeCodeEnvFacade(final CodeEnvModel.CodeEnvListItem codeEnv) {
        try {
            final CodeEnvModel.DesignUIPythonEnv pyEnv = this.designNodeCodeEnvsService.getPythonEnvForUI(codeEnv.envName, false);
            return new CodeEnvFacade(){

                @Override
                public String getInstalledPackageList() {
                    return pyEnv.actualPackageList;
                }

                @Override
                @Nullable
                public String getVersion() {
                    return null;
                }

                @Override
                public String getName() {
                    return codeEnv.envName;
                }

                @Override
                public StandardPythonInterpreter getPythonInterpreter() {
                    return ((CodeEnvModel.PythonEnvDesc)pyEnv.desc).pythonInterpreter;
                }

                @Override
                public String getCustomInterpreter() {
                    return ((CodeEnvModel.PythonEnvDesc)pyEnv.desc).customInterpreter;
                }

                @Override
                public CodeEnvModel.EnvLang getEnvLang() {
                    return codeEnv.envLang;
                }
            };
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    private Stream<CodeEnvFacade> buildAutomationNodeCodeEnvFacades(CodeEnvModel.CodeEnvListItem codeEnv) {
        try {
            CodeEnvModel.AutomationUIPythonEnv uiEnv = this.automationNodeCodeEnvsService.getPythonEnvForUI(codeEnv.envName, false);
            switch (uiEnv.deploymentMode) {
                case AUTOMATION_SINGLE: {
                    return Optional.ofNullable((CodeEnvModel.AutomationUIPythonEnvVersion)uiEnv.currentVersion).map(pythonEnvVersion -> this.buildCodeEnvFacade(codeEnv, (CodeEnvModel.AutomationUIPythonEnvVersion)pythonEnvVersion)).stream();
                }
                case AUTOMATION_VERSIONED: {
                    return uiEnv.versions.stream().map(pythonEnvVersion -> this.buildCodeEnvFacade(codeEnv, (CodeEnvModel.AutomationUIPythonEnvVersion)pythonEnvVersion));
                }
            }
            return Stream.empty();
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    private CodeEnvFacade buildCodeEnvFacade(final CodeEnvModel.CodeEnvListItem codeEnv, final CodeEnvModel.AutomationUIPythonEnvVersion pythonEnvVersion) {
        return new CodeEnvFacade(){

            @Override
            public String getInstalledPackageList() {
                return pythonEnvVersion.actualPackageList;
            }

            @Override
            @Nullable
            public String getVersion() {
                return pythonEnvVersion.versionId;
            }

            @Override
            public String getName() {
                return codeEnv.envName;
            }

            @Override
            public StandardPythonInterpreter getPythonInterpreter() {
                return ((CodeEnvModel.PythonEnvDesc)pythonEnvVersion.desc).pythonInterpreter;
            }

            @Override
            public String getCustomInterpreter() {
                return ((CodeEnvModel.PythonEnvDesc)pythonEnvVersion.desc).customInterpreter;
            }

            @Override
            public CodeEnvModel.EnvLang getEnvLang() {
                return codeEnv.envLang;
            }
        };
    }

    private String buildCodeEnvReferenceForMessage(CodeEnvFacade codeEnvFacade) {
        return Optional.ofNullable(codeEnvFacade.getVersion()).map(version -> String.format("code environment '%s' version '%s'", codeEnvFacade.getName(), version)).orElse(String.format("code environment '%s'", codeEnvFacade.getName()));
    }

    private Stream<InfoMessage> generateManualPySparkInstallationMessages(CodeEnvFacade codeEnvFacade) {
        if (codeEnvFacade.getEnvLang() == CodeEnvModel.EnvLang.PYTHON && this.isPySparkInstalled(codeEnvFacade.getInstalledPackageList())) {
            return Stream.of(InfoMessage.warning((InfoMessage.MessageCode)Codes.WARN_MISC_CODE_ENV_USES_PYSPARK, (String)String.format("pyspark is explicitly installed in the %s. It is not recommended to install pyspark manually.", this.buildCodeEnvReferenceForMessage(codeEnvFacade))));
        }
        return Stream.empty();
    }

    private Stream<InfoMessage> generatePythonDeprecatedMessages(CodeEnvFacade codeEnvFacade) {
        if (codeEnvFacade.getEnvLang() == CodeEnvModel.EnvLang.PYTHON) {
            return this.returnInterpreterVersionIfDeprecate(codeEnvFacade).map(interpreterVersion -> InfoMessage.warning((InfoMessage.MessageCode)Codes.WARN_MISC_CODE_ENV_DEPRECATED_INTERPRETER, (String)String.format("The %s uses a deprecated python interpreter : %s", this.buildCodeEnvReferenceForMessage(codeEnvFacade), interpreterVersion)));
        }
        return Stream.empty();
    }

    private Stream<String> returnInterpreterVersionIfDeprecate(CodeEnvFacade codeEnvFacade) {
        StandardPythonInterpreter pythonInterpreter = codeEnvFacade.getPythonInterpreter();
        if (pythonInterpreter.equals((Object)StandardPythonInterpreter.CUSTOM)) {
            try {
                String interpreterVersion = this.pythonEnvironmentInformation.getPythonVersion(codeEnvFacade.getCustomInterpreter());
                return this.isPythonVersionDeprecated(interpreterVersion) ? Stream.of(interpreterVersion) : Stream.empty();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return codeEnvFacade.getPythonInterpreter().isDeprecated() ? Stream.of(this.getPythonInterpreterFriendlyName(codeEnvFacade.getPythonInterpreter())) : Stream.empty();
    }

    private boolean isPySparkInstalled(String actualPackageList) {
        if (null == actualPackageList) {
            logger.warn((Object)"Code env package list is null.");
            return false;
        }
        BufferedReader reader = new BufferedReader(new StringReader(actualPackageList));
        return reader.lines().anyMatch(s -> s.startsWith("pyspark=="));
    }

    private SanityCheckInfoMessages analyzeBuiltinCodeEnv(Set<String> exclusionList) {
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        if (!exclusionList.contains(Codes.WARN_MISC_CODE_ENV_BUILTIN_MODIFIED.getCode())) {
            try {
                String listOfManuallyInstalledPackages = this.pythonEnvironmentInformation.getListOfManuallyInstalledPackages();
                if (StringUtils.isNotBlank((String)listOfManuallyInstalledPackages)) {
                    messages.withHTMLAndExtraInfo(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_MISC_CODE_ENV_BUILTIN_MODIFIED, "<p>The python built-in code environment should not be modified but it looks like packages have been installed manually. It is recommended to use a custom code environment instead.</p>", "List of manually installed packages", String.format("<pre>%s</pre>", HtmlEscapers.htmlEscaper().escape(listOfManuallyInstalledPackages)));
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unable to analyse built-in env", (Throwable)e);
                messages.addMessage(this.createFatalMessage(e));
            }
        }
        if (!exclusionList.contains(Codes.WARN_MISC_CODE_ENV_DEPRECATED_INTERPRETER.getCode())) {
            try {
                String interpreterVersion = this.pythonEnvironmentInformation.getPythonVersion();
                if (this.isPythonVersionDeprecated(interpreterVersion)) {
                    messages.withWarningV((InfoMessage.MessageCode)Codes.WARN_MISC_CODE_ENV_DEPRECATED_INTERPRETER, "The python built-in code environment uses a deprecated python interpreter : %s.", new Object[]{interpreterVersion});
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unable to analyse built-in env", (Throwable)e);
                messages.addMessage(this.createFatalMessage(e));
            }
        }
        return messages;
    }

    private boolean isPythonVersionDeprecated(String pythonVersion) {
        Pattern pattern = Pattern.compile("(?s)(?<major>\\d)\\.(?<minor>\\d+)\\.(?<patch>\\d+) .*");
        Matcher matcher = pattern.matcher(pythonVersion);
        if (matcher.matches()) {
            int major = Integer.parseInt(matcher.group("major"));
            int minor = Integer.parseInt(matcher.group("minor"));
            return major < 3 || major == 3 && minor < 9;
        }
        throw new IllegalStateException("Could not parse command output: " + pythonVersion);
    }

    private String getPythonInterpreterFriendlyName(StandardPythonInterpreter pythonInterpreter) {
        String interpreterName;
        switch (interpreterName = pythonInterpreter.name()) {
            case "PYTHON27": {
                return "Python 2.7";
            }
            case "PYTHON35": {
                return "Python 3.5";
            }
            case "PYTHON36": {
                return "Python 3.6";
            }
            case "PYTHON37": {
                return "Python 3.7";
            }
            case "PYTHON38": {
                return "Python 3.8";
            }
            case "PYTHON39": {
                return "Python 3.9";
            }
            case "PYTHON310": {
                return "Python 3.10";
            }
            case "PYTHON311": {
                return "Python 3.11";
            }
            case "PYTHON312": {
                return "Python 3.12";
            }
            case "PYTHON313": {
                return "Python 3.13";
            }
        }
        return "";
    }

    public static enum Codes implements InfoMessage.MessageCode
    {
        WARN_MISC_CODE_ENV_DEPRECATED_INTERPRETER("Code Envs - deprecated python interpreter", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING),
        WARN_MISC_CODE_ENV_USES_PYSPARK("Code Envs - pyspark explicitly installed", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING),
        WARN_MISC_CODE_ENV_BUILTIN_MODIFIED("Code Envs - built-in code env modified", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private Codes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }

    private static class InternalException
    extends RuntimeException {
        InternalException(Throwable throwable) {
            super(throwable);
        }
    }

    private static interface CodeEnvFacade {
        public String getInstalledPackageList();

        @CheckForNull
        public String getVersion();

        public String getName();

        public StandardPythonInterpreter getPythonInterpreter();

        public String getCustomInterpreter();

        public CodeEnvModel.EnvLang getEnvLang();
    }
}

