/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterRegistry;
import com.dataiku.dip.cluster.ClustersService;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.custom.UnavailablePluginItemInfo;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StopClusterStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return StopClusterStepParams.class;
        }

        @Override
        public String getType() {
            return "stop_cluster";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new StopClusterStepRunner(step.getParamsAs(StopClusterStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "Stop cluster";
        }

        @Override
        public String buildId(Step step) {
            StopClusterStepParams stepParams = step.getParamsAs(StopClusterStepParams.class);
            return "stop_cluster" + (String)(stepParams != null ? "_" + stepParams.clusterId : "");
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return StopClusterStepRunner.doCheckClusterRunnable(sc, step, pluginUsagesInspector);
        }
    };
    @Autowired
    private ClustersService clustersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private IPermissionsService permissionsService;
    private final StopClusterStepParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.stopcluster");

    public static StepMeta.UnavailableStepInfo doCheckClusterRunnable(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
        StopClusterStepParams stepParams = (StopClusterStepParams)step.params;
        if (StringUtils.isBlank((String)stepParams.clusterId)) {
            return null;
        }
        String clusterId = pluginUsagesInspector.variablesService.getContext(sc.getProjectKey()).expand(stepParams.clusterId);
        try {
            Cluster cluster = pluginUsagesInspector.clustersService.getMandatoryUnsafe(clusterId);
            try {
                ClusterRegistry.getMeta(cluster.type);
            }
            catch (UnavailableDSSObjectException ue) {
                logger.error((Object)"Unavailable DSS object", (Throwable)((Object)ue));
                return new StepMeta.UnavailableStepInfo(step, UnavailablePluginItemInfo.fromObjectTypeAndType(null, cluster.type));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error while checking if step " + step.id + " is runnable"), (Throwable)e);
        }
        return null;
    }

    public StopClusterStepRunner(StopClusterStepParams params) {
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        Cluster cluster;
        if (StringUtils.isBlank((String)this.params.clusterId)) {
            throw new Exception("Missing cluster id");
        }
        DSSAuthCtx authCtx = stepRun.getScenarioRun().getRunAsUser();
        logger.info((Object)("Stop cluster " + this.params.clusterId));
        try (Transaction t = this.transactionService.beginRead();){
            String clusterId = this.variablesService.getContext(stepRun.getScenarioRun().getScenario().getProjectKey()).expand(this.params.clusterId);
            logger.info((Object)("Resolved cluster id " + clusterId));
            this.permissionsService.checkClusterPrivileges(authCtx, clusterId, Privileges.ClusterLevelPrivilegeType.UPDATE);
            cluster = this.clustersService.getMandatoryUnsafe(clusterId);
        }
        logger.info((Object)("Stopping cluster " + cluster.id));
        ReportTargetItem.ClusterItem clusterItem = new ReportTargetItem.ClusterItem(cluster.id);
        AnyLoc clusterLoc = new AnyLoc("__DKU_INSTANCE_CLUSTERS__", cluster.id);
        ReportItem.StoppedCluster reportItem = (ReportItem.StoppedCluster)new ReportItem.StoppedCluster(clusterItem).withStart(DateTime.now().getMillis());
        try {
            Object fr;
            try (Transaction t = this.transactionService.beginRead();){
                fr = this.clustersService.stop(authCtx, stepRun.getScenarioRun().getScenario().getProjectKey(), cluster, false, false);
            }
            if (!fr.hasResult) {
                fr = this.futureService.waitForCompletion(fr.jobId);
            }
            logger.info((Object)"Cluster stopped");
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
        }
        catch (Throwable ex) {
            logger.warn((Object)("Failed to stop cluster " + cluster.id), ex);
            reportItem.withThrown(ex).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
            throw ex;
        }
        finally {
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(clusterLoc, null, null, stepRun.getScenarioRun(), stepRun, reportItem);
        }
        stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
    }

    public static class StopClusterStepParams
    implements StepParams {
        public String clusterId;
    }
}

