/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports;

import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class Columns
implements Iterable<String> {
    private Set<String> flatColumns;
    private Map<String, ExpressionBuilder> expressionColumns;

    public Columns(Collection<String> flatColumns) {
        this.flatColumns = new HashSet<String>(flatColumns);
        this.expressionColumns = new HashMap<String, ExpressionBuilder>();
    }

    public Columns(String ... columns) {
        this.flatColumns = new HashSet<String>();
        for (String s : columns) {
            this.flatColumns.add(s);
        }
        this.expressionColumns = new HashMap<String, ExpressionBuilder>();
    }

    public Columns addFlatColumn(String name) {
        this.flatColumns.add(name);
        if (this.expressionColumns.containsKey(name)) {
            this.expressionColumns.remove(name);
        }
        return this;
    }

    public Columns addExpression(ExpressionBuilder eb, String as) {
        if (this.flatColumns.contains(as)) {
            this.flatColumns.remove(as);
        }
        this.expressionColumns.put(as, eb);
        return this;
    }

    public boolean contains(String name) {
        return this.flatColumns.contains(name) || this.expressionColumns.containsKey(name);
    }

    public Columns remove(String name) {
        if (!this.flatColumns.remove(name)) {
            this.expressionColumns.remove(name);
        }
        return this;
    }

    public void flatten() {
        this.flatColumns.addAll(this.expressionColumns.keySet());
        this.expressionColumns.clear();
    }

    public SelectQueryBuilder selectFrom(SelectQueryBuilder from) {
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        this.selectIn(sqb);
        sqb.from(from, "P");
        return sqb;
    }

    public void selectIn(SelectQueryBuilder in) {
        for (String string : this.flatColumns) {
            in.select(string);
        }
        for (Map.Entry entry : this.expressionColumns.entrySet()) {
            in.select((ExpressionBuilder)entry.getValue(), (String)entry.getKey());
        }
    }

    @Override
    public Iterator<String> iterator() {
        return Iterators.concat(this.flatColumns.iterator(), this.expressionColumns.keySet().iterator());
    }
}

