/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports.pmml.helpers;

import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.CatFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.NumFeaturePreprocessingParams;
import com.dataiku.dip.scoring.exports.pmml.PMMLPreprocessing;
import com.dataiku.dip.scoring.exports.pmml.XML;
import com.dataiku.scoring.pipelines.PreprocessingPipeline;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PMMLDataDictionary {
    @XML.Attribute
    public int numberOfFields;
    @XML.Element
    public List<PMMLDataField> DataField;

    private PMMLDataDictionary(List<PMMLDataField> dataField) {
        this.DataField = dataField;
        this.numberOfFields = dataField.size();
    }

    public static PMMLDataDictionary build(PreprocessingPipeline pipe, ResolvedPredictionPreprocessingParams rppp) {
        Map<String, List<String>> catLevels = PMMLPreprocessing.extractCategoryLevels(pipe);
        ArrayList<PMMLDataField> fields = new ArrayList<PMMLDataField>();
        for (Map.Entry e : rppp.per_feature.entrySet()) {
            FeaturePreprocessingParams par = (FeaturePreprocessingParams)e.getValue();
            if (par.role != FeaturePreprocessingParams.Role.INPUT) continue;
            if (par instanceof NumFeaturePreprocessingParams) {
                fields.add(PMMLDataField.numerical((String)e.getKey()));
                continue;
            }
            if (par instanceof CatFeaturePreprocessingParams) {
                List<String> levels = catLevels.get(e.getKey());
                if (levels == null) {
                    throw new IllegalStateException("Failed to find any levels for a categorical feature inside the pipeline.");
                }
                fields.add(PMMLDataField.categorical((String)e.getKey(), levels));
                continue;
            }
            throw new IllegalArgumentException("Text features not supported with pmml");
        }
        return new PMMLDataDictionary(fields);
    }

    public static class PMMLDataField {
        @XML.Attribute
        public String name;
        @XML.Attribute
        public String optype;
        @XML.Attribute
        public String dataType;
        @XML.Element
        public List<Value> Value;

        PMMLDataField() {
        }

        public static PMMLDataField numerical(String name) {
            PMMLDataField dataField = new PMMLDataField();
            dataField.name = name;
            dataField.optype = "continuous";
            dataField.dataType = "double";
            return dataField;
        }

        public static PMMLDataField categorical(String name, List<String> levels) {
            ArrayList<Value> values = new ArrayList<Value>();
            for (String level : levels) {
                values.add(new Value(level));
            }
            PMMLDataField dataField = new PMMLDataField();
            dataField.dataType = "string";
            dataField.optype = "categorical";
            dataField.name = name;
            dataField.Value = values;
            return dataField;
        }

        public static class Value {
            @XML.Attribute
            public String value;

            Value(String value) {
                this.value = value;
            }
        }
    }
}

