/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports.pmml.helpers;

import com.dataiku.dip.scoring.exports.pmml.helpers.PMMLNode;
import com.dataiku.scoring.models.DecisionTreeModel;
import com.dataiku.scoring.util.MathUtils;
import java.util.Arrays;

public abstract class PMMLTreeGenerator<T, R> {
    private final DecisionTreeModel<T> tree;
    private final String treeName;
    private final String[] colNames;

    public PMMLTreeGenerator(DecisionTreeModel<T> tree, String treeName, String[] colNames) {
        this.tree = tree;
        this.treeName = treeName;
        this.colNames = colNames;
    }

    protected abstract void setLeafAttributes(PMMLNode<R> var1, DecisionTreeModel.Node<T> var2);

    public PMMLNode<R> generateTree() {
        return this.generateNode(this.tree.getRoot(), null, null, 0L);
    }

    private PMMLNode<R> generateNode(DecisionTreeModel.Node<T> node, String feature, Boolean isLeft, long parentId) {
        PMMLNode pmmlNode = new PMMLNode();
        pmmlNode.id = node.id;
        if (isLeft == null) {
            pmmlNode.True = new Object();
        } else {
            String operator = this.tree.variant.expectsStrictComparison ? (isLeft != false ? "lessThan" : "greaterOrEqual") : (isLeft != false ? "lessOrEqual" : "greaterThan");
            String fieldName = String.format("%s:%s:%d", feature, this.treeName, parentId);
            pmmlNode.SimplePredicate = new PMMLNode.PMMLSimplePredicate(fieldName, operator, 0.0);
        }
        if (node.isLeaf) {
            this.setLeafAttributes(pmmlNode, node);
        } else {
            String nodeFeature = this.colNames[node.variable];
            PMMLNode<R> leftSon = this.generateNode(node.leftSon, nodeFeature, true, node.id);
            PMMLNode<R> rightSon = this.generateNode(node.rightSon, nodeFeature, false, node.id);
            pmmlNode.Node = Arrays.asList(leftSon, rightSon);
        }
        return pmmlNode;
    }

    public static class PMMLClassificationTreeGenerator
    extends PMMLTreeGenerator<double[], String> {
        private final String[] classes;

        public PMMLClassificationTreeGenerator(DecisionTreeModel<double[]> tree, String treeName, String[] colNames, String[] classes) {
            super(tree, treeName, colNames);
            this.classes = classes;
        }

        @Override
        protected void setLeafAttributes(PMMLNode<String> pmmlNode, DecisionTreeModel.Node<double[]> node) {
            pmmlNode.score = this.classes[MathUtils.argmax((double[])((double[])node.label))];
            for (int i = 0; i < ((double[])node.label).length; ++i) {
                PMMLNode.PMMLScoreDistribution distribution = new PMMLNode.PMMLScoreDistribution(this.classes[i], ((double[])node.label)[i], ((double[])node.label)[i]);
                pmmlNode.ScoreDistribution.add(distribution);
            }
        }
    }

    public static class PMMLRegressionTreeGenerator
    extends PMMLTreeGenerator<Double, Double> {
        public PMMLRegressionTreeGenerator(DecisionTreeModel<Double> tree, String treeName, String[] colNames) {
            super(tree, treeName, colNames);
        }

        @Override
        protected void setLeafAttributes(PMMLNode<Double> pmmlNode, DecisionTreeModel.Node<Double> node) {
            pmmlNode.score = node.label;
        }
    }
}

