/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.azure;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.azure.AzureADSettings;
import com.dataiku.dip.security.azure.AzureADUserSupplier;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSAzureADUserSupplier
extends AzureADUserSupplier {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");
    private ProxySettings proxySettings;

    @Autowired
    public DSSAzureADUserSupplier(GeneralSettingsDAO generalSettingsDao, PubSubService pubSubService, PasswordEncryptionService symetricCryptoService) {
        super(symetricCryptoService);
        GeneralSettingsDAO.GeneralSettings settings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        this.azureADSettings = settings.azureADSettings;
        this.proxySettings = settings.proxySettings;
        pubSubService.subscribe("general-settings-changed", evt -> {
            try {
                GeneralSettingsDAO.GeneralSettings generalSettings = generalSettingsDao.getUnsafeAutoTXN();
                this.azureADSettings = generalSettings.azureADSettings;
                this.proxySettings = generalSettings.proxySettings;
                this.onRefreshSettings();
            }
            catch (IOException e) {
                logger.error((Object)"Could not reload modified general settings", (Throwable)e);
            }
        });
    }

    public DSSAzureADUserSupplier(PasswordEncryptionService symetricCryptoService, AzureADSettings azureADSettings) {
        super(symetricCryptoService);
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        this.azureADSettings = azureADSettings;
        this.proxySettings = generalSettings.proxySettings;
    }

    public ProxySettings getProxySetting() {
        return this.azureADSettings.useGlobalProxy ? this.proxySettings : new ProxySettings();
    }
}

