/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringRecipesMeta;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesMeta;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.custom.UnavailablePluginItemInfo;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.exec.distinct.DistinctRecipeMeta;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipeMeta;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeMeta;
import com.dataiku.dip.dataflow.exec.pig.PigRecipeMeta;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeMeta;
import com.dataiku.dip.dataflow.exec.sort.SortRecipeMeta;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipeMeta;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipeMeta;
import com.dataiku.dip.dataflow.exec.window.WindowRecipeMeta;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.custompython.CustomPythonDatasetDesc;
import com.dataiku.dip.datasets.inline.InlineDatasetHandler;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatMeta;
import com.dataiku.dip.input.formats.parquet.ParquetFormatMeta;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.KernelsManagedFolderService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.naming.ASCIITransliterator;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.impala.ImpalaRecipeMeta;
import com.dataiku.dip.recipes.code.scala.SparkScalaRecipeMeta;
import com.dataiku.dip.recipes.code.spark.PySparkRecipeMeta;
import com.dataiku.dip.recipes.code.spark.SparkRRecipeMeta;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.ObjectUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class UsabilityComputer {
    @Autowired
    private GeneralSettingsService gsService;
    @Autowired
    private SavedModelsCRUDService savedModelsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private KernelsManagedFolderService foldersService;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private PluginUsagesInspector pluginUsagesInspector;
    @Autowired
    private TranslationService translationService;
    private AuthCtx user;
    private boolean retrieveDetails;
    private FlowGraph contextProjectGraph;
    private ListSettings settings;
    private String contextProjectKey;
    private boolean allowNonProjectLocalOutput = false;
    private Map<String, DSSConnection> connections = null;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.usability");

    public UsabilityComputer(AuthCtx user, FlowGraph contextProjectGraph, ListSettings settings, boolean retrieveDetails, String contextProjectKey) {
        this.user = user;
        this.contextProjectGraph = contextProjectGraph;
        this.settings = settings;
        this.retrieveDetails = retrieveDetails;
        this.contextProjectKey = contextProjectKey;
        this.allowNonProjectLocalOutput = ApplicationConfigurator.getParams().getBoolParam("dku.flow.allowNonProjectLocalOutput", false);
        SpringUtils.getInstance().autowire((Object)this);
    }

    public static void checkDatasetAvailable(PluginUsagesInspector pluginUsagesInspector, SerializedDataset sd) {
        UnavailablePluginItemInfo unavailablePluginItemInfo = pluginUsagesInspector.checkDataset(sd);
        if (null != unavailablePluginItemInfo) {
            throw UnavailableDSSObjectException.fromItemInfo(unavailablePluginItemInfo);
        }
    }

    private void checkManagedFolderAvailable(ManagedFolder mf) {
        UnavailablePluginItemInfo unavailablePluginItemInfo = this.pluginUsagesInspector.checkManagedFolder(mf);
        if (null != unavailablePluginItemInfo) {
            throw UnavailableDSSObjectException.fromItemInfo(unavailablePluginItemInfo);
        }
    }

    private UsableComputable makeDataset(SerializedDataset sd, String lang) {
        RecipeDesc recipeDesc;
        RecipeMeta meta;
        FlowDataset fds;
        UsableComputable ret = new UsableComputable();
        ret.type = FlowComputable.FCType.DATASET;
        ret.projectKey = sd.projectKey;
        ret.name = sd.name;
        ret.label = sd.name;
        ret.id = sd.getFullName();
        ret.localProject = sd.projectKey.equals(this.contextProjectKey);
        ret.smartName = ret.localProject ? ret.name : ret.id;
        String notUsableMsg = null;
        try {
            UsabilityComputer.checkDatasetAvailable(this.pluginUsagesInspector, sd);
            ret.usable = true;
        }
        catch (Exception e) {
            ret.usable = false;
            notUsableMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
            logger.errorV("Dataset %s is not usable: %s", new Object[]{ret.smartName, notUsableMsg});
        }
        ret.datasetType = sd.type;
        ret.dataset = sd;
        ret.dataset.smartName = ret.smartName;
        if (!this.retrieveDetails) {
            ret.dataset = (SerializedDataset)ObjectUtils.shallowCopy((Object)ret.dataset);
            ret.dataset.setSchema(null);
            ret.dataset.setMetrics(null);
            ret.dataset.setDataQualityRuleSet(null);
        }
        ret.variableName = ASCIITransliterator.transliterateToASCIIVariableName(ret.smartName, "dataset");
        if (ret.localProject && (fds = this.contextProjectGraph.datasets.get(ret.id)) != null && fds.getPredecessors().size() > 0 && fds.getPredecessors().get(0) instanceof FlowRunnable) {
            String name;
            ret.alreadyUsedAsOutputOf = name = ((FlowRunnable)fds.getPredecessors().get(0)).getName();
        }
        if (this.settings.forRecipeType != null) {
            String types;
            meta = RecipeRegistry.getMeta(this.settings.forRecipeType);
            recipeDesc = meta.getRecipeDesc();
            Dataset dataset = Dataset.fromSerializedUnsafe(ret.id, sd);
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.inputRoles) {
                if (!ret.usable) {
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_NOT_USABLE", "This dataset is not usable: " + notUsableMsg, "message", notUsableMsg));
                    continue;
                }
                if (!roleDef.acceptsDataset) {
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.INPUT_NOT_ACCEPT_DATASETS", "This input doesn't accept datasets", new Object[0]));
                    continue;
                }
                if (roleDef.mustBeStrictlyType != null && !ret.dataset.type.equals(roleDef.mustBeStrictlyType)) {
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_NOT_OF_TYPE", "This dataset is not of type " + roleDef.mustBeStrictlyType, "type", roleDef.mustBeStrictlyType));
                    continue;
                }
                if (roleDef.acceptedTypes != null && !roleDef.acceptedTypes.contains(ret.dataset.type)) {
                    types = Joiner.on((String)this.translationService.translate(lang, "GLOBAL.OR_SEPARATOR", " or ", new Object[0])).join(roleDef.acceptedTypes);
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_NOT_OF_TYPE", "This dataset is not of type " + types, "type", types));
                    continue;
                }
                if (roleDef.mustBeSQL && !DatasetInspector.isSQLTable(dataset)) {
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_NOT_SQL_TABLE", "This dataset is not a SQL table", new Object[0]));
                    continue;
                }
                if (roleDef.mustBeSQLAble && !DatasetInspector.isSQLAble(this.user, dataset)) {
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_NOT_SQL_TABLE_QUERY", "This dataset is not a SQL table or query", new Object[0]));
                    continue;
                }
                if (roleDef.mustHaveSchema && !DatasetInspector.hasValidSchema(dataset)) {
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_NO_VALID_SCHEMA", "This dataset has no valid schema", new Object[0]));
                    continue;
                }
                if (roleDef.mustNotBePartitioned && sd.isPartitioned()) {
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_PARTITIONED", "This dataset is partitioned", new Object[0]));
                    continue;
                }
                ret.usableForInput(roleDef.name);
            }
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.outputRoles) {
                if (!ret.usable) {
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_NOT_USABLE", "This dataset is not usable: " + notUsableMsg, "message", notUsableMsg));
                    continue;
                }
                if (!roleDef.acceptsDataset) {
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.OUTPUT_NOT_ACCEPT_DATASETS", "This output doesn't accept datasets", new Object[0]));
                    continue;
                }
                if (roleDef.mustBeStrictlyType != null && !ret.dataset.type.equals(roleDef.mustBeStrictlyType)) {
                    String msg = roleDef.mustBeStrictlyType.equals(InlineDatasetHandler.META.getType()) ? this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_NOT_EDITABLE", "This dataset is not editable", new Object[0]) : this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_NOT_OF_TYPE", "This dataset is not of type " + roleDef.mustBeStrictlyType, "type", roleDef.mustBeStrictlyType);
                    ret.notUsableForOutput(roleDef.name, msg);
                    continue;
                }
                if (roleDef.acceptedTypes != null && !roleDef.acceptedTypes.contains(ret.dataset.type)) {
                    types = Joiner.on((String)this.translationService.translate(lang, "GLOBAL.OR_SEPARATOR", " or ", new Object[0])).join(roleDef.acceptedTypes);
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_NOT_OF_TYPE", "This dataset is not of type " + types, "types", types));
                    continue;
                }
                if (roleDef.mustBeSQL && !DatasetInspector.isSQLTable(dataset)) {
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_NOT_SQL_TABLE", "This dataset is not a SQL table", new Object[0]));
                    continue;
                }
                if (!DatasetInspector.checkDatasetConnectionWritePermission(sd, this.connections)) {
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_READ_ONLY_CONNECTION", "This dataset is on a read-only connection", new Object[0]));
                    continue;
                }
                if (DatasetUtils.isReadOnlySQL(dataset)) {
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.SQL_DATASET_READ_ONLY", "This SQL dataset is read-only", new Object[0]));
                    continue;
                }
                if (DatasetUtils.isReadOnly(dataset)) {
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_READ_ONLY", "This dataset is read-only", new Object[0]));
                    continue;
                }
                if (roleDef.mustHaveSchema && !DatasetInspector.hasValidSchema(dataset)) {
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_NO_VALID_SCHEMA", "This dataset has no valid schema", new Object[0]));
                    continue;
                }
                if (roleDef.mustNotBePartitioned && sd.isPartitioned()) {
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.DATASET_PARTITIONED", "This dataset is partitioned", new Object[0]));
                    continue;
                }
                ret.usableForOutput(roleDef.name);
            }
            if (DatasetInspector.supportsParquet(dataset) && ParquetFormatMeta.META.getType().equals(dataset.getFormatType())) {
                ret.noAppend = true;
            }
            if (DatasetInspector.supportsORC(dataset) && ORCFileFormatMeta.META.getType().equals(dataset.getFormatType())) {
                ret.noAppend = true;
            }
            if (DatasetInspector.isCustomPythonDatasetNoThrow(dataset)) {
                CustomPythonDatasetDesc desc = DatasetInspector.getCustomPythonDatasetDesc(dataset);
                if (!desc.supportAppend) {
                    ret.noAppend = true;
                }
            }
            if (DatasetInspector.canHDFS(dataset)) {
                HashSet notAppendableRecipes = Sets.newHashSet();
                notAppendableRecipes.add(HiveRecipeMeta.META.getType());
                notAppendableRecipes.add(PigRecipeMeta.META.getType());
                notAppendableRecipes.add(ImpalaRecipeMeta.META.getType());
                notAppendableRecipes.add(PySparkRecipeMeta.META.getType());
                notAppendableRecipes.add(SparkSQLQueryRecipeMeta.META.getType());
                notAppendableRecipes.add(SparkRRecipeMeta.META.getType());
                notAppendableRecipes.add(SparkScalaRecipeMeta.META.getType());
                HashSet engineDependentRecipes = Sets.newHashSet();
                engineDependentRecipes.add(GroupingRecipeMeta.META.getType());
                engineDependentRecipes.add(DistinctRecipeMeta.META.getType());
                engineDependentRecipes.add(TopNRecipeMeta.META.getType());
                engineDependentRecipes.add(SortRecipeMeta.META.getType());
                engineDependentRecipes.add(PivotRecipeMeta.META.getType());
                engineDependentRecipes.add(WindowRecipeMeta.META.getType());
                engineDependentRecipes.add(JoinRecipeMeta.META.getType());
                engineDependentRecipes.add(VStackRecipeMeta.META.getType());
                engineDependentRecipes.add("shaker");
                if (notAppendableRecipes.contains(meta.getType())) {
                    ret.noAppend = true;
                }
                if (engineDependentRecipes.contains(meta.getType())) {
                    ret.onlyAppendOnStreamOrSQLEngine = true;
                }
            }
            if (meta == HiveRecipeMeta.META) {
                hiveStatus = HiveSchemaHandler.isCompatible(this.user, dataset);
                if (!hiveStatus.compatible) {
                    ret.notUsableForInput("main", hiveStatus.reason);
                    ret.notUsableForOutput("main", hiveStatus.reason);
                }
            } else if (meta == ImpalaRecipeMeta.META) {
                hiveStatus = HiveSchemaHandler.isCompatible(this.user, dataset);
                if (!hiveStatus.compatible) {
                    ret.notUsableForInput("main", hiveStatus.reason);
                }
            }
        }
        if (!ret.localProject && !this.allowNonProjectLocalOutput && this.settings.forRecipeType != null) {
            meta = RecipeRegistry.getMeta(this.settings.forRecipeType);
            recipeDesc = meta.getRecipeDesc();
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.outputRoles) {
                if (!roleDef.acceptsDataset) continue;
                ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.NOT_IN_THIS_PROJECT", "Not in this project", new Object[0]));
            }
        }
        return ret;
    }

    private UsableComputable makeSavedModel(SavedModel sm, String lang) {
        RecipeDesc recipeDesc;
        RecipeMeta meta;
        FlowComputable fc;
        UsableComputable ret = new UsableComputable();
        ret.type = FlowComputable.FCType.SAVED_MODEL;
        ret.projectKey = sm.projectKey;
        ret.name = sm.id;
        ret.label = sm.name;
        ret.id = sm.projectKey + "." + sm.id;
        ret.localProject = sm.projectKey.equals(this.contextProjectKey);
        ret.smartName = ret.localProject ? ret.name : ret.id;
        ret.usable = true;
        ret.model = sm;
        if (ret.localProject && (fc = this.contextProjectGraph.getComputable(ret.id)) != null && fc.getPredecessors().size() > 0 && fc.getPredecessors().get(0) instanceof FlowRecipe) {
            String name;
            ret.alreadyUsedAsOutputOf = name = ((FlowRecipe)fc.getPredecessors().get(0)).getName();
        }
        if (this.settings.forRecipeType != null) {
            meta = RecipeRegistry.getMeta(this.settings.forRecipeType);
            recipeDesc = meta.getRecipeDesc();
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.inputRoles) {
                if (!roleDef.acceptsSavedModel) {
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.INPUT_NO_SAVED_MODELS", "This input doesn't accept saved models", new Object[0]));
                    continue;
                }
                boolean isEvaluationRecipe = meta instanceof PredictionRecipesMeta.EvaluationRecipeMeta;
                boolean isPredictionScoring = meta instanceof PredictionRecipesMeta.ScoringRecipeMeta;
                boolean isClusteringScoring = meta instanceof ClusteringRecipesMeta.ClusteringScoringRecipeMeta;
                if ((isEvaluationRecipe || isPredictionScoring || isClusteringScoring) && sm.savedModelType == SavedModel.SavedModelType.LLM_GENERIC) {
                    ret.notUsableForInput(roleDef.name, "LLM Saved models are not usable in evaluation and scoring recipes.");
                    continue;
                }
                if ((isEvaluationRecipe || isPredictionScoring || isClusteringScoring) && sm.savedModelType.isAgent()) {
                    ret.notUsableForInput(roleDef.name, "LLM Agents are not usable in evaluation and scoring recipes.");
                    continue;
                }
                if ((isEvaluationRecipe || isPredictionScoring || isClusteringScoring) && sm.savedModelType.isRetrievalAugmentedLlm()) {
                    ret.notUsableForInput(roleDef.name, "Retrieval Augmented LLMs are not usable in evaluation and scoring recipes.");
                    continue;
                }
                if ((isEvaluationRecipe || isPredictionScoring) && sm.miniTask.taskType == MLTask.MLTaskType.CLUSTERING) {
                    ret.notUsableForInput(roleDef.name, "This input doesn't accept clustering models");
                    continue;
                }
                if (isEvaluationRecipe && sm.miniTask.backendType == MLTask.BackendType.DEEP_HUB) {
                    ret.notUsableForInput(roleDef.name, "This input doesn't accept computer vision models");
                    continue;
                }
                if (isClusteringScoring && sm.miniTask.taskType == MLTask.MLTaskType.PREDICTION) {
                    ret.notUsableForInput(roleDef.name, "This input doesn't accept prediction models");
                    continue;
                }
                ret.usableForInput(roleDef.name);
            }
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.outputRoles) {
                if (!roleDef.acceptsSavedModel) {
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.OUTPUT_NO_SAVED_MODELS", "This output doesn't accept saved models", new Object[0]));
                    continue;
                }
                ret.usableForOutput(roleDef.name);
            }
        }
        if (!ret.localProject && !this.allowNonProjectLocalOutput && this.settings.forRecipeType != null) {
            meta = RecipeRegistry.getMeta(this.settings.forRecipeType);
            recipeDesc = meta.getRecipeDesc();
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.outputRoles) {
                if (!roleDef.acceptsSavedModel) continue;
                ret.notUsableForOutput(roleDef.name, "Not in this project");
            }
        }
        if (!this.retrieveDetails) {
            ret.model = (SavedModel)ObjectUtils.shallowCopy((Object)ret.model);
            ret.model.metrics = null;
            ret.model.metricsChecks = null;
        }
        return ret;
    }

    private UsableComputable makeManagedFolder(ManagedFolder mf, String lang) {
        RecipeDesc recipeDesc;
        RecipeMeta meta;
        FlowComputable fc;
        UsableComputable ret = new UsableComputable();
        ret.type = FlowComputable.FCType.MANAGED_FOLDER;
        ret.projectKey = mf.projectKey;
        ret.name = mf.id;
        ret.label = mf.name;
        ret.id = mf.projectKey + "." + mf.id;
        ret.localProject = mf.projectKey.equals(this.contextProjectKey);
        ret.smartName = ret.localProject ? ret.name : ret.id;
        String notUsableMsg = null;
        try {
            this.checkManagedFolderAvailable(mf);
            ret.usable = true;
        }
        catch (Exception e) {
            notUsableMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
            logger.errorV("Managed folder %s unavailable: %s", new Object[]{ret.smartName, notUsableMsg});
        }
        ret.box = mf;
        ret.variableName = ASCIITransliterator.transliterateToASCIIVariableName(ret.label, "folder");
        if (ret.localProject && (fc = this.contextProjectGraph.getComputable(ret.id)) != null && fc.getPredecessors().size() > 0 && fc.getPredecessors().get(0) instanceof FlowRecipe) {
            String name;
            ret.alreadyUsedAsOutputOf = name = ((FlowRecipe)fc.getPredecessors().get(0)).getName();
        }
        if (this.settings.forRecipeType != null) {
            meta = RecipeRegistry.getMeta(this.settings.forRecipeType);
            recipeDesc = meta.getRecipeDesc();
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.inputRoles) {
                if (!ret.usable) {
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.MANAGED_FOLDER_NOT_USABLE", "This managed folded is not usable: " + notUsableMsg, "message", notUsableMsg));
                    continue;
                }
                if (!roleDef.acceptsManagedFolder) {
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.INPUT_NO_MANAGED_FOLDERS", "This input doesn't accept managed folders", new Object[0]));
                    continue;
                }
                if (roleDef.mustBeSharepointFolder && !"SharePointOnline".equals(mf.getType())) {
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.INPUT_MUST_BE_SHAREPOINT_FOLDER", "This input isn't a SharePoint folder", new Object[0]));
                    continue;
                }
                ret.usableForInput(roleDef.name);
            }
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.outputRoles) {
                if (!ret.usable) {
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.MANAGED_FOLDER_NOT_USABLE", "This managed folded is not usable: " + notUsableMsg, "message", notUsableMsg));
                    continue;
                }
                if (!roleDef.acceptsManagedFolder) {
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.OUTPUT_NO_MANAGED_FOLDERS", "This output doesn't accept managed folders", new Object[0]));
                    continue;
                }
                ret.usableForOutput(roleDef.name);
            }
        }
        if (!ret.localProject && !this.allowNonProjectLocalOutput && this.settings.forRecipeType != null) {
            meta = RecipeRegistry.getMeta(this.settings.forRecipeType);
            recipeDesc = meta.getRecipeDesc();
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.outputRoles) {
                if (!roleDef.acceptsManagedFolder) continue;
                ret.notUsableForOutput(roleDef.name, "Not in this project");
            }
        }
        if (!this.retrieveDetails) {
            ret.box = (ManagedFolder)ObjectUtils.shallowCopy((Object)ret.box);
            ret.box.metrics = null;
            ret.box.checks = null;
        }
        return ret;
    }

    private UsableComputable makeStreamingEndpoint(StreamingEndpoint sm, String lang) {
        RecipeDesc recipeDesc;
        RecipeMeta meta;
        FlowComputable fc;
        UsableComputable ret = new UsableComputable();
        ret.type = FlowComputable.FCType.STREAMING_ENDPOINT;
        ret.projectKey = sm.projectKey;
        ret.name = sm.id;
        ret.label = sm.id;
        ret.id = sm.projectKey + "." + sm.id;
        ret.localProject = sm.projectKey.equals(this.contextProjectKey);
        ret.smartName = ret.localProject ? ret.name : ret.id;
        ret.usable = true;
        ret.streamingEndpoint = sm;
        ret.variableName = ASCIITransliterator.transliterateToASCIIVariableName(ret.label, "endpoint");
        if (ret.localProject && (fc = this.contextProjectGraph.getComputable(ret.id)) != null && fc.getPredecessors().size() > 0 && fc.getPredecessors().get(0) instanceof FlowRecipe) {
            String name;
            ret.alreadyUsedAsOutputOf = name = ((FlowRecipe)fc.getPredecessors().get(0)).getName();
        }
        if (this.settings.forRecipeType != null) {
            String acceptedTypesConcatenated;
            meta = RecipeRegistry.getMeta(this.settings.forRecipeType);
            recipeDesc = meta.getRecipeDesc();
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.inputRoles) {
                if (!roleDef.acceptsStreamingEndpoint) {
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.INPUT_NO_STREAMING", "This input doesn't accept streaming endpoints", new Object[0]));
                    continue;
                }
                if (roleDef.mustBeStrictlyType != null && !roleDef.mustBeStrictlyType.equals(sm.type)) {
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.STREAMING_NOT_OF_TYPE", "This streaming endpoint is not of type " + roleDef.mustBeStrictlyType, "type", roleDef.mustBeStrictlyType));
                    continue;
                }
                if (roleDef.acceptedTypes != null && !roleDef.acceptedTypes.contains(sm.type)) {
                    acceptedTypesConcatenated = Joiner.on((String)this.translationService.translate(lang, "GLOBAL.OR_SEPARATOR", " or ", new Object[0])).join(roleDef.acceptedTypes);
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.STREAMING_NOT_OF_TYPE", "This streaming endpoint is not of type " + acceptedTypesConcatenated, "type", acceptedTypesConcatenated));
                    continue;
                }
                ret.usableForInput(roleDef.name);
            }
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.outputRoles) {
                if (!roleDef.acceptsStreamingEndpoint) {
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.OUTPUT_NO_STREAMING", "This output doesn't accept streaming enpdoints", new Object[0]));
                    continue;
                }
                if (roleDef.mustBeStrictlyType != null && !roleDef.mustBeStrictlyType.equals(sm.type)) {
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.STREAMING_NOT_OF_TYPE", "This streaming endpoint is not of type " + roleDef.mustBeStrictlyType, "type", roleDef.mustBeStrictlyType));
                    continue;
                }
                if (roleDef.acceptedTypes != null && !roleDef.acceptedTypes.contains(sm.type)) {
                    acceptedTypesConcatenated = Joiner.on((String)this.translationService.translate(lang, "GLOBAL.OR_SEPARATOR", " or ", new Object[0])).join(roleDef.acceptedTypes);
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.STREAMING_NOT_OF_TYPE", "This streaming endpoint is not of type " + acceptedTypesConcatenated, "type", acceptedTypesConcatenated));
                    continue;
                }
                ret.usableForOutput(roleDef.name);
            }
        }
        if (!ret.localProject && !this.allowNonProjectLocalOutput && this.settings.forRecipeType != null) {
            meta = RecipeRegistry.getMeta(this.settings.forRecipeType);
            recipeDesc = meta.getRecipeDesc();
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.outputRoles) {
                if (!roleDef.acceptsStreamingEndpoint) continue;
                ret.notUsableForOutput(roleDef.name, "Not in this project");
            }
        }
        if (!this.retrieveDetails) {
            ret.streamingEndpoint = (StreamingEndpoint)ObjectUtils.shallowCopy((Object)ret.streamingEndpoint);
            ret.streamingEndpoint.schema = null;
        }
        return ret;
    }

    private UsableComputable makeRetrievableKnowledge(RetrievableKnowledge rk, String lang) {
        RecipeDesc recipeDesc;
        RecipeMeta meta;
        FlowComputable fc;
        UsableComputable ret = new UsableComputable();
        ret.type = FlowComputable.FCType.RETRIEVABLE_KNOWLEDGE;
        ret.projectKey = rk.projectKey;
        ret.name = rk.id;
        ret.label = rk.name;
        ret.id = rk.projectKey + "." + rk.id;
        ret.localProject = rk.projectKey.equals(this.contextProjectKey);
        ret.smartName = ret.localProject ? ret.name : ret.id;
        ret.usable = true;
        ret.retrievableKnowledge = rk;
        ret.variableName = ASCIITransliterator.transliterateToASCIIVariableName(ret.label, "rk");
        if (ret.localProject && (fc = this.contextProjectGraph.getComputable(ret.id)) != null && fc.getPredecessors().size() > 0 && fc.getPredecessors().get(0) instanceof FlowRecipe) {
            String name;
            ret.alreadyUsedAsOutputOf = name = ((FlowRecipe)fc.getPredecessors().get(0)).getName();
        }
        if (this.settings.forRecipeType != null) {
            meta = RecipeRegistry.getMeta(this.settings.forRecipeType);
            recipeDesc = meta.getRecipeDesc();
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.inputRoles) {
                if (!roleDef.acceptsRetrievableKnowledge) {
                    ret.notUsableForInput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.INPUT_NO_KNOWLEDGE_BANK", "This input doesn't accept knowledge bank", new Object[0]));
                    continue;
                }
                ret.usableForInput(roleDef.name);
            }
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.outputRoles) {
                if (!roleDef.acceptsRetrievableKnowledge) {
                    ret.notUsableForOutput(roleDef.name, this.translationService.translate(lang, "USABILITY_COMPUTER.OUTPUT_NO_KNOWLEDGE_BANK", "This output doesn't accept knowledge bank", new Object[0]));
                    continue;
                }
                ret.usableForOutput(roleDef.name);
            }
        }
        if (!ret.localProject && !this.allowNonProjectLocalOutput && this.settings.forRecipeType != null) {
            meta = RecipeRegistry.getMeta(this.settings.forRecipeType);
            recipeDesc = meta.getRecipeDesc();
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.outputRoles) {
                if (!roleDef.acceptsRetrievableKnowledge) continue;
                ret.notUsableForOutput(roleDef.name, "Not in this project");
            }
        }
        return ret;
    }

    private UsableComputable makeModelEvaluationStore(ModelEvaluationStore mes) {
        RecipeDesc recipeDesc;
        RecipeMeta meta;
        FlowComputable fc;
        UsableComputable ret = new UsableComputable();
        ret.type = FlowComputable.FCType.MODEL_EVALUATION_STORE;
        ret.projectKey = mes.projectKey;
        ret.name = mes.id;
        ret.label = mes.name;
        ret.id = mes.projectKey + "." + mes.id;
        ret.localProject = mes.projectKey.equals(this.contextProjectKey);
        ret.smartName = ret.localProject ? ret.name : ret.id;
        ret.usable = true;
        ret.mes = mes;
        ret.variableName = ASCIITransliterator.transliterateToASCIIVariableName(ret.label, "evaluation_store");
        if (ret.localProject && (fc = this.contextProjectGraph.getComputable(ret.id)) != null && fc.getPredecessors().size() > 0 && fc.getPredecessors().get(0) instanceof FlowRecipe) {
            String name;
            ret.alreadyUsedAsOutputOf = name = ((FlowRecipe)fc.getPredecessors().get(0)).getName();
        }
        if (this.settings.forRecipeType != null) {
            meta = RecipeRegistry.getMeta(this.settings.forRecipeType);
            recipeDesc = meta.getRecipeDesc();
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.inputRoles) {
                if (!roleDef.acceptsModelEvaluationStore) {
                    ret.notUsableForInput(roleDef.name, "This input doesn't accept evaluation stores");
                    continue;
                }
                ret.usableForInput(roleDef.name);
            }
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.outputRoles) {
                if (!roleDef.acceptsModelEvaluationStore) {
                    ret.notUsableForOutput(roleDef.name, "This output doesn't accept evaluation stores");
                    continue;
                }
                ret.usableForOutput(roleDef.name);
            }
        }
        if (!ret.localProject && !this.allowNonProjectLocalOutput && this.settings.forRecipeType != null) {
            meta = RecipeRegistry.getMeta(this.settings.forRecipeType);
            recipeDesc = meta.getRecipeDesc();
            for (RecipeDesc.IORoleDef roleDef : recipeDesc.outputRoles) {
                if (!roleDef.acceptsModelEvaluationStore) continue;
                ret.notUsableForOutput(roleDef.name, "Not in this project");
            }
        }
        return ret;
    }

    public List<UsableComputable> compute(String lang) throws Exception {
        ArrayList<UsableComputable> out = new ArrayList<UsableComputable>();
        GeneralSettingsDAO.GeneralSettings gs = this.gsService.read();
        this.connections = ConnectionsDAO.get().listUnsafe();
        boolean withDatasets = this.settings.type == null || this.settings.type == FlowComputable.FCType.DATASET;
        boolean withModels = !this.settings.datasetsOnly && (this.settings.type == null || this.settings.type == FlowComputable.FCType.SAVED_MODEL);
        boolean withFolders = !this.settings.datasetsOnly && (this.settings.type == null || this.settings.type == FlowComputable.FCType.MANAGED_FOLDER);
        boolean withEvaluationStores = !this.settings.datasetsOnly && (this.settings.type == null || this.settings.type == FlowComputable.FCType.MODEL_EVALUATION_STORE);
        boolean withStreamingEndpoints = !this.settings.datasetsOnly && (this.settings.type == null || this.settings.type == FlowComputable.FCType.STREAMING_ENDPOINT);
        boolean withRetrievableKnowledges = !this.settings.datasetsOnly && (this.settings.type == null || this.settings.type == FlowComputable.FCType.RETRIEVABLE_KNOWLEDGE);
        switch (gs.computablesAvailabilityMode) {
            case ALL_ACCESSIBLE_AVAILABLE: {
                for (ProjectsService.UIProject uIProject : this.projectsService.listAccessibleUnsafe(this.user)) {
                    if (!this.permissionsService.hasProjectPrivilege(this.user, uIProject.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
                    if (withDatasets) {
                        for (SerializedDataset serializedDataset : this.datasetsDAO.listUnsafe(uIProject.projectKey)) {
                            out.add(this.makeDataset(serializedDataset, lang));
                        }
                    }
                    if (withModels) {
                        for (SavedModel savedModel : this.savedModelsService.listUnsafe(uIProject.projectKey)) {
                            out.add(this.makeSavedModel(savedModel, lang));
                        }
                    }
                    if (withFolders) {
                        for (ManagedFolder managedFolder : this.foldersService.list(uIProject.projectKey)) {
                            out.add(this.makeManagedFolder(managedFolder, lang));
                        }
                    }
                    if (withEvaluationStores) {
                        for (ModelEvaluationStore modelEvaluationStore : this.modelEvaluationStoresDAO.list(uIProject.projectKey)) {
                            out.add(this.makeModelEvaluationStore(modelEvaluationStore));
                        }
                    }
                    if (withStreamingEndpoints) {
                        for (StreamingEndpoint streamingEndpoint : this.streamingEndpointsDAO.listUnsafe(uIProject.projectKey)) {
                            out.add(this.makeStreamingEndpoint(streamingEndpoint, lang));
                        }
                    }
                    if (!withRetrievableKnowledges) continue;
                    for (RetrievableKnowledge retrievableKnowledge : this.retrievableKnowledgeDAO.listUnsafe(uIProject.projectKey)) {
                        out.add(this.makeRetrievableKnowledge(retrievableKnowledge, lang));
                    }
                }
                break;
            }
            case EXPOSED_ONLY: {
                if (this.contextProjectKey != null && this.permissionsService.hasProjectPrivilege(this.user, this.contextProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                    if (withDatasets) {
                        for (SerializedDataset serializedDataset : this.datasetsDAO.listUnsafe(this.contextProjectKey)) {
                            out.add(this.makeDataset(serializedDataset, lang));
                        }
                    }
                    if (withModels) {
                        for (SavedModel savedModel : this.savedModelsService.listUnsafe(this.contextProjectKey)) {
                            out.add(this.makeSavedModel(savedModel, lang));
                        }
                    }
                    if (withFolders) {
                        for (ManagedFolder managedFolder : this.foldersService.list(this.contextProjectKey)) {
                            out.add(this.makeManagedFolder(managedFolder, lang));
                        }
                    }
                    if (withEvaluationStores) {
                        for (ModelEvaluationStore modelEvaluationStore : this.modelEvaluationStoresDAO.list(this.contextProjectKey)) {
                            out.add(this.makeModelEvaluationStore(modelEvaluationStore));
                        }
                    }
                    if (withStreamingEndpoints) {
                        for (StreamingEndpoint streamingEndpoint : this.streamingEndpointsDAO.listUnsafe(this.contextProjectKey)) {
                            out.add(this.makeStreamingEndpoint(streamingEndpoint, lang));
                        }
                    }
                    if (withRetrievableKnowledges) {
                        for (RetrievableKnowledge retrievableKnowledge : this.retrievableKnowledgeDAO.listUnsafe(this.contextProjectKey)) {
                            out.add(this.makeRetrievableKnowledge(retrievableKnowledge, lang));
                        }
                    }
                }
                if (this.contextProjectKey == null) break;
                if (withDatasets) {
                    for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedDatasets(this.contextProjectKey)) {
                        SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(datasetLoc);
                        if (sd == null) continue;
                        out.add(this.makeDataset(sd, lang));
                    }
                }
                if (withModels) {
                    for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedSavedModels(this.contextProjectKey)) {
                        SavedModel sm = this.savedModelsService.getOrNullUnsafe(datasetLoc.getProjectKey(), datasetLoc.getName());
                        if (sm == null) continue;
                        out.add(this.makeSavedModel(sm, lang));
                    }
                }
                if (withFolders) {
                    for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedManagedFolders(this.contextProjectKey)) {
                        ManagedFolder odb = this.foldersService.getOrNull(datasetLoc.getProjectKey(), datasetLoc.getName());
                        if (odb == null) continue;
                        out.add(this.makeManagedFolder(odb, lang));
                    }
                }
                if (withEvaluationStores) {
                    for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedModelEvaluationStores(this.contextProjectKey)) {
                        ModelEvaluationStore mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNull(datasetLoc.getProjectKey(), datasetLoc.getName());
                        if (mes == null) continue;
                        out.add(this.makeModelEvaluationStore(mes));
                    }
                }
                if (withRetrievableKnowledges) {
                    for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedRetrievableKnowledges(this.contextProjectKey)) {
                        RetrievableKnowledge rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getOrNull(datasetLoc.getProjectKey(), datasetLoc.getName());
                        if (rk == null) continue;
                        out.add(this.makeRetrievableKnowledge(rk, lang));
                    }
                }
                if (!withStreamingEndpoints) break;
                for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedStreamingEndpoints(this.contextProjectKey)) {
                    StreamingEndpoint se = (StreamingEndpoint)this.streamingEndpointsDAO.getOrNull(datasetLoc.getProjectKey(), datasetLoc.getName());
                    if (se == null) continue;
                    out.add(this.makeStreamingEndpoint(se, lang));
                }
                break;
            }
        }
        return out;
    }

    public List<UsableComputable> computeUnsafe(String lang) throws Exception {
        boolean withRetrievableKnowledges;
        ArrayList<UsableComputable> out = new ArrayList<UsableComputable>();
        boolean withDatasets = this.settings.type == null || this.settings.type == FlowComputable.FCType.DATASET;
        boolean withModels = !this.settings.datasetsOnly && (this.settings.type == null || this.settings.type == FlowComputable.FCType.SAVED_MODEL);
        boolean withFolders = !this.settings.datasetsOnly && (this.settings.type == null || this.settings.type == FlowComputable.FCType.MANAGED_FOLDER);
        boolean withEvaluationStores = !this.settings.datasetsOnly && (this.settings.type == null || this.settings.type == FlowComputable.FCType.MODEL_EVALUATION_STORE);
        boolean bl = withRetrievableKnowledges = !this.settings.datasetsOnly && (this.settings.type == null || this.settings.type == FlowComputable.FCType.RETRIEVABLE_KNOWLEDGE);
        if (withDatasets) {
            for (SerializedDataset serializedDataset : this.datasetsDAO.list(this.contextProjectKey)) {
                out.add(this.makeDataset(serializedDataset, lang));
            }
        }
        if (withModels) {
            for (SavedModel savedModel : this.savedModelsService.list(this.contextProjectKey)) {
                out.add(this.makeSavedModel(savedModel, lang));
            }
        }
        if (withFolders) {
            for (ManagedFolder managedFolder : this.foldersService.list(this.contextProjectKey)) {
                out.add(this.makeManagedFolder(managedFolder, lang));
            }
        }
        if (withEvaluationStores) {
            for (ModelEvaluationStore modelEvaluationStore : this.modelEvaluationStoresDAO.list(this.contextProjectKey)) {
                out.add(this.makeModelEvaluationStore(modelEvaluationStore));
            }
        }
        if (withRetrievableKnowledges) {
            for (RetrievableKnowledge retrievableKnowledge : this.retrievableKnowledgeDAO.list(this.contextProjectKey)) {
                out.add(this.makeRetrievableKnowledge(retrievableKnowledge, lang));
            }
        }
        if (this.contextProjectKey != null) {
            for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedDatasets(this.contextProjectKey)) {
                SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(datasetLoc);
                if (sd == null) continue;
                out.add(this.makeDataset(sd, lang));
            }
            if (!this.settings.datasetsOnly) {
                for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedSavedModels(this.contextProjectKey)) {
                    SavedModel sm = this.savedModelsService.getOrNullUnsafe(datasetLoc.getProjectKey(), datasetLoc.getName());
                    if (sm == null) continue;
                    out.add(this.makeSavedModel(sm, lang));
                }
                for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedManagedFolders(this.contextProjectKey)) {
                    ManagedFolder odb = this.foldersService.getOrNull(datasetLoc.getProjectKey(), datasetLoc.getName());
                    if (odb == null) continue;
                    out.add(this.makeManagedFolder(odb, lang));
                }
                for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedModelEvaluationStores(this.contextProjectKey)) {
                    ModelEvaluationStore mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNull(datasetLoc.getProjectKey(), datasetLoc.getName());
                    if (mes == null) continue;
                    out.add(this.makeModelEvaluationStore(mes));
                }
                for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedRetrievableKnowledges(this.contextProjectKey)) {
                    RetrievableKnowledge rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getOrNull(datasetLoc.getProjectKey(), datasetLoc.getName());
                    if (rk == null) continue;
                    out.add(this.makeRetrievableKnowledge(rk, lang));
                }
            }
        }
        return out;
    }

    @UIModel
    public static class ListSettings {
        @Nullable
        public boolean datasetsOnly;
        @Nullable
        public boolean hideUnusableInput;
        @Nullable
        public boolean hideUnusableOutput;
        @Nullable
        public String forRecipeType;
        @Nullable
        public FlowComputable.FCType type;
    }

    @UIModel
    public static class UsableComputable {
        public FlowComputable.FCType type;
        public String projectKey;
        public String id;
        public String name;
        public String label;
        public boolean localProject;
        public String smartName;
        public String datasetType;
        public String variableName;
        public Map<String, Usable> usableAsInput = new HashMap<String, Usable>();
        public Map<String, Usable> usableAsOutput = new HashMap<String, Usable>();
        public String alreadyUsedAsOutputOf;
        public boolean usable;
        public boolean noAppend;
        public boolean onlyAppendOnStreamOrSQLEngine;
        public SerializedDataset dataset;
        public SavedModel model;
        public ManagedFolder box;
        public StreamingEndpoint streamingEndpoint;
        public ModelEvaluationStore mes;
        public RetrievableKnowledge retrievableKnowledge;

        boolean alreadyMarkedNotUsableAsInput(String role) {
            return this.usableAsInput.get(role) != null && !this.usableAsInput.get((Object)role).usable;
        }

        boolean alreadyMarkedNotUsableAsOutput(String role) {
            return this.usableAsOutput.get(role) != null && !this.usableAsOutput.get((Object)role).usable;
        }

        void usableForInput(String role) {
            this.usableAsInput.put(role, Usable.yes());
        }

        void notUsableForInput(String role, String reason) {
            if (this.alreadyMarkedNotUsableAsInput(role)) {
                return;
            }
            this.usableAsInput.put(role, Usable.no(reason));
        }

        void usableForOutput(String role) {
            this.usableAsOutput.put(role, Usable.yes());
        }

        void notUsableForOutput(String role, String reason) {
            if (this.alreadyMarkedNotUsableAsOutput(role)) {
                return;
            }
            this.usableAsOutput.put(role, Usable.no(reason));
        }

        private static String getPredictionTypeDisplayName(@Nullable PredictionMLTask.PredictionType predictionType) {
            if (predictionType == null) {
                return "an external model (no declared prediction type)";
            }
            switch (predictionType) {
                case BINARY_CLASSIFICATION: {
                    return "a binary classification model";
                }
                case MULTICLASS: {
                    return "a multiclass model";
                }
                case REGRESSION: {
                    return "a regression model";
                }
                case TIMESERIES_FORECAST: {
                    return "a time series forecasting model";
                }
                case DEEP_HUB_IMAGE_OBJECT_DETECTION: {
                    return "an object detection model";
                }
                case DEEP_HUB_IMAGE_CLASSIFICATION: {
                    return "an image classification model";
                }
                case CAUSAL_BINARY_CLASSIFICATION: {
                    return "a causal binary classification model";
                }
                case CAUSAL_REGRESSION: {
                    return "a causal regression model";
                }
            }
            throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)predictionType));
        }

        public void checkPredictionSMInputCompatibilityForRecipes(boolean inputModelNeedsDataFolder, @Nullable PredictionMLTask.PredictionType inputModelPredictionType) {
            if (this.model == null || !FlowComputable.FCType.SAVED_MODEL.equals((Object)this.type)) {
                return;
            }
            if (this.model.miniTask == null) {
                return;
            }
            if (!MLTask.MLTaskType.PREDICTION.equals((Object)this.model.miniTask.taskType)) {
                return;
            }
            PredictionMLTask.PredictionType predictionType = ((PredictionMLTask)this.model.miniTask).predictionType;
            for (String roleName : this.usableAsInput.keySet()) {
                if (this.alreadyMarkedNotUsableAsInput(roleName)) continue;
                if (inputModelPredictionType == null && predictionType != null || inputModelPredictionType != null && !inputModelPredictionType.equals((Object)predictionType)) {
                    this.notUsableForInput(roleName, String.format("The recipe was created with %s, this input cannot use %s", UsableComputable.getPredictionTypeDisplayName(inputModelPredictionType), UsableComputable.getPredictionTypeDisplayName(predictionType)));
                }
                if (inputModelNeedsDataFolder == this.model.needsInputDataFolder) continue;
                this.notUsableForInput(roleName, String.format("The recipe was created with a model that requires %s data input, this input cannot use a model with different requirements", inputModelNeedsDataFolder ? "a" : "no"));
            }
        }
    }

    static class Usable {
        boolean usable;
        String reason;

        Usable() {
        }

        static Usable yes() {
            Usable u = new Usable();
            u.usable = true;
            return u;
        }

        static Usable no(String reason) {
            Usable u = new Usable();
            u.usable = false;
            u.reason = reason;
            return u;
        }
    }
}

