/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.ElasticSearchConnection;
import com.dataiku.dip.connections.JdbcConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDialect;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.hive.massimport.HiveImportabilityChecker;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.connections.AlationImportService;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.connections.ConnectionsImportService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ConnectionsImportController
extends DIPInternalControllerBase {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.connections.import");
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ConnectionsImportService importService;
    @Autowired
    private AlationImportService alationService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;

    @AuditedCall(value={"msgType", "connection-list-mass-import-sources"})
    @RequestMapping(value={"/api/connections/list-mass-import-sources"})
    public void listMassImportSources(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey) throws Exception {
        boolean listMetastoreTablesFromMainCatalog;
        List<ElasticSearchConnection> usableESConnections;
        List<AbstractSQLConnection> usableSQLConnections;
        AuthCtx authCtx;
        ArrayList metastoreSourceSQLConnections = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            usableSQLConnections = this.connectionsService.getUsableSqlConnections(authCtx);
            usableESConnections = this.connectionsService.getUsableElasticSearchConnections(authCtx);
        }
        MassImportSources ret = new MassImportSources();
        for (AbstractSQLConnection abstractSQLConnection : usableSQLConnections) {
            Params p;
            if (abstractSQLConnection.getParams().useAsMetastoreSource) {
                ret.sources.add(new MassImportSourceConnection(abstractSQLConnection.name, abstractSQLConnection.name, abstractSQLConnection.type + " (as SQL)"));
                metastoreSourceSQLConnections.add(abstractSQLConnection);
                continue;
            }
            MassImportSourceConnection misc = new MassImportSourceConnection(abstractSQLConnection.name, abstractSQLConnection.name, abstractSQLConnection.type);
            if (abstractSQLConnection instanceof JdbcConnection) {
                SQLDialect dialect = abstractSQLConnection.getDialect();
                boolean bl = misc.jdbcConnectionSupportsBrowsingCatalogs = dialect.isCatalogAware() || ((JdbcConnection)abstractSQLConnection).params.supportsBrowsingCatalogs;
            }
            if (!(p = abstractSQLConnection.getDkuPropertiesAsParams()).getBoolParam("dku.connection.sql.allowCatalogAndSchemaDropdownInput", true)) {
                misc.defaultCatalogAndSchemaInputMode = CatalogAndSchemaInputMode.FREE_TEXT;
                misc.allowCatalogAndSchemaFreeTextInput = true;
                misc.allowCatalogAndSchemaDropdownInput = false;
            }
            if (p.getBoolParam("dku.connection.sql.allowCatalogAndSchemaFreeTextInput", false)) {
                misc.allowCatalogAndSchemaFreeTextInput = true;
            }
            misc.defaultCatalog = p.getParam("dku.connection.sql.defaultCatalogForTablesListing");
            misc.defaultSchema = p.getParam("dku.connection.sql.defaultSchemaForTablesListing");
            ret.sources.add(misc);
        }
        for (ElasticSearchConnection elasticSearchConnection : usableESConnections) {
            ret.sources.add(new MassImportSourceConnection(elasticSearchConnection.name, elasticSearchConnection.name, elasticSearchConnection.type, elasticSearchConnection.params.dialect.toString()));
        }
        boolean bl = listMetastoreTablesFromMainCatalog = HadoopLoader.hadoopEnabled() && this.metastoreInspectionService.metastoreSupportEnabled(authCtx, projectKey);
        if (listMetastoreTablesFromMainCatalog) {
            try {
                String string = new ClusterSelector().getClusterForProject(projectKey, Cluster.ClusterArchitecture.HADOOP);
                for (String db : this.metastoreInspectionService.newInspector(authCtx, projectKey).listHiveDatabase(string, "default", authCtx, projectKey)) {
                    ret.sources.add(new MassImportSourceConnection("@virtual(hive-jdbc):" + db, "Hive (" + db + ")", "HDFS"));
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Failed to list hive databases", (Throwable)exception);
                ret.messages.withFatal((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_METASTORE_DATABASES_LIST_FAILED, "FAiled to list databases from metastore: " + ExceptionUtils.getMessageWithCauses((Throwable)exception));
            }
        }
        ConnectionsImportController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "connection-list-mass-import-schemas"})
    @RequestMapping(value={"/api/connections/list-sql-mass-import-schemas"})
    public void listSQLMassImportSchemas(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String connectionName) throws Exception {
        DSSConnection connection;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            connection = this.connectionsDAO.getMandatoryConnection(authCtx, connectionName);
            if (!connection.isFreelyUsableBy(authCtx)) {
                throw new DKUSecurityException("You may not use this connection");
            }
        }
        if (!(connection instanceof AbstractSQLConnection)) {
            throw new IllegalArgumentException("Connection " + connectionName + " is of type " + connection.getType() + " and doesn't have several schemas");
        }
        ConnectionsImportController.writeJSON((HttpServletResponse)resp, SQLUtils.listSchemasCatalogUnaware(((AbstractSQLConnection)connection).getConnectionData_NT(authCtx, projectKey), authCtx, projectKey));
    }

    @AuditedCall(value={"msgType", "connection-list-sql-schemas"})
    @RequestMapping(value={"/api/connections/list-sql-schemas"})
    public void listSQLSchemas(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String connectionName, @RequestParam(required=false) String catalog) throws Exception {
        DSSConnection connection;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            connection = this.connectionsDAO.getMandatoryConnection(authCtx, connectionName);
            if (!connection.isFreelyUsableBy(authCtx)) {
                throw new DKUSecurityException("You may not use this connection");
            }
        }
        if (!(connection instanceof AbstractSQLConnection)) {
            throw new IllegalArgumentException("Connection " + connectionName + " is of type " + connection.getType() + " and doesn't have several schemas");
        }
        FutureResponse<List<String>> res = this.connectionsService.listSqlSchemasForCatalog(((AbstractSQLConnection)connection).getConnectionData_NT(authCtx, projectKey), authCtx, projectKey, catalog);
        ConnectionsImportController.writeJSON((HttpServletResponse)resp, res);
    }

    @AuditedCall(value={"msgType", "connection-list-sql-catalogs"})
    @RequestMapping(value={"/api/connections/list-sql-catalogs"})
    public void listSQLCatalogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String connectionName) throws Exception {
        DSSConnection connection;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            connection = this.connectionsDAO.getMandatoryConnection(authCtx, connectionName);
            if (!connection.isFreelyUsableBy(authCtx)) {
                throw new DKUSecurityException("You may not use this connection");
            }
        }
        if (!(connection instanceof AbstractSQLConnection)) {
            throw new IllegalArgumentException("Connection " + connectionName + " is of type " + connection.getType() + " and doesn't have several catalogs");
        }
        FutureResponse<List<String>> res = this.connectionsService.listSqlCatalogs(((AbstractSQLConnection)connection).getConnectionData_NT(authCtx, projectKey), authCtx, projectKey);
        ConnectionsImportController.writeJSON((HttpServletResponse)resp, res);
    }

    @AuditedCall(value={"msgType", "connection-list-mass-import-schemas"})
    @RequestMapping(value={"/api/connections/list-sql-mass-import-schemas-with-catalogs"})
    public void listSQLMassImportSchemasWithCatalogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String connectionName) throws Exception {
        DSSConnection connection;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            connection = this.connectionsDAO.getMandatoryConnection(authCtx, connectionName);
            if (!connection.isFreelyUsableBy(authCtx)) {
                throw new DKUSecurityException("You may not use this connection");
            }
        }
        if (!(connection instanceof AbstractSQLConnection)) {
            throw new IllegalArgumentException("Connection " + connectionName + " is of type " + connection.getType() + " and doesn't have several schemas");
        }
        ConnectionsImportController.writeJSON((HttpServletResponse)resp, SQLUtils.listSchemasWithCatalogs(((AbstractSQLConnection)connection).getConnectionData_NT(authCtx, projectKey), authCtx, projectKey));
    }

    @AuditedCall(value={"msgType", "connection-list-mass-import-sql-tables"})
    @RequestMapping(value={"/api/connections/list-sql-mass-import-tables"})
    public void listSQLMassImportTables(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String connectionName, @RequestParam(required=false) String sourceCatalog, @RequestParam(required=false) String sourceSchema) throws Exception {
        AbstractSQLConnection sqlConnection;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            DSSConnection connection = this.connectionsDAO.getConnection(authCtx, connectionName);
            if (!(connection instanceof AbstractSQLConnection)) {
                throw ErrorContext.iaef((String)"Expected SQL connection type, got %s", (Object)connection.getType(), (Object[])new Object[0]);
            }
            if (!connection.isFreelyUsableBy(authCtx)) {
                throw ErrorContext.iaef((String)"Cannot use connection %s", (Object)connection.name, (Object[])new Object[0]);
            }
            sqlConnection = (AbstractSQLConnection)connection;
        }
        FutureResponse<ConnectionsImportService.SQLTableImportData> res = this.importService.startListSQLTables(sqlConnection, sourceCatalog, sourceSchema, authCtx, projectKey);
        ConnectionsImportController.writeJSON((HttpServletResponse)resp, res);
    }

    @AuditedCall(value={"msgType", "connection-list-mass-import-elasticsearch-indices"})
    @RequestMapping(value={"/api/connections/list-elasticsearch-mass-import-indices"})
    @ResponseBody
    public FutureResponse<ConnectionsImportService.ElasticSearchIndicesImportData> listElasticSearchMassImportIndices(HttpServletRequest req, @RequestParam String connectionName) throws Exception {
        ElasticSearchConnection elasticSearchConnection;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            DSSConnection connection = this.connectionsDAO.getConnection(authCtx, connectionName);
            if (!(connection instanceof ElasticSearchConnection)) {
                throw ErrorContext.iaef((String)"Expected ElasticSearch connection type, got %s", (Object)connection.getType(), (Object[])new Object[0]);
            }
            if (!connection.isFreelyUsableBy(authCtx)) {
                throw ErrorContext.iaef((String)"Cannot use connection %s", (Object)connection.name, (Object[])new Object[0]);
            }
            elasticSearchConnection = (ElasticSearchConnection)connection;
            if (!ElasticSearchDialect.ES_7.equals((Object)elasticSearchConnection.params.dialect)) {
                throw ErrorContext.iaef((String)"Listing indices is only supported for ES7 dialect, got %s", (Object)((Object)elasticSearchConnection.params.dialect), (Object[])new Object[0]);
            }
        }
        return this.importService.startListElasticSearchIndices(elasticSearchConnection, authCtx);
    }

    @AuditedCall(value={"msgType", "connection-list-mass-import-hive-tables"})
    @RequestMapping(value={"/api/connections/list-hive-mass-import-tables"})
    public void listHiveMassImportTables(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connectionName, @RequestParam(required=false) String projectKey) throws Exception {
        AuthCtx authCtx;
        ConnectionsDAO.VirtualConnectionId virtualConnectionId = ConnectionsDAO.parseVirtualConnection(connectionName);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        ConnectionsImportController.writeJSON((HttpServletResponse)resp, this.importService.startListMetastoreTables(projectKey, authCtx, virtualConnectionId));
    }

    @AuditedCall(value={"msgType", "table-import-candidate", "connection", "${connection}", "catalog", "${catalog}", "schema", "${schema}", "table", "${table}", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/connections/get-table-import-candidates-from-keys"})
    public void getTableImportCandidatesFromKeys(HttpServletRequest req, HttpServletResponse resp, @RequestParam String tables, @RequestParam(required=false) String remarks, @RequestParam String projectKey, @RequestParam(required=false) String targetConnection) throws Exception {
        AuthCtx u;
        List keys = (List)JSON.parse((String)tables, (TypeToken)new TypeToken<List<DatabaseObjectKey>>(){});
        List remarksList = null;
        if (remarks != null) {
            remarksList = (List)JSON.parse((String)remarks, (TypeToken)new TypeToken<List<String>>(){});
        }
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ConnectionsImportController.writeJSON((HttpServletResponse)resp, this.importService.startGetTableImportCandidatesFromKeys_NT(projectKey, keys, remarksList, targetConnection, u));
    }

    @AuditedCall(value={"msgType", "table-import-candidates-from-explorer", "workflowType", "${workflowType}", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/connections/get-table-import-candidates-from-explorer"})
    public void getTableImportCandidatesFromExplorer(HttpServletRequest req, HttpServletResponse resp, @RequestParam ExplorerWorkflowType workflowType, @RequestParam String tables, @RequestParam String projectKey) throws Exception {
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ConnectionsImportController.writeJSON((HttpServletResponse)resp, this.importService.startGetTableImportCandidatesFromExplorer_NT(u, projectKey, workflowType, tables));
    }

    @AuditedCall(value={"msgType", "connection-mass-import-candidates"})
    @RequestMapping(value={"/api/connections/mass-import-candidates"})
    public void massImportCandidates(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) String sqlTableCandidates, @RequestParam(required=false) String hiveTableCandidates, @RequestParam(required=false) String elasticSearchIndexCandidates, @RequestParam(required=false) String zoneId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        List sqlCandidates = (List)JSON.parse((String)sqlTableCandidates, (TypeToken)new TypeToken<List<ConnectionsImportService.SQLTableImportCandidate>>(){});
        List hiveCandidates = (List)JSON.parse((String)hiveTableCandidates, (TypeToken)new TypeToken<List<HiveImportabilityChecker.HiveTableImportCandidate>>(){});
        List elasticSearchCandidates = (List)JSON.parse((String)elasticSearchIndexCandidates, (TypeToken)new TypeToken<List<ConnectionsImportService.ElasticSearchIndexImportCandidate>>(){});
        FutureResponse<InfoMessage.InfoMessages> res = this.importService.massImportCandidates(projectKey, sqlCandidates, hiveCandidates, elasticSearchCandidates, authCtx, zoneId);
        ConnectionsImportController.writeJSON((HttpServletResponse)resp, res);
    }

    @AuditedCall(value={"msgType", "connection-list-mass-import-sql-tables"})
    @RequestMapping(value={"/api/connections/get-table-import-candidates-from-alation-mcc"})
    public void getImportableFromAlation(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String alationSelection) throws Exception {
        AuthCtx authCtx;
        AlationImportService.AlationCatalogSelection catalogSelection = (AlationImportService.AlationCatalogSelection)JSON.parse((String)alationSelection, AlationImportService.AlationCatalogSelection.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ConnectionsImportController.writeJSON((HttpServletResponse)resp, (Object)this.alationService.getTableImportCandidatesFromAlationSelection_NT(authCtx, projectKey, catalogSelection));
    }

    @AuditedCall(value={"msgType", "alation-register-opener"})
    @RequestMapping(value={"/api/connections/register-alation-opener"})
    public void registerAlationOpenIn(HttpServletRequest req, HttpServletResponse resp, @RequestParam String alationAPIToken) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        this.alationService.registerAlationOpener_NT(alationAPIToken);
    }

    @AuditedCall(value={"msgType", "start-mass-import-from-alation-open"})
    @RequestMapping(value={"/api/connections/init-import-from-alation-open"}, method={RequestMethod.POST})
    public void startMassImportFromAlationOpen(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        logger.info((Object)("Starting Alation import-from-open with params: " + JSON.json((Object)req.getParameterMap())));
        AlationImportService.AlationOpenRequest openRequest = new AlationImportService.AlationOpenRequest();
        openRequest.catalogSelection = new AlationImportService.AlationCatalogSelection();
        openRequest.catalogSelection.semanticMetadata = new AlationImportService.AlationCatalogSelection.AlationSemanticMetadata();
        openRequest.catalogSelection.semanticMetadata.title = req.getParameter("semanticMetadata[title]");
        openRequest.catalogSelection.semanticMetadata.description = req.getParameter("semanticMetadata[description]");
        openRequest.catalogSelection.qualifiedName = req.getParameter("qualifiedName");
        openRequest.catalogSelection.dataSource = new AlationImportService.AlationCatalogSelection.AlationCatalogDataSource();
        openRequest.catalogSelection.dataSource.catalogUrl = req.getParameter("dataSource[catalogUrl]");
        openRequest.catalogSelection.dataSource.type = req.getParameter("dataSource[type]");
        String requestId = this.alationService.registerNewOpenRequest(openRequest);
        JsonObject ret = new JsonObject();
        ret.addProperty("location", ApplicationConfigurator.getGeneralSettings().studioExternalUrl + "/alation-open/" + requestId);
        ConnectionsImportController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "get-alation-open-info"})
    @RequestMapping(value={"/api/connections/get-alation-open-info"})
    public void getAlationOpenInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String alationOpenId) throws Exception {
        logger.info((Object)("Getting Alation open info for openId=" + alationOpenId));
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            AlationImportService.AlationOpenRequest enrichedRequest = this.alationService.getEnrichedOpenRequest(authCtx, alationOpenId);
            ConnectionsImportController.writeJSON((HttpServletResponse)resp, (Object)enrichedRequest);
        }
    }

    public static class MassImportSources {
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        public List<MassImportSourceConnection> sources = Lists.newArrayList();
    }

    static class MassImportSourceConnection {
        public final String name;
        public final String type;
        public final String displayName;
        public String dialect;
        public boolean jdbcConnectionSupportsBrowsingCatalogs;
        public CatalogAndSchemaInputMode defaultCatalogAndSchemaInputMode = CatalogAndSchemaInputMode.DROPDOWN;
        public boolean allowCatalogAndSchemaFreeTextInput = false;
        public boolean allowCatalogAndSchemaDropdownInput = true;
        public String defaultCatalog;
        public String defaultSchema;

        MassImportSourceConnection(String name, String displayName, String type) {
            this.name = name;
            this.displayName = displayName;
            this.type = type;
        }

        MassImportSourceConnection(String name, String displayName, String type, String dialect) {
            this(name, displayName, type);
            this.dialect = dialect;
        }
    }

    public static enum CatalogAndSchemaInputMode {
        DROPDOWN,
        FREE_TEXT;

    }

    public static enum ExplorerWorkflowType {
        SQL,
        HIVE,
        ELASTIC_SEARCH;

    }
}

