/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.aiexplanations.ExplainStuffFrontendResponse;
import com.dataiku.dip.aiexplanations.code.AICodeExplanationService;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CodeToolsController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AICodeExplanationService aiCodeExplanationService;

    @AuditedCall(value={"msgType", "start-code-explanation"})
    @RequestMapping(value={"/api/code/ai-tools/start-code-explanation"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<ExplainStuffFrontendResponse> startCodeExplanation(HttpServletRequest req, @RequestParam String language, @RequestParam String code, @RequestParam String explanationOptions) throws Exception {
        DSSAuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
        }
        return this.aiCodeExplanationService.startExplainingCode(user, language, code, explanationOptions);
    }
}

