/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.PluginConfigUtils;
import com.dataiku.dip.plugins.PluginRequirementService;
import com.dataiku.dip.plugins.PluginStoreService;
import com.dataiku.dip.plugins.PluginsLoadService;
import com.dataiku.dip.plugins.PluginsSetupService;
import com.dataiku.dip.plugins.dev.DevPluginsService;
import com.dataiku.dip.plugins.dev.FolderEditorService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.MimeTypesSecurity;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class DevPluginsController
extends DIPInternalControllerBase {
    @Autowired
    UIAuthService authService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    IPluginsRegistryService pluginsRegistry;
    @Autowired
    PluginsLoadService loadService;
    @Autowired
    PluginRequirementService pluginRequirementService;
    @Autowired
    PluginStoreService pluginStoreService;
    @Autowired
    DevPluginsService devPluginsService;
    @Autowired
    PluginsSetupService pluginsSetupService;
    @Autowired
    IPermissionsService permissionsService;
    @Autowired
    DesignNodeCodeEnvsService designNodeEnvsService;
    @Autowired
    AutomationNodeCodeEnvsService automationNodeEnvsService;

    @AuditedCall(value={"msgType", "plugindev-reload-all"})
    @RequestMapping(value={"/api/plugins/dev/reload-all"})
    public void reloadDevPlugins(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.getAndCheckDevUser(req);
            this.loadService.reloadDevPlugins();
            this.pluginsSetupService.killSessions();
        }
    }

    @AuditedCall(value={"msgType", "plugindev-reload", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/reload"})
    public void reloadDevPlugin(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.getAndCheckDevUser(req);
            this.loadService.reloadPlugin(pluginId);
        }
    }

    @AuditedCall(value={"msgType", "plugindev-list"})
    @RequestMapping(value={"/api/plugins/dev/list"})
    @ResponseBody
    public List<InstalledPluginDesc> listDevPlugins(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.getAndCheckDevUser(req);
            List<InstalledPluginDesc> list = this.devPluginsService.listDevPlugins();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-get", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/get"})
    @ResponseBody
    public DevPluginsService.DevPluginData getDevPlugin(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.DevPluginData devPluginData = this.devPluginsService.getMandatory(authCtx, pluginId);
            return devPluginData;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-create", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/create"})
    @ResponseBody
    public FutureResponse<InfoMessage> bootstrapDevPlugin(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String bootstrapMode, @RequestParam String gitRepository, @RequestParam String gitCheckout, @RequestParam String gitPath) throws Exception {
        AuthCtx authCtx;
        DevPluginsService.DevPluginBootstrapMode mode;
        try {
            mode = DevPluginsService.DevPluginBootstrapMode.valueOf(bootstrapMode);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid plugin bootstrap mode:" + bootstrapMode, e);
        }
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckDevUser(req);
        }
        return this.devPluginsService.startCreatePlugin(pluginId, mode, gitRepository, gitCheckout, gitPath, authCtx);
    }

    @AuditedCall(value={"msgType", "plugindev-download", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/download"})
    public void downloadDevPlugin(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        String now = DKUtils.getDateFormatter((String)"_yyyy_MM_dd").print(new Date().getTime());
        String dlName = "dssPlugin_" + pluginId + "_" + now + ".zip";
        String cd = String.format("attachment; filename=\"%s\"", dlName);
        resp.setHeader("Content-Disposition", cd);
        this.devPluginsService.streamPluginContent_NT(pluginId, (OutputStream)resp.getOutputStream());
    }

    @AuditedCall(value={"msgType", "plugindev-delete", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/delete"})
    public void deleteDevPlugin(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        AuthCtx authCtx = this.getAndCheckDevUser_NT(req);
        this.devPluginsService.deleteDevPlugin_NT(pluginId, authCtx);
    }

    @AuditedCall(value={"msgType", "plugindev-list-contents", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/list-contents"})
    @ResponseBody
    public List<FolderEditorService.FolderContent> listPluginContents(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.getAndCheckDevUser(req);
            List<FolderEditorService.FolderContent> list = this.devPluginsService.getDevPluginContent_NT(pluginId);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-get-coontent", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/get-content"})
    @ResponseBody
    public FolderEditorService.FolderContent getPluginContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String path, @RequestParam boolean sendAnyway) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.getAndCheckDevUser(req);
            FolderEditorService.FolderContent folderContent = this.devPluginsService.getDevPluginContent_NT(pluginId, path, sendAnyway);
            return folderContent;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-preview-image", "pluginId", "${pluginId}", "path", "${path}", "contentType", "${contentType}"})
    @RequestMapping(value={"/api/plugins/dev/preview-image"}, method={RequestMethod.GET})
    public void previewImage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String path, @RequestParam String contentType) throws Exception {
        byte[] picData;
        MimeTypesSecurity.failIfNotSafeImageType((String)contentType);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
            picData = this.devPluginsService.previewImageStream_NT(pluginId, path);
        }
        resp.setContentType(contentType);
        resp.getOutputStream().write(picData);
    }

    @AuditedCall(value={"msgType", "plugindev-set-content", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/set-content"})
    public void setPluginContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String path, @RequestParam String data) throws Exception {
        AuthCtx authCtx = this.getAndCheckDevUser_NT(req);
        this.devPluginsService.setOrAddDevPluginContent_NT(pluginId, path, data, authCtx);
    }

    @AuditedCall(value={"msgType", "plugindev-set-content-muliple", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/set-content-multiple"})
    public void setPluginContentList(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String contentMap) throws Exception {
        AuthCtx authCtx = this.getAndCheckDevUser_NT(req);
        Map fileMap = (Map)JSON.parse((String)contentMap, (TypeToken)new TypeToken<Map<String, String>>(){});
        this.devPluginsService.setDevPluginContentList_NT(pluginId, fileMap, authCtx);
    }

    @AuditedCall(value={"msgType", "plugindev-validate", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/validate"})
    @ResponseBody
    public InfoMessage.InfoMessages validate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String contentMap) throws Exception {
        this.getAndCheckDevUser_NT(req);
        Map fileMap = (Map)JSON.parse((String)contentMap, (TypeToken)new TypeToken<Map<String, String>>(){});
        return this.devPluginsService.validatePluginContent(pluginId, fileMap);
    }

    @AuditedCall(value={"msgType", "plugindev-create-content", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/create-content"})
    public void createPluginContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String path, @RequestParam boolean isFolder) throws Exception {
        AuthCtx authCtx = this.getAndCheckDevUser_NT(req);
        this.devPluginsService.addDevPluginContent_NT(pluginId, path, isFolder, authCtx);
    }

    @AuditedCall(value={"msgType", "plugindev-delete-content", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/delete-content"})
    public void deletePluginContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String path) throws Exception {
        AuthCtx authCtx = this.getAndCheckDevUser_NT(req);
        this.devPluginsService.removeDevPluginContent_NT(pluginId, path, authCtx);
    }

    @AuditedCall(value={"msgType", "plugindev-decompress-content", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/decompress-content"})
    public void decompressPluginContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String path) throws Exception {
        AuthCtx authCtx = this.getAndCheckDevUser_NT(req);
        this.devPluginsService.decompressDevPluginContent_NT(pluginId, path, authCtx);
    }

    @AuditedCall(value={"msgType", "plugindev-rename-content", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/rename-content"})
    @ResponseBody
    public FolderEditorService.FolderContent renamePluginContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String path, @RequestParam String newName) throws Exception {
        AuthCtx authCtx = this.getAndCheckDevUser_NT(req);
        return this.devPluginsService.renameDevPluginContent_NT(pluginId, path, newName, authCtx);
    }

    @AuditedCall(value={"msgType", "plugindev-move-content", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/move-content"})
    @ResponseBody
    public FolderEditorService.FolderContent movePluginContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String path, @RequestParam String toPath) throws Exception {
        AuthCtx authCtx = this.getAndCheckDevUser_NT(req);
        return this.devPluginsService.moveDevPluginContent_NT(pluginId, path, toPath, authCtx);
    }

    @AuditedCall(value={"msgType", "plugindev-copy-content", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/copy-content"})
    @ResponseBody
    public FolderEditorService.FolderContent copyPluginContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String path) throws Exception {
        AuthCtx authCtx = this.getAndCheckDevUser_NT(req);
        return this.devPluginsService.copyDevPluginContent_NT(pluginId, path, authCtx);
    }

    @AuditedCall(value={"msgType", "plugindev-check-upload-content", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/check-upload-content"})
    @ResponseBody
    public FolderEditorService.UploadFeasabilities checkUploadContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String path, @RequestParam(value="filePaths") String filePathsData) throws Exception {
        this.getAndCheckDevUser_NT(req);
        List filePaths = (List)JSON.parse((String)filePathsData, (TypeToken)new TypeToken<List<String>>(){});
        return this.devPluginsService.checkUploadContent_NT(pluginId, path, filePaths);
    }

    @AuditedCall(value={"msgType", "plugindev-upload-content", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/upload-content"})
    @ResponseBody
    public FolderEditorService.FolderContent uploadContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String path, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        return this.devPluginsService.uploadContent_NT(pluginId, path, filePart.getInputStream(), filePart.getOriginalFilename(), authCtx);
    }

    @AuditedCall(value={"msgType", "plugindev-download", "pluginId", "${pluginId}", "path", "${path}"})
    @RequestMapping(value={"/api/plugins/dev/download-content"}, method={RequestMethod.GET})
    public void previewImage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String path) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
            this.devPluginsService.streamContent_NT(pluginId, path, resp);
        }
    }

    @AuditedCall(value={"msgType", "plugindev-use-venv", "pluginId", "${pluginId}", "envName", "${envName}"})
    @RequestMapping(value={"/api/plugins/dev/use-code-env"})
    public void useDevPluginCodeEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String envName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            this.permissionsService.checkCreateCodeEnvPrivilege(authCtx);
            PluginSettings settings = this.pluginsRegistry.getSettings(pluginId);
            settings.codeEnvName = envName;
            this.pluginsRegistry.setSettings(pluginId, settings);
            t.commit("Changed code env on plugin " + pluginId);
        }
    }

    @AuditedCall(value={"msgType", "plugindev-set-active-remote", "pluginId", "${pluginId}", "remoteName", "${remoteName}"})
    @RequestMapping(value={"/api/plugins/dev/set-active-remote"})
    public void setDevPluginDefaultRemote(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String remoteName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.getAndCheckDevUser(req);
            PluginSettings settings = this.pluginsRegistry.getSettings(pluginId);
            settings.gitConfig.defaultRemoteName = remoteName;
            this.pluginsRegistry.setSettings(pluginId, settings);
            t.commit("Set default Git remote on " + pluginId + " to " + remoteName);
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-python-prediction-algorithm", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-python-prediction-algorithm"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addPythonPredictionAlgorithm(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String algoId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewPythonPredictionAlgoToDevPlugin(pluginId, pluginId + "_" + algoId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-standard-webapp-template", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-standard-webapp-template"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addStandardWebAppTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String webAppId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewStandardWebAppTemplateToDevPlugin(pluginId, pluginId + "_" + webAppId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-bokeh-webapp-template", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-bokeh-webapp-template"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addBokehWebAppTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String webAppId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewBokehWebAppTemplateToDevPlugin(pluginId, pluginId + "_" + webAppId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-dash-webapp-template", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-dash-webapp-template"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addDashdWebAppTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String webAppId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewDashWebAppTemplateToDevPlugin(pluginId, pluginId + "_" + webAppId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-shiny-webapp-template", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-shiny-webapp-template"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addShinydWebAppTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String webAppId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewShinyWebAppTemplateToDevPlugin(pluginId, pluginId + "_" + webAppId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-rmarkdown-report-template", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-rmarkdown-report-template"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addRMarkdownReportTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String reportId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewRMarkdownReportTemplateToDevPlugin(pluginId, pluginId + "_" + reportId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-notebook-template", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-notebook-template"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addNotebookTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String language, @RequestParam boolean preBuilt, @RequestParam String type, @RequestParam String notebookId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewNotebookTemplateToDevPlugin(pluginId, pluginId + "_" + notebookId, type, language, preBuilt, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-python-dataset", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-python-dataset"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addPythonDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String datasetId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomPyDatasetToDevPlugin(pluginId, pluginId + "_" + datasetId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-java-dataset", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-java-dataset"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addJavaDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String datasetId, @RequestParam String className) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomJavaDatasetToDevPlugin(pluginId, pluginId + "_" + datasetId, className, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-sample-dataset", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-sample-dataset"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addSampleDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String label) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomSampleDatasetToDevPlugin(pluginId, label, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-java-recipe", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-java-recipe"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addJavaRecipe(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String recipeId, @RequestParam String className) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomJavaRecipeToDevPlugin(pluginId, pluginId + "_" + recipeId, className, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-java-dialect", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-java-dialect"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addJavaDialect(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String dialectId, @RequestParam String className) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomJavaDialectToDevPlugin(pluginId, pluginId + "_" + dialectId, className, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-java-dialect", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-java-exposition"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addJavaExpositions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String expositionId, @RequestParam String className) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomJavaExpositionToDevPlugin(pluginId, pluginId + "_" + expositionId, className, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-python-format", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-python-format"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addPythonFormat(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String formatId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomPyFormatToDevPlugin(pluginId, formatId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-java-format", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-java-format"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addJavaFormat(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String formatId, @RequestParam String className) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomJavaFormatToDevPlugin(pluginId, formatId, className, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-python-probe", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-python-probe"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addPythonProbe(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String probeId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomPyProbeToDevPlugin(pluginId, probeId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-python-exporter", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-python-exporter"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addPythonExporter(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String exporterId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomPyExporterToDevPlugin(pluginId, exporterId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-java-exporter", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-java-exporter"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addJavaExporter(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String exporterId, @RequestParam String className) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomJavaExporterToDevPlugin(pluginId, exporterId, className, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-python-check", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-python-check"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addPythonCheck(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String checkId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomPyCheckToDevPlugin(pluginId, checkId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-sql-probe", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-sql-probe"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addSQLProbe(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String probeId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomSqlProbeToDevPlugin(pluginId, probeId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-python-step", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-python-step"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addPythonStep(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String stepId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomPyStepToDevPlugin(pluginId, stepId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-edit", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-custom-fields"})
    @ResponseBody
    public Object addCustomFields(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String customFieldsId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            Object object = this.devPluginsService.addNewCustomFieldsToDevPlugin(pluginId, customFieldsId, authCtx);
            return object;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-edit", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-java-policy-hooks"})
    @ResponseBody
    public Object addJavaPolicyHooks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String policyHooksId, @RequestParam String className) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            Object object = this.devPluginsService.addNewCustomJavaPolicyHookToDevPlugin(pluginId, policyHooksId, className, authCtx);
            return object;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-edit", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-java-user-supplier"})
    @ResponseBody
    public Object addJavaUserSupplier(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String userSupplierId, @RequestParam String className) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            Object object = this.devPluginsService.addNewCustomJavaUserSupplierToDevPlugin(pluginId, userSupplierId, className, authCtx);
            return object;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-edit", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-java-user-authenticator"})
    @ResponseBody
    public Object addJavaUserAuthenticator(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String userSupplierId, @RequestParam String className) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            Object object = this.devPluginsService.addNewCustomJavaUserAuthenticatorToDevPlugin(pluginId, userSupplierId, className, authCtx);
            return object;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-edit", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-java-user-authenticator-and-supplier"})
    @ResponseBody
    public Object addJavaUserAuthenticatorAndSupplier(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String userSupplierId, @RequestParam String className) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            Object object = this.devPluginsService.addNewCustomJavaUserAuthenticatorAndSupplierToDevPlugin(pluginId, userSupplierId, className, authCtx);
            return object;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-python-cluster", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-python-cluster"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addPythonCluster(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String clusterId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomPyClusterToDevPlugin(pluginId, clusterId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-python-code-studio-block", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-python-code-studio-block"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addPythonCodeStudioBlock(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String codeStudioBlockId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomPyCodeStudioBlockToDevPlugin(pluginId, codeStudioBlockId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-python-code-studio", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-python-code-studio"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addPythonCodeStudioTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String codeStudioId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomPyCodeStudioTemplateToDevPlugin(pluginId, codeStudioId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-python-project-standards-check-spec", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-python-project-standards-check-spec"})
    public void addPythonProjectStandardsCheckSpec(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String projectStandardsCheckSpecId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.devPluginsService.addNewCustomPyProjectStandardsCheckSpecToDevPlugin(pluginId, projectStandardsCheckSpecId, authCtx));
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-jython-processor", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-jython-processor"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addJythonProcessor(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String stepId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomJythonProcessorToDevPlugin(pluginId, stepId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-python-trigger", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-python-trigger"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addPythonTrigger(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String triggerId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomPyTriggerToDevPlugin(pluginId, triggerId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-python-runnable", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-python-runnable"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addPythonRunnable(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String runnableId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomPyRunnableToDevPlugin(pluginId, runnableId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-java-runnable", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-java-runnable"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addJavaRunnable(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String runnableId, @RequestParam String className) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomJavaRunnableToDevPlugin(pluginId, runnableId, className, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-python-fs-provider", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-python-fs-provider"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addPythonFSProvider(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String fsProviderId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomPyFSProviderToDevPlugin(pluginId, pluginId + "_" + fsProviderId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-java-fs-provider", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-java-fs-provider"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addJavaFSProvider(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String fsProviderId, @RequestParam String className) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomJavaFSProviderToDevPlugin(pluginId, pluginId + "_" + fsProviderId, className, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-python-code-env", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-python-code-env"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addPythonCodeEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam(required=false, defaultValue="false") boolean forceConda) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomCodeEnvToDevPlugin(pluginId, CodeEnvModel.EnvLang.PYTHON, forceConda, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-r-code-env", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-r-code-env"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addRCodeEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam(required=false, defaultValue="false") boolean forceConda) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addNewCustomCodeEnvToDevPlugin(pluginId, CodeEnvModel.EnvLang.R, forceConda, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-remove-code-env", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/remove-code-env"})
    public void removeCodeEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            this.devPluginsService.removeCustomCodeEnvFromDevPlugin(pluginId, authCtx);
        }
    }

    @AuditedCall(value={"msgType", "plugindev-edit", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/dev/add-parameter-set"})
    @ResponseBody
    public synchronized DevPluginsService.RecipeConversionResult addParameterSet(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String parameterSetId) throws Exception {
        DevPluginsService.RecipeConversionResult ret;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            ret = this.devPluginsService.addNewParameterSetToDevPlugin(pluginId, parameterSetId, authCtx);
        }
        t = this.transactionService.beginWriteAsDSS();
        try {
            PluginSettings settings = this.pluginsRegistry.getSettings(pluginId);
            PluginConfigUtils.setDefaultParameterSetPermissions(this.pluginsRegistry.getInstalledDescMand(pluginId), settings);
            this.pluginsRegistry.setSettings(pluginId, settings);
            t.commit("Bootstrap settings of parameter sets in " + pluginId);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        return ret;
    }

    @AuditedCall(value={"msgType", "plugindev-add-guardrail", "pluginId", "${pluginId}", "guardrailId", "${guardrailId}"})
    @RequestMapping(value={"/api/plugins/dev/add-guardrail"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addGuardrail(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String guardrailId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addGuardrailToDevPlugin(pluginId, guardrailId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-agent", "pluginId", "${pluginId}", "agentId", "${agentId}"})
    @RequestMapping(value={"/api/plugins/dev/add-agent"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addAgent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String agentId, @RequestParam String template) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addAgentToDevPlugin(pluginId, agentId, template, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-agent-tool", "pluginId", "${pluginId}", "toolId", "${toolId}"})
    @RequestMapping(value={"/api/plugins/dev/add-agent-tool"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addAgentTool(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String toolId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addAgentToolToDevPlugin(pluginId, toolId, authCtx);
            return recipeConversionResult;
        }
    }

    @AuditedCall(value={"msgType", "plugindev-add-custom-llm", "pluginId", "${pluginId}", "llmId", "${llmId}"})
    @RequestMapping(value={"/api/plugins/dev/add-custom-llm"})
    @ResponseBody
    public DevPluginsService.RecipeConversionResult addCustomLLM(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String llmId, @RequestParam String codeTemplate) throws Exception {
        String jsonModelTemplate;
        String pythonModelTemplate = switch (codeTemplate) {
            case "text-completion" -> {
                jsonModelTemplate = "bootstrap-python-custom-llm.json";
                yield "bootstrap-python-custom-llm.py";
            }
            case "embedding" -> {
                jsonModelTemplate = "bootstrap-python-custom-embedding.json";
                yield "bootstrap-python-custom-embedding.py";
            }
            case "image-generation" -> {
                jsonModelTemplate = "bootstrap-python-custom-image-generation.json";
                yield "bootstrap-python-custom-image-generation.py";
            }
            default -> throw new IllegalArgumentException(String.format("'%s' model type is not recognized, expecting one of 'text-completion', 'image-generation' or 'embedding'.", codeTemplate));
        };
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            DevPluginsService.RecipeConversionResult recipeConversionResult = this.devPluginsService.addCustomLLMToDevPlugin(pluginId, llmId, authCtx, jsonModelTemplate, pythonModelTemplate);
            return recipeConversionResult;
        }
    }

    private AuthCtx getAndCheckDevUser_NT(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getAndCheckDevUser(req);
            return authCtx;
        }
    }

    private AuthCtx getAndCheckDevUser(HttpServletRequest req) throws Exception {
        AuthCtx authCtx = this.authService.getMandatoryUser(req);
        this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        return authCtx;
    }
}

