/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.experimenttracking.Experiment;
import com.dataiku.dip.experimenttracking.ExperimentTrackingService;
import com.dataiku.dip.experimenttracking.Run;
import com.dataiku.dip.experimenttracking.ViewType;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/experiment-tracking"})
public class ExperimentTrackingController
extends DIPInternalControllerBase {
    private static final int MAX_RESULTS = 100000;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ExperimentTrackingService experimentTrackingService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private UIAuthService authService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.experimenttracking.controller");

    @AuditedCall(value={"msgType", "experiments-get", "projectKey", "${projectKey}", "experimentId", "${experimentId}"})
    @RequestMapping(value={"/experiments/get"})
    @ResponseBody
    public Experiment getExperiment(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String experimentId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.experimentTrackingService.getExperiment(projectKey, experimentId);
    }

    @AuditedCall(value={"msgType", "experiments-list", "projectKey", "${projectKey}", "viewType", "${viewType}"})
    @RequestMapping(value={"/experiments/list"})
    @ResponseBody
    public List<Experiment> listExperiments(HttpServletRequest req, @RequestParam String projectKey, @RequestParam(defaultValue="ACTIVE_ONLY") ViewType viewType) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.experimentTrackingService.listExperiments(projectKey, 1000L, viewType, true);
    }

    @AuditedCall(value={"msgType", "runs-search", "projectKey", "${projectKey}", "experimentIds", "${experimentIds}", "viewType", "${viewType}"})
    @RequestMapping(value={"/runs/search"})
    @ResponseBody
    public List<Run> searchRuns(HttpServletRequest req, @RequestParam String projectKey, @RequestParam List<String> experimentIds, @RequestParam(defaultValue="ACTIVE_ONLY") ViewType viewType) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.experimentTrackingService.searchRuns_NT(projectKey, experimentIds, viewType, "", 100000L, Collections.emptyList(), true);
    }

    @AuditedCall(value={"msgType", "runs-get", "projectKey", "${projectKey}", "runId", "${runId}"})
    @RequestMapping(value={"/runs/get"})
    @ResponseBody
    public Run getRun(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String runId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.experimentTrackingService.getRun(projectKey, runId, true);
    }

    @AuditedCall(value={"msgType", "delete-experiments", "projectKey", "${projectKey}", "experimentIds", "${experimentIds}"})
    @ResponseBody
    @RequestMapping(value={"/delete-experiments"}, method={RequestMethod.POST})
    public String[] deleteExperiments(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String experimentIds) throws IOException, DKUSecurityException, SQLException {
        String[] experimentIdsArray = (String[])JSON.parse((String)experimentIds, String[].class);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        for (String experimentId : experimentIdsArray) {
            logger.debugV("Logically deleting experiment %s of project %s", new Object[]{experimentId, projectKey});
            this.experimentTrackingService.deleteExperiment(projectKey, experimentId);
        }
        return experimentIdsArray;
    }

    @AuditedCall(value={"msgType", "restore-experiments", "projectKey", "${projectKey}", "experimentIds", "${experimentIds}"})
    @ResponseBody
    @RequestMapping(value={"/restore-experiments"}, method={RequestMethod.POST})
    public String[] restoreExperiments(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String experimentIds) throws IOException, DKUSecurityException, SQLException {
        String[] experimentIdsArray = (String[])JSON.parse((String)experimentIds, String[].class);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        for (String experimentId : experimentIdsArray) {
            logger.debugV("Restoring experiment %s of project %s", new Object[]{experimentId, projectKey});
            this.experimentTrackingService.restoreExperiment(projectKey, experimentId);
        }
        return experimentIdsArray;
    }

    @AuditedCall(value={"msgType", "delete-runs", "projectKey", "${projectKey}", "runIds", "${runIds}"})
    @ResponseBody
    @RequestMapping(value={"/delete-runs"}, method={RequestMethod.POST})
    public String[] deleteRuns(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String runIds) throws IOException, DKUSecurityException, SQLException {
        String[] runIdsArray = (String[])JSON.parse((String)runIds, String[].class);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        for (String runId : runIdsArray) {
            logger.debugV("Logically deleting run %s of project %s", new Object[]{runId, projectKey});
            this.experimentTrackingService.deleteRun(projectKey, runId);
        }
        return runIdsArray;
    }

    @AuditedCall(value={"msgType", "restore-runs", "projectKey", "${projectKey}", "runIds", "${runIds}"})
    @ResponseBody
    @RequestMapping(value={"/restore-runs"}, method={RequestMethod.POST})
    public String[] restoreRuns(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String runIds) throws IOException, DKUSecurityException, SQLException {
        String[] runIdsArray = (String[])JSON.parse((String)runIds, String[].class);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        for (String runId : runIdsArray) {
            logger.debugV("Restoring run %s of project %s", new Object[]{runId, projectKey});
            this.experimentTrackingService.restoreRun(projectKey, runId);
        }
        return runIdsArray;
    }

    @AuditedCall(value={"msgType", "compare-with-experiment-tracking", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/compare-with-experiment-tracking"})
    public void createRunsForAnalysisModels(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String modelIds, @RequestParam String experimentId) throws Exception {
        AuthCtx user;
        logger.debug((Object)("Comparing with experiment tracking model_ids : " + modelIds));
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = this.authService.getMandatoryUser(req);
        }
        List fmis = (List)JSON.parse((String)modelIds, JSON.StringList.class);
        List<FullModelId> fullModelIds = fmis.stream().map(FullModelId::parse).collect(Collectors.toList());
        this.experimentTrackingService.createRunsFromAnalyses(user, projectKey, fullModelIds, experimentId);
    }

    @AuditedCall(value={"msgType", "compare-with-experiment-tracking", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/create-experiment-tracking-for-analysis-models"}, method={RequestMethod.POST})
    public void createEmptyExperimentForLabModels(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String experimentName) throws Exception {
        String experimentId = this.experimentTrackingService.createExperiment("/dummy", projectKey, experimentName, "/", Collections.emptyList());
        ExperimentTrackingController.writeJSON((HttpServletResponse)resp, (Object)experimentId);
    }
}

