/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ModelEvaluationStoresController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ModelEvaluationStoresCRUDService service;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    public static final int DEFAULT_MAX_EVALUATION_LIST_LENGTH = 1000;
    public static final String DKU_MAX_EVALUATION_LIST_LENGTH = "dku.max.evaluation_list.length";
    static DKULogger logger = DKULogger.getLogger((String)"dku.modelevaluationstores.controller");

    @AuditedCall(value={"msgType", "modelevaluationstore-get", "projectKey", "${projectKey}", "mesId", "${smartId}"})
    @RequestMapping(value={"/api/modelevaluationstores/get"})
    public void getModelEvaluationStore(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smartId) throws Exception {
        ModelEvaluationStore mes;
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, smartId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
            mes = this.service.lookupMandatoryUnsafe(ref.getProjectKey(projectKey), ref.objectId);
        }
        ModelEvaluationStoresController.writeJSON((HttpServletResponse)resp, (Object)mes);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-get-full-info", "projectKey", "${projectKey}", "mesId", "${smartId}"})
    @RequestMapping(value={"/api/modelevaluationstores/get-full-info"})
    public void getFullInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smartId) throws Exception {
        NavigatorService.ModelEvaluationStoreFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, smartId);
            this.projectsService.failIfNoModelEvaluationStoreReadUseAccess(u, loc, projectKey);
            info = this.navigatorService.getModelEvaluationStoreFullInfo(loc, projectKey, u);
        }
        this.navigatorService.addInfo_NT(info, u);
        ModelEvaluationStoresController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditedCall(value={"msgType", "modelevaluationstores-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/modelevaluationstores/list"})
    public void listModelEvaluationStores(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        List<ModelEvaluationStore> list;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            list = this.service.list(projectKey);
        }
        ModelEvaluationStoresController.writeJSON((HttpServletResponse)resp, list);
    }

    @AuditedCall(value={"msgType", "modelevaluationstores-list-with-accessible", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/modelevaluationstores/list-with-accessible"})
    public void listModelEvaluationStoresWithAccessible(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        List<ModelEvaluationStore> list;
        try (Transaction t = this.transactionService.beginRead();){
            list = this.service.list(projectKey);
            for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedModelEvaluationStores(projectKey)) {
                ModelEvaluationStore model = this.service.getOrNull(datasetLoc.getProjectKey(), datasetLoc.getId());
                if (model == null) continue;
                SmartObjectRef ref = SmartObjectRef.fromResolved(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, datasetLoc.getProjectKey(), datasetLoc.getId(), datasetLoc.getProjectKey());
                this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
                list.add(model);
            }
        }
        ModelEvaluationStoresController.writeJSON((HttpServletResponse)resp, list);
    }

    @AuditedCall(value={"msgType", "modelevaluationstores-list-heads", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/modelevaluationstores/list-heads"})
    public void listModelEvaluationStoresHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx;
        ArrayList<ModelEvaluationStore.ModelEvaluationStoreListItem> heads = new ArrayList<ModelEvaluationStore.ModelEvaluationStoreListItem>();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            List<ModelEvaluationStore> list = this.service.list(projectKey);
            for (ModelEvaluationStore mes : list) {
                ModelEvaluationStore.ModelEvaluationStoreListItem item = new ModelEvaluationStore.ModelEvaluationStoreListItem(mes);
                this.taggableObjectsService.setEditionInfoFromTags(mes, item);
                item.evaluationCount = this.service.listRunIds(mes).size();
                heads.add(item);
            }
        }
        this.interestsService.enrichListItems(authCtx.getAssociatedDSSUser(), projectKey, heads);
        ModelEvaluationStoresController.writeJSON((HttpServletResponse)resp, heads);
    }

    @AuditInline
    @RequestMapping(value={"/api/modelevaluationstores/save"}, method={RequestMethod.POST})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data, @RequestParam(required=false) String saveInfo) throws Exception {
        ModelEvaluationStore mes = (ModelEvaluationStore)JSON.parse((String)data, ModelEvaluationStore.class);
        TaggableObjectsService.TaggableObjectSaveInfo si = TaggableObjectsService.TaggableObjectSaveInfo.parse(saveInfo);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, mes.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.service.save(mes, false, si.summaryOnly);
            if (si.summaryOnly) {
                t.commit("Updated summary for model evaluation store " + mes.projectKey + "." + mes.name + " (id: " + mes.id + ")", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            } else {
                t.commit("Saved model evaluation store " + mes.projectKey + "." + mes.name + " (id: " + mes.id + ")");
            }
            this.auditTrailService.generic("modelevaluationstore-save").with("projectKey", mes.projectKey).with("mesId", mes.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("modelevaluationstore-save", (Throwable)e).with("projectKey", mes.projectKey).with("mesId", mes.id).emit();
        }
        ModelEvaluationStoresController.writeJSONString((HttpServletResponse)resp, (String)"{}");
    }

    @AuditedCall(value={"msgType", "modelevaluationstores-rename", "projectKey", "${projectKey}", "mesId", "${mesId}", "newName", "${newName}"})
    @RequestMapping(value={"/api/modelevaluationstores/rename"}, method={RequestMethod.POST})
    public void rename(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String mesId, @RequestParam String newName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.service.rename(projectKey, mesId, newName);
            t.commit("Renamed model evaluation store to " + newName + " (id: " + mesId + ")");
        }
    }

    @AuditedCall(value={"msgType", "modelevaluationstores-get-summary", "projectKey", "${projectKey}", "mesId", "${id}"})
    @RequestMapping(value={"/api/modelevaluationstores/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        AuthCtx authCtx;
        TaggableObjectsService.TaggableObjectSummary summ = new TaggableObjectsService.TaggableObjectSummary();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            ModelEvaluationStore mes = this.service.getMandatoryUnsafe(projectKey, id);
            this.projectsService.failIfNoModelEvaluationStoreReadUseAccess(authCtx, mes.getLoc(), projectKey);
            summ.object = mes;
        }
        summ.timeline = this.timelinesService.getObjectTimeline_NT(summ.object.getTaggableType(), projectKey, id, summ.object.creationTag, summ.object.versionTag, 0, 100);
        summ.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summ.object.getTaggableType(), projectKey, id);
        ModelEvaluationStoresController.writeJSON((HttpServletResponse)resp, (Object)summ);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-list-evaluations", "projectKey", "${projectKey}", "mesId", "${smartId}"})
    @RequestMapping(value={"/api/modelevaluationstores/list-evaluations"})
    public void listModelEvaluations(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smartId) throws Exception {
        ModelEvaluationStoreEvaluationHeaders ret = new ModelEvaluationStoreEvaluationHeaders();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, smartId);
            this.projectsService.failIfNoModelEvaluationStoreReadUseAccess(u, loc, projectKey);
            ret.modelEvaluationStore = this.service.getMandatoryUnsafe(projectKey, smartId);
        }
        int maxEvaluations = DKUApp.getProperty((String)DKU_MAX_EVALUATION_LIST_LENGTH, (int)1000);
        ret.evaluationHeaders = this.service.listEvaluations(ret.modelEvaluationStore, ret.infoMessages, maxEvaluations);
        ModelEvaluationStoresController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-get-evaluation-details", "projectKey", "${projectKey}", "mesId", "${smartId}", "evaluationId", "${evaluationId}"})
    @RequestMapping(value={"/api/modelevaluationstores/get-evaluation-details"})
    public void getModelEvaluation(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smartId, @RequestParam String evaluationId) throws Exception {
        ModelEvaluationStoreEvaluationDetails ret = new ModelEvaluationStoreEvaluationDetails();
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, smartId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
            ret.modelEvaluationStore = this.service.getMandatoryUnsafe(projectKey, smartId);
            ret.evaluationDetails = this.service.getEvaluationDetails(ret.modelEvaluationStore, evaluationId);
        }
        ModelEvaluationStoresController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-get-latest-evaluation-details", "projectKey", "${projectKey}", "mesId", "${smartId}", "evaluationId", "${evaluationId}"})
    @RequestMapping(value={"/api/modelevaluationstores/get-latest-evaluation-details"})
    public void getLatestEvaluationDetails(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smartId) throws Exception {
        ModelEvaluationStoresCRUDService.AbstractModelEvaluationDetails ret;
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, smartId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
            ModelEvaluationStore mes = this.service.getMandatoryUnsafe(projectKey, smartId);
            ret = this.service.getLatestModelEvaluation(projectKey, mes);
        }
        if (ret != null) {
            ModelEvaluationStoresController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-delete-evaluations", "projectKey", "${projectKey}", "mesId", "${smartId}"})
    @RequestMapping(value={"/api/modelevaluationstores/delete-evaluations"})
    public void deleteModelEvaluations(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smartId, @RequestParam List<String> evaluations) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, smartId);
            this.projectsService.failIfNoModelEvaluationStoreReadUseAccess(u, loc, projectKey);
            ModelEvaluationStore mes = this.service.getMandatoryUnsafe(projectKey, smartId);
            this.service.deleteEvaluations(mes, evaluations);
        }
    }

    public static class ModelEvaluationStoreEvaluationHeaders {
        public ModelEvaluationStore modelEvaluationStore;
        public List<ModelEvaluationStoresCRUDService.ModelEvaluationHeader> evaluationHeaders = Lists.newArrayList();
        public InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
    }

    public static class ModelEvaluationStoreEvaluationDetails {
        public ModelEvaluationStore modelEvaluationStore;
        public ModelEvaluationStoresCRUDService.AbstractModelEvaluationDetails evaluationDetails;
    }
}

