/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderCodes;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.SQLCommentService;
import com.dataiku.dip.server.services.AccessibleObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectCodes;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsSaveService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.EnumUtils;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/taggable-objects"})
public class TaggableObjectsController
extends DIPInternalControllerBase {
    @Autowired
    private TaggableObjectsDeletionService taggableObjectsDeletionService;
    @Autowired
    private ITaggingService taggingService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private SQLCommentService sqlCommentService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private DatasetAccessService datasetsAccessService;
    @Autowired
    private DatasetDeletionService datasetsDeletionService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private TaggableObjectsSaveService taggableObjectsSaveService;
    @Autowired
    private JupyterService jupyterService;
    @Autowired
    private AccessibleObjectsService accessibleObjectsService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.taggableItems.controller");

    @AuditedCall(value={"msgType", "accessible-objects-count", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/count-accessible-objects"})
    public void countAccessibleObjects(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            TaggableObjectsController.writeJSON((HttpServletResponse)resp, (Object)this.accessibleObjectsService.countAccessibleObjectsWithTotal(projectKey));
        }
    }

    @AuditedCall(value={"msgType", "accessible-objects-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/list-accessible-objects"})
    public void listAccessibleObjects(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam(required=false) String type, @RequestParam(required=false, defaultValue="READ") SerializedProject.ReaderAuthorization.Mode mode) throws Exception {
        List<AccessibleObjectsService.AccessibleObject> objects;
        AuthCtx u;
        ITaggingService.TaggableType taggableType = null;
        if (StringUtils.isNotBlank((String)type) && EnumUtils.isValidEnum(ITaggingService.TaggableType.class, (String)type)) {
            taggableType = ITaggingService.TaggableType.valueOf(type);
        }
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            if ("APP".equals(type)) {
                objects = this.accessibleObjectsService.listAppTemplatesUnsafe(u);
            } else if (taggableType == ITaggingService.TaggableType.PROJECT) {
                objects = this.accessibleObjectsService.listAccessibleProjectsUnsafe(u);
            } else if (taggableType == ITaggingService.TaggableType.WORKSPACE) {
                objects = this.accessibleObjectsService.listAccessibleWorkspacesUnsafe(u);
            } else if (taggableType == ITaggingService.TaggableType.DATA_COLLECTION) {
                objects = this.accessibleObjectsService.listAccessibleDataCollectionsUnsafe(u);
            } else {
                if (StringUtils.isBlank((String)projectKey)) {
                    throw new IllegalArgumentException("Project key not specified.");
                }
                this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
                objects = this.accessibleObjectsService.listAccessibleObjectsUnsafe(u, projectKey, taggableType, mode);
            }
        }
        this.accessibleObjectsService.addKernelSpecInfo_NT(u, objects);
        TaggableObjectsController.writeJSON((HttpServletResponse)resp, objects);
    }

    @AuditedCall(value={"msgType", "check-deleted-objects", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/check-deleted-objects"})
    public void checkDeletedObjects(HttpServletRequest req, HttpServletResponse resp, @RequestParam String requests) throws Exception {
        List parsedRequests = (List)JSON.parse((String)requests, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        ArrayList<TaggableObjectsService.TaggableObjectRef> deletedIds = new ArrayList<TaggableObjectsService.TaggableObjectRef>();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            for (TaggableObjectsService.TaggableObjectRef ref : parsedRequests) {
                if (StringUtils.isBlank((String)ref.id) || StringUtils.isBlank((String)ref.projectKey) || ref.type == null) continue;
                if (!this.projectsService.projectExists(ref.projectKey)) {
                    deletedIds.add(ref);
                    continue;
                }
                if (this.projectsService.hasPerm(authCtx, ref.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF) && this.taggableObjectsReadService.exists(ref)) continue;
                deletedIds.add(ref);
            }
        }
        TaggableObjectsController.writeJSON((HttpServletResponse)resp, deletedIds);
    }

    @AuditedCall(value={"msgType", "tags-edit"})
    @RequestMapping(value={"/apply-tagging"})
    public void applyTags(HttpServletRequest req, HttpServletResponse resp, @RequestParam String request) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            TaggingService.TaggingRequest taggingRequest = (TaggingService.TaggingRequest)JSON.parse((String)request, TaggingService.TaggingRequest.class);
            for (TaggableObjectsService.TaggableObjectRef ref : taggingRequest.elements) {
                this.projectsService.checkPerm(user, ref.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            }
            for (TaggingService.TaggingOperation taggingOperation : taggingRequest.operations) {
                this.taggingService.executeTaggingRequest(taggingRequest.elements, taggingOperation);
            }
            t.commit("Apply tagging");
        }
        TaggableObjectsController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "tags-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/list-tags"})
    public void listTags(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            if (!this.projectsService.isVisible(projectKey)) {
                this.projectsService.checkReadDashboardPerm(req, projectKey, null, null);
            }
            TaggableObjectsController.writeJSON((HttpServletResponse)resp, (Object)this.taggingService.listTags(projectKey));
        }
    }

    @AuditedCall(value={"msgType", "tags-usage", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/list-tags-usage"})
    public void listTagsUsage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            TaggableObjectsController.writeJSON((HttpServletResponse)resp, this.taggingService.getTagNodeMap(projectKey));
        }
    }

    @AuditedCall(value={"msgType", "tags-list"})
    @RequestMapping(value={"/list-all-tags"})
    public void listAllTags(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) boolean includeLimitedVisibility) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            TaggableObjectsController.writeJSON((HttpServletResponse)resp, this.taggingService.listAllTags(user, includeLimitedVisibility));
        }
    }

    @AuditedCall(value={"msgType", "tags-edit", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/set-tags"})
    public void setTags(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, String data) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            TaggingService.TagsFile finalisedTags = this.taggingService.setTags(projectKey, (TaggingService.TagsFile)JSON.parse((String)data, TaggingService.TagsFile.class), user);
            t.commit("Edited tags list");
            TaggableObjectsController.writeJSON((HttpServletResponse)resp, (Object)finalisedTags);
        }
    }

    @AuditedCall(value={"msgType", "set-short-desc", "taggableObject", "${taggableObject}"})
    @RequestMapping(value={"/set-short-desc"})
    public void setShortDesc(HttpServletRequest req, HttpServletResponse resp, @RequestParam String taggableObject, String shortDesc) throws Exception {
        TaggableObjectsService.TaggableObjectRef ref = (TaggableObjectsService.TaggableObjectRef)JSON.parse((String)taggableObject, TaggableObjectsService.TaggableObjectRef.class);
        AnyLoc loc = ref.getLoc().resolved();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            TaggableObjectsService.TaggableObject to = this.taggableObjectsReadService.getMandatory(ref);
            to.shortDesc = shortDesc;
            this.taggableObjectsSaveService.save(to);
            t.commit("Edited short desc for " + ref.toString());
        }
        TaggableObjectsController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "get-metadata", "taggableObject", "${taggableObject}"})
    @RequestMapping(value={"/get-metadata"})
    @ResponseBody
    public TaggableObjectsService.TaggableObjectMetadata getMetadata(HttpServletRequest req, @RequestParam TaggableObjectsService.TaggableObjectRef taggableObject) throws Exception {
        TaggableObjectsService.TaggableObjectMetadata metadata = new TaggableObjectsService.TaggableObjectMetadata();
        AnyLoc loc = taggableObject.getLoc().resolved();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (taggableObject.type == ITaggingService.TaggableType.JUPYTER_NOTEBOOK) {
                metadata = this.jupyterService.getMetadata(taggableObject.projectKey, taggableObject.id);
            } else {
                TaggableObjectsService.TaggableObject to = this.taggableObjectsReadService.getMandatoryUnsafe(taggableObject);
                metadata.shortDesc = to.shortDesc;
                metadata.description = to.description;
                metadata.tags = to.tags;
                metadata.customFields = to.customFields;
            }
        }
        return metadata;
    }

    @AuditedCall(value={"msgType", "set-metadata", "taggableObject", "${taggableObject}"})
    @RequestMapping(value={"/set-metadata"})
    public void setMetadata(HttpServletRequest req, HttpServletResponse resp, @RequestParam String taggableObject, @RequestParam String request) throws Exception {
        TaggableObjectsService.TaggableObjectMetadata metadata;
        AuthCtx authCtx;
        TaggableObjectsService.TaggableObjectRef ref = (TaggableObjectsService.TaggableObjectRef)JSON.parse((String)taggableObject, TaggableObjectsService.TaggableObjectRef.class);
        AnyLoc loc = ref.getLoc().resolved();
        TaggableObjectsService.TaggableObject to = null;
        String oldDescription = null;
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            metadata = (TaggableObjectsService.TaggableObjectMetadata)JSON.parse((String)request, TaggableObjectsService.TaggableObjectMetadata.class);
            if (ref.type == ITaggingService.TaggableType.JUPYTER_NOTEBOOK) {
                this.jupyterService.setMetaData(ref.projectKey, ref.id, metadata);
            } else {
                to = this.taggableObjectsReadService.getMandatory(ref);
                to.shortDesc = metadata.shortDesc;
                oldDescription = to.description;
                to.description = metadata.description;
                to.tags = metadata.tags;
                to.customFields = metadata.customFields;
                this.taggableObjectsSaveService.save(to);
            }
            t.commit("Edited short desc for " + ref.toString());
        }
        if (to != null && ref.type == ITaggingService.TaggableType.DATASET) {
            SerializedDataset dataset = (SerializedDataset)to;
            if (!Objects.equals(metadata.description, oldDescription)) {
                this.sqlCommentService.addCommentToTable(dataset, metadata.description, authCtx, messages);
            }
        }
        TaggableObjectsController.writeJSON((HttpServletResponse)resp, (Object)messages);
    }

    @AuditInline
    @RequestMapping(value={"/clear"})
    public void clear(HttpServletRequest req, HttpServletResponse resp, @RequestParam String requests) throws Exception {
        List parsedRequests = (List)JSON.parse((String)requests, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        ArrayList<TaggableObjectsService.TaggableObject> tObjects = new ArrayList<TaggableObjectsService.TaggableObject>(parsedRequests.size());
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            for (TaggableObjectsService.TaggableObjectRef ref : parsedRequests) {
                AnyLoc loc = ref.getLoc().resolved();
                this.projectsService.checkPerm(authCtx, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                tObjects.add(this.taggableObjectsReadService.getMandatoryUnsafe(ref));
            }
        }
        TaggableObjectsDeletionService.DeletionResult results = new TaggableObjectsDeletionService.DeletionResult();
        for (TaggableObjectsService.TaggableObject to : tObjects) {
            try {
                if (to.getTaggableType() == ITaggingService.TaggableType.DATASET) {
                    Dataset ds = Dataset.fromSerialized((SerializedDataset)to);
                    results.mergeFrom(this.datasetsDeletionService.clearDatasetData_NT(authCtx, ds, true, true));
                } else if (to.getTaggableType() == ITaggingService.TaggableType.MANAGED_FOLDER) {
                    TaggableObjectsDeletionService.DeletionResult dr = new TaggableObjectsDeletionService.DeletionResult();
                    try {
                        this.managedFoldersService.clear(authCtx, (ManagedFolder)to);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Managed folder clear failed", (Throwable)e);
                        results.withWarningV(ManagedFolderCodes.ERR_FOLDER_CLEAR_FAILED, "Unable to drop data of folder %s: %s", new Object[]{to.getFullId(), ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                    results.mergeFrom(dr);
                } else {
                    throw new CodedException((InfoMessage.MessageCode)TaggableObjectCodes.ERR_OBJECT_OPERATION_NOT_AVAILABLE_FOR_TYPE, "Invalid object type: " + String.valueOf((Object)to.getTaggableType()) + " cannot be cleared");
                }
                this.auditTrailService.generic("taggable-object-clear-data").with("itemType", to.getTaggableType().toString()).with("projectKey", to.getProjectKey()).with("id", to.getFullId()).emit();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to clear dataset", (Throwable)e);
                this.auditTrailService.failure("taggable-object-clear-data", (Throwable)e).with("itemType", to.getTaggableType().toString()).with("projectKey", to.getProjectKey()).with("id", to.getFullId()).emit();
            }
        }
        results.summarize();
        TaggableObjectsController.writeJSON((HttpServletResponse)resp, (Object)((Object)results));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/compute-deletion-impact"})
    public void computeDeletionImpact(HttpServletRequest req, HttpServletResponse resp, @RequestParam String request, @RequestParam(required=false) String contextProjectKey) throws Exception {
        TaggableObjectsDeletionService.DeletionImpact impact;
        Set items = (Set)JSON.parse((String)request, (TypeToken)new TypeToken<Set<TaggableObjectsDeletionService.DeletionRequestItem>>(){});
        HashSet<TaggableObjectsDeletionService.DeletionRequestItem> toDelete = new HashSet<TaggableObjectsDeletionService.DeletionRequestItem>();
        HashSet<TaggableObjectsDeletionService.ImpactedComputable> toUnshare = new HashSet<TaggableObjectsDeletionService.ImpactedComputable>();
        HashSet<TaggableObjectsService.TaggableObjectRef> ignored = new HashSet<TaggableObjectsService.TaggableObjectRef>();
        for (TaggableObjectsDeletionService.DeletionRequestItem dr : items) {
            boolean isForeign;
            this.checkNotBlank(dr.id, "Id not specified", new Object[0]);
            this.checkNotBlank(dr.projectKey, "Project key not specified", new Object[0]);
            this.checkNotNull((Object)dr.type, "Type not specified", new Object[0]);
            ignored.add(new TaggableObjectsService.TaggableObjectRef(dr.projectKey, dr.type, dr.id));
            boolean bl = isForeign = dr.id.contains(".") || contextProjectKey != null && !contextProjectKey.equals(dr.projectKey);
            if (isForeign) {
                TaggableObjectsDeletionService.ImpactedComputable ic = new TaggableObjectsDeletionService.ImpactedComputable();
                ic.id = dr.id;
                ic.projectKey = dr.projectKey;
                ic.type = dr.type;
                ic.displayName = dr.displayName;
                toUnshare.add(ic);
                continue;
            }
            toDelete.add(dr);
        }
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            impact = this.taggableObjectsDeletionService.computeDeletionImpact(contextProjectKey, toDelete, toUnshare, ignored, authCtx);
        }
        impact.toUnshare = toUnshare;
        TaggableObjectsController.writeJSON((HttpServletResponse)resp, (Object)impact);
    }

    @AuditInline
    @RequestMapping(value={"/delete"})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @RequestParam String request, @RequestParam String contextProjectKey) throws Exception {
        Set items = (Set)JSON.parse((String)request, (TypeToken)new TypeToken<LinkedHashSet<TaggableObjectsDeletionService.DeletionRequestItem>>(){});
        HashSet<TaggableObjectsService.TaggableObjectRef> ignored = new HashSet<TaggableObjectsService.TaggableObjectRef>();
        LinkedHashSet<TaggableObjectsDeletionService.DeletionRequestItem> toDelete = new LinkedHashSet<TaggableObjectsDeletionService.DeletionRequestItem>();
        HashSet<TaggableObjectsService.TaggableObjectRef> toUnshare = new HashSet<TaggableObjectsService.TaggableObjectRef>();
        AuthCtx authCtx = null;
        HashMap<TaggableObjectsDeletionService.DeletionRequestItem, TaggableObjectsService.TaggableObject> taggableObjectsMap = new HashMap<TaggableObjectsDeletionService.DeletionRequestItem, TaggableObjectsService.TaggableObject>(items.size());
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            for (TaggableObjectsDeletionService.DeletionRequestItem dr : items) {
                boolean isForeign = dr.id.contains(".") || contextProjectKey != null && !contextProjectKey.equals(dr.projectKey);
                TaggableObjectsService.TaggableObjectRef drAsTaggableObjectRef = new TaggableObjectsService.TaggableObjectRef(dr.projectKey, dr.type, dr.id);
                ignored.add(drAsTaggableObjectRef);
                if (!isForeign) {
                    this.taggableObjectsDeletionService.failIfCannotDelete(dr, authCtx);
                    toDelete.add(dr);
                    TaggableObjectsService.TaggableObject to = this.taggableObjectsReadService.getMandatoryUnsafe(dr);
                    taggableObjectsMap.put(dr, to);
                    continue;
                }
                toUnshare.add(drAsTaggableObjectRef);
            }
        }
        TaggableObjectsDeletionService.DeletionResult result = this.taggableObjectsDeletionService.delete_NT(toDelete, taggableObjectsMap, contextProjectKey, ignored, authCtx);
        try {
            this.taggableObjectsDeletionService.stopExposeObjects_NT(authCtx, toUnshare, contextProjectKey);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to unshare object", (Throwable)e);
            result.withFatalV(TaggableObjectCodes.ERR_OBJECT_UNSHARE_ERROR, "Unable to unshare objects due to the following error: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        TaggableObjectsController.writeJSON((HttpServletResponse)resp, (Object)((Object)result));
    }
}

