/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.analysis;

import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.llm.LLMSMMgmtService;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMRefEnricherService;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.langchain.PythonLLMServerKernelPool;
import com.dataiku.dip.savedmodels.SavedModelsAgentsService;
import com.dataiku.dip.savedmodels.agents.AgentTypesRegistry;
import com.dataiku.dip.savedmodels.agents.CustomAgentDesc;
import com.dataiku.dip.savedmodels.agents.CustomAgentMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ConflictCheckService;
import com.dataiku.dip.server.services.LLMQuickChatService;
import com.dataiku.dip.server.services.LLMQuickTestService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.endpoints.httpsse.MiniSSEEmitter;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SavedModelsAgentsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private SavedModelsCRUDService service;
    @Autowired
    private LLMSMMgmtService llmsmService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private SavedModelsAgentsService savedModelsAgentsService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private PythonLLMServerKernelPool pythonLLMServerKernelPool;
    @Autowired
    private ConflictCheckService conflictCheckService;
    @Autowired
    private LLMQuickTestService llmQuickTestService;
    @Autowired
    private LLMQuickChatService llmQuickChatService;
    @Autowired
    private LLMRefEnricherService llmRefEnricherService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.genai.agents.controller");

    @ResponseBody
    @RequestMapping(value={"/api/savedmodels/agents/save"}, method={RequestMethod.POST})
    public SavedModel saveInline(HttpServletRequest req, HttpServletResponse resp, @RequestParam SavedModel savedModel, @RequestParam(required=false) String versionId) throws Exception {
        try (RWTransaction rwt = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, savedModel.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            savedModel = this.savedModelsAgentsService.save(authCtx, savedModel, versionId);
            String commitMessage = "Saved Agent: " + savedModel.id;
            if (versionId != null) {
                commitMessage = commitMessage + " / Version: " + versionId;
            }
            rwt.commit(commitMessage);
        }
        this.pythonLLMServerKernelPool.invalidateKernels(savedModel.projectKey, savedModel.id);
        return savedModel;
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/savedmodels/agents/check-save-conflict"})
    public void checkSaveConflict(HttpServletRequest req, HttpServletResponse resp, @RequestParam SavedModel savedModel) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, savedModel.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SavedModel existingAgent = this.service.getMandatory(savedModel.projectKey, savedModel.id);
            VersionTag.ConflictCheckResult ccr = this.conflictCheckService.checkConflict(existingAgent.versionTag, savedModel.versionTag);
            if (!ccr.canBeSaved) {
                ccr.message = "This agent is being edited by more than one user.";
            }
            SavedModelsAgentsController.writeJSON((HttpServletResponse)resp, (Object)ccr);
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-set-active", "projectKey", "${projectKey}", "modelId", "${savedModelId}", "version", "${newActiveVersion}"})
    @RequestMapping(value={"/api/savedmodels/agents/set-active"})
    public void agentModelSetActive(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String savedModelId, @RequestParam String newActiveVersion) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SavedModel sm = this.service.getMandatory(projectKey, savedModelId);
            String oldActiveVersion = sm.getActiveVersion();
            this.llmsmService.setAgentVersionActive(sm, newActiveVersion);
            t.commit("Set active version of " + projectKey + "." + savedModelId + " to " + newActiveVersion + " (previously " + oldActiveVersion + ")");
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-delete-versions", "projectKey", "${projectKey}", "modelId", "${savedModelId}", "versions", "${versions}"})
    @RequestMapping(value={"/api/savedmodels/agents/delete-versions"})
    public void inlineModelDeleteVersions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String savedModelId, @RequestParam String versions) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SavedModel sm = this.service.getMandatory(projectKey, savedModelId);
            ArrayList versionsList = (ArrayList)JSON.parse((String)versions, (TypeToken)new TypeToken<ArrayList<String>>(){});
            for (String version : versionsList) {
                this.llmsmService.deleteAgentVersion(sm, version);
            }
            t.commit("Deleted " + versionsList.size() + " versions from " + projectKey + "." + savedModelId);
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-duplicate-versions", "projectKey", "${projectKey}", "modelId", "${savedModelId}", "versionIdToCopy", "${versionIdToCopy}", "newVersionId", "${newVersionId}"})
    @RequestMapping(value={"/api/savedmodels/agents/duplicate-version"}, method={RequestMethod.POST})
    @ResponseBody
    public FullModelId inlineModelDuplicateVersion(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String savedModelId, @RequestParam String versionIdToCopy, @RequestParam String newVersionId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            SavedModel sm = this.service.getMandatory(projectKey, savedModelId);
            FullModelId fullModelId = this.llmsmService.duplicateAgentVersion(authCtx, sm, versionIdToCopy, newVersionId);
            t.commit("Duplicated " + versionIdToCopy + " to " + fullModelId.getSavedModelVersionID() + " in " + projectKey + "." + savedModelId);
            FullModelId fullModelId2 = fullModelId;
            return fullModelId2;
        }
    }

    @ResponseBody
    @AuditInline
    @RequestMapping(value={"/api/savedmodels/agents/create-python"}, method={RequestMethod.POST})
    public SavedModel createPythonAgent(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String name, @RequestParam(required=false, defaultValue="") String zoneId) throws Exception {
        this.checkNotEmpty(new String[]{name, "Name of Saved Model can not be empty"});
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            }
            SavedModel sm = this.savedModelsAgentsService.createAgent(authCtx, projectKey, SavedModel.SavedModelType.PYTHON_AGENT, name, zoneId);
            this.auditTrailService.generic("agent-create").with("projectKey", projectKey).with("modelId", sm.id).with("type", SavedModel.SavedModelType.PYTHON_AGENT.toString()).emit();
            return sm;
        }
        catch (Exception e) {
            this.auditTrailService.failure("agent-create", (Throwable)e).with("projectKey", projectKey).with("name", name).with("type", SavedModel.SavedModelType.PYTHON_AGENT.toString()).emit();
            throw e;
        }
    }

    @ResponseBody
    @AuditInline
    @RequestMapping(value={"/api/savedmodels/agents/create-plugin"}, method={RequestMethod.POST})
    public SavedModel createPluginAgent(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String type, @RequestParam String name, @RequestParam(required=false, defaultValue="") String zoneId) throws Exception {
        this.checkNotEmpty(new String[]{name, "Name of Saved Model can not be empty"});
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            }
            SavedModel sm = this.savedModelsAgentsService.createPluginAgentAndVersion(authCtx, projectKey, type, name, zoneId);
            this.auditTrailService.generic("agent-create").with("projectKey", projectKey).with("modelId", sm.id).with("type", SavedModel.SavedModelType.PLUGIN_AGENT.toString()).emit();
            return sm;
        }
        catch (Exception e) {
            this.auditTrailService.failure("agent-create", (Throwable)e).with("projectKey", projectKey).with("name", name).with("type", SavedModel.SavedModelType.PLUGIN_AGENT.toString()).emit();
            throw e;
        }
    }

    @ResponseBody
    @AuditInline
    @RequestMapping(value={"/api/savedmodels/agents/create-tools-using"}, method={RequestMethod.POST})
    public SavedModel createToolsUsingAgent(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String name, @RequestParam(required=false, defaultValue="") String zoneId) throws Exception {
        this.checkNotEmpty(new String[]{name, "Name of Saved Model can not be empty"});
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            }
            SavedModel sm = this.savedModelsAgentsService.createToolsUsingAgentAndVersion(authCtx, projectKey, name, zoneId);
            this.auditTrailService.generic("agent-create").with("projectKey", projectKey).with("modelId", sm.id).with("type", SavedModel.SavedModelType.TOOLS_USING_AGENT.toString()).emit();
            return sm;
        }
        catch (Exception e) {
            this.auditTrailService.failure("agent-create", (Throwable)e).with("projectKey", projectKey).with("name", name).with("type", SavedModel.SavedModelType.TOOLS_USING_AGENT.toString()).emit();
            throw e;
        }
    }

    @RequestMapping(value={"/api/savedmodels/agents/create-version"}, method={RequestMethod.POST})
    @ResponseBody
    public FullModelId createAgentVersion(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smId, @RequestParam String versionId, @RequestParam String initialData) throws Exception {
        SavedModel sm;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            sm = (SavedModel)this.savedModelsDAO.getMandatory(projectKey, smId);
        }
        return this.savedModelsAgentsService.createAgentVersion(authCtx, sm, versionId, (SavedModel.SavedModelInlineVersion)JSON.parse((String)initialData, SavedModel.SavedModelInlineVersion.class));
    }

    @AuditedCall(value={"msgType", "agent-logs-list", "projectKey", "${projectKey}", "modelId", "${smId}"})
    @RequestMapping(value={"/api/savedmodels/agents/list-logs"})
    public void agentListLogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smId, @RequestParam String versionId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        SavedModelsAgentsController.writeJSON((HttpServletResponse)resp, this.savedModelsAgentsService.listLogs(projectKey, smId, versionId));
    }

    @AuditedCall(value={"msgType", "agent-log-get", "projectKey", "${projectKey}", "modelId", "${smId}"})
    @RequestMapping(value={"/api/savedmodels/agents/stream-log"})
    public void agentStreamLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smId, @RequestParam String versionId, @RequestParam String logName) throws Exception {
        String dlName;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        String now = DKUtils.getDateFormatter((String)"_yyyy_MM_dd").print(new Date().getTime());
        if (StringUtils.isNotBlank((String)logName)) {
            String basename = FilenameUtils.getBaseName((String)logName);
            String extension = FilenameUtils.getExtension((String)logName);
            dlName = basename + now + "." + extension + ".gz";
        } else {
            dlName = "dssLogs" + now + ".zip";
        }
        String cd = String.format("attachment; filename=\"%s\"", dlName);
        resp.setHeader("Content-Disposition", cd);
        this.savedModelsAgentsService.streamLog(projectKey, smId, versionId, logName, (OutputStream)resp.getOutputStream());
    }

    @AuditedCall(value={"msgType", "agent-log-get", "projectKey", "${projectKey}", "modelId", "${smId}"})
    @RequestMapping(value={"/api/savedmodels/agents/get-log"})
    public void agentGetLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smId, @RequestParam String versionId, @RequestParam String logName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        SavedModelsAgentsController.writeJSON((HttpServletResponse)resp, (Object)this.savedModelsAgentsService.getLog(projectKey, smId, versionId, logName));
    }

    @AuditedCall(value={"msgType", "agent-logs-clear", "projectKey", "${projectKey}", "modelId", "${smId}"})
    @RequestMapping(value={"/api/savedmodels/agent/clear-logs"})
    public void agentClearLogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smId, @RequestParam String versionId, @RequestParam boolean devRuns, @RequestParam boolean prodRuns) throws Exception {
    }

    @AuditedCall(value={"msgType", "agent-test", "projectKey", "${projectKey}", "modelId", "${smId}"})
    @RequestMapping(value={"/api/savedmodels/agents/test"})
    @ResponseBody
    public LLMQuickTestService.LLMQuickTestResponse agentQuickTest(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smId, @RequestParam String versionId, @RequestParam String query) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        LLMStructuredRef llmRef = LLMStructuredRef.forAgentSavedModelVersion(new AnyLoc(projectKey, smId).getFullName(), versionId);
        return this.llmQuickTestService.llmQuickTestCompletion(authCtx, projectKey, llmRef, query);
    }

    @AuditedCall(value={"msgType", "agent-stop-dev-kernel", "projectKey", "${projectKey}", "modelId", "${smId}"})
    @RequestMapping(value={"/api/savedmodels/agents/stop-dev-kernel"}, method={RequestMethod.POST})
    public void agentStopDevKernel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smId, @RequestParam String versionId) throws Exception {
        AuthCtx authCtx;
        try (RWTransaction rwt = this.transactionService.beginWriteForUI(req);){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        if (!this.pythonLLMServerKernelPool.stopDevKernel((DSSAuthCtx)authCtx, projectKey, smId, versionId)) {
            throw new NotFoundException("Dev kernel not running");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditedCall(value={"msgType", "agent-chat", "projectKey", "${projectKey}", "modelId", "${smId}"})
    @RequestMapping(value={"/api/savedmodels/agents/chat"}, method={RequestMethod.POST})
    public void agentChat(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smId, @RequestParam String versionId, @RequestParam LLMQuickChatService.LLMQuickChatInput chatInput) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        LLMStructuredRef llmRef = LLMStructuredRef.forAgentSavedModelVersion(new AnyLoc(projectKey, smId).getFullName(), versionId);
        EnrichedLLMStructuredRef enrichedLLMRef = this.llmRefEnricherService.getEnrichedLLMRefFromAgentSM(authCtx, projectKey, llmRef);
        try (MiniSSEEmitter emitter = new MiniSSEEmitter(resp, 0L, true);){
            LLMQuickChatService.LLMQuickChatResponse response = this.llmQuickChatService.streamChatResponse(authCtx, projectKey, enrichedLLMRef, chatInput, emitter);
            emitter.sendEventWithData("completion-response", JSON.json((Object)response), false);
        }
        catch (Exception e) {
            logger.error((Object)"Client disconnected", (Throwable)e);
        }
        finally {
            logger.info((Object)"streamed completion: done");
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/savedmodels/agents/list-types"})
    public void listTypes(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        HashMap<String, CustomAgentDesc> descriptors = new HashMap<String, CustomAgentDesc>();
        for (CustomAgentMeta meta : AgentTypesRegistry.getAllMeta()) {
            CustomAgentDesc desc = meta.getAgentDesc();
            if (desc == null) continue;
            descriptors.put(meta.getType(), desc);
        }
        SavedModelsAgentsController.writeJSON((HttpServletResponse)resp, descriptors);
    }
}

