/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.security.AuthCtx;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.springframework.stereotype.Service;

@Service
public class SQLCommentService {
    public void addCommentToTable(SerializedDataset dataset, String comment, AuthCtx authCtx) throws SQLException, DKUSecurityException, InterruptedException {
        this.addCommentToTable(dataset, comment, authCtx, new InfoMessage.InfoMessages());
    }

    public void addCommentToTable(SerializedDataset dataset, String comment, AuthCtx authCtx, InfoMessage.InfoMessages messages) throws SQLException, DKUSecurityException, InterruptedException {
        if (DatasetInspector.isSQL(dataset)) {
            AbstractSQLDatasetHandler.AbstractSQLConfig config = (AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParams();
            if (config.writeDescriptionsAsSQLComment && config.mode.equals("table")) {
                try (AbstractSQLTableDatasetHandler handler = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(authCtx, Dataset.fromSerialized(dataset));){
                    handler.tryAddCommentToTable(comment, messages);
                }
            }
        }
    }

    public void writeColumnsCommentsToTable(AuthCtx authCtx, Dataset dataset, List<SchemaColumn> columns, InfoMessage.InfoMessages messages) {
        if (!columns.isEmpty() && DatasetInspector.isSQL(dataset)) {
            AbstractSQLDatasetHandler.AbstractSQLConfig config = (AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParams();
            if (config.mode.equals("table")) {
                try (AbstractSQLTableDatasetHandler handler = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
                    handler.tryWriteColumnComments(authCtx, dataset.getProjectKey(), columns, messages);
                }
            }
        }
    }

    public List<SchemaColumn> getColumnsWithEditedComments(@Nullable List<SchemaColumn> original, @Nullable List<SchemaColumn> updated) {
        original = Objects.requireNonNullElse(original, new ArrayList());
        updated = Objects.requireNonNullElse(updated, new ArrayList());
        HashMap<String, SchemaColumn> originalColumnsMap = new HashMap<String, SchemaColumn>();
        for (SchemaColumn sc : original) {
            if (sc.getName() == null) continue;
            originalColumnsMap.put(sc.getName().toLowerCase(), sc);
        }
        ArrayList<SchemaColumn> editedSchemaColumns = new ArrayList<SchemaColumn>();
        for (SchemaColumn sc : updated) {
            String lowercaseColumnName;
            SchemaColumn originalCol;
            if (sc.getName() == null || (originalCol = (SchemaColumn)originalColumnsMap.get(lowercaseColumnName = sc.getName().toLowerCase())) != null && Objects.equals(sc.comment, originalCol.comment)) continue;
            if (originalCol != null) {
                originalCol.comment = sc.comment;
                editedSchemaColumns.add(originalCol);
                continue;
            }
            editedSchemaColumns.add(sc);
        }
        return editedSchemaColumns;
    }
}

