/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.dataflow.export.FlowExportService;
import com.dataiku.dip.docgen.resolver.ResolvedResult;
import com.dataiku.dip.graphicsexport.BaseExportService;
import com.dataiku.dip.graphicsexport.charts.DomElementsExportService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ExportModelChartsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DomElementsExportService domElementsExportService;
    @Autowired
    private FlowExportService flowExportService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/export/docgen/download"}, method={RequestMethod.GET})
    public void downloadExport(HttpServletRequest req, HttpServletResponse resp, @RequestParam ResolvedResult.Export.ExportType exportType, @RequestParam String projectKey, @RequestParam String exportId) throws Exception {
        File file;
        BaseExportService<?, ?, ?> exportService = this.getExportServiceForType(exportType);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);
            this.projectsService.checkPerm(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            file = exportService.getExportFile(authCtxUsage.getAuthCtx(), projectKey, exportId);
        }
        String mimeType = DKUtils.probeContentTypeWithFallback((File)file);
        this.writeFileForDownload(resp, file, mimeType, file.getName());
        exportService.clean(projectKey, exportId);
    }

    private BaseExportService<?, ?, ?> getExportServiceForType(ResolvedResult.Export.ExportType exportType) {
        switch (exportType) {
            case DOM_ELEMENTS: {
                return this.domElementsExportService;
            }
            case FLOW: {
                return this.flowExportService;
            }
        }
        throw new IllegalArgumentException("Unknown export type");
    }
}

