/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class TaggableObjectChangedEvent
extends BackendEvent
implements ProjectEvent,
WorkspaceEvent,
UserEvent,
TaggableObjectEvent {
    public static final String NAME = "object-change";
    private static InheritableThreadLocal<String> projectKeyBeingDeleted = new InheritableThreadLocal();
    public final String projectKey;
    public final String workspaceKey;
    public final String objectId;
    public final ITaggingService.TaggableType objectType;
    public final ActionType action;
    public final String newObjectId;
    public final String user;
    public boolean isProjectDeletion;
    public ProjectEditSubtype projectEditSubtype;
    public Set<String> relatedProjectsBeforeAndAfter = new HashSet<String>();
    public boolean libDocumentationChanged;
    public TaggableObjectDiffService.TaggableObjectsDiff metadataDiff;
    public JsonObject details = new JsonObject();
    public String objectName;

    public TaggableObjectChangedEvent(ITaggingService.TaggableType objectType, String projectKey, String objectId, String user, ActionType action, String newObjectId) {
        this.objectType = objectType;
        this.projectKey = projectKey;
        this.workspaceKey = null;
        this.objectId = objectId;
        this.action = action;
        this.newObjectId = newObjectId;
        this.user = user;
        this.objectName = objectId;
        this.isProjectDeletion = StringUtils.equals((String)projectKey, (String)((String)projectKeyBeingDeleted.get()));
    }

    public TaggableObjectChangedEvent(ITaggingService.TaggableType objectType, String projectKey, String objectId, AuthCtx liu, ActionType action, String newObjectId) {
        this(objectType, projectKey, objectId, liu != null ? liu.getIdentifier() : null, action, newObjectId);
    }

    public TaggableObjectChangedEvent(ITaggingService.TaggableType objectType, String projectKey, String objectId, AuthCtx liu, ActionType action) {
        this(objectType, projectKey, objectId, liu != null ? liu.getIdentifier() : null, action, null);
    }

    public TaggableObjectChangedEvent(ITaggingService.TaggableType objectType, String projectKey, String objectId, String user, ActionType action) {
        this(objectType, projectKey, objectId, user, action, null);
    }

    public TaggableObjectChangedEvent(ITaggingService.TaggableType objectType, String projectKey, String objectId, ActionType action) {
        this(objectType, projectKey, objectId, (String)null, action, null);
    }

    public TaggableObjectChangedEvent(ITaggingService.TaggableType objectType, String projectKey, String objectId, String user, ActionType action, String newObjectId, String workspaceKey) {
        this.objectType = objectType;
        this.projectKey = projectKey;
        this.workspaceKey = workspaceKey;
        this.objectId = objectId;
        this.action = action;
        this.newObjectId = newObjectId;
        this.user = user;
        this.objectName = objectId;
    }

    public TaggableObjectChangedEvent(ITaggingService.TaggableType objectType, String projectKey, String objectId, AuthCtx liu, ActionType action, String newObjectId, String workspaceKey) {
        this(objectType, projectKey, objectId, liu != null ? liu.getIdentifier() : null, action, newObjectId, workspaceKey);
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getWorkspaceKey() {
        return this.projectKey;
    }

    @Override
    public String getUserLogin() {
        return this.user;
    }

    @Override
    public TaggableObjectsService.TaggableObjectRef getTaggableObjectRef() {
        if (this.action == ActionType.DATASET_RENAME || this.action == ActionType.RECIPE_RENAME) {
            return new TaggableObjectsService.TaggableObjectRef(this.projectKey, this.objectType, this.newObjectId, this.workspaceKey);
        }
        return new TaggableObjectsService.TaggableObjectRef(this.projectKey, this.objectType, this.objectId, this.workspaceKey);
    }

    public TaggableObjectChangedEvent withProjectEditSubtype(ProjectEditSubtype pes) {
        this.projectEditSubtype = pes;
        return this;
    }

    public DSSEvent withDetails(JsonObject details) {
        if (details != null) {
            this.details = details;
            if (details.has("objectDisplayName") && details.get("objectDisplayName").isJsonPrimitive() && StringUtils.isNotBlank((String)details.get("objectDisplayName").getAsString())) {
                this.objectName = details.get("objectDisplayName").getAsString() + " (" + this.objectId + ")";
            }
        }
        return this;
    }

    public static enum ActionType {
        PROJECT_CREATE(ActionCategory.CREATED, true),
        PROJECT_EDIT(ActionCategory.EDITED, true),
        PROJECT_GIT_PULL(ActionCategory.EDITED, false),
        PROJECT_GIT_REVERT(ActionCategory.EDITED, false),
        PROJECT_GIT_RESET(ActionCategory.EDITED, false),
        PROJECT_GIT_CHECKOUT(ActionCategory.EDITED, false),
        PROJECT_GIT_MERGE(ActionCategory.EDITED, false),
        PROJECT_GIT_ADD_REMOTE(ActionCategory.EDITED, false),
        PROJECT_GIT_UPDATE_REMOTE(ActionCategory.EDITED, false),
        PROJECT_GIT_DELETED_REMOTE(ActionCategory.DELETED, false),
        PROJECT_DELETE(ActionCategory.DELETED, true),
        PROJECT_DUPLICATE(ActionCategory.DUPLICATED, true),
        DATASET_CREATE(ActionCategory.CREATED, true),
        DATASET_EDIT(ActionCategory.EDITED, true),
        DATASET_DELETE(ActionCategory.DELETED, true),
        DATASET_RENAME(ActionCategory.RENAMED, false),
        DATASET_UPDATE_METRICS(ActionCategory.METRICS_UPDATED, true),
        DATASET_DQ_RULES_EDIT(ActionCategory.EDITED, true),
        DATASET_SHARED_TO_WORKSPACE(ActionCategory.OTHER, false),
        DATASET_MANUAL_DATA_LINEAGE_EDIT(ActionCategory.EDITED, true),
        SAVED_MODEL_CREATE(ActionCategory.CREATED, true),
        SAVED_MODEL_EDIT(ActionCategory.EDITED, true),
        SAVED_MODEL_DELETE(ActionCategory.DELETED, true),
        SAVED_MODEL_RENAME(ActionCategory.RENAMED, false),
        SAVED_MODEL_UPDATE_METRICS(ActionCategory.METRICS_UPDATED, true),
        SAVED_MODEL_CHANGE_ACTIVE_VERSION(ActionCategory.OTHER, true),
        MODEL_EVALUATION_STORE_CREATE(ActionCategory.CREATED, true),
        MODEL_EVALUATION_STORE_EDIT(ActionCategory.EDITED, true),
        MODEL_EVALUATION_STORE_DELETE(ActionCategory.DELETED, true),
        MODEL_EVALUATION_STORE_RENAME(ActionCategory.RENAMED, false),
        MODEL_COMPARISON_CREATE(ActionCategory.CREATED, true),
        MODEL_COMPARISON_EDIT(ActionCategory.EDITED, true),
        MODEL_COMPARISON_DELETE(ActionCategory.DELETED, true),
        MODEL_COMPARISON_RENAME(ActionCategory.RENAMED, false),
        PROMPT_STUDIO_CREATE(ActionCategory.CREATED, true),
        PROMPT_STUDIO_EDIT(ActionCategory.EDITED, true),
        PROMPT_STUDIO_DELETE(ActionCategory.DELETED, true),
        PROMPT_STUDIO_RENAME(ActionCategory.RENAMED, false),
        AGENT_TOOL_CREATE(ActionCategory.CREATED, true),
        AGENT_TOOL_EDIT(ActionCategory.EDITED, true),
        AGENT_TOOL_DELETE(ActionCategory.DELETED, true),
        AGENT_TOOL_RENAME(ActionCategory.RENAMED, false),
        RETRIEVABLE_KNOWLEDGE_CREATE(ActionCategory.CREATED, true),
        RETRIEVABLE_KNOWLEDGE_EDIT(ActionCategory.EDITED, true),
        RETRIEVABLE_KNOWLEDGE_DELETE(ActionCategory.DELETED, true),
        RETRIEVABLE_KNOWLEDGE_RENAME(ActionCategory.RENAMED, false),
        LABELING_TASK_CREATE(ActionCategory.CREATED, true),
        LABELING_TASK_EDIT(ActionCategory.EDITED, true),
        LABELING_TASK_DELETE(ActionCategory.DELETED, true),
        LABELING_TASK_RENAME(ActionCategory.RENAMED, false),
        MANAGED_FOLDER_CREATE(ActionCategory.CREATED, true),
        MANAGED_FOLDER_EDIT(ActionCategory.EDITED, true),
        MANAGED_FOLDER_DELETE(ActionCategory.DELETED, true),
        MANAGED_FOLDER_RENAME(ActionCategory.RENAMED, false),
        MANAGED_FOLDER_UPDATE_METRICS(ActionCategory.METRICS_UPDATED, true),
        STREAMING_ENDPOINT_CREATE(ActionCategory.CREATED, true),
        STREAMING_ENDPOINT_EDIT(ActionCategory.EDITED, true),
        STREAMING_ENDPOINT_DELETE(ActionCategory.DELETED, true),
        RECIPE_CREATE(ActionCategory.CREATED, true),
        RECIPE_EDIT(ActionCategory.EDITED, true),
        RECIPE_DELETE(ActionCategory.DELETED, true),
        RECIPE_RENAME(ActionCategory.RENAMED, false),
        ANALYSIS_CREATE(ActionCategory.CREATED, true),
        ANALYSIS_EDIT(ActionCategory.EDITED, true),
        ANALYSIS_DELETE(ActionCategory.DELETED, true),
        ANALYSIS_RENAME(ActionCategory.RENAMED, false),
        DASHBOARD_CREATE(ActionCategory.CREATED, true),
        DASHBOARD_DELETE(ActionCategory.DELETED, true),
        DASHBOARD_EDIT(ActionCategory.EDITED, true),
        DASHBOARD_RENAME(ActionCategory.RENAMED, false),
        DASHBOARD_LISTED(ActionCategory.OTHER, false),
        DASHBOARD_UNLISTED(ActionCategory.OTHER, false),
        DASHBOARD_SHARED_TO_WORKSPACE(ActionCategory.OTHER, false),
        WEB_APP_CREATE(ActionCategory.CREATED, true),
        WEB_APP_DELETE(ActionCategory.DELETED, true),
        WEB_APP_EDIT(ActionCategory.EDITED, true),
        WEB_APP_RENAME(ActionCategory.RENAMED, false),
        WEB_APP_SHARED_TO_WORKSPACE(ActionCategory.OTHER, false),
        CODE_STUDIO_CREATE(ActionCategory.CREATED, true),
        CODE_STUDIO_DELETE(ActionCategory.DELETED, true),
        CODE_STUDIO_EDIT(ActionCategory.EDITED, true),
        CODE_STUDIO_RENAME(ActionCategory.RENAMED, false),
        REPORT_CREATE(ActionCategory.CREATED, true),
        REPORT_DELETE(ActionCategory.DELETED, true),
        REPORT_EDIT(ActionCategory.EDITED, true),
        REPORT_RENAME(ActionCategory.RENAMED, false),
        SQL_NOTEBOOK_CREATE(ActionCategory.CREATED, true),
        SQL_NOTEBOOK_EDIT(ActionCategory.EDITED, true),
        SQL_NOTEBOOK_DELETE(ActionCategory.DELETED, true),
        SQL_NOTEBOOK_RENAME(ActionCategory.RENAMED, false),
        SEARCH_NOTEBOOK_CREATE(ActionCategory.CREATED, true),
        SEARCH_NOTEBOOK_EDIT(ActionCategory.EDITED, true),
        SEARCH_NOTEBOOK_DELETE(ActionCategory.DELETED, true),
        SEARCH_NOTEBOOK_RENAME(ActionCategory.RENAMED, false),
        JUPYTER_NOTEBOOK_CREATE(ActionCategory.CREATED, true),
        JUPYTER_NOTEBOOK_EDIT(ActionCategory.EDITED, true),
        JUPYTER_NOTEBOOK_DELETE(ActionCategory.DELETED, true),
        JUPYTER_NOTEBOOK_RENAME(ActionCategory.RENAMED, false),
        INSIGHT_CREATE(ActionCategory.CREATED, true),
        INSIGHT_DELETE(ActionCategory.DELETED, true),
        INSIGHT_EDIT(ActionCategory.EDITED, true),
        INSIGHT_RENAME(ActionCategory.RENAMED, false),
        INSIGHT_LISTED(ActionCategory.OTHER, false),
        INSIGHT_UNLISTED(ActionCategory.OTHER, false),
        INSIGHT_SHARED_TO_WORKSPACE(ActionCategory.OTHER, false),
        LAMBDA_SERVICE_CREATE(ActionCategory.CREATED, true),
        LAMBDA_SERVICE_EDIT(ActionCategory.EDITED, true),
        LAMBDA_SERVICE_DELETE(ActionCategory.DELETED, true),
        LAMBDA_SERVICE_RENAME(ActionCategory.RENAMED, false),
        LAMBDA_SERVICE_PACKAGE(ActionCategory.OTHER, true),
        SCENARIO_CREATE(ActionCategory.CREATED, true),
        SCENARIO_EDIT(ActionCategory.EDITED, true),
        SCENARIO_DELETE(ActionCategory.DELETED, true),
        SCENARIO_RENAME(ActionCategory.RENAMED, false),
        ARTICLE_CREATE(ActionCategory.CREATED, true),
        ARTICLE_EDIT(ActionCategory.EDITED, true),
        ARTICLE_DELETE(ActionCategory.DELETED, true),
        ARTICLE_RENAME(ActionCategory.RENAMED, false),
        ARTICLE_SHARED_TO_WORKSPACE(ActionCategory.OTHER, false),
        STATISTICS_WORKSHEET_CREATE(ActionCategory.CREATED, true),
        STATISTICS_WORKSHEET_EDIT(ActionCategory.EDITED, true),
        STATISTICS_WORKSHEET_DELETE(ActionCategory.DELETED, true),
        STATISTICS_WORKSHEET_RENAME(ActionCategory.RENAMED, false),
        FLOW_ZONE_CREATE(ActionCategory.CREATED, true),
        FLOW_ZONE_EDIT(ActionCategory.EDITED, true),
        FLOW_ZONE_DELETE(ActionCategory.DELETED, true),
        EDIT_COLLABORATIVE_METADATA(ActionCategory.EDITED, false),
        DATA_COLLECTION_CREATE(ActionCategory.CREATED, true),
        DATA_COLLECTION_EDIT(ActionCategory.EDITED, true),
        DATA_COLLECTION_EDIT_ITEMS(ActionCategory.EDITED, true),
        DATA_COLLECTION_DELETE(ActionCategory.DELETED, true),
        SHARED_OBJECT_DELETE(ActionCategory.DELETED, true),
        OBJECT_SHARE(ActionCategory.SHARED, true),
        COMMENT(ActionCategory.OTHER, false),
        UNKNOWN(ActionCategory.OTHER, true);

        public final ActionCategory category;
        private final boolean collapsable;

        private ActionType(ActionCategory cat, boolean collapsable) {
            this.category = cat;
            this.collapsable = collapsable;
        }

        public boolean isCreation() {
            return this.category == ActionCategory.CREATED;
        }

        public boolean isDeletion() {
            return this.category == ActionCategory.DELETED;
        }

        public boolean isEdition() {
            return this.category == ActionCategory.EDITED;
        }

        public boolean isRenaming() {
            return this.category == ActionCategory.RENAMED;
        }

        public boolean isCollapsable() {
            return this.collapsable;
        }

        public static ActionType getEditAction(ITaggingService.TaggableType taggableType) {
            if (taggableType == null) {
                return null;
            }
            if (taggableType.isFakeType()) {
                return null;
            }
            for (ActionType action : ActionType.values()) {
                if (!action.isEdition() || !action.name().startsWith(taggableType.name())) continue;
                return action;
            }
            return null;
        }
    }

    public static enum ProjectEditSubtype {
        SUMMARY_ONLY,
        PERMISSIONS_ONLY,
        LOCAL_SETTINGS_ONLY,
        EXPOSED_ONLY,
        QUICK_SHARE_ONLY,
        LOCAL_SETTINGS_AND_EXPOSED_ONLY,
        DUPLICATION,
        GIT,
        UNKNOWN;

    }

    public static class ProjectBeingDeletedContext
    implements AutoCloseable {
        public ProjectBeingDeletedContext(String projectKey) {
            projectKeyBeingDeleted.set(projectKey);
        }

        @Override
        public void close() {
            projectKeyBeingDeleted.remove();
        }
    }

    public static enum ActionCategory {
        CREATED,
        EDITED,
        EDITED_DESCRIPTION,
        RENAMED,
        DELETED,
        DUPLICATED,
        SHARED,
        METRICS_UPDATED,
        OTHER;

    }
}

