/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog;

import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.document.Document;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexReader;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class LuceneSecureIndexReader
implements Closeable {
    private final LuceneMappingsAnalyzer luceneMappingsAnalyzer;
    private final IndexReader indexReader;

    private LuceneSecureIndexReader(LuceneMappingsAnalyzer luceneMappingsAnalyzer, IndexReader indexReader) {
        this.luceneMappingsAnalyzer = luceneMappingsAnalyzer;
        this.indexReader = indexReader;
    }

    public static LuceneSecureIndexReader fromIndexSearcher(LuceneMappingsAnalyzer luceneMappingsAnalyzer, IndexSearcher indexSearcher) {
        return new LuceneSecureIndexReader(luceneMappingsAnalyzer, indexSearcher.getIndexReader());
    }

    private Document document(int docID) throws IOException {
        Document doc = this.indexReader.document(docID);
        String docType = doc.getField("_type").stringValue();
        for (String restrictedField : this.luceneMappingsAnalyzer.getRestrictedFields(docType)) {
            doc.removeFields(restrictedField);
        }
        return doc;
    }

    public Document document(int docID, IndexableType docType) throws IOException {
        if (docType == IndexableType.ALL) {
            return this.document(docID);
        }
        Set<String> publicFields = this.getPublicFields(docType);
        Set<String> jsonsField = this.luceneMappingsAnalyzer.getJsons(docType.index());
        publicFields.addAll(jsonsField.stream().map(s -> "$json_" + s).collect(Collectors.toSet()));
        return this.indexReader.document(docID, publicFields);
    }

    private Set<String> getPublicFields(IndexableType docType) {
        if (docType == IndexableType.ALL) {
            throw new IllegalArgumentException("Listing public fields requires an explicit document type");
        }
        Map<String, Boolean> publicFieldMapping = this.luceneMappingsAnalyzer.getStoredAndUnrestrictedMappingForType(docType.index());
        return publicFieldMapping.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static IndexableType getDocumentType(Document document) {
        return IndexableType.forName(document.getField("_type").stringValue());
    }

    public Set<String> filterPublicFields(Document document, Set<String> fieldNames) {
        return this.filterPublicFields(LuceneSecureIndexReader.getDocumentType(document), fieldNames);
    }

    public Set<String> filterPublicFields(IndexableType docType, Set<String> fieldNames) {
        Set<String> publicFields = this.getPublicFields(docType);
        return fieldNames.stream().filter(publicFields::contains).collect(Collectors.toSet());
    }

    public LuceneMappingsAnalyzer getMappingsAnalyzer() {
        return this.luceneMappingsAnalyzer;
    }

    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public boolean isIndexEmpty() {
        return this.indexReader.numDocs() == 0;
    }

    @Override
    public void close() throws IOException {
        this.indexReader.close();
    }
}

