/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.filtering;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.FilterAndFlagProcessor;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.SqlFilterAndFlagOnValue;
import com.dataiku.dip.shaker.text.StringMatchingHelper;
import com.dataiku.dip.shaker.text.StringMatchingMode;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.util.ParamDesc;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FilterAndFlagOnValue {
    public static final ProcessorMeta<StreamImpl, Parameter> META_FLAG = new FilterAndFlagProcessor.FlagProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "FlagOnValue";
        }

        @Override
        public String getDocPage() {
            return "flag-on-value";
        }

        @Override
        public Category getCategory() {
            return Category.FILTER;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.FILTER});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnValue.FLAG.HELP", "Flag rows from dataset that contain specific values by creating a column containing '1' for all matching (in-range) rows. Unmatched rows are left empty.\n\n# Options\n\n**Flag (output) column**\n\nCreate a column in which to store the flag.\n\n**Column**\n\nApply the matching condition to the following: \n\n* A single column\n\n* An explicit list of columns\n\n* All columns matching a regex pattern\n\n* All columns\n\n<u>*Note*</u> \nWhen applying the match condition to several columns (multiple, pattern, all), select whether the row will be considered as matching if all column match (ALL) or at least one column matches (OR).");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnValue.FLAG.DESCRIPTION", 1.actionVerb("Flag") + " rows on value")).withParam("exclude", "boolean", false, false, this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnValue.PARAMS.EXCLUDE", "Exclude provided values")).withParam("values", "list", true, false, this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnValue.PARAMS.VALUES", "has values")).withParam(ParamDesc.advancedSelect("matchingMode", this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnValue.PARAMS.MATCHING_MODE", "Match mode"), this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnValue.PARAMS.MATCHING_MODE.HELP", "How to match the cell value"), StringMatchingMode.class, language).withDefaultValue(StringMatchingMode.FULL_STRING)).withParam(ParamDesc.advancedSelect("normalizationMode", this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnValue.PARAMS.NORMALIZATION_MODE", "Normalization mode"), this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnValue.PARAMS.NORMALIZATION_MODE.HELP", "How to transform the cell value before matching"), StringNormalizationMode.class, language).withDefaultValue(StringNormalizationMode.EXACT)).withFilterAndFlagMode("FLAG");
        }

        @Override
        public Object selfReport(Parameter parameter) {
            JsonObject obj = FilterAndFlagProcessor.selfReport(parameter);
            obj.remove("values");
            obj.addProperty("numValues", (Number)parameter.values.size());
            return obj;
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            Parameter p = (Parameter)sp;
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.NATIVE_SPARK_IMPL, ProcessorCapabilities.KNOWN_INPUTS, ProcessorCapabilities.KNOWN_OUTPUTS);
            if (p.normalizationMode != StringNormalizationMode.EXACT && p.normalizationMode != StringNormalizationMode.LOWERCASE) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, String.format("Cannot use SQL engine: %s string normalization is not translatable", p.normalizationMode));
            } else if (p.matchingMode != StringMatchingMode.SUBSTRING && p.matchingMode != StringMatchingMode.FULL_STRING) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, String.format("Cannot use SQL engine: %s string matching is not translatable", p.matchingMode));
            } else {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            }
            return ret;
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.cleansing.FilterAndFlagOnValueNS";
        }

        @Override
        public StreamImpl build(Parameter parameter) {
            return new StreamImpl(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new FilterSQLTranslator((Parameter)parameter);
        }
    };
    public static final ProcessorMeta<StreamImpl, Parameter> META_FILTER = new FilterAndFlagProcessor.FilterProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "FilterOnValue";
        }

        @Override
        public String getDocPage() {
            return "filter-on-value";
        }

        @Override
        public Category getCategory() {
            return Category.FILTER;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.FILTER});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnValue.FILTER.HELP", "Filter rows from the dataset that contain specific values. Alternatively, this processor can clear content from matching cells instead of filtering entire rows. \n\n# Options\n\n**Action**\n\nSelect the action to perform on matching (in range) rows or cells: \n\n* Keep matching rows only\n\n* Remove matching rows\n\n* Clear content of matching cells\n\n* Clear content of non-matching cells\n\n**Column**\n\nApply the matching condition to the following: \n\n* A single column\n\n* An explicit list of columns\n\n* All columns matching a regex pattern\n\n* All columns\n\n<u>*Note*</u>\nWhen applying the match condition to several columns (multiple, pattern, all), select whether the row will be considered as matching if all columns match (ALL) or at least one column matches (OR).\n\n**has values**\n\nInput the values for the match condition. A cell will match if it matches one or more values in the list. \n\n**Match mode**\n\nDetermine the match type:\n\n* **Complete value:** the entire cell must match the searched value(s)\n\n* **Substring:** the cell contains the searched value(s)\n\n* **Regular expression:** the cell matches the regex \n\n<u>*Note*</u>\nThe regex is not anchored. \n\n**Normalization mode**\n\nSpecify how to find the match: \n\n* **Exact (no transformation):** use case-sensitive search\n\n* **Ignore case:** use case-insenstive search\n\n* **Normalize (ignore accents):** use accents-insensitive search\n\n<u>*Note*</u>\nAccent-insensitive normalization is only available for complete value matching.");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnValue.FILTER.DESCRIPTION", 2.actionVerb("Filter") + " rows on value")).withParam("values", "list", true, false, this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnValue.PARAMS.VALUES", "has values")).withParam(ParamDesc.advancedSelect("matchingMode", this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnValue.PARAMS.MATCHING_MODE", "Match mode"), this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnValue.PARAMS.MATCHING_MODE.HELP", "How to match the cell value"), StringMatchingMode.class, language).withDefaultValue(StringMatchingMode.FULL_STRING)).withParam(ParamDesc.advancedSelect("normalizationMode", this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnValue.PARAMS.NORMALIZATION_MODE", "Normalization mode"), this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnValue.PARAMS.NORMALIZATION_MODE.HELP", "How to transform the cell value before matching"), StringNormalizationMode.class, language).withDefaultValue(StringNormalizationMode.EXACT)).withFilterAndFlagMode("FILTER");
        }

        @Override
        public Object selfReport(Parameter parameter) {
            JsonObject obj = FilterAndFlagProcessor.selfReport(parameter);
            obj.remove("values");
            obj.addProperty("numValues", (Number)parameter.values.size());
            return obj;
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            Parameter p = (Parameter)sp;
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.NATIVE_SPARK_IMPL, ProcessorCapabilities.KNOWN_INPUTS, ProcessorCapabilities.KNOWN_OUTPUTS);
            if (p.normalizationMode != StringNormalizationMode.EXACT && p.normalizationMode != StringNormalizationMode.LOWERCASE) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, String.format("Cannot use SQL engine: %s string normalization is not translatable", p.normalizationMode));
            } else if (p.matchingMode != StringMatchingMode.SUBSTRING && p.matchingMode != StringMatchingMode.FULL_STRING) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, String.format("Cannot use SQL engine: %s string matching is not translatable", p.matchingMode));
            } else {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            }
            return ret;
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.cleansing.FilterAndFlagOnValueNS";
        }

        @Override
        public StreamImpl build(Parameter parameter) {
            return new StreamImpl(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new FilterSQLTranslator((Parameter)parameter);
        }
    };

    static class StreamImpl
    extends FilterAndFlagProcessor
    implements Processor {
        private final Parameter parameter;
        private final List<StringMatchingHelper> helpers;

        public StreamImpl(Parameter parameter) {
            this.parameter = parameter;
            this.helpers = new ArrayList<StringMatchingHelper>();
            for (String row : parameter.values) {
                this.helpers.add(new StringMatchingHelper(row, parameter.matchingMode, parameter.normalizationMode));
            }
        }

        @Override
        public FilterAndFlagProcessor.FilterAndFlagParams getParams() {
            return this.parameter;
        }

        @Override
        public boolean matchCell(Row row, Column column) throws Exception {
            boolean empty;
            String v = row.get(column);
            boolean bl = empty = v == null || v.isEmpty();
            if (empty) {
                if (!this.parameter.processNullOrEmptyValues) {
                    return false;
                }
                v = "";
            }
            for (StringMatchingHelper helper : this.helpers) {
                if (!helper.matches(v)) continue;
                return !this.parameter.exclude;
            }
            return this.parameter.exclude;
        }

        public void postProcess() {
        }
    }

    private static class FilterSQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private FilterSQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema input) {
            return new SqlFilterAndFlagOnValue(input, this.parameter).apply();
        }
    }

    public static class Parameter
    extends FilterAndFlagProcessor.FilterAndFlagParams
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public boolean exclude = false;
        public List<String> values = new ArrayList<String>();
        public StringMatchingMode matchingMode = StringMatchingMode.FULL_STRING;
        public StringNormalizationMode normalizationMode = StringNormalizationMode.EXACT;
        public boolean processNullOrEmptyValues = false;
    }
}

