/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.typespecific;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.PrepareSnowflakeUDFUtils;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.typespecific.EmailSplitterAlgorithm;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.SnowflakeUDFProcessorTranslator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class EmailSplitter {
    public static final ProcessorMeta<StreamImpl, Parameter> META = new ProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "EmailSplitter";
        }

        @Override
        public String getDocPage() {
            return "email-split";
        }

        @Override
        public Category getCategory() {
            return Category.WEB;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.WEB, ProcessorTag.SPLIT});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.EmailSplitter.HELP", "Split an e-mail address into two parts: the local part (before the @) and the domain (after the @).\n\nThis processor generates two output columns, prefixed by the input column name. If the input doesn't contain a valid email address, the processor will not produce an output value.\n\n# Example\n\nFrom the input column `email` two output columns are created: `email_localpart` and `email_domain`. The `email` column also is preserved in the output dataset.\n\nInput `myemail@domain.com` becomes two values: `myemail` and `domain.com`.\n\n");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.EmailSplitter.DESCRIPTION", 1.actionVerb("Split") + " e-mail addresses")).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.COLUMN", "Column"));
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return this.getCapabilities(sp, report, dialect, null);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect, AbstractSQLConnection conn) {
            if (PrepareSnowflakeUDFUtils.canUseSnowflakeUDF(conn)) {
                return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            }
            return new ProcessorMeta.ProcessorCapabilitiesSummary();
        }

        @Override
        public StreamImpl build(Parameter parameter) {
            return new StreamImpl(parameter.column);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SnowflakeUDFSQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter emailSplitterParams = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (StringUtils.isBlank((String)emailSplitterParams.column)) {
                    throw new IllegalConfigurationException("Missing column information for lineage on the email splitter processor.");
                }
                updatedDatasetPairLineage.addFactorizedColumnRelations(emailSplitterParams.column, emailSplitterParams.column + "_domain");
                updatedDatasetPairLineage.addFactorizedColumnRelations(emailSplitterParams.column, emailSplitterParams.column + "_localpart");
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    static class StreamImpl
    extends SingleRowProcessor
    implements Processor {
        private final String inCol;
        private Column inputColumn;
        private Column domainColumn;
        private Column localPartColumn;

        public StreamImpl(String column) {
            this.inCol = column;
        }

        public void init() {
            this.inputColumn = this.getColumnFactory().column(this.inCol, Processor.ProcessorRole.INPUT_COLUMN);
            this.domainColumn = this.getColumnFactory().columnAfter(this.inCol, this.inCol + "_domain", Processor.ProcessorRole.OUTPUT_COLUMN);
            this.localPartColumn = this.getColumnFactory().columnAfter(this.inCol, this.inCol + "_localpart", Processor.ProcessorRole.OUTPUT_COLUMN);
        }

        public void processRow(Row row) {
            String emailVal = row.get(this.inputColumn);
            String[] parts = EmailSplitterAlgorithm.splitEmail((String)emailVal);
            row.put(this.localPartColumn, parts[0]);
            row.put(this.domainColumn, parts[1]);
        }

        public void postProcess() {
        }
    }

    private static class SnowflakeUDFSQLTranslator
    implements SnowflakeUDFProcessorTranslator {
        private final String emailSplitterFunctionName = "emailSplitter_" + SecretKeyGenerator.generate();
        private final Parameter params;

        private SnowflakeUDFSQLTranslator(Parameter params) {
            this.params = params;
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> getUDFResources() throws IOException {
            List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> resources = SnowflakeUDFProcessorTranslator.createStandardResourceList();
            SnowflakeUDFProcessorTranslator.addStandardResources(resources, SnowflakeUDFProcessorTranslator.StandardResource.COMMONS_LANG_JAR);
            return resources;
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef> getUDFs() {
            SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef def = new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef(this.emailSplitterFunctionName, "com.dataiku.dip.shaker.processors.typespecific.EmailSplitterUDF.process", "input STRING", "STRING", "ARRAY");
            def.importStandardResources(SnowflakeUDFProcessorTranslator.StandardResource.COMMONS_LANG_JAR);
            return Lists.newArrayList((Object[])new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef[]{def});
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            String tmpColumnName = "EMAIL_SPLITTER_" + SecretKeyGenerator.generate((int)16);
            SQLDialect d = chain.getDialect();
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            if (chain.isCreatedOrModifiedByCurrentQuery(this.params.column)) {
                chain = chain.makeSubquery();
            }
            chain.select(ebf.expr(String.format("%s(%s)", this.emailSplitterFunctionName, d.quoteIdentifier(this.params.column))), tmpColumnName);
            SQLQueryWithSchema outer = chain.makeSubquery();
            SchemaColumn inputSchemaColumn = outer.getCurrentColumn(this.params.column);
            String[] outputColumns = new String[]{"localpart", "domain"};
            for (int i = 0; i < outputColumns.length; ++i) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr(d.quoteIdentifier(tmpColumnName) + "[" + i + "]"), Type.STRING, this.params.column + "_" + outputColumns[i], false);
            }
            outer.deleteColumn(tmpColumnName);
            outer.deleteSelect(tmpColumnName);
            return outer;
        }
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String column;

        public void validate() throws IllegalArgumentException {
        }
    }
}

