/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.utils.DKULogger;
import java.util.List;

public class RowSizeLimiter {
    private final String databaseName;
    private final DatasetCodes code;
    private final int maxRowSize;
    private final int characterSize;
    private final boolean keepRoom;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.sql");

    public RowSizeLimiter(String databaseName, DatasetCodes code, int maxRowSize, int characterSize, boolean leaveRoomForExpansion) {
        this.databaseName = databaseName;
        this.code = code;
        this.maxRowSize = maxRowSize;
        this.characterSize = characterSize;
        this.keepRoom = leaveRoomForExpansion;
    }

    public void setDefaultLengthForSchemaColumn(Schema schema, List<SchemaColumn> indexColumns, InfoMessage.InfoMessages messages) {
        int explicitlyRequestedSize = 0;
        int nfields = 0;
        int sizeForRequestedStrings = 0;
        for (SchemaColumn column : schema.getColumns()) {
            if (column.getType().equals((Object)Type.STRING)) {
                if (column.maxLength != -1) {
                    sizeForRequestedStrings += column.maxLength * this.characterSize;
                    explicitlyRequestedSize += column.maxLength * this.characterSize;
                    continue;
                }
                ++nfields;
                continue;
            }
            explicitlyRequestedSize += 8;
        }
        int remainingSize = (this.maxRowSize - explicitlyRequestedSize) / this.characterSize;
        if (remainingSize < 0 || remainingSize == 0 && nfields > 0 || remainingSize < nfields) {
            messages.withWarningV((InfoMessage.MessageCode)this.code, "Max row size in " + this.databaseName + " is " + this.maxRowSize / 1000 + "KB but the cumulative size of strings for dataset is %d. Table creation may fail. You may need to modify fields lengths in the dataset settings > Schema", new Object[]{sizeForRequestedStrings});
            remainingSize = nfields * 500;
        }
        if (this.keepRoom) {
            int remainingSizeBefore = remainingSize;
            if (remainingSize > 2000) {
                remainingSize = (this.maxRowSize - 2000 - explicitlyRequestedSize) / this.characterSize;
            }
            logger.infoV("%s explicit=%d remain=%d remainsafe=%d fields=%d", new Object[]{this.databaseName, explicitlyRequestedSize, remainingSizeBefore, remainingSize, nfields});
        }
        if (nfields > 0) {
            int sizePerField = remainingSize / nfields;
            if (sizePerField > 500) {
                sizePerField = 500;
            }
            for (SchemaColumn column : schema.getColumns()) {
                if (!column.getType().equals((Object)Type.STRING) || column.maxLength != -1) continue;
                column.maxLength = this.computeMaxColumnLength(column.getName(), indexColumns, sizePerField);
            }
        }
    }

    protected int computeMaxColumnLength(String columnName, List<SchemaColumn> indexColumns, int sizePerField) {
        return sizePerField;
    }
}

