/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.utils.Params;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.Random;
import org.apache.log4j.Logger;

public class DKUNetUtils {
    private static final Random fgRandom = new Random(System.currentTimeMillis());
    private static Logger logger = Logger.getLogger((String)"dku.utils.net");

    public static int findUnusedPort() throws IOException {
        Params params = ApplicationConfigurator.getParams();
        int low = params.getIntParam("dku.core.findUnusedPort.range.low", Integer.valueOf(2000));
        int high = params.getIntParam("dku.core.findUnusedPort.range.high", Integer.valueOf(65500));
        return DKUNetUtils.findUnusedPort(low, high);
    }

    public static int findUnusedK8SPort() throws IOException {
        return DKUNetUtils.findUnusedPort(32000, Short.MAX_VALUE);
    }

    public static int findUnusedPort(int low, int high) throws IOException {
        for (int i = 0; i < 10; ++i) {
            int port = (int)(fgRandom.nextFloat() * (float)(high - low)) + low;
            try {
                ServerSocket s = new ServerSocket(port);
                s.close();
                return port;
            }
            catch (BindException e) {
                continue;
            }
            catch (IOException e) {
                logger.warn((Object)"Failure while finding unused port, will retry", (Throwable)e);
            }
        }
        throw new IOException("Failed to find a unused port after several attempts");
    }
}

