/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps;

import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedWebAppsDAO
extends AbstractStandardDAO<WebApp>
implements WebAppsDAO {
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.WEB_APP.toHumanReadableString();
    }

    @Override
    protected WebApp getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile webAppFile = this.getDAOFile(projectKey, id);
        this.logger.trace((Object)("Reading web app file " + String.valueOf(webAppFile)));
        if (!t.isFile(webAppFile)) {
            return null;
        }
        WebApp webApp = unsafe ? (WebApp)t.readObjectUnsafe(webAppFile, WebApp.class) : (WebApp)t.readObject(webAppFile, WebApp.class);
        webApp.id = id;
        webApp.projectKey = projectKey;
        webApp.storageFile = webAppFile;
        return webApp;
    }

    @Override
    protected List<WebApp> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<WebApp> ret = new ArrayList<WebApp>();
        RelFile webAppsFolder = this.getWebAppsFolder(projectKey);
        if (!t.exists(webAppsFolder)) {
            return ret;
        }
        for (RelFile file : t.listFiles(webAppsFolder, (RelFileFilter)FileFilter.json())) {
            try {
                String webAppId = StringUtils.removeEnd((String)file.getLeafName(), (String)".json");
                WebApp webApp = unsafe ? (WebApp)t.readObjectUnsafe(file, WebApp.class) : (WebApp)t.readObject(file, WebApp.class);
                webApp.id = webAppId;
                webApp.projectKey = projectKey;
                webApp.storageFile = file;
                ret.add(webApp);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to read web app file " + String.valueOf(file) + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        return ret;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile webAppsFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(webAppsFolder = this.getWebAppsFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(webAppsFolder, (RelFileFilter)FileFilter.json()).size();
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RelFile webAppFile;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (!t.isFile(webAppFile = this.getDAOFile(projectKey, id))) {
            throw new NotFoundException("Web app does not exist: " + projectKey + "." + id);
        }
        t.deleteFile(webAppFile);
    }

    private RelFile getWebAppsFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Webapp project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "web_apps"});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Webapp id is not specified");
        return new RelFile(this.getWebAppsFolder(projectKey), new String[]{id + ".json"});
    }

    @Override
    public void save(WebApp webApp) throws IOException {
        WebApp encryptedCopy = (WebApp)JSON.deepCopy((Object)webApp);
        encryptedCopy.apiKey = this.passwordEncryptionService.encryptIfNotEncryptedOrEmpty(encryptedCopy.apiKey);
        super.save(encryptedCopy);
    }
}

