/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr;

import com.dataiku.dip.classpathfix.DKUDoubles;
import com.dataiku.dip.classpathfix.DKULongs;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.variables.VariablesContext;
import com.google.gson.JsonObject;
import com.google.refine.expr.CellTuple;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.WrappedCell;
import com.google.refine.expr.WrappedRow;
import com.google.refine.expr.WrappedVariables;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class ExpressionUtils {
    public static Properties createBindings(SerializedShakerScript script) {
        Properties bindings = new Properties();
        bindings.put("true", (Object)true);
        bindings.put("false", (Object)false);
        bindings.put("PI", (Object)Math.PI);
        bindings.put("project", script);
        return bindings;
    }

    public static Properties createBindings(VariablesContext vc) {
        if (vc == null) {
            return null;
        }
        Properties properties = new Properties();
        ExpressionUtils.bindVariables(properties, vc);
        return properties;
    }

    public static void bindVariables(Properties bindings, VariablesContext vc) {
        if (vc != null) {
            bindings.put("variables", new WrappedVariables(vc));
        }
    }

    public static void bind(Properties bindings, ColumnFactory cf, Row row, int rowIndex, String columnName, VariablesContext vc, List<Map<String, Object>> previousRows) {
        String v;
        bindings.put("rowIndex", (Object)rowIndex);
        bindings.put("row", new WrappedRow(cf, row));
        bindings.put("cells", new CellTuple(cf, row));
        if (previousRows != null) {
            bindings.put("previousRows", previousRows);
        }
        if (columnName != null) {
            bindings.put("columnName", columnName);
        }
        ExpressionUtils.bindVariables(bindings, vc);
        bindings.put("cell", new WrappedCell(cf, columnName, row));
        if (columnName != null && (v = row.get(cf.column(columnName))) != null) {
            bindings.put("value", v);
            try {
                bindings.put("numvalue", (Object)Double.parseDouble(v));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Object parseValue(Object v) {
        if (v instanceof String) {
            String s = (String)v;
            if (s.isEmpty()) {
                return s;
            }
            Long l = DKULongs.tryParse((String)s);
            if (l != null) {
                return l;
            }
            Double d = DKUDoubles.tryParse((String)s);
            return d != null ? d : s;
        }
        return v;
    }

    public static boolean isError(Object o) {
        return o instanceof EvalError;
    }

    public static boolean isNonBlankData(Object o) {
        return o != null && !(o instanceof EvalError) && (!(o instanceof String) || ((String)o).length() > 0);
    }

    public static boolean isTrue(Object o) {
        return o != null && (o instanceof Boolean ? (Boolean)o != false : Boolean.parseBoolean(o.toString()));
    }

    public static boolean isTrueish(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue() != 0.0;
        }
        return Boolean.parseBoolean(o.toString());
    }

    public static boolean sameValue(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null || v2 instanceof String && ((String)v2).length() == 0;
        }
        if (v2 == null) {
            return v1 instanceof String && ((String)v1).length() == 0;
        }
        return v1.equals(v2);
    }

    public static boolean isStorable(Object v) {
        return v == null || v instanceof Number || v instanceof String || v instanceof Boolean || v instanceof Date || v instanceof Calendar || v instanceof EvalError;
    }

    public static Serializable wrapStorable(Object v) {
        if (v instanceof JSONArray || v instanceof JSONObject) {
            return v.toString();
        }
        if (v instanceof JsonObject) {
            return ((JsonObject)v).getAsString();
        }
        return ExpressionUtils.isStorable(v) ? (Serializable)v : new EvalError(v.getClass().getSimpleName() + " value not storable");
    }

    public static boolean isArray(Object v) {
        return v != null && v.getClass().isArray();
    }

    public static boolean isArrayOrList(Object v) {
        return v != null && (v.getClass().isArray() || v instanceof List);
    }

    public static List<Object> toObjectList(Object v) {
        return (List)v;
    }

    public static Collection<Object> toObjectCollection(Object v) {
        return (Collection)v;
    }
}

