/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.math.BigInteger;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class Hex2Dec
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 0 || args[0] == null || args[0] instanceof String && StringUtils.isBlank((String)((String)args[0]))) {
            return null;
        }
        if (args.length == 1) {
            try {
                String arg = args[0].toString().toLowerCase().replace(" ", "").replace("\\", "").replace("0x", "");
                return new BigInteger(arg, 16);
            }
            catch (Exception e) {
                return null;
            }
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects only 1 argument");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Hex2Dec.DOCUMENTATION", "Returns a decimal representation of an hexadecimal string.").withParams("string").withReturns("long").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("\"a\"").returns("10")).withExample(Example.with("\"100\"").returns("256"));
    }
}

