/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.date;

import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.Days;
import com.dataiku.dss.shadelib.org.joda.time.Hours;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.Minutes;
import com.dataiku.dss.shadelib.org.joda.time.Months;
import com.dataiku.dss.shadelib.org.joda.time.ReadablePeriod;
import com.dataiku.dss.shadelib.org.joda.time.Seconds;
import com.dataiku.dss.shadelib.org.joda.time.Weeks;
import com.dataiku.dss.shadelib.org.joda.time.Years;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class Inc
implements Function {
    DKUFormulaUtils formulaUtils = new DKUFormulaUtils();

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 3 && DKUFormulaUtils.isNotABlankString(args[0]) && args[1] instanceof Number && args[2] instanceof String) {
            Object date = this.formulaUtils.asTemporal(args[0], bindings);
            if (date == null) {
                return null;
            }
            int amount = ((Number)args[1]).intValue();
            String unit = (String)args[2];
            if (date instanceof DateTime) {
                return ((DateTime)date).plus(this.ms(amount, unit));
            }
            if (date instanceof LocalDate) {
                return ((LocalDate)date).toDateTimeAtStartOfDay().plus(this.ms(amount, unit)).toLocalDate();
            }
            if (date instanceof LocalDateTime) {
                return ((LocalDateTime)date).plus(this.ms(amount, unit));
            }
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects a date, a number and a string");
    }

    private ReadablePeriod ms(int amount, String unit) {
        if ("hours".equals(unit) || "hour".equals(unit) || "h".equals(unit)) {
            return Hours.hours((int)amount);
        }
        if ("days".equals(unit) || "day".equals(unit) || "d".equals(unit)) {
            return Days.days((int)amount);
        }
        if ("years".equals(unit) || "year".equals(unit)) {
            return Years.years((int)amount);
        }
        if ("months".equals(unit) || "month".equals(unit)) {
            return Months.months((int)amount);
        }
        if ("minutes".equals(unit) || "minute".equals(unit) || "min".equals(unit)) {
            return Minutes.minutes((int)amount);
        }
        if ("weeks".equals(unit) || "week".equals(unit) || "w".equals(unit)) {
            return Weeks.weeks((int)amount);
        }
        if ("seconds".equals(unit) || "sec".equals(unit) || "s".equals(unit)) {
            return Seconds.seconds((int)amount);
        }
        throw new RuntimeException("Unit '" + unit + "' not recognized.");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Inc.DOCUMENTATION", "Returns a date incremented or decremented by the number value in the specified unit of time; a decimal number value will be truncated to an integer. The available units are: hours, minutes, seconds, years, months, days, weeks").withParams("date d, number value, string unit").withReturns("date").withCategory("GREL.FUNCTIONS.CATEGORY.DATE", "Date functions").withExample(Example.with("'2020-04-15T00:00:00.000Z'", "-3", "'weeks'").returns("2020-03-25T00:00:00.000Z")).withExample(Example.with("'2020-04-15'", "1", "'month'").returns("2020-05-15"));
    }
}

