/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.controls;

import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.grel.Control;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class Switch
implements Control {
    static final String TRUE = "true";
    static final String FALSE = "false";

    @Override
    public String checkArguments(Evaluable[] args) {
        if (args.length < 3) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects at least 3 arguments";
        }
        return null;
    }

    @Override
    public Object call(Properties bindings, Evaluable[] args) {
        int numberOfArguments = args.length;
        Object expressionToMatch = args[0].evaluate(bindings);
        if (ExpressionUtils.isError(expressionToMatch)) {
            return expressionToMatch;
        }
        if (expressionToMatch != null && (expressionToMatch.toString().equalsIgnoreCase(TRUE) || expressionToMatch.toString().equalsIgnoreCase(FALSE))) {
            expressionToMatch = ExpressionUtils.isTrue(expressionToMatch);
        }
        for (int argIndex = 1; argIndex < numberOfArguments - 1; argIndex += 2) {
            Object switchArgument = args[argIndex].evaluate(bindings);
            if (ExpressionUtils.isError(switchArgument)) {
                return switchArgument;
            }
            if (switchArgument != null && (switchArgument.toString().equalsIgnoreCase(TRUE) || switchArgument.toString().equalsIgnoreCase(FALSE))) {
                switchArgument = ExpressionUtils.isTrue(switchArgument);
            }
            if (!ExpressionUtils.sameValue(switchArgument, expressionToMatch)) continue;
            return args[argIndex + 1].evaluate(bindings);
        }
        if (numberOfArguments % 2 == 0) {
            return args[numberOfArguments - 1].evaluate(bindings);
        }
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Switch.DOCUMENTATION", "Compares <code>expression</code> to <code>match_1</code>, then to <code>match_2</code>, etc. When a match is found, returns the corresponding <code>return_i</code>. If no match is found, returns <code>default</code>, or empty if there is no <code>default</code>.").withParams("expression, match_1, return_1, match_2, return_2, ..., default").withReturns("GREL.FUNCTIONS.RETURNS.DEPENDS_ON_ARGUMENTS", "depends on arguments").withCategory("GREL.FUNCTIONS.CATEGORY.CONTROL_STRUCTURES", "Control structures").withExample(Example.with("\"Miami\"", "\"Paris\"", "1", "\"Miami\"", "2", "-1").returns("2")).withExample(Example.with("\"Boston\"", "\"Paris\"", "\"1\"", "\"Miami\"", "\"2\"", "\"Other\"").returns("\"Other\""));
    }
}

