/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.controls;

import com.google.refine.expr.Evaluable;
import com.google.refine.grel.Control;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.GrelControlFunctionRegistry;
import com.google.refine.grel.ast.VariableExpr;
import java.util.Properties;

public class With
implements Control {
    @Override
    public String checkArguments(Evaluable[] args) {
        if (args.length != 3) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects 3 arguments";
        }
        if (!(args[1] instanceof VariableExpr)) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects second argument to be a variable name";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call(Properties bindings, Evaluable[] args) {
        Object o = args[0].evaluate(bindings);
        String name = ((VariableExpr)args[1]).getName();
        Object oldValue = bindings.get(name);
        try {
            if (o != null) {
                bindings.put(name, o);
            } else {
                bindings.remove(name);
            }
            Object object = args[2].evaluate(bindings);
            return object;
        }
        finally {
            if (oldValue != null) {
                bindings.put(name, oldValue);
            } else {
                bindings.remove(name);
            }
        }
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.With.DOCUMENTATION", "Evaluates expression <code>o</code> and binds its value to variable name <code>v</code>. Then evaluates expression <code>e</code> and returns that result.").withParams("expression o, variable v, expression e").withReturns("GREL.FUNCTIONS.RETURNS.DEPENDS_ON_ARGUMENTS", "depends on arguments").withCategory("GREL.FUNCTIONS.CATEGORY.CONTROL_STRUCTURES", "Control structures").withExample(Example.with("\"european union\".split(\" \")", "a", "a.length()").returns("2"));
    }
}

