#' Checks whether the partitioning scheme of the folder uses sub-directories
#'
#' @param name the name of the folder
#' @return TRUE if each partition in the folder is a distinct sub-directory
#'
#' @export
#' @importFrom httr POST
dkuManagedFolderDirectoryBasedPartitioning <- function(name) {
    getPathURL = dku_intercom__get_jek_or_backend_url("/managed-folders/get-info")
    ref = dku__resolve_smart_name(name)

    resp = POST(getPathURL,body = list(projectKey=dku__ref_to_pkey(ref), lookup=dku__ref_to_name(ref)),
        encode="form",  dku__get_auth_headers(), dku_intercom__get_httr_config())

    dku__check_api_error(resp, "Failed to get Box path")
    data <- content(resp)

    return(data$info$directoryBasedPartitioning)
}
