// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: http://codemirror.net/LICENSE

/**
 * Author: Ben Varkey Benjamin, based on implementation by Koh Zi Chun
 */
 
(function(mod) {
  if (typeof exports == "object" && typeof module == "object") // CommonJS
    mod(require("codemirror/lib/codemirror"));
  else if (typeof define == "function" && define.amd) // AMD
    define(["codemirror/lib/codemirror"], mod);
  else // Plain browser env
    mod(CodeMirror);
})(function(CodeMirror) {
"use strict";

CodeMirror.defineMode("skill", function () {
    var BUILTIN = "builtin", COMMENT = "comment", STRING = "string",
        ATOM = "atom", NUMBER = "number", BRACKET = "bracket";
    var isOperatorChar = /[+\-*&%=<>!|\/@]/;

    function makeKeywords(str) {
        var obj = {}, words = str.split(" ");
        for (var i = 0; i < words.length; ++i) obj[words[i]] = true;
        return obj;
    }

    var keywords = makeKeywords(
"ALIAS DATA ERC IDC IF IS IT LVS MP NG OP OPT PN SIMULATOR VAR VDC VF VN VN2 VNP VNPP VPD VS a2d abs absAbstract absAttachTechLib absCopyBinOptions absDeleteBin absDeleteBinMoveCellsTo absDeselectAllBins absDeselectBin absDeselectBinFrom absDeselectCell absDeselectCellFrom absDeselectCells absDeselectCellsInList absDisableUpdate absDistributeCells absEnableUpdate absExit absExportLEF absExportOptions absExportReport absExtract absGetBinOption absGetBinType absGetBins absGetCellProp absGetLibrary absGetOption absGetSelectedBins absGetSelectedCells absGetTerminalProp absImportCTLF absImportDEF absImportGDS absImportLEF absImportLogical absImportOptions absImportVerilog absMoveSelectedCellsToBin absNewBin absPins absRenameBin absRevalidateSelectedCells absSelect absSelectAllBins absSelectBin absSelectBinFrom absSelectCell absSelectCellFrom absSelectCells absSelectCellsInList absSetBinOption absSetCellProp absSetLibrary absSetOption absSetTerminalProp absSort absVerify absVersion abs_jitter ac acos acosh add1 addCheck addDefstructClass addDependent addPoint addSubwindow addSubwindowTitle addTitle addToExportList addToNamespace addWaveLabel addWindowLabel adpInitFloorplan adpnlSetEnv aedCopyCDF aedDeleteCDF aedEditCDF aelCheckRange aelDisplayOPParam aelEngNotation aelEnvCompile aelEnvCreate aelEnvExecute aelEnvFreeCompExpr aelEnvGetErrStr aelEnvGetGlobal aelEnvInterpret aelEnvListDeferredFuncs aelEnvListDeferredGlobals aelEnvListExprFuncs aelEnvListExprGlobals aelEnvListFuncs aelEnvListGlobals aelEnvListGlobalsValues aelEnvName aelEnvSetGlobalList aelEnvSetGlobals aelGetSignifDigits aelNumber aelPopSignifDigits aelPushSignifDigits aelSetLineage aelSignum aelStrDblNotation aelSuffixNotation aelSuffixWithUnits aelSumOPParam ahdlUpdateViewInfo alias allocateInstance almDefineParam_accuracyMode almDefineParam_additionalParam almDefineParam_fq almDefineParam_noiseParaLabel almDefineParam_nportFileB almDefineParam_otherParaLabel almDefineParam_tranAdvanParaLabel almDefineParam_tranParaLabel almGetModuleName almGetNamePrefix almGetNetlistProcedure almGetNetlistType almGetOpPointParamMap almGetOtherParameterList almGetParameterList almGetPropMappingList almGetStringParameterList almGetTerminalList almGetTerminalMap almGetViewInfoNameList almHasViewInformation almSetModuleName almSetNamePrefix almSetNetlistProcedure almSetOpPointParamMap almSetOtherParameterList almSetParameterList almSetPropMappingList almSetStringParameterList almSetTerminalList almSetTerminalMap alphaNumCmp alphalessp amsCheckCV amsError amsGetInstanceName amsGetNetlister amsGetPortExpr amsGetUniqueName amsInfo amsIsPresent amsMapName amsMtlinePrintParams amsMtlineTermOrder amsNetlist amsNportTermOrder amsPrint amsPrintAlias amsPrintAliases amsPrintAttribute amsPrintAttributes amsPrintIO amsPrintIOs amsPrintInstance amsPrintInstanceMasterName amsPrintInstanceParameter amsPrintInstanceParameters amsPrintInstancePorts amsPrintParameter amsPrintParameters amsPrintPort amsPrintPorts amsPrintWire amsPrintWires amsProcessCellViews amsSpectreToVams amsUIOptionsForm amsUIRunNetlisterForm amsUpdateTextviews amsWarning amseGeneralSetupForm amseQuickSetupForm analysis ancAdjustNameCase ancGetSimInstName and angle annPinCurrentInfoBalloon annToggleInfoBalloonVisibilityStatus ansAnalogRegCDFsimInfo ansCdlCompPrim ansCdlGetMultiplicity ansCdlGetSegmentConnections ansCdlGetSegmentInfo ansCdlGetSegmentInstParams ansCdlGetSimPropValue ansCdlHnlPrintInst ansCdlPrintConnections ansCdlPrintInheritedParams ansCdlPrintInstName ansCdlPrintInstParams ansCdlPrintInstProps ansCdlPrintModelName ansCdlPrintModuleName ansCdlPrintString apaExport apaExportCB apaStop apaStopCB appTrigger append append1 appendPath appendWaves apply applyEnterFun argc arglist argmax argmin argv armSetCalc arrayp arrayref artBlankString artClose artCloseAllFiles artCurrentInstSimName artEnableAnnotationBalloon artFlush artFprintf artGenerateHierSymbolCDF artGetCdfTargetCV artGetCellViewDesignVarList artInvalidateAmap artListOpenFiles artListToWaveform artMakeString artMakeStringPrec15 artOutfile asiAddAnalysis asiAddAnalysisField asiAddAnalysisOption asiAddDesignVarList asiAddEnvOption asiAddFlowchartLink asiAddFlowchartStep asiAddKeepOption asiAddModelLibSelection asiAddOceanAlias asiAddSimOption asiAddVerilogArgs asiAnalogAutoloadProc asiChangeAnalysis asiChangeAnalysisField asiChangeAnalysisOption asiChangeAnalysisOptionFormProperties asiChangeEnvOption asiChangeEnvOptionFormProperties asiChangeFlowchartStep asiChangeKeepOption asiChangeKeepOptionFormProperties asiChangeSimOption asiChangeSimOptionFormProperties asiCheck asiCheckAcEnabledWhenNoiseEnabled asiCheckAnalysis asiCheckBlank asiCheckBlankInstExists asiCheckBlankNetExists asiCheckBlankNumeric asiCheckBlankNumericGeq asiCheckBlankNumericGreater asiCheckBlankNumericLeq asiCheckBlankNumericNequal asiCheckDesignVariable asiCheckDigitalSimulationSuccess asiCheckExpression asiCheckExpressionGreater asiCheckMultipleGreater asiCheckSimulationSuccess asiCloseOceanScript asiConstructDigitalNetlist asiCornerSimCB asiCreateAnalysisField asiCreateAnalysisOption asiCreateCdsenvFile asiCreateFlowchart asiCreateFormatter asiCreateLogFileVerilog asiDcStore asiDefineDataAccessFunction asiDefineDataMappingFunction asiDeleteAnalysis asiDeleteAnalysisField asiDeleteAnalysisOption asiDeleteEnvOption asiDeleteFlowchartLink asiDeleteFlowchartStep asiDeleteKeepOption asiDeleteSimOption asiDisableAnalysis asiDisplayAnalysis asiDisplayAnalysisField asiDisplayAnalysisOption asiDisplayAnalysisOptionFormProperties asiDisplayEnvOption asiDisplayEnvOptionFormProperties asiDisplayFlowchart asiDisplayHighPerformanceOption asiDisplayKeepOption asiDisplayKeepOptionFormProperties asiDisplayNetlistOption asiDisplaySimOption asiDisplaySimOptionFormProperties asiEditDigitalStimulus asiEnableAnalysis asiExecuteFlowchart asiFinalNetlist asiFormatAnalysis asiFormatAnalysisList asiFormatControlStmts asiFormatDefinitionFileList asiFormatDesignVarList asiFormatGraphicalStimuli asiFormatGraphicalStimulusFileList asiFormatInitCond asiFormatKeepList asiFormatMTSModelAndSimOptions asiFormatModelLibSelectionList asiFormatNodeSet asiFormatSimulatorOptions asiFormatTextStimulusFileList asiGetAnalogKeepList asiGetAnalogRunDir asiGetAnalogSimulator asiGetAnalysis asiGetAnalysisField asiGetAnalysisFieldChoices asiGetAnalysisFieldList asiGetAnalysisFieldVal asiGetAnalysisFormFieldChoices asiGetAnalysisFormFieldVal asiGetAnalysisName asiGetAnalysisNameList asiGetAnalysisOptionChoices asiGetAnalysisOptionList asiGetAnalysisOptionSendMethod asiGetAnalysisOptionVal asiGetAnalysisParamNameList asiGetAnalysisSigList asiGetAnalysisSimFieldList asiGetAnalysisType asiGetCalcResultsDir asiGetCommandFooter asiGetCommandLineOption asiGetCornerDesignVarList asiGetCornerList asiGetCornerModelSelectionList asiGetCornerModelingStyles asiGetCornerName asiGetCornerResultsDir asiGetCornerTemperature asiGetCurrentSession asiGetDefinitionFileList asiGetDesignCellName asiGetDesignLibName asiGetDesignVarList asiGetDesignViewName asiGetDigitalCommandLineOption asiGetDigitalKeepList asiGetDigitalNetlistFileName asiGetDigitalRunDir asiGetDigitalSimExecName asiGetDigitalSimulator asiGetDigitalSimulatorLogFileName asiGetDigitalStimulusFileName asiGetDrlData asiGetEnabledAnalysisList asiGetEnvOptionChoices asiGetEnvOptionVal asiGetFlowchart asiGetFormFieldChoices asiGetFormFieldVal asiGetFormattedVal asiGetFormatter asiGetHighPerfformanceOptionVal asiGetId asiGetKeepList asiGetKeepOptionChoices asiGetKeepOptionVal asiGetLogFileList asiGetMarchList asiGetModelLibFile asiGetModelLibSection asiGetModelLibSelectionList asiGetNetlistDir asiGetNetlistOption asiGetNetworkId asiGetOutputList asiGetPlotList asiGetPredefinedCommandLineOption asiGetPsfDir asiGetReservedWordList asiGetSelObjName asiGetSelObjType asiGetSelObjValue asiGetSession asiGetSimCommandLineOrder asiGetSimExecName asiGetSimInputFileList asiGetSimInputFileName asiGetSimInputFileSuffix asiGetSimName asiGetSimOptionChoices asiGetSimOptionNameList asiGetSimOptionSendMethod asiGetSimOptionVal asiGetSimulationRunCommand asiGetSimulatorList asiGetSimulatorSrcList asiGetStimulusGlobals asiGetStimulusInputs asiGetTextStimulusFileList asiGetTool asiGetTopCellView asiGetVerilogCommandLineOption asiGetVerilogHost asiGetVerilogHostMode asiInitAdvAnalysis asiInitAnalysis asiInitDataAccessFunction asiInitEnvOption asiInitMixedKeepOption asiInitSimOption asiInitVerilog asiInitVerilogEnvOption asiInitVerilogFNLEnvOption asiInitVerilogHNLEnvOption asiInitVerilogSimOption asiInitialize asiInitializeNetlisterMixed asiInterruptSim asiInvalidateControlStmts asiInvalidateFlowchartStep asiIsAnalysisEnabled asiIsCaseSensitive asiIsConfigDesign asiLoadState asiMTSIncludeFileExtension asiMTSIncludeFormat asiMapInstanceName asiMapNetName asiMapOutputName asiMapTerminalName asiNeedSuffixEvaluation asiNetlist asiNetlistMixed asiOpenOceanScript asiPartitionDesign asiPrepareDigitalSimulation asiQuitSimulator asiRawNetlist asiRegCallBackOnSimComp asiRegisterTool asiRemoveAllModelLibSelection asiRunSimulation asiSaveState asiSelectAnalysisCompParam asiSelectAnalysisInst asiSelectAnalysisNet asiSelectAnalysisSource asiSelectInst asiSelectNet asiSelectSourceInst asiSelectTerm asiSelectTermNet asiSendAnalysis asiSendControlStmts asiSendDesignVars asiSendInitCond asiSendInitFile asiSendKeepList asiSendModelPath asiSendNetlist asiSendNodeSets asiSendOptions asiSendRestore asiSendSim asiSendUpdateFile asiSetAnalogSimulator asiSetAnalysisFieldChoices asiSetAnalysisFieldVal asiSetAnalysisFormFieldChoices asiSetAnalysisFormFieldVal asiSetAnalysisFormWidth asiSetAnalysisOptionChoices asiSetAnalysisOptionFormProperties asiSetAnalysisOptionVal asiSetDesignVarList asiSetDigitalSimulator asiSetEnvOptionChoices asiSetEnvOptionVal asiSetFormFieldChoices asiSetFormFieldVal asiSetHighPerformanceOptionVal asiSetHostOptions asiSetKeepList asiSetKeepOptionChoices asiSetKeepOptionVal asiSetMarchList asiSetNetlistFormatterClass asiSetNetlistOption asiSetPlotList asiSetProjectDirChangeSetup asiSetSimOptionChoices asiSetSimOptionVal asiSetSyncFlag asiSetValid asiSetVerilogHost asiSetVerilogHostMode asiTransientStore asiUnRegCallBackOnSimComp asiVerilogNetlistMoreCB asiWriteOceanScript asin asinh assert assoc assq assv atan atan2 atanh atof atoi atom auCdl auHiUltraPCell auLvs auLvsGetLabelSuffix auProbeAddDevsForNet avSwitch average awvAddSubwindow awvAnalog2Digital awvAppendExpression awvAppendList awvAppendWaveform awvClearPlotWindow awvClearSubwindowHistory awvClearWindowHistory awvCloseCalculator awvCloseWindow awvCloseWindowMenuCB awvCreateBus awvCreateBusFromWaveList awvCreatePlotWindow awvDeleteAllWaveforms awvDeleteSubwindow awvDeleteWaveform awvDigital2Analog awvDisableRedraw awvDisplayDate awvDisplayGrid awvDisplaySubwindowTitle awvDisplayTitle awvEraseWindowMenuCB awvEval awvExitWindowFunctionAdd awvExitWindowFunctionDel awvExitWindowFunctionGet awvGetCurrentSubwindow awvGetCurrentWindow awvGetDisplayMode awvGetDrawStatus awvGetInitializationTimeout awvGetOnSubwindowList awvGetPlotStyle awvGetSavePromptNeeded awvGetSmithModeType awvGetSubwindowList awvGetUnusedEntityList awvGetWaveNameList awvGetWindowList awvGetXAxisLabel awvGetXMarkerNames awvGetYAxisLabel awvGetYMarkerNames awvInitWindowFunctionAdd awvInitWindowFunctionDel awvInitWindowFunctionGet awvIsPlotWindow awvLoadMenuCB awvLoadWindow awvLogXAxis awvLogYAxis awvPlaceWaveformLabel awvPlaceWindowLabel awvPlaceXMarker awvPlaceYMarker awvPlotExpression awvPlotList awvPlotSignals awvPlotSimpleExpression awvPlotWaveform awvPlotWaveformOption awvPrintWaveform awvRedisplaySubwindow awvRedisplayWindow awvRedrawWindowMenuCB awvRefreshOutputPlotWindows awvRemoveDate awvRemoveLabel awvRemoveSubwindowTitle awvRemoveTitle awvResetAllWindows awvResetWindow awvResumeViVA awvRfLoadPull awvSaveMenuCB awvSaveWindow awvSaveWindowImage awvSetCurrentSubwindow awvSetCurrentWindow awvSetCursorPrompts awvSetDisplayMode awvSetDisplayStatus awvSetInitializationTimeout awvSetOptionDefault awvSetOptionValue awvSetOrigin awvSetPlotStyle awvSetSavePromptNeeded awvSetSmithModeType awvSetSmithXLimit awvSetSmithYLimit awvSetUpdateStatus awvSetWaveNameList awvSetWaveformDisplayStatus awvSetXAxisLabel awvSetXLimit awvSetXScale awvSetYAxisLabel awvSetYLimit awvSetYRange awvSimplePlotExpression awvSmithAxisMenuCB awvTableSignals awvUpdateAllWindows awvUpdateWindow awvZoomFit awvZoomGraphX awvZoomGraphXY awvZoomGraphY awviEditMenuCB awviMakeActiveMenuCB awviPLoadMenuCB awviPSaveMenuCB awviPUpdateMenuCB awviShowOutputMenuCB axlAddJobPolicy axlAddModelPermissibleSectionLists axlAddOutputExpr axlAddOutputSignal axlAddOutputs axlAddOutputsColumn axlAddSpecToOutput axlAttachJobPolicy axlCloseSession axlCloseSessionInWindow axlCloseSetupDB axlCommitSetupDB axlCommitSetupDBAndHistoryAs axlCommitSetupDBas axlCorners axlCreateSession axlCustomADETestName axlDeleteJobPolicy axlDeleteOutput axlDeleteOutputsColumn axlDetachJobPolicy axlDiffSetup axlExportOutputView axlExportSetup axlGetAllCornersEnabled axlGetAllParametersDisabled axlGetAllSweepsEnabled axlGetAllVarsDisabled axlGetAttachedJobPolicy axlGetCopyRefResultsOption axlGetCorner axlGetCornerCountForName axlGetCornerNameForCurrentPointInRun axlGetCorners axlGetCornersForATest axlGetCurrentHistory axlGetCurrentResultSimulationHost axlGetCurrentRunMode axlGetDataViewHistoryUserMenu axlGetElementParent axlGetEnabled axlGetEnabledGlobalVarPerTest axlGetHistory axlGetHistoryCheckpoint axlGetHistoryEntry axlGetHistoryGroup axlGetHistoryGroupChildren axlGetHistoryGroupChildrenEntry axlGetHistoryLock axlGetHistoryName axlGetHistoryPrefix axlGetHistoryResults axlGetJobPolicy axlGetJobPolicyTypes axlGetLocalResultsDir axlGetMainSetupDB axlGetModel axlGetModelBlock axlGetModelFile axlGetModelGroup axlGetModelGroupName axlGetModelGroups axlGetModelPermissibleSectionLists axlGetModelSection axlGetModelTest axlGetModels axlGetNominalCornerEnabled axlGetOrigTestToolArgs axlGetOutputUserDefinedData axlGetOverwriteHistory axlGetOverwriteHistoryName axlGetParameter axlGetParameterValue axlGetParameters axlGetParasiticParaLCV axlGetParasiticRunMode axlGetParasiticSchLCV axlGetPointNetlistDir axlGetPointPsfDir axlGetPointRunDir axlGetPointTroubleshootDir axlGetPreRunScript axlGetReferenceHistoryItemName axlGetResultsLocation axlGetReuseNetlist axlGetRunData axlGetRunDistributeOptions axlGetRunMode axlGetRunModes axlGetRunOption axlGetRunOptionName axlGetRunOptionValue axlGetRunOptions axlGetScript axlGetScriptPath axlGetScripts axlGetSessionCellName axlGetSessionFromSetupDB axlGetSessionLibName axlGetSessionViewName axlGetSessionWindowNumber axlGetSetupDBDir axlGetSpec axlGetSpecData axlGetSpecWeight axlGetSpecs axlGetTemperatureForCurrentPointInRun axlGetTest axlGetTestToolArgs axlGetTests axlGetToolSession axlGetTopLevel axlGetUseIncremental axlGetUserDefinedOutputsColumns axlGetVar axlGetVarValue axlGetVars axlGetWCCCorner axlGetWCCHistory axlGetWCCRangeBound axlGetWCCResult axlGetWCCSpec axlGetWCCSpecs axlGetWCCTest axlGetWCCTime axlGetWCCVar axlGetWCCVarMonotonicity axlGetWCCVars axlGetWYCSigmaTargetLimit axlGetWindowSession axlImportPreRunScript axlImportSetup axlIsICRPProcess axlIsLocalResultsDir axlIsSimUsingStatParams axlJPGUICusReadFromForm axlJPGUICustDiffer axlJPGUICustHIFields axlJPGUICustOffset axlJPGUICustSelected axlJPGUICustWriteToForm axlJobIntfcDebugPrintf axlJobIntfcDebugToFile axlJobIntfcDebugp axlJobIntfcExitMethod axlJobIntfcHealthMethod axlJobIntfcSetDebug axlJobIntfcStartMethod axlLoadCorners axlLoadCornersFromPcfToSetupDB axlLoadHistory axlLoadSetupState axlMainAppSaveSetup axlMapInstTermToNet axlNewSetupDB axlNewSetupDBLCV axlNoSession axlOpenResDB axlOutputResult axlOutputsExportToFile axlOutputsImportFromFile axlPutCorner axlPutDisabledCorner axlPutHistoryEntry axlPutModel axlPutModelGroup axlPutRunOption axlPutScript axlPutTest axlPutVar axlReadHistoryResDB axlReadResDB axlRegisterCustomDeviceFilter axlRegisterJobIntfc axlRegisteredJPGUICust axlRegisteredJobIntfcNames axlRemoveElement axlRemoveSetupState axlRemoveSimulationResults axlRenameOutputsColumn axlResetActive axlRunAllTests axlRunAllTestsWithCallback axlRunSimulation axlSaveJobPolicy axlSaveSetup axlSaveSetupState axlSaveSetupToLib axlSessionConnect axlSessionDisconnect axlSessionRegisterCreationCallback axlSessionSignalList axlSessionSignalSignature axlSetAllCornersEnabled axlSetAllParametersDisabled axlSetAllSweepsEnabled axlSetAllVarsDisabled axlSetCopyRefResultsOption axlSetCurrentRunMode axlSetDefaultCornerEnabled axlSetDefaultVariables axlSetEnabled axlSetHistoryLock axlSetJobPolicyProperty axlSetMainSetupDB axlSetMainSetupDBLCV axlSetModelBlock axlSetModelFile axlSetModelGroupName axlSetModelPermissibleSectionLists axlSetModelSection axlSetModelTest axlSetNominalCornerEnabled axlSetOutputUserDefinedData axlSetOverwriteHistory axlSetOverwriteHistoryName axlSetParameter axlSetPreRunScript axlSetPreRunScriptEnabled axlSetReferenceHistoryItemName axlSetReuseNetlistOption axlSetRunDistributeOptions axlSetRunOptionName axlSetScriptPath axlSetTestToolArgs axlSetUseIncremental axlSetWCCTime axlSetWYCSigmaTargetLimit axlSetupStates axlStop axlStopAll axlStopAllJobs axlStopJob axlToolSetOriginalSetupOptions axlToolSetSetupOptions axlViewHistoryResults axlViewResDB axlWriteDatasheet axlWriteDatasheetForm axlWriteOceanScriptLCV b1f band bandwidth bcdp begin bitfield bitfield1 blankstrp bnand bndAddInstsBindingByName bndAddObjectsBinding bndGetBoundObjects bndGetSiblingBoundObjects bndRemoveInstBindingByName bndRemoveObjectBinding bndRemoveTermBindingByName bndReplaceInstsBindingByName bndReplaceObjectsBinding bndReplaceTermsBindingByName bndSetInstsBindingByName bndSetObjectsBinding bndSetTermsBindingByName bnor bnot booleanp bor bottomEdge boundp break breakpt breakptMethod buildString bxnor bxor cPwrContour cReflContour caaar caadr caar caddr cadr calCalcInput calCalculatorFormCB calCreateSpecialFunction calCreateSpecialFunctionsForm calGetBuffer calRegisterSpecialFunction calSetBuffer calSetCurrentTest calSpecialFunctionInput calcVal caliModeToggle caliRestoreDefaultWindowSize callAs callInitProc callNextMethod callUserAutoInitProc cancelEnterFun captabSummary car case caseq cat catch ccpCopy ccpCopyConfig ccpCopyDesign ccpCopyExactDesign ccpExpand ccpExpandConfig ccpExpandDesign ccpExpandExactDesign ccpRegMonitor ccpRegTrigger ccpRemoveTrigger ccpRename ccpRenameReferenceLib cdar cddr cdfCopyCDF cdfCopyParam cdfCreateBaseCellCDF cdfCreateBaseLibCDF cdfCreateParam cdfCreateUserCellCDF cdfCreateUserLibCDF cdfDeleteCDF cdfDeleteParam cdfDump cdfDumpAll cdfEditScaleFactors cdfFindParamByName cdfFormatFloatString cdfGetBaseCellCDF cdfGetBaseLibCDF cdfGetCellCDF cdfGetCustomViaCDF cdfGetInstCDF cdfGetLibCDF cdfGetUnitScaleFactor cdfGetUserCellCDF cdfGetUserLibCDF cdfParseFloatString cdfRefreshCDF cdfSaveCDF cdfSetUnitScaleFactor cdfSyncInstParamValue cdfUpdateCustomViaParam cdfUpdateInstParam cdfUpdateInstSingleParam cdr cdsGenViaDefs cdsGetInstPath cdsGetNetlistMode cdsGetToolsPath cdsName cdsNetExpr cdsParam cdsPlat cdsSetNetlistMode cdsTerm ceiling centerBox changeClass changeEnterFun changeNextEnterFun changeWorkingDir charToInt checkContextBit ciAddLeadingSlash ciAddProcessRules ciAddRuleGroup ciAddStructArg ciAddTrailingSlash ciAlignPinsOnCellSide ciAllCellViewsInHierarchy ciAxisCreate ciAxisDelete ciAxisExists ciAxisListCon ciAxisListParams ciAxisReplaceParams ciBasicGetParamValue ciBuildModgenParams ciBundleSignalsIterator ciCPRegistrationFromLAM ciCacheCellName ciCacheConstraintCellName ciCacheConstraintLibName ciCacheConstraintViewName ciCacheDiscardEdits ciCacheFind ciCacheGet ciCacheGetAllNetNames ciCacheIsLayout ciCacheIsModified ciCacheIsWritable ciCacheLCV ciCacheLibName ciCacheListAxesNames ciCacheListCon ciCacheListConstrainedObjectNames ciCacheListConstrainedObjects ciCacheListTemplates ciCacheListTypeNames ciCacheListTypes ciCacheMakeEditable ciCacheMakeReadOnly ciCacheNeedRefresh ciCachePurge ciCacheSave ciCacheTopCellName ciCacheTopLibName ciCacheTopViewName ciCacheViewName ciCachep ciCanCGBeUsed ciCheckConstraints ciClearNetSuperTypes ciClusterBoundaryForCluster ciCollectDeviceInfo ciCombineInstNetsPins ciConAppendOneMember ciConCreate ciConCreateExpanded ciConDelete ciConFind ciConGetAxisName ciConGetCache ciConGetComment ciConGetCreatedTime ciConGetMembersOfType ciConGetName ciConGetNote ciConGetOwner ciConGetPriority ciConGetStatus ciConGetType ciConIsInContext ciConIsOutOfContext ciConIsOverridden ciConIsWritable ciConListMemberNames ciConListMembers ciConListParamNames ciConListParams ciConListTemplates ciConRemoveMembers ciConResetAllParams ciConResetParams ciConSetAxis ciConSetNote ciConSetPriority ciConSetStatus ciConTypeHasNamedParameter ciConUpdateMembers ciConUpdateParams ciConUprevCellBoundary ciConVerify ciConp ciConstraintLCV ciConstraintViewLessp ciConvertParamsDPLToParams ciConvertParamsToDPL ciConvertToConArg ciCreateFilter ciCreateGuardRing ciCreateHierarchicalConstraintNotes ciCreateModgen ciCreateModgenDummy ciCreateModgenForStructure ciCreateRoutePriorityCon ciCreateRoutingLayerEnumString ciCurrentPathIterator ciDefaultParamToMatchFilter ciDeleteClusterMembersWithinModgens ciDeleteGuardRing ciDeleteRuleGroup ciDeleteStructArgs ciDeleteSymmetriesWithinModgens ciDesignLCV ciEnableAssistant ciEnableAutoConstraintNotes ciExpandAndRepeatName ciExpandIteratedDeviceInfo ciExpandMembers ciExpandName ciExtractRowNumber ciFindDeviceArraysForDev ciFindObjectInHier ciFindOpenCellView ciFindOpenCellViews ciGUIArgsToConArgs ciGenerateArrayChannelDesc ciGenerateBestFitPattern ciGenerateCascodedCurrentMirrorChannelDesc ciGenerateCascodedCurrentMirrorPattern ciGenerateConstraintGroups ciGenerateCurrentMirrorChannelDesc ciGenerateCurrentMirrorPattern ciGenerateDiffPairChannelDesc ciGenerateDiffPairPattern ciGenerateLargeMfactorPattern ciGeneratorCheckInstsNetsPinsInstTerms ciGeneratorForInstSymmetry ciGeneratorForNetSymmetry ciGetCellTermDefaultNetName ciGetCellView ciGetCellViewForObjectPath ciGetConstraintGroupsEnum ciGetCustomFilterNames ciGetDefaultNetName ciGetDeviceBulkTermName ciGetDeviceInfo ciGetDeviceNames ciGetDeviceTermName ciGetFirstDeviceTermName ciGetFluidGuardRingDeviceEnum ciGetFoundryRules ciGetGuardRing ciGetGuardRingMPPName ciGetLAMComponentTypes ciGetMatchParam2DList ciGetMembersOfType ciGetNetNames ciGetNetSubTypes ciGetNetSuperTypes ciGetObjectCellView ciGetOpenCellViews ciGetParamMapping ciGetParamName ciGetParamValFromParameters ciGetParamValue ciGetParamValueOrDefault ciGetParamValues ciGetRoutingLayer ciGetRoutingLayers ciGetRule ciGetRuleGroupByName ciGetRuleGroupName ciGetRuleGroups ciGetStructArg ciGetStructArgs ciGetStructGeneratorExpressions ciGetStructPDKMult ciGetTechFile ciGetTechMPPNames ciGetTermNames ciGuardRingForCluster ciGuardRingForModgen ciHasCellAnyRegTerm ciHaveSameBulkNets ciHaveSameParamValues ciHierCompareConstraint ciHierCompareConstraints ciHierUpdateConstraints ciHighestLevelNet ciIgnoreDevice ciInstIterator ciInstTermIterator ciIsDevice ciIsNet ciIsNetSuperType ciListEditors ciListGeneratableConstraintGroups ciListProcessRules ciListStructGeneratorExpressions ciListStructPDKMults ciListStructTypes ciListTemplateTypes ciListTypes ciLoadConfigXML ciLoadDotCadenceFiles ciLoadIcon ciLoadIcons ciLxComparisonReport ciMOSActiveLoadStructIterator ciMOSCascodeIterator ciMOSCascodedCurrentMirrorStructIterator ciMOSCascodedCurrentMirrorStructIterator2 ciMOSCommonGateStructIterator ciMOSCrossCoupledDifferentialPairStructIterator ciMOSCrossCoupledQuadStructIterator ciMOSCurrentMirrorStructIterator ciMOSDifferentialPairStructIterator ciMOSInverterStructIterator ciMOSParallelStructIterator ciMOSTransmissionGateStructIterator ciMakeHierContext ciMakeObjectInfo ciMapParam ciMapTerm ciMapTermName ciMatchedFingerWidth ciMatchedParametersForCurrent_Mirror ciMatchedParamsForInstanceSymmetry ciMatchedParamsForSameSizeInstances ciMemberIndexToModgenPatternSymbol ciMergeParams ciModgenDummyNetName ciModgenForSameCellSizeAndBulk ciModgenMergeLayersFromArgs ciNetIterator ciNetNames ciNetOnTerm ciNetPredicates ciNetRegexs ciNextConName ciNextObjName ciNextTemplateName ciNumDevices ciNumTermsEQ2 ciObjectIsInContext ciObjectListCon ciObjectPathAndName ciOpenCellView ciOpenPanicCellView ciOrientationForModgen ciPadModgenPattern ciPinIterator ciPlacerControlledWellGeneration ciPrintMappedDefaultNetNames ciPrintMappedDeviceNames ciPrintMappedNetNames ciPrintMappedParams ciPrintMappedTerminals ciPrintReport ciPullConstraint ciPullConstraints ciPushConstraint ciPushConstraints ciRefreshCellView ciRegTypeBindingParameter ciRegexReplaceStructArgs ciRegisterAssistant ciRegisterConstraintEditor ciRegisterConstraintGenerator ciRegisterCustomDeviceFilter ciRegisterDefaultNetName ciRegisterDevice ciRegisterDynamicParamDef ciRegisterFinder ciRegisterIterator ciRegisterNet ciRegisterNetNames ciRegisterNetPredicate ciRegisterNetRegexs ciRegisterNetSuperType ciRegisterStructure ciReinitStructTemplateDefs ciRemoveConstrainedPinNetsFromRails ciRemoveHierarchicalConstraintNotes ciRemoveLeadingSlash ciRemoveProcessRules ciRemoveSymmetricPinAlignments ciRemoveTrailingSlash ciReopenCellView ciReorderAssistants ciReplaceStructArgs ciResolveBulkNet ciResolveNet ciRunFinder ciRunMatchingConstraintsGenerator ciSameCellIterator ciSaveConstraintGenerator ciSeparateInstsNetsPins ciSetCMCGSKILLCallbacks ciSetDefaultConstraintEditor ciSetHaloOptions ciSetHaloPolicy ciSetMaxHaloGroupSize ciSetStructArgVal ciSetStructArgs ciSetStructGeneratorExpressions ciSetStructPDKMult ciSetSymmetricAxes ciSigTypeMatchesNetType ciSignalIterator ciSimpleName ciSortDeviceInfoByFingerWidth ciSortDeviceInfoByMfactor ciSortDeviceInfoByX ciSortDeviceInfoByXY ciSortDeviceInfoByY ciSortDeviceInfoByYX ciSortedOpenCellViews ciTemplateAddCons ciTemplateCreate ciTemplateCreateDefinition ciTemplateCreateExpanded ciTemplateDefinitionExists ciTemplateDelete ciTemplateDeleteCons ciTemplateFind ciTemplateGetCreatedTime ciTemplateGetDefName ciTemplateGetName ciTemplateGetNote ciTemplateGetType ciTemplateListCon ciTemplateListParamNames ciTemplateListParams ciTemplateResetAllParams ciTemplateResetParams ciTemplateSetNote ciTemplateSortParamDefs ciTemplateUpdateParams ciTemplatep ciToFloat ciTypeBindingParameter ciTypeHasBindingParameter ciTypeIsType ciTypeIsUserDefined ciTypeListCon ciUnRegisterTerm ciUnexpandDeviceInfo ciUnexpandIteratedDeviceInfo ciUnexpandPhysicalDeviceInfo ciUniqueMembers ciUnregisterAssistant ciUnregisterConstraintGenerator ciUnregisterIterator ciUnregisterNetSuperType ciUpdateModgenParamsAndMembers ciUprevEAConstrs ciUtilsAddNTimes ciUtilsAddQuotes ciUtilsBuildString ciUtilsGetArgVal ciUtilsMakeNumberRange ciUtilsMakeUnique ciUtilsRemoveNils ciUtilsRepeatNTimes ciUtilsReplaceNils ciVariantInfoForFingersAndFingerWidth ciWithinConstraint ciXYInstSymmetricIterator ciXYNetSymmetricIterator ciXYPinSymmetricIterator ciXYSortInsts ciXYSymmetricIterator ciwAddTranslatorItem ciwCreateMenu ciwCreatePulldown ciwHiExit ciwMenuInit ciwMenuInstall ciwMenuLoadFile ciwRemoveTranslatorItem className classOf classp clear clearAll clearAllEnterFunctions clearExitProcs clearSubwindow clip clipX close closeResults cmdCtrlOption cmdOption cmdShiftOption colorIndex compare compareTime complex complexp compress compression compressionVRI compressionVRICurves concat cond conjugate conn2Sch conn2SchImpHdlDisplay conn2SchStartUp connectRules cons constar cont continue converge convolve copy copyDefstructDeep cos cosh count cpfAddCLPLibs cpfAddCLPSearchPath cpfDefineEquivalentExpression cpfDefinePowerSwitchInstance cpfExportPowerIntent cpfExtractPowerIntent cpfFindReferenceLibs cpfGetCLPLibs cpfGetCLPSearchPath cpfGetCellNetVoltage cpfGetDefaultPowerDomainPGNets cpfGetDevicePowerGroundNetPair cpfGetEquivalentExpression cpfGetInstancePowerGroundNetPair cpfGetMatchingGroundNet cpfGetMatchingGroundNets cpfGetModelPowerGroundNetPair cpfGetNetVoltage cpfGetNetVoltages cpfGetPowerDomainNamePrefix cpfGetPowerGroundNetPairs cpfGetPowerGroundNetVoltagePairs cpfGetPowerSwitchInstanceInfo cpfGetReferenceLibs cpfGetSpecialCellExcludeDataPins cpfGetUserNetlistConfigViewName cpfGetUserNetlistViewNameList cpfHiExportPowerIntent cpfHiPowerIntentExtractOptions cpfHiPropagateSignalType cpfIsNetExternalControlledShutoff cpfIsPowerSwitchInstance cpfRegDefaultPowerDomainPGNets cpfRegDevicePowerGroundNetPair cpfRegInstancePowerGroundNetPair cpfRegModelPowerGroundNetPair cpfRegPowerGroundNetPairs cpfRegisterPowerDomainNamePrefix cpfRegisterSpecialCell cpfRemoveCLPLib cpfRemoveCLPSearchPath cpfRemovePowerIntent cpfRemovePowerSwitchInstance cpfResetCLPLibs cpfSetCLPLibs cpfSetCLPSearchPath cpfSetCellNetVoltage cpfSetNetExternalControlledShutoff cpfSetNetVoltage cpfSetNetVoltages cpfSetPowerGroundNetVoltagePairs cpfSetPowerIntentExtractOptions cpfSetReferenceLibs cpfSetSpecialCellExcludeDataPins cpfSetUserNetlistConfigViewName cpfSetUserNetlistViewNameList cpfValidatePowerIntent cphClearCellPhysicalBinding cphClearInstPhysicalBinding cphClearOccurPhysicalBinding cphCloseConfig cphCloseWindow cphCreatePhysConfig cphDeleteCellFingerSplit cphDeleteCellIgnoreForCheck cphDeleteCellIgnoreForGen cphDeleteCellMFactorSplit cphDeleteCellParamIgnoreForCheck cphDeleteCellParamIgnoreForGen cphDeleteCellParamNameMapping cphDeleteCellRemoveDevice cphDeleteCellRounding cphDeleteCellSFactorSplit cphDeleteCellTermIgnoreForCheck cphDeleteCellTermIgnoreForGen cphDeleteCellTermNameMapping cphDeleteCellVPLGen cphDeleteInstFingerSplit cphDeleteInstIgnoreForCheck cphDeleteInstIgnoreForGen cphDeleteInstMFactorSplit cphDeleteInstParamIgnoreForCheck cphDeleteInstParamIgnoreForGen cphDeleteInstRemoveDevice cphDeleteInstRounding cphDeleteInstSFactorSplit cphDeleteInstTermIgnoreForCheck cphDeleteInstTermIgnoreForGen cphDeleteOccurFingerSplit cphDeleteOccurIgnoreForCheck cphDeleteOccurIgnoreForGen cphDeleteOccurMFactorSplit cphDeleteOccurParamIgnoreForCheck cphDeleteOccurParamIgnoreForGen cphDeleteOccurRemoveDevice cphDeleteOccurRounding cphDeleteOccurSFactorSplit cphDeleteOccurTermIgnoreForCheck cphDeleteOccurTermIgnoreForGen cphFindOpenConfig cphGetCell cphGetCellFingerSplit cphGetCellForceDescend cphGetCellIgnoreForCheck cphGetCellIgnoreForGen cphGetCellMFactorSplit cphGetCellParamIgnoreForCheck cphGetCellParamIgnoreForGen cphGetCellParamNameMapping cphGetCellPhysicalBinding cphGetCellPhysicalCell cphGetCellPhysicalLib cphGetCellPhysicalView cphGetCellRemoveDevice cphGetCellRounding cphGetCellSFactorSplit cphGetCellStopList cphGetCellTermIgnoreForCheck cphGetCellTermIgnoreForGen cphGetCellTermNameMapping cphGetCellVPLGen cphGetCellVPLGenParams cphGetCellViewBinding cphGetCellViewList cphGetCstList cphGetFingerSplit cphGetForceDescend cphGetIgnoreForCheck cphGetIgnoreForGen cphGetInstFingerSplit cphGetInstForceDescend cphGetInstIgnoreForCheck cphGetInstIgnoreForGen cphGetInstMFactorSplit cphGetInstParamIgnoreForCheck cphGetInstParamIgnoreForGen cphGetInstPhysicalCell cphGetInstPhysicalLib cphGetInstPhysicalView cphGetInstRemoveDevice cphGetInstRounding cphGetInstSFactorSplit cphGetInstStopList cphGetInstTermIgnoreForCheck cphGetInstTermIgnoreForGen cphGetInstViewBinding cphGetInstViewList cphGetLayoutXLConfig cphGetLib cphGetLibList cphGetMFactorSplit cphGetOccurFingerSplit cphGetOccurForceDescend cphGetOccurIgnoreForCheck cphGetOccurIgnoreForGen cphGetOccurMFactorSplit cphGetOccurParamIgnoreForCheck cphGetOccurParamIgnoreForGen cphGetOccurPhysicalCell cphGetOccurPhysicalLib cphGetOccurPhysicalView cphGetOccurRemoveDevice cphGetOccurRounding cphGetOccurSFactorSplit cphGetOccurStopList cphGetOccurTermIgnoreForCheck cphGetOccurTermIgnoreForGen cphGetOccurViewBinding cphGetOccurViewList cphGetParamIgnoreForCheck cphGetParamIgnoreForGen cphGetParamNameMapping cphGetPhysicalCell cphGetPhysicalLib cphGetPhysicalTermName cphGetPhysicalView cphGetRemoveDevice cphGetRounding cphGetSFactorSplit cphGetSelectedSet cphGetStopList cphGetStopPoint cphGetTermIgnoreForCheck cphGetTermIgnoreForGen cphGetTermNameMapping cphGetTopCellView cphGetView cphGetViewBinding cphGetViewList cphGetWinConfig cphGetWindowId cphIsConfigModified cphIsLeaf cphIsParamIgnoredForCheck cphIsParamIgnoredForGen cphIsRemoveDevice cphIsTermIgnoredForCheck cphIsTermIgnoredForGen cphIsUnderPhysConfig cphLaunchFromLayout cphOpenConfig cphOpenWindow cphSaveAsConfig cphSaveConfig cphSbAddIOPin cphSbDefineIOPinLabelFlag cphSbDefineObstruction cphSbDefineSoftBlock cphSbDelIOPin cphSbDelIOPinById cphSbDelObstruction cphSbDisplayAllIOPinsInfo cphSbDisplayBoundaryInfo cphSbDisplayIOPinInfo cphSbDisplayObstruction cphSbDisplaySoftBlockAttributes cphSbEditIOPin cphSbEditIOPinById cphSbEditSoftBlockAttributes cphSbGetAllIOPins cphSbGetFilteredIOPins cphSbGetIOPinId cphSbGetIOPinName cphSbGetSoftBlockId cphSbGetSoftBlocks cphSbIsValidIOPin cphSbLoadSoftBlocks cphSbRemoveSoftBlock cphSbSaveSoftBlocks cphSbSetPolygonalBoundary cphSbSetRectangularBoundary cphSbSetRectangularBoundaryUsingUtil cphSetCellFingerSplit cphSetCellForceDescend cphSetCellIgnoreForCheck cphSetCellIgnoreForGen cphSetCellMFactorSplit cphSetCellParamIgnoreForCheck cphSetCellParamIgnoreForGen cphSetCellParamNameMapping cphSetCellPhysicalBinding cphSetCellRemoveDevice cphSetCellRounding cphSetCellSFactorSplit cphSetCellStopList cphSetCellTermIgnoreForCheck cphSetCellTermIgnoreForGen cphSetCellTermNameMapping cphSetCellVPLGen cphSetCellVPLGenParams cphSetCellViewBinding cphSetCellViewList cphSetCstList cphSetInstFingerSplit cphSetInstForceDescend cphSetInstIgnoreForCheck cphSetInstIgnoreForGen cphSetInstMFactorSplit cphSetInstParamIgnoreForCheck cphSetInstParamIgnoreForGen cphSetInstPhysicalBinding cphSetInstRemoveDevice cphSetInstRounding cphSetInstSFactorSplit cphSetInstStopList cphSetInstStopPoint cphSetInstTermIgnoreForCheck cphSetInstTermIgnoreForGen cphSetInstViewBinding cphSetInstViewList cphSetLibList cphSetOccurFingerSplit cphSetOccurForceDescend cphSetOccurIgnoreForCheck cphSetOccurIgnoreForGen cphSetOccurMFactorSplit cphSetOccurParamIgnoreForCheck cphSetOccurParamIgnoreForGen cphSetOccurPhysicalBinding cphSetOccurRemoveDevice cphSetOccurRounding cphSetOccurSFactorSplit cphSetOccurStopList cphSetOccurStopPoint cphSetOccurTermIgnoreForCheck cphSetOccurTermIgnoreForGen cphSetOccurViewBinding cphSetOccurViewList cphSetStopList cphSetViewList cphUprevDesign cphUprevIncremental cphUprevLibrary cphVisitNextNode cphVisitStart cphVisitStop cphVisitedInstance cphVisitedPath cphVisitedSwitchMaster cphVisitedTarget cputime createDir createDirHier createFinalNetlist createNetlist cross csh cstAddToConstraintGroup cstCreateConstraint cstCreateConstraintGroupIn cstCreateConstraintGroupOn cstDeleteConstraint cstDeleteConstraintGroup cstFindConstraintGroupIn cstFindConstraintGroupOn cstFindFirstConstraint cstGet1DTableValue cstGet2DTableValue cstGetConstraintGroups cstGetDefaultConstraintGroupName cstGetTwoWidthTableValue cstGetUnreferencedConstraints cstIsId cstSetDefaultConstraintGroupName ctAddCellToCompTypeGroup ctCreateCompTypeGroup ctDeleteCellFromCompTypeGroup ctDeleteCompTypeGroup ctGetCellCompTypeGroup ctGetCompTypeCells ctGetCompTypeGroupAttr ctGetCompTypeNames ctSetCompTypeGroupAttr currentSubwindow currentWindow d2a dB10 dB20 dBm dagAddActionToObject dagCreateClass dagCreateNode dagDeleteActionFromObject dagDestroyNode dagDisplayTool dagGetCurrentObject dagGetCurrentTool dagLinkParentToChild dagNumToTool dagOpenTool dagPopTool dagPushTool dagRefreshObject dagSetActionStatus dagSetCurrentTool dagSetExpandedActionStatus dagSetFont dagUnlinkParentFromChild dataTrigger dataTypes db10 db20 dbAbutIsInteractive dbAddAreaToPinGroupGuide dbAddFigToFigGroup dbAddFigToNet dbAddFigToPin dbAddFigToPinGroupGuide dbAddFigsToPin dbAddObjectToGroup dbAddObjectsToMarker dbAddPinToPinGroupGuide dbAddPlaceAreaCompTypeSetDef dbAddPlaceAreaRailDef dbAddRowCompTypeSetDef dbAddRowRailDef dbAddStrapObject dbAllCellViews dbAreaBoundaryHasLayerPriorityOrder dbAreaBoundaryHasValidRoutingLayers dbBoundaryQuery dbCVHasInheritedSig dbCVHasInheritedTerm dbCVHasNetSetProp dbCellViewAreLayerShiftsValid dbCellViewClearLayerShifts dbCellViewHasLayerShifts dbCellViewInitForLayerShifting dbCellViewUpdateLayerShifts dbChangeGroupType dbCheckParamCell dbCheckRecursion dbClearPcellCache dbClose dbCloseBag dbColorShapeQuery dbCompressPointArray dbCompressionPlot dbComputeBBox dbComputeBBoxNoNLP dbConcatTransform dbConnectObject dbConvertArcToLine dbConvertDonutToPolygon dbConvertEllipseToPolygon dbConvertLineToPath dbConvertPathSegToPolygon dbConvertPathToPolygon dbConvertRectToPolygon dbCopyCellView dbCopyFig dbCopyProp dbCopyPropList dbCopyShape dbCopySingleProp dbCreateArc dbCreateAreaBlockage dbCreateAreaBoundary dbCreateAreaHalo dbCreateAreaPinGroupGuide dbCreateBusNetDef dbCreateBusTermDef dbCreateCluster dbCreateClusterBoundary dbCreateCompTypeSetDef dbCreateConn dbCreateConnByName dbCreateConnByNewName dbCreateCoverObstruction dbCreateCustomViaVariant dbCreateDiffMaskGroup dbCreateDonut dbCreateDot dbCreateEdgePinGroupGuide dbCreateEllipse dbCreateEnumProp dbCreateExtParamInst dbCreateExtParamInstByMasterName dbCreateFigGroup dbCreateGCellPattern dbCreateGroup dbCreateGuide dbCreateHierProp dbCreateInst dbCreateInstByMasterName dbCreateInstTerm dbCreateInstTermByPosition dbCreateLabel dbCreateLayerBlockage dbCreateLayerHalo dbCreateLib dbCreateLine dbCreateMarker dbCreateNet dbCreatePRBoundary dbCreateParamInst dbCreateParamInstByMasterName dbCreateParamSimpleMosaic dbCreateParamSimpleMosaicByMasterName dbCreatePath dbCreatePathSeg dbCreatePin dbCreatePlaceArea dbCreatePolygon dbCreateProp dbCreateRailDef dbCreateRangeProp dbCreateRect dbCreateRoute dbCreateRow dbCreateSameMaskGroup dbCreateSigNetExpr dbCreateSimpleMosaic dbCreateSnapBoundary dbCreateStdViaVariant dbCreateSteiner dbCreateStrap dbCreateStrongGroup dbCreateTerm dbCreateTermNetExpr dbCreateTextDisplay dbCreateTopology dbCreateTrackPattern dbCreateTrunk dbCreateTrunkConnect dbCreateTwig dbCreateUniqueNamedNet dbCreateVectorInstDef dbCreateVia dbCreateViaShapeArray dbCreateXformPCell dbDebugStats2 dbDefineProc dbDeleteAllNet dbDeleteAllTerminalAntennaRules dbDeleteEmptyNet dbDeleteGroupByName dbDeleteGroupMemberFromGroup dbDeleteObject dbDeleteObjectFromGroup dbDeletePropByName dbDeleteSigNetExpr dbDeleteStrap dbDeleteTermNetExpr dbDeleteTerminalAntennaRuleOnLayer dbDeleteTerminalAntennaRules dbDeleteTopology dbDeleteTrunk dbDeleteTrunkConnect dbDeleteTwig dbDisableCellViewCounter dbDisconnectObject dbDumpPcDefinePcell dbDumpPcell dbDumpPcellWithLib dbEnableCellViewCounter dbEnableUndo dbEvalParamCell dbExpandToMemNameExpr dbExternallyConnectPins dbFigGroupQuery dbFindAbutFig dbFindAnyInstByName dbFindAreaBoundaryByName dbFindBusNetDefByName dbFindBusTermDefByName dbFindClusterBoundaryByName dbFindClusterByName dbFindMemInstByName dbFindMosaicByName dbFindNetByName dbFindOpenBag dbFindOpenCellView dbFindPinGroupGuideByName dbFindProp dbFindRowByName dbFindRowHeader dbFindSigByAlias dbFindSigByName dbFindTermByName dbFindTermByPosition dbFindVectorInstDefByName dbFindViaHeaderByName dbFindViaVariantByName dbFix dbFixParamCell dbFlattenInst dbFlattenInst2 dbFreeze dbFullLibPath dbFullPath dbGet dbGetAnyInstSwitchMaster dbGetAreaBoundaryLayerPriorityOrder dbGetAreaBoundaryPinGroupGuide dbGetAreaBoundaryValidRoutingLayers dbGetAreaPinGroupGuideAreas dbGetBag dbGetBagDdId dbGetBagOwner dbGetBagTimeStamp dbGetBlockageColor dbGetBuildInfo dbGetCellViewCompTypeSetDef dbGetCellViewCounter dbGetCellViewDdId dbGetCellViewEEQMaster dbGetCellViewInheritedSig dbGetCellViewInheritedTerm dbGetCellViewNetVoltageRange dbGetCellViewPlaceArea dbGetCellViewRailDef dbGetCellViewSymmetry dbGetCellViewTopologies dbGetColorModel dbGetDatabaseType dbGetFigAbutName dbGetFigAbutRefName dbGetFigGroupByName dbGetFigPinGroupGuide dbGetFileDatabaseType dbGetFileTimeStamp dbGetFluidShapeByName dbGetGroupByName dbGetGroupsWithDef dbGetHierPathTransform dbGetInstByName dbGetInstNameNumInst dbGetInstTermStraps dbGetInstTermTwigs dbGetInstTransform dbGetInstanceByName dbGetIntegrationColorModel dbGetLibDataCompressionLevel dbGetMaxHierDepth dbGetMaxNumBit dbGetMemName dbGetMemNetSig dbGetMemNetSigName dbGetNameNumBit dbGetNeighbor dbGetNeighborList dbGetNetPowerDomain dbGetNetTerms dbGetNetTopologies dbGetNetVoltageRange dbGetNetVoltageRangeSource dbGetOpenBags dbGetOpenCellViews dbGetOverlaps dbGetPRBoundaryPinGroupGuides dbGetPathSegStyle dbGetPinConnection dbGetPinFigAccessDirection dbGetPinFigName dbGetPinFigPlacementStatus dbGetPinGroupGuideEdgeBoundary dbGetPinGroupGuideEdgeName dbGetPinGroupGuideEdgeStartOffset dbGetPinGroupGuideEdgeStopOffset dbGetPinGroupGuideKeepoutSpacing dbGetPinGroupGuideLayerPriorityOrder dbGetPinGroupGuideMinPinSpacing dbGetPinGroupGuideMinPinWidth dbGetPinGroupGuideValidRoutingLayers dbGetPinGroupGuides dbGetPinMinPinSpacing dbGetPinMinPinWidth dbGetPinPinGroupGuides dbGetPlaceAreaCompTypeSetDef dbGetPlaceAreaOrient dbGetPlaceAreaRailDef dbGetPlaceAreaUtilization dbGetPlacementGrid dbGetPropByName dbGetRedoHandles dbGetRowCompTypeSetDef dbGetRowRailDef dbGetSameMaskDiffMaskGroups dbGetShapeColor dbGetShapeSameMaskGroups dbGetShapeStraps dbGetShapeTwigs dbGetSigNameMemNets dbGetSigNetExpr dbGetSoftConnectTermConnectToLayer dbGetSoftConnectTermPinlessLayer dbGetStrapName dbGetStrapObjects dbGetStrapTopology dbGetStrapTwig dbGetStrongGroups dbGetTermGroundSensitivity dbGetTermNetExpr dbGetTermSupplySensitivity dbGetTerminalAntennaRuleOnLayer dbGetTerminalAntennaRules dbGetTopologyName dbGetTopologyNet dbGetTopologyObjects dbGetTopologyPatternType dbGetTrackPatternFirstTrackColor dbGetTrueOverlaps dbGetTrunkAnchor dbGetTrunkConnectName dbGetTrunkConnectTopology dbGetTrunkConnectTrunks dbGetTrunkDirection dbGetTrunkLongOffset1 dbGetTrunkLongOffset2 dbGetTrunkLongOffsetSource dbGetTrunkLongOffsetSource1 dbGetTrunkLongOffsetSource2 dbGetTrunkName dbGetTrunkOrthoOffset dbGetTrunkSide dbGetTrunkTopology dbGetTrunkTwigs dbGetTwigName dbGetTwigObject dbGetTwigPinName dbGetTwigTrunk dbGetUndoHandles dbGetVersion dbGetViaCutLayerControl dbGetViaLayer1Control dbGetViaLayer2Control dbGetViaStraps dbGetViaTwigs dbGetq dbGuideQuery dbHasExternalConnections dbHasFigAbutName dbHasFigAbutRefName dbHasInstance dbHasMustConnections dbHasShape dbHasShortedTerminals dbInstClearLayerShifts dbInstGetLayerShifts dbInstHasLayerShifts dbInstQuery dbInstSetLayerShifts dbIsAnyInstBaseNameUsed dbIsBagId dbIsBagReadable dbIsBagWritable dbIsBlockageColored dbIsBlockageColoringAllowed dbIsCellViewModified dbIsCellViewStdViaMaster dbIsConnCurrent dbIsFluidPcell dbIsId dbIsNetNameDescend dbIsObjectBound dbIsObjectConnected dbIsSameMaster dbIsShapeColorLocked dbIsShapeColored dbIsShapeColoringAllowed dbIsSigInherited dbIsSigNameGlobal dbIsTermInherited dbIsTermSoftConnect dbIsTopologyPatternId dbIsTrackPatternColorAlternating dbIsTrackPatternColored dbIsTrackPatternColoringAllowed dbIsVPLGen dbIsValidSigNetExpr dbIsValidTermNetExpr dbIsViaColorStateLocked dbLayerAnd dbLayerAndNot dbLayerBlockageQuery dbLayerEnclose dbLayerHoles dbLayerInside dbLayerNoHoles dbLayerOr dbLayerOutside dbLayerSize dbLayerStraddle dbLayerTile dbLayerXor dbMakeBagCurrent dbMakeNet dbMarkerQuery dbMergeNet dbMergeSignal dbMergeSingleProp dbMergeStrongGroups dbMoveChildNet dbMoveFig dbMoveGroupMember dbMovePinToNet dbMoveShape dbMustConnectPins dbNetHasTopology dbNetIsSig dbObjectHasConnection dbOpenAutoSavedCellView dbOpenBag dbOpenCellViewByType dbOpenHier dbOpenPanicCellView dbParseSigNetExpr dbParseTermNetExpr dbPinGroupGuideHasKeepoutSpacing dbPinGroupGuideHasLayerPriorityOrder dbPinGroupGuideHasMinPinSpacing dbPinGroupGuideHasMinPinWidth dbPinGroupGuideHasValidRoutingLayers dbPinHasMinPinSpacing dbPinHasMinPinWidth dbPlacementBlockageQuery dbPointArrayAnd dbPointArrayAndNot dbPointArrayOr dbPointArraySize dbPointArrayXor dbProduceMemName dbProduceOverlap dbProduceOverlapInst dbPurge dbPurgeBag dbReOpenBag dbRedoToHandle dbRefreshBag dbRefreshCellView dbRefreshLibDataCompressionLevel dbRegPostSaveAsTrigger dbRegPostSaveTrigger dbRegPurgeTrigger dbRegSaveTrigger dbRegVPLGenCreateCellName dbRemoveFigFromFigGroup dbRemoveObjectsFromMarker dbRemovePinGroupGuideEdge dbRemovePlaceAreaCompTypeSetDef dbRemovePlaceAreaRailDef dbRemoveRowCompTypeSetDef dbRemoveRowRailDef dbRemoveStrapObject dbRenameNet dbReopen dbReplaceEnumProp dbReplaceHierProp dbReplaceInstParamList dbReplaceParam dbReplaceProp dbReplacePropList dbReplaceRangeProp dbReplaceSigNetExpr dbReplaceTermNetExpr dbRowQuery dbSave dbSaveBag dbSavePcellCache dbSavePcellCacheForCV dbSavePcellCacheForCVOnly dbSearchCDF dbSearchPropByName dbSet dbSetAreaBoundaryLayerPriorityOrder dbSetAreaBoundaryValidRoutingLayers dbSetAutoSave dbSetBlockageColor dbSetBoundaryEdge dbSetCellViewEEQMaster dbSetCellViewNetVoltageRange dbSetCellViewSymmetry dbSetColorModel dbSetConnCurrent dbSetFigAbutName dbSetFigAbutRefName dbSetInstHeaderMasterName dbSetInstHeadersCounter dbSetIntegrationColorModel dbSetLibDataCompressionLevel dbSetNIMsgMode dbSetNetNameDescend dbSetNetPowerDomain dbSetNetVoltageRange dbSetNetVoltageRangeSource dbSetPathSegPoints dbSetPathSegStyle dbSetPinFigAccessDirection dbSetPinFigName dbSetPinFigPlacementStatus dbSetPinGroupGuideEdge dbSetPinGroupGuideEdgeStartOffset dbSetPinGroupGuideEdgeStopOffset dbSetPinGroupGuideKeepoutSpacing dbSetPinGroupGuideLayerPriorityOrder dbSetPinGroupGuideMinPinSpacing dbSetPinGroupGuideMinPinWidth dbSetPinGroupGuideValidRoutingLayers dbSetPinMinPinSpacing dbSetPinMinPinWidth dbSetPlaceAreaOrient dbSetPlaceAreaUtilization dbSetPlacementGrid dbSetShapeColor dbSetShapeColorLocked dbSetSoftConnectTermConnectToLayer dbSetSoftConnectTermPinlessLayer dbSetStrapName dbSetStrapTwig dbSetTermGroundSensitivity dbSetTermMustJoin dbSetTermSoftConnect dbSetTermSupplySensitivity dbSetTerminalAntennaRuleOnLayer dbSetTerminalAntennaRules dbSetTextDisplayNameValueVisible dbSetTopologyName dbSetTopologyNet dbSetTrackPatternColorAlternating dbSetTrackPatternFirstTrackColor dbSetTrunkAnchor dbSetTrunkConnectName dbSetTrunkConnectTrunks dbSetTrunkDirection dbSetTrunkLongOffset1 dbSetTrunkLongOffset2 dbSetTrunkLongOffsetSource dbSetTrunkLongOffsetSource1 dbSetTrunkLongOffsetSource2 dbSetTrunkName dbSetTrunkOrthoOffset dbSetTrunkSide dbSetTwigName dbSetTwigObject dbSetTwigPinName dbSetUndoHandle dbSetViaColorStateLocked dbSetViaCutLayerControl dbSetViaLayer1Control dbSetViaLayer2Control dbSetViaParamDefault dbSetViaShapePurpose dbSetq dbShapeQuery dbSoftConnectTermHasConnectToLayer dbSoftConnectTermHasPinlessLayer dbSteinerQuery dbStronglyConnectPins dbSubAreaFromPinGroupGuide dbSubFigFromNet dbSubFigFromPin dbSubFigFromPinGroupGuide dbSubFigsFromPin dbSubPinFromPinGroupGuide dbTransformAccessDirection dbTransformBBox dbTransformCellView dbTransformPoint dbTransformPointList dbUndefineProc dbUndoToHandle dbUnregPostSaveAsTrigger dbUnregPostSaveTrigger dbUnregPurgeTrigger dbUnregSaveTrigger dbUnregVPLGenCreateCellName dbUnsetAreaBoundaryLayerPriorityOrder dbUnsetAreaBoundaryValidRoutingLayers dbUnsetLibDataCompressionLevel dbUnsetNetVoltageRange dbUnsetNetVoltageRangeSource dbUnsetPinGroupGuideKeepoutSpacing dbUnsetPinGroupGuideLayerPriorityOrder dbUnsetPinGroupGuideMinPinSpacing dbUnsetPinGroupGuideMinPinWidth dbUnsetPinGroupGuideValidRoutingLayers dbUnsetPinMinPinSpacing dbUnsetPinMinPinWidth dbUnsetTermMustJoin dbUpdatePcellCache dbValidP dbViaQuery dbWeaklyConnectPins dbWriteSkill dbWriteSkillWithLib dbm dbobjectp dc dcmatchSummary ddAmUsingDM ddAutoCheckin ddAutoCheckout ddAutoCtlGetVars ddAutoCtlSetVars ddCatAddItem ddCatClose ddCatFindCat ddCatGetCatMembers ddCatGetCatName ddCatGetCellsNotInCat ddCatGetLibCats ddCatIsObjInCat ddCatOpen ddCatOpenEx ddCatRefresh ddCatRemove ddCatSave ddCatSubItem ddCheckin ddCheckout ddClearLibUnmanaged ddCreateLib ddDeleteLocal ddDeleteObj ddDumpLibList ddGetCoManagedSet ddGetForcedLib ddGetForcedLibEx ddGetLibList ddGetObj ddGetObjAccess ddGetObjAccessEx ddGetObjChildren ddGetObjChildrenEx ddGetObjDMSys ddGetObjFiles ddGetObjFilesEx ddGetObjGroup ddGetObjGroupEx ddGetObjLastModify ddGetObjLastModifyEx ddGetObjLib ddGetObjName ddGetObjOwner ddGetObjOwnerEx ddGetObjParent ddGetObjReadPath ddGetObjReadPathEx ddGetObjSize ddGetObjSizeEx ddGetObjType ddGetObjWritePath ddGetObjWritePathEx ddGetPathDMSys ddGetStartup ddGetTmpdirWarn ddGetTriggerList ddGetUpdatedLib ddIsId ddIsObjLibMarked ddIsObjReadable ddIsObjReadableEx ddIsObjWritable ddIsObjWritableEx ddIsPathManageable ddIsPathManaged ddLibHasTmpDir ddLibIs5X ddLockDescribe ddLockFree ddLockGetStatus ddLockPath ddLockSet ddLockSetEx ddMapGetDataTypeFileName ddMapGetDataTypeList ddMapGetFileDataType ddMapGetFileTool ddMapGetFileViewType ddMapGetToolNameDataType ddMapGetToolNameList ddMapGetToolNameViewType ddMapGetViewTypeFileName ddMapGetViewTypeList ddMapIsFileNameKnown ddMapIsToolLegal ddMapIsToolNameKnown ddMarkObjMaster ddNeedCheckout ddObjHasNamedObj ddObjHasNamedObjEx ddObjIsInMaster ddObjIsInTmp ddProduceObjRelNames ddProduceObjRelNamesEx ddRegTrigger ddReleaseObj ddSetForcedLib ddSetForcedLibEx ddSetLibDmType ddSetLibUnmanaged ddSetTmpdirWarn ddUnregTrigger ddUpdateLibList ddsAboutDFII ddsBrowserAction ddsCheckSessionName ddsCheckinPreferences ddsCheckoutPreferences ddsCloseLibManager ddsCvtAMSTranslateCell ddsCvtAMSTranslateLib ddsCvtToolBoxAMS ddsEditProp ddsEndSyncWithForm ddsFileBrowseCB ddsGetCurrentLib ddsGetCustomLibSelect ddsGetLibManLCV ddsGetServiceName ddsHiCloseData ddsHiCreateLibrary ddsHiDefragCellView ddsHiDefragLib ddsHiMakeReadOnly ddsHiOpenCdsLibEditor ddsHiPreferences ddsHiRefresh ddsLEWhatsNewAtStartup ddsOnLineHelp ddsOpenConvertToolBox ddsOpenLibManager ddsProgramName ddsRefresh ddsRegCustomLibSelect ddsServSelect ddsSetLibManLCV ddsSyncWithForm ddsUnregCustomLibSelect ddsUpdateSyncWithForm ddsViewDDProp ddsWhatsNew deBack deCopy deCustomizeToolbars deDisableApp deEditInPlace deEnableApp deFileNew deFileOpen deFindAssistant deFindPlugin deFindToolbar deForward deGetAllApplicationNames deGetAllRootTypes deGetAllViewTypes deGetAppClassInfo deGetAppInfo deGetCellView deGetConfigId deGetContext deGetEIP deGetEditCellView deGetEditContext deGetEditLevel deGetEditRootType deGetEditViewType deGetLowerTierApp deGetMaxEditLevel deGetMaxInContextLevel deGetPlugins deGetProbeContext deGetProbeTrigger deGetPushed deGetRootType deGetRootViewTypeList deGetVector deGetViewType deHiSetDefaultApplication deInheritEnabling deInheritMenus deInstallApp deInstallPlugin deIsEditInContext deManageToolbar deMapUserTypeToViewType deMapViewTypeToUserType deNew deNewCellView deOpen deOpenCellView dePush deRegApp deRegPlugin deRegProbeTrigger deRegUserTriggers deRemovePlugin deReturn deSetCellView deSetConfigId deSetContext deSetHistoryOpenMode deSetProbeContext deSetWorkspace deSwap deToggleAssistantVisibility deToggleAssistants deToggleToolbars deUnInheritEnabling deUnInheritMenus deUnRegApp deUnRegProbeTrigger deUnRegUserTriggers deUnmanageToolbar deViewTypeIsRegistered debugQuit debugStatus declare declareLambda declareNLambda declareSQNLambda defCapDepends defCapPrefixes defInitProc defMathConstants defUserInitProc defcell defclass defgeneric defglobalfun define definitionFile defmacro defmethod defprop defstruct defstructp defun defvar delay delete deleteChecks deleteDir deleteFile deleteJob deletePoint deleteSubckt deleteSubwindow deleteWaveform deoEnableTrigger deoExitTrigger deoGetAssistantList deoGetBindkeys deoMenuTrigger deoOnApplicationChange deoOnEvent deoOnTabSwitch deoPostInstallTrigger deoRequireToolbars deoUpdateToolbar deriv desVar design destructuringBind dft dftbb difference digitalHostMode digitalHostName disableAllChecks disableChecks disableDeviceChecking discipline display displayChecks displayMode displayNetlist displaySubckt dlAddArc dlAddBox dlAddCircle dlAddDonut dlAddEventObject dlAddPath dlAddPoint dlAddPolygon dlAddRasterText dlAddSegment dlAddSkillObject dlAddStrokeText dlAttachDlistToWidget dlAttachDlistToWindow dlClearDisplayList dlCloseWidget dlConfigureButton dlDetachDlistFromWidget dlDetachDlistFromWindow dlDisplay dlDlistToIcon dlDrawArc dlDrawBox dlDrawCircle dlDrawDonut dlDrawPath dlDrawPoint dlDrawPolygon dlDrawRasterText dlDrawSegment dlDrawStrokeText dlEnableItem dlFitDlistOnDraw dlMakeDisplayList dlMakeDlistButton dlMakePenTable dlMakeStipple dlMakeWidget dlMapWidget dlMoveButton dlResizeButton dlSaveDlist dlSetClearOnDraw dlSetCurrentPen dlSetDlistPosition dlSetDlistScale dlSetPenColor dlSetPenFillStyle dlSetPenFilled dlSetPenStipple dlSetPenTable dlSetWidgetName dlUnMapWidget dmAddCellToCategory dmCreateCellCategory dmRemoveCellCategory dmRemoveCellFromCategory dmbGetCurrentLib dmbLibBrowserFormDone dmbOpenLibBrowser dmbSetBrowserInteractions dmbSyncWithCellForm dmbSyncWithForm dmbUpdateBrowser dmvStart dnl do dplp dptActivate dptChangeColor dptColorLibrary dptCreateTrackPattern dptDeleteAllTrackPatterns dptGetAllColorGroups dptGetColorGroup dptGetColorModel dptGetLayerDefaultColor dptGetLayerTrackPatternConstraint dptGetTrackPatternPattern dptGetUnfoldedColor dptHasColorInfo dptHiStitch dptHiUnStitch dptHierUpdateColor dptIsShapeHierColorLocked dptIsTrackPatternFiltered dptLPPMergeToColor dptMakeDiffColor dptMakeSameColor dptMarkersToMaskColors dptPropagateLocks dptReColor dptReconstructStitch dptRemoveDiffColor dptRemoveSameColor dptRemoveTrackPatternFilters dptSaveAll dptSetColorModel dptSetLayerDefaultColor dptSetLayerTrackPatternConstraint dptSetTrackPatternFiltered dptSetTrackPatternPattern dptShowMaskColor dptUpdateColor drAddElem drCreateEmptyWaveform drCreateVec drCreateWaveform drDeleteColor drDeleteDisplay drDeleteLineStyle drDeletePacket drDeleteStipple drDumpDrf drFindPacket drGetColor drGetDisplay drGetDisplayIdList drGetDisplayName drGetDisplayNameList drGetElem drGetLineStyle drGetLineStyleIndexByName drGetPacket drGetPacketAlias drGetPacketFillStyle drGetPacketList drGetStipple drGetStippleIndexByName drGetWaveformXType drGetWaveformXVec drGetWaveformYType drGetWaveformYVec drIsDataVector drIsParamWave drIsWaveform drLoadDrf drPutWaveformXVec drPutWaveformYVec drSetElem drSetPacket drType drVectorLength drain drawEnterFun drbBrowseFormCB drdAddTarget drdBatchCheck drdBatchCheckLicenseAvailable drdCompactObjects drdCompactSelSet drdCompactorOptions drdEnablePixelThreshold drdIsPixelThresholdEnabled drdListConstraintCategoryRules drdRemoveTarget drdToggleSmartSnapMode drdVerifyObjects drdVerifySelSet dreInvokeDre drplACPRWithMask drplEvmBpsk drplJitter drplPacVolGnExpDen drplParamSweepRFJc drplParamSweepRFJcc drplRFJc drplRFJcc drplSwpHp drplSwpSp drplSwpYp drplSwpZm drplSwpZp dtpr dump dutyCycle dutycycle dwindow dwindowp eadRemoveParasitics ed edgeTriggeredEyeDiagram edi ediFinishStatus edifDisplay edifLayerNumMap edifinDisplay edifinMakeRenameString edifoutAddCellInfo edifoutAddInstInfo edifoutAddInterfaceInfo edifoutAddLibraryInfo edifoutAddNetInfo edifoutAddPortInfo edifoutAddViewInfo edifoutEditCellProperty edifoutEditInstProperty edifoutEditLibProperty edifoutEditNetProperty edifoutEditPortProperty edifoutEditProperty edifoutEditViewProperty edifoutMakeRenameString edit edl enableAllChecks enableChecks enableDeviceChecking enableTrigger encrypt enterArc enterBox enterCircle enterDonut enterEllipse enterLine enterMultiRep enterNumber enterPath enterPoint enterPoints enterPolygon enterScreenBox enterSegment enterString envCyclicIndexToString envCyclicStringToIndex envGetAvailableTools envGetDefVal envGetLoadedTools envGetModifiedTools envGetVal envGetVarType envIsToolModified envIsVal envLoadFile envLoadVals envOption envRegLoadDumpTrigger envRegSetTrigger envSetToolCurrValToDefault envSetToolDefaultToCurrVal envSetVal envSetVarCurrValToDefault envSetVarDefaultToCurrVal envStoreEnv eq equal eqv err error errset errsetstring eval evalstring evcdFile evcdInfoFile evenp evmOFDM evmQAM evmQpsk exists existss exit exp expandMacro expandMacroDeep expr expt eyeDiagram eyeMeasurement fallTime famAddValue famCreateFamily famEval famGetSweepName famGetSweepValues famIsFamily famMap famValue fboundp fileLength fileSeek fileTell fileTimeModified findClass findNamespace findSymbol finishEnterFun fix fix2 fixp flet flip float floatp floor fnlAbortNetlist fnlCurrentCell fnlCurrentCellCdsName fnlCurrentInst fnlCurrentInstCdsName fnlCurrentIteration fnlCurrentModelExtName fnlCurrentSig fnlCurrentSigPathName fnlGetGlobalSigNames fnlInstCdsNameExtName fnlPathList fnlPrint fnlSearchPropString fnlSigCdsNameExtName fnlTermCdsNameExtName fnlTermExtName fnlTopCell for forall foralls forcenode foreach foreachs fors fourEval fprintf freq freq_jitter frequency fscanf funcall ga gac gac_freq gac_gain gainBwProd gainMargin gc gcsummary gdmAddSpecToSpecList gdmCreateSpec gdmCreateSpecFromDDID gdmCreateSpecList gdmExecute gdmInspectSpec gdmIsSpecId gdmNextFromSpecList gdmObjIsCreated gdmRemovename gdmResetSpecList gdmSpecListp gdmSpecType gdmSpecp gdmcancel gdmci gdmco gdmdelete gdmexport gdmhistory gdmsetdefver gdmsetname gdmstatus gdmsubmit gdmupdate geAddHilightArc geAddHilightBlockage geAddHilightCircle geAddHilightDistance geAddHilightDonut geAddHilightDot geAddHilightEllipse geAddHilightFig geAddHilightLabel geAddHilightLine geAddHilightPath geAddHilightPathSeg geAddHilightPolygon geAddHilightRectangle geAddHilightRow geAddHilightRuler geAddHilightTrackPattern geAddInstProbe geAddNetProbe geAddNetProbeFromTo geAddPathProbe geAddSelectBox geAddSelectPoint geAddTermProbe geAdjustPoint geAdvWireSelection geAskOverwriteMode geBackgroundCellView geCellViewToDlist geCenter geChangeCellView geChangeEditMode geChangeHilightPacketName geClosePolygon geCompressPointArray geComputeQueryBbox geCoordp geCopySelSet geCreateBend geCreateHilightGroup geCreateHilightSet geCreateMarker geCreateMarkerByBBox geCreateMarkerByPoints geCreatePacket geCreateTaper geCreateTrl geCreateWindowHilightSet geCycleSelectNext geDSAFreeze geDeleteAllAreaViewLevel geDeleteAllHilightSet geDeleteAllInstViewLevel geDeleteAllMarker geDeleteAllProbe geDeleteAllWindowHilightSet geDeleteAreaViewLevel geDeleteHilightGroup geDeleteHilightObject geDeleteHilightSet geDeleteHilightSetInWindows geDeleteInstProbe geDeleteInstViewLevel geDeleteNetProbe geDeletePathProbe geDeleteProbe geDeleteSelSet geDeleteStoredSelectionSet geDeleteTermProbe geDeselectAll geDeselectAllFig geDeselectAllObject geDeselectArea geDeselectFig geDeselectFigNoFilter geDeselectFigPoint geDeselectObject geDeselectObjectNoFilter geDeselectObjectPoint geDeselectPoint geDeselectProtected geDeselectStoredSelectionSet geDisableBackgroundCellView geDiscardEdits geDispWinEnvProps geDrawHilightSet geEditInPlace geEditSelSet geEditSingleObject geEditToWindowPoint geEnableBackgroundCellView geEnterAddInstProbe geEnterAddNetProbe geEnterAddTermProbe geEnterDeleteInstProbe geEnterDeleteNetProbe geEnterDeleteTermProbe geEquivWindow geEquivWindowSet geExplainProbe geFindPathToCellViewInst geGetAdjustedPath geGetAllAreaViewLevel geGetAllInstViewLevel geGetAllProbe geGetAreaViewLevel geGetCellViewWindow geGetCrossProbeValue geGetCurrentHilightSet geGetCurrentWindowHilightSet geGetDisabledMenus geGetEditCellView geGetEditCellViewWindow geGetEditRep geGetEnablePredicate geGetFigHilightObjectId geGetHierMemInst geGetHilightObjectFigId geGetInstHier geGetInstHierPath geGetInstTransform geGetInstViewLevel geGetLockInfo geGetMarkerDisplayText geGetMarkerOwner geGetMarkerReason geGetMarkerType geGetObjectSelectedSet geGetPotentialSelection geGetProbeNetStopLevel geGetProbeUserLPP geGetScrollPercent geGetSelProtectedObjects geGetSelSet geGetSelSetCount geGetSelSetFigPoint geGetSelectedInstancesCount geGetSelectedSet geGetSortedSelectByLine geGetStoredSelectionSets geGetTopCellViewWindow geGetTopLevelCellView geGetWindowBox geGetWindowCellView geGetWindowRep geGetWindowSelProtectionHighlight geGetWindowSelProtectionSelectability geGetWindowStatus geHasMarker geHiCommonFindMarker geHiDeleteAllMarker geHiDeleteMarker geHiDisplaySelectionForm geHiDragFig geHiExplainMarker geHiFindMarker geHiSetSelProtectionEF geHiStoreSelectionForm geHiUnsetSelProtectionEF geHighlightProtected geInsertHilightObjectsInGroup geInstIdToFileSpec geIsAutoStoreSelectionOn geIsFigAllSelected geIsFigPartiallySelected geIsFigSelected geIsGraphicalWindow geIsMarkerShape geIsObjectAllSelected geIsObjectPartiallySelected geIsObjectSelected geIsPathReentrant geIsPolygonReentrant geIsSelProtection geIsValidHilightGroup geIsValidHilightId geIsValidHilightObject geIsValidHilightSet geLoadIcon geLoadNextProbe geLoadProbe geMakeProbeWithColor geMakeProbeWithLabel geMakeProbeWithOnColor geMakeProbeWithoutColor geNewWindow geOpen gePointQuery gePointToFig gePopHilightStack gePopWindowHilightStack gePrintAllProbe geProbeP gePush gePushHilightStack geQuerySelSet geRefresh geRefreshCellView geRefreshCellViews geRefreshWindow geRefreshWorldView geRegCrossProbeTrigger geRegSaveAllTrigger geResetBackgroundCellView geResetCellView geResetHilightSetHaloParameters geRestoreWinView geReturn geReturnToLevel geSave geSaveAs geSaveHier geSaveIcon geSaveProbe geSaveWinView geScroll geSelObjectsPartiallySelected geSelectAll geSelectAllFig geSelectArea geSelectByline geSelectFig geSelectFigNoFilter geSelectFigPoint geSelectFigs geSelectNextAutoStoreSet geSelectNextInSelSet geSelectObject geSelectObjectNoFilter geSelectPoint geSelectPreviousAutoStoreSet geSelectPreviousInSelSet geSelectProtected geSelectStoredSelectionSet geSelectToggleObject geSelectViaPile geSetAreaViewLevel geSetAutoStoreSelection geSetBackgroundCellView geSetCrossProbeValue geSetEnablePredicate geSetEnterFunctionSelectionMode geSetHilightSetHaloParameters geSetInstViewLevel geSetLimitedProbe geSetMaxCreatedProbe geSetProbeDirection geSetProbeNetStopLevel geSetProbeUserLPP geSetScrollPercent geSetSelProtection geSetSelProtectionAllObjects geSetSelProtectionHighlightOptionForm geSetSelProtectionHighlightOptions geSetWindowStatus geShareWindowHilightSet geShift geSingleSelectBox geSingleSelectPoint geStoreSelectionSet geSubSelectBox geSubSelectPoint geSwitch geToggleAreaSelectOption geToggleFilterSize geTogglePartialSelect geToggleWindowSelProtectionHighlight geToggleWindowSelProtectionSelectability geTransformUserBBox geTransformUserPoint geUnRegCrossProbeTrigger geUnhighlightProtected geUnsetAllSelProtection geUnsetSelProtection geUpdateWindowMenus geValidateWindow geWindowToEditPoint geWriteCellView geZoomToBackgroundAndEditCV geZoomToBackgroundCV geZoomToGrid geiLoadProbe geiSaveProbe gensym geqp get getAllLoadedFiles getApplicableMethods getAsciiWave getCallingFunction getCompatContextVersion getCurSaveContextVersion getCurrentTime getCurrentWindow getData getDependents getDirFiles getFnWriteProtect getFunType getFunctions getGFbyClass getGFproxy getInstallPath getLogin getMaxScreenCoords getMethodName getMethodRole getMethodSpec getMethodSpecializers getNativeContextVersion getOutstring getPrompts getResult getSG getShellEnvVar getSkillPath getSkillVersion getSymbolNamespace getTempDir getVarWriteProtect getVersion getWarn getWorkingDir get_filename get_pname get_string getc getchar getd getq getqq gets globalProc globalSigAlias globalSignal gmax gmin gmsg gmux go gp gpc gpc_freq gpc_gain graphicsOff graphicsOn greaterp groupDelay gt hardCopy hardCopyOptions harmonic harmonicFreq harmonicFreqList harmonicList hdbAddConfigToBag hdbBind hdbClose hdbCloseConfigsInBag hdbCreateConfigBag hdbCreatePathVector hdbCreatePathVectorStack hdbDestroyPathVector hdbExplainBinding hdbExplainSignature hdbExplainStop hdbGetCellName hdbGetLibName hdbGetPathStackStr hdbGetPathStr hdbGetPathVectorStackTop hdbGetTopCellName hdbGetTopLibName hdbGetTopViewName hdbGetViewName hdbIsAtStopPoint hdbIsConfig hdbIsOpenConfig hdbOpen hdbPopCell hdbPopPathVect hdbPushCell hdbPushPathVect hdbReOpenNewConfig hdbSave hdbSaveAs hdbSetDefaultLibListString hdbSetDefaultStopListString hdbSetDefaultViewListString hdbSetObjBindRule hdbSetTopCellViewName heHiEditConfig heHiSetInstBinding heHiShowViewsFound heHiUpdate help hiAbout hiAbsolutePan hiAddCyclicChoice hiAddField hiAddFields hiAddFixedMenu hiAddMenuItem hiAddNonRepeatPrefix hiAddTextWordDelimiter hiAddToolbarItem hiAddToolbarItems hiAdvanceProgressBarOneStep hiAppendInputCmd hiApplyWinConfig hiBindKeyModifiers hiBoxCenter hiCancelProgressBox hiChangeBannerLabel hiChangeFormCallback hiChangeFormTitle hiCheckAbort hiClearCurrentTextSelection hiCloseWindow hiCollapseTreeItem hiConfigureBindKeys hiCreate2DMenu hiCreateAction hiCreateAppForm hiCreateBBoxField hiCreateBooleanButton hiCreateButton hiCreateButtonBoxField hiCreateColorArray hiCreateComboField hiCreateCyclicField hiCreateDockWindow hiCreateFileSelectorField hiCreateFloatField hiCreateFloatSpinBox hiCreateForm hiCreateFormButton hiCreateFormLabel hiCreateFrameField hiCreateHorizontalFixedMenu hiCreateHypertextField hiCreateIntField hiCreateLabel hiCreateLayerCyclicField hiCreateListBoxField hiCreateListField hiCreateMLTextField hiCreateMenu hiCreateMenuItem hiCreateOptionsForm hiCreateOutputStringField hiCreatePointField hiCreatePointListField hiCreatePulldownMenu hiCreateRadioField hiCreateReportField hiCreateScaleField hiCreateScrollRegion hiCreateSeparatorField hiCreateSeparatorMenuItem hiCreateSimpleHypertextField hiCreateSimpleMenu hiCreateSliderMenuItem hiCreateSpinBox hiCreateStringField hiCreateTabField hiCreateToggleField hiCreateToolbar hiCreateToolbarComboBox hiCreateToolbarSeparator hiCreateToolbarTypein hiCreateTree hiCreateTreeItem hiCreateTreeTable hiCreateVerticalFixedMenu hiCreateWindow hiCreateWorldView hiDBoxCancel hiDBoxOK hiDeiconifyWindow hiDeleteBannerLabel hiDeleteBannerMenu hiDeleteBannerMenus hiDeleteField hiDeleteFields hiDeleteForm hiDeleteMenu hiDeleteMenuItem hiDeleteToolbar hiDeleteToolbarItem hiDeleteToolbarItems hiDeltaPan hiDisableAsstBindKeyPrefix hiDisableMenuItem hiDisableTailViewfile hiDisplayAppDBox hiDisplayBlockingDBox hiDisplayColorDialog hiDisplayFileDialog hiDisplayFixedMenu hiDisplayForm hiDisplayHistory hiDisplayListBox hiDisplayMenu hiDisplayModalDBox hiDisplayModelessDBox hiDisplayNonBlockingDBox hiDisplayProgressBox hiDisplaySaveForRestoreDialog hiDisplayUserDBox hiDisplayWindow hiDisplayWindowMenu hiDockWindow hiDynamicPanAbsolute hiDynamicPanGrabbing hiDynamicPanInteractive hiDynamicPanRelative hiEditPropList hiEditfile hiEnableAsstBindKeyPrefix hiEnableBlink hiEnableMenuItem hiEnableTailViewfile hiEncap hiEndLog hiEnqueueCmd hiEscapeHTMLTags hiEscapeStringChars hiExpandTreeItem hiExportImage hiExportImageDialog hiFileDialogDone hiFileDialogSelection hiFileDialogSetSelection hiFixedMenuDown hiFlush hiFlushCIW hiFlushLogFile hiFocusToCIW hiFocusToCursor hiFocusToEncap hiFormApply hiFormCancel hiFormClose hiFormDefaults hiFormDone hiFormFinish hiFormList hiFormUnmap hiGenTextIndex hiGenerateThumbnails hiGetAbsWindowScreenBBox hiGetActiveTabWindow hiGetAnyFile hiGetAppType hiGetAttention hiGetBBoxResource hiGetBannerLabels hiGetBannerMenus hiGetBannerPoint hiGetBeepVolume hiGetBindKey hiGetBindKeyInheritAlias hiGetBindKeyInheritRoot hiGetBindKeyPrefixList hiGetBindKeys hiGetButtonAreaHeight hiGetCIWindow hiGetClipboard hiGetCommandPoint hiGetCurrentCmd hiGetCurrentField hiGetCurrentForm hiGetCurrentIndex hiGetCurrentTextSelection hiGetCurrentTextSelectionLoc hiGetCurrentWindow hiGetCursor hiGetDBoxDefaultLocation hiGetDbuPoint hiGetDefaultThumbnail hiGetDefaultThumbnailResolution hiGetDisabledAsstBindKeyPrefixes hiGetDisplayName hiGetDrawThruDelta hiGetEFDrawThruDelta hiGetEFunCursor hiGetEncapSkillCmd hiGetExistingDirectory hiGetExistingFile hiGetExistingFiles hiGetFieldInfo hiGetFieldOverlaps hiGetFieldScope hiGetFont hiGetFormLocation hiGetFormSize hiGetGeometryResource hiGetHelp hiGetIconName hiGetInsertionPosition hiGetLayerCyclicValue hiGetListBoxFieldFit hiGetListBoxValue hiGetLogFileName hiGetMagnifierSize hiGetMaxScreenCoords hiGetMenuItems hiGetMouseMoveSampleRate hiGetMouseStopDetectTime hiGetMultiClickTime hiGetNonRepeatPrefixes hiGetNumMenus hiGetNumVisibleItems hiGetPoint hiGetProgress hiGetProgressBarCurrentStep hiGetProgressBarTotalSteps hiGetProgressTotalSteps hiGetRepeatCommand hiGetScreenPoint hiGetScreenSize hiGetScrollBarInfo hiGetSessionWindow hiGetSharedIcon hiGetStringResource hiGetStrokeBBox hiGetStrokeFirstPt hiGetStrokeLastPt hiGetTextCharAtLoc hiGetTextClass hiGetTextDispLoc hiGetTextFieldFit hiGetTextIndexLoc hiGetTextLineColumn hiGetTextSelByLoc hiGetTextSelection hiGetTextSourceLength hiGetTextWidth hiGetTextWordDelimiter hiGetThumbnailFilename hiGetToolbarObjName hiGetTopListItem hiGetTree hiGetTreeItemDescription hiGetTreeItemIcons hiGetTreeItemParent hiGetTreeItems hiGetTreeParent hiGetUndoLimit hiGetUserAbort hiGetViewBBox hiGetWMOffsets hiGetWidgetType hiGetWinConfig hiGetWinConfigInfo hiGetWinObjName hiGetWindowDisplayState hiGetWindowFixedMenu hiGetWindowIconifyState hiGetWindowList hiGetWindowMenu hiGetWindowName hiGetWindowState hiGetWindowToolbars hiGoToIndex hiGoToLine hiGraphicMode hiHelp hiHideProgressBar hiHideToolbar hiHighlightField hiHypertextReadin hiHypertextReplace hiHypertextScroll hiIconifyWindow hiIgnoreProp hiInEnterFun hiInFormApply hiInheritBindKey hiInsertBannerMenu hiInsertMenuItem hiInsertToolbar hiInsertToolbarItem hiInsertToolbarItems hiInstantiateForm hiIs2DMenu hiIsBlinkEnabled hiIsForm hiIsFormDisplayed hiIsIcon hiIsInFieldCancel hiIsInReplay hiIsInstantiated hiIsMagnifierAnchored hiIsMagnifierOpened hiIsMenu hiIsMenuItemEnabled hiIsMenuSlotFilled hiIsProgressBoxCancelled hiIsScrollRegion hiIsWidgetType hiIsWindowSpecifier hiItemInsertTree hiItemRemoveTree hiLaunchBrowser hiLayerDispMainForm hiLayerMatchCyclicStr hiLayerStringToLPP hiListBoxCancel hiListBoxDone hiListView hiLoadIconData hiLoadIconFile hiLoadImageFile hiLogDragEvents hiLookupHRFtag hiLowerTab hiLowerWindow hiMakeLPChoiceList hiMapWindow hiMarkNestable hiMarkNonNestable hiMatchColor hiMatchColorByName hiModalDBoxHelp hiModelessDBoxHelp hiMoveField hiMoveFixedMenu hiMoveInsBarToEnd hiMoveToFormField hiMoveWindow hiNextWinView hiOffsetField hiOffsetFields hiOpenWindow hiPan hiPickWindow hiPlaceToolbar hiPrevWinView hiPrintToLogFile hiQueryFont hiQuit hiRaiseTab hiRaiseWindow hiReadWinConfig hiReattachField hiReattachToolbar hiRedo hiRedraw hiRefreshTextWindow hiRegCloseProc hiRegCurWindowTrigger hiRegSetBindKeyProc hiRegTimer hiRegZoomPanProc hiRegisterBindKeyPrefix hiRemoveFixedMenu hiRemoveNonRepeatPrefix hiRemovePromptLine hiRemoveTextWordDelimiter hiRepeat hiReplaceAllBannerMenus hiReplaceTextWordDelimiter hiReplayFile hiReportDeselectAllItems hiReportDeselectItem hiReportDeselectItems hiReportGetSelectedItems hiReportSelectAllItems hiReportSelectItem hiReportSelectItems hiResetAbort hiResetProgressBox hiResizeField hiResizeMagnifier hiResizeWindow hiRestoreView hiSaveAsViewfile hiSaveForRestore hiSaveIconData hiSaveView hiSaveViewfile hiSaveWinConfig hiScaleBox hiScaleMagnifier hiScrollWindowBottom hiScrollWindowDown hiScrollWindowLeft hiScrollWindowRight hiScrollWindowToCurrentIndex hiScrollWindowToIndex hiScrollWindowToName hiScrollWindowTop hiScrollWindowUp hiSelectTextByLoc hiSetAbort hiSetActionChecked hiSetBeepVolume hiSetBindKey hiSetBindKeys hiSetButtonIcon hiSetButtonLabel hiSetCallbackStatus hiSetCurrentField hiSetCurrentForm hiSetCurrentIndex hiSetCurrentTextSelectionLoc hiSetCurrentWindow hiSetCursor hiSetDBoxDefaultLocation hiSetDisabledIcon hiSetDrawThruDelta hiSetEFDrawThruDelta hiSetEFunCursor hiSetEncapHistory hiSetEncapPrompt hiSetEncapSkillCmd hiSetFieldEditable hiSetFieldEnabled hiSetFilter hiSetFilterOptions hiSetFont hiSetFormBlock hiSetFormButtonEnabled hiSetFormHighlights hiSetFormMinMaxSize hiSetFormName hiSetFormPosition hiSetFormSize hiSetFormToDefaults hiSetIconName hiSetInsertionPosition hiSetLayerCyclicValue hiSetListItemCenter hiSetListItemVisible hiSetMenuItemCallback hiSetMenuItemStatusTip hiSetMenuItemText hiSetMouseMoveSampleRate hiSetMouseStopDetectTime hiSetMultiClickTime hiSetProgress hiSetProgressAndText hiSetProgressBannerText hiSetProgressBar hiSetProgressButtonText hiSetProgressLabel hiSetProgressText hiSetProgressTotalSteps hiSetScrollBarValue hiSetSessionFocus hiSetShadowMode hiSetSplashBackground hiSetSplashDefaultBackground hiSetSplashFamily hiSetSplashIcon hiSetSplashLicense hiSetSplashProduct hiSetTabWindowIcon hiSetTabWindowTip hiSetTabWindowTitle hiSetTextClass hiSetTextHighlightColor hiSetTextSelectAll hiSetTextSelection hiSetToolbarObjName hiSetTopListItem hiSetTreeItemDescription hiSetTreeItemIcons hiSetUndoLimit hiSetUserPreferences hiSetViewfile hiSetWinObjName hiSetWinStyle hiSetWindowAtts hiSetWindowDefaultPrompt hiSetWindowFocus hiSetWindowIcon hiSetWindowMenu hiSetWindowName hiShowBindKeys hiShowBindKeysByAppType hiShowBindKeysByWindow hiShowFieldBorders hiShowListBox hiShowProgressBar hiShowToolbar hiSleep hiStartGenTextIndex hiStartLog hiStoreFormLocation hiStringToIcon hiStroke hiSwapTreeItemSelectionIcons hiSwitchWindowType hiSynchronize hiTextDisplayString hiTextWidth hiToggleAnchorMagnifier hiToggleEnterForm hiToggleMagnifier hiToggleMagnifierResolution hiTreeAppendItem hiTreeAppendItems hiTreePrependItem hiTreePrependItems hiTreeRemoveAllItems hiTreeRemoveItem hiTreeRemoveItems hiTreeTableDeselectAllItems hiTreeTableDeselectItem hiTreeTableDeselectItems hiTreeTableGetExpandedItemCount hiTreeTableGetExpandedItems hiTreeTableGetItemCount hiTreeTableGetItems hiTreeTableGetSelectedItemCount hiTreeTableGetSelectedItems hiTreeTableSelectAllItems hiTreeTableSelectItem hiTreeTableSelectItems hiUndo hiUndockWindow hiUnmapWindow hiUnregCloseProc hiUnregCurWindowTrigger hiUnregZoomPanProc hiUnselectText hiUnselectTextAll hiUnselectTextByLoc hiUnselectTextClass hiUpdate hiUpdateFormBlock hiUpdateMagOptions hiUpdateTextSelectionColors hiUseMagnifierResolution hiUsingMagnifierResolution hiVectorPan hiViewfile hiWinConfigModified hiWindowSaveImage hiZoomAbsoluteScale hiZoomExpandAtMouse hiZoomExpandAtPoint hiZoomIn hiZoomInAtMouse hiZoomInMagnifier hiZoomOut hiZoomOutAtMouse hiZoomOutMagnifier hiZoomRelativeScale hiZoomWindowAtMouse hiZoomWindowAtPoint histo histogram2D history hlcheck hnlAbortNetlist hnlAddExtraParameters hnlCDLPrintBJTElement hnlCDLPrintBSIM3SOIElement hnlCDLPrintCapElement hnlCDLPrintCapacitorElement hnlCDLPrintCds_Thru hnlCDLPrintDiodeElement hnlCDLPrintGeneralElement hnlCDLPrintICIsrcElement hnlCDLPrintICVsrcElement hnlCDLPrintInductorElement hnlCDLPrintIsrcElement hnlCDLPrintJfetElement hnlCDLPrintMultiCNPNElement hnlCDLPrintMultiCPNPElement hnlCDLPrintMultiENPNElement hnlCDLPrintMultiEPNPElement hnlCDLPrintNMOSfetElement hnlCDLPrintNPNElement hnlCDLPrintPMOSfetElement hnlCDLPrintPNPElement hnlCDLPrintResElement hnlCDLPrintResistorElement hnlCDLPrintSchottkyTranElement hnlCDLPrintTlineElement hnlCDLPrintVCIsrcElement hnlCDLPrintVCVsrcElement hnlCDLPrintVsrcElement hnlCatIncrementalNetlistFiles hnlCellExtracted hnlCellInAllCells hnlCloseCellFiles hnlCloseMasterList hnlCompletePrint hnlDoInstBased hnlDoNetBased hnlEMHGetDigitaGlobalNets hnlEMHGetDigitalNetlistFileName hnlEMHSetVerbosityLevel hnlFindAllCells hnlFindAllInstInCell hnlGenIncludeFile hnlGetCellHdbProps hnlGetGlobalModelMappedName hnlGetGlobalNetMappedName hnlGetInstanceCount hnlGetMappedInstNames hnlGetMappedModelNames hnlGetMappedNames hnlGetMappedNetNames hnlGetMasterCells hnlGetPropVal hnlGetRoundProp hnlGetScaleCapacitance hnlGetScaleMarginalDelay hnlGetScaleTimeUnit hnlGetSimulator hnlGetSourceFile hnlGetSourceFileModels hnlGetSymbolPropVal hnlGetTermByName hnlGetTermNameOfSig hnlHspiceInstPropVal hnlHspicePrintInstPropEqVal hnlHspicePrintInstPropVal hnlHspicePrintMOSfetModel hnlHspicePrintNMOSfetElement hnlIfNoProcedure hnlIgnoreTerm hnlInitMap hnlInitPrint hnlIsAPatchCord hnlIsAStoppingCell hnlIsCellNetlistable hnlIsCurrentInstStopping hnlMakeNetlistFileName hnlMapCellModuleName hnlMapCellName hnlMapInstName hnlMapModelName hnlMapName hnlMapNetName hnlMapTermName hnlMultipleCells hnlNameOfSignal hnlNetNameOnTerm hnlNetNameOnTermName hnlNmpSetNameSpaces hnlOpenTopCell hnlPcellIsParamOverridden hnlPrintDevices hnlPrintMessage hnlPrintNetlist hnlPrintSignal hnlPrintString hnlRunNetlister hnlScaleCapacitance hnlScaleMarginalDelay hnlScaleTimeUnit hnlSetCellFiles hnlSetDef hnlSetMappingType hnlSetPseudoTermDir hnlSetVars hnlSortTerms hnlSortTermsToNets hnlStartNetlist hnlStopNetlist hnlStringToList hnlVerilogPrintBehaveModel hnlVerilogPrintBehavePortOrder hnlVerilogPrintBidiXfr hnlVerilogPrintBufif0Notif0 hnlVerilogPrintBufif1Notif1 hnlVerilogPrintCmos hnlVerilogPrintLibraryModel hnlVerilogPrintLogGate hnlVerilogPrintNmosPmos hnlVerilogPrintPrimGate hnlVerilogPrintVhdlImport hnlWriteBlockControlFile hnlWriteMap hnllsCVInUserStopCVList hostMode hostName hsmDeselect hsmGetSelectedSet hsmSelect i ic iccIsConnected iccSendCommand iccSendSkillCommand idfHiAbout if ifreq ih iim iinteg ilAddTopLevelErrorHandler ilDebugCountLevels ilGetGFbyClass ilGetIdeSessionWindow ilRemoveMethod ilRemoveTopLevelErrorHandler ilSlotBoundp ilToolBox ilgAddRecentFiles ilgInvokeIDE ilgLastDir ilgRunSKILLIDE ilgSetLastDir im imag impHdlDisplay importSkillVar importSymbol inNext inScheme inSkill inStepOut include includeFile index infile info initializeInstance inl inportp installDebugger instring int intToChar integ integerp intersect ip ip3Plot ipcActivateBatch ipcActivateMessages ipcBatchProcess ipcBeginProcess ipcCloseProcess ipcContProcess ipcGetExitStatus ipcGetPid ipcGetPriority ipcIsActiveProcess ipcIsAliveProcess ipcKillAllProcesses ipcKillProcess ipcReadProcess ipcSetPriority ipcSkillProcess ipcSleep ipcSoftInterrupt ipcStopProcess ipcWait ipcWaitForProcess ipcWriteProcess ipn ipnVRI ipnVRICurves iqCreateDummyCell ir isBBox isCallable isClass isContextLoaded isDir isExecutable isFile isFileEncrypted isFileName isInfinity isLargeFile isLink isLocation isMacro isNaN isPortAtEOF isReadable isVarImported isWritable iseCloseSchWindow iseCloseSimWindow iseCompleteInteractive iseEnterNodeNamesList iseExitSimulator iseGetExtName iseGetInputFromEncapWindow iseGetMappedProbeList iseGetProbeList iseInitSchematicWindow iseInitSimWindow iseNetExtNameCdsName iseOpenWindows isePrintName isePrintNameCB isePrintSimulatorCommand iseReleaseNodeFrom iseSearchForASchWindow iseSendOutputToEncapHistory iseSetEncapBindKeys iseSetNodeTo iseSimulate iseStartInteractive iseStartSimulator iseUpdateNetlist iseUpdateStimulus itime ivCallProc ivCompilingFor ivConcICe ivCreatePCells ivDRC ivERC ivExtract ivGetCellView ivLVS ivVerify kf killJob labels lambda last lbuiGetCheckedOutLicenses lbuiPrintLicenseUseReport lceClearLogicalConn lceExtract lceExtractArea lceGetExtractLayers lceGetFracturedShapes lceGetFracturedShapesFromNet lceGetIncompleteNets lceGetOption lceHiExtract lceHierExtract lceIsExtractLayer lcePrintExtractLayers lcePrintExtractVias lcePrintTechLibExtractLayers lcePrintTechLibExtractVias lceSetOption lconc ldtrDefReadOA ldtrDefWriteOA ldtrLefReadOA ldtrLefWriteOA leAlign leApplyAreaFunction leApplyLastCopyTransform leArrowFunc leAttachFig leBalloonCycleThru leBalloonToggleOnOff leChopShape leClearAllRuler leCloseWindow leConvertInstToMosaic leConvertShapeToPathSeg leConvertShapeToPolygon leCreateAutoPin leCreatePath leCreatePin leCreateRuler leCycleSnapModes leCycleSnapPatternDisplay leDefineExternalPins leDefineInternalPins leDefineMPPTemplate leDefinePPPins leDefineWeaklyConnectedPins leDeiconifyLSW leDescend leDesignSummary leDoubleClick leEIPZoomAbsoluteScale leEditDesignProperties leEditInPlace leEnvLoad leExportLabel leFinishTrunk leFinishWire leFlattenInst leFreezeInst leFullSelectFigOfSelSet leGetAreaEstimationDisplayNames leGetAreaEstimatorFunction leGetAreaEstimatorParamList leGetAreaEstimatorRunMode leGetCoordinateForm leGetEditFigGroup leGetEntryLayer leGetEnv leGetGlobalGridsVisible leGetLSWBBox leGetLocalGridsVisible leGetObjectSelectable leGetObjectVisible leGetRefPoint leGetSnapPatternVisible leGetSnapToSPTransform leGetTechFormList leGetValidLayerList leGetValidPurposeList leHiAbout leHiAddShapeToNet leHiAddToGroup leHiAddWireVia leHiAlign leHiAttach leHiBatchChecker leHiCancelStitch leHiCellviewTrackPatterns leHiChop leHiClearRuler leHiClearRulerInHier leHiConvertInstToMosaic leHiConvertPolygonToPath leHiConvertShapeToPathSeg leHiConvertShapeToPolygon leHiCopy leHiCreateAreaBoundary leHiCreateBend leHiCreateBlockage leHiCreateBus leHiCreateChoiceOfPin leHiCreateCircle leHiCreateClusterBoundary leHiCreateClusters leHiCreateDonut leHiCreateEllipse leHiCreateGeometricWire leHiCreateGroup leHiCreateGuardRing leHiCreateInst leHiCreateLabel leHiCreatePRBoundary leHiCreatePath leHiCreatePin leHiCreatePinsFromLabels leHiCreatePlacementArea leHiCreatePolygon leHiCreateRect leHiCreateRow leHiCreateRuler leHiCreateSlot leHiCreateSnapBoundary leHiCreateTaper leHiCreateTrl leHiCreateVia leHiCreateWire leHiDelete leHiDeleteAllAreaViewLevel leHiDeleteAreaViewLevel leHiDeleteShapeFromNet leHiDescend leHiDisplayPadOpeningInfoForm leHiDisplayStartRouterForm leHiDisplayTechGraphForm leHiEditBalloonOptions leHiEditDRDOptions leHiEditDRDRuleOptions leHiEditDisplayOptions leHiEditDynamicMeasurementOptions leHiEditEditorOptions leHiEditInPlace leHiEditObjectInfo leHiEditProp leHiEditSlot leHiEditTbOptions leHiFlatten leHiFlip leHiGuidedRouting leHiGuidedRoutingReverseEnvelope leHiLayerGen leHiLayerTap leHiMakeCell leHiMarkNet leHiMerge leHiModifyCorner leHiMousePopUp leHiMove leHiMoveOrigin leHiOptionLayer leHiP2P leHiPaste leHiPlotQueueStatus leHiPropagateNets leHiQuery leHiQuickAlign leHiReShape leHiRemasterInstances leHiRemoveFromGroup leHiRepeatCopy leHiRotate leHiSave leHiSaveACopy leHiSaveAllHighLightMarkNet leHiSaveHier leHiSearch leHiSetAreaViewLevel leHiSetRefPoint leHiSetValidLayer leHiShowAngles leHiShowCoords leHiShowSelSet leHiSize leHiSplit leHiStitchToLayer leHiStretch leHiSubmitPlot leHiSummary leHiTree leHiUngroup leHiUnmarkNet leHiUnmarkNetAll leHiYank leIconifyLSW leIsFigSelectable leIsInstSelectable leIsLSWIconified leIsLayerSelectable leIsLayerValid leIsLayerVisible leIsNewODCInfraEnabled leIsPinSelectable leIsPointInsideFig leIsRefPointActive leLSWGetBlockageSelectable leLSWGetBlockageVisible leLSWGetRoutingGridVisible leLSWSetBlockageSelectable leLSWSetBlockageVisible leLSWSetRoutingGridVisible leLSWSetTrackPatternVisible leLSWShowGrids leLSWShowLayers leLSWShowObjects leLayerAnd leLayerAndNot leLayerOr leLayerSize leLayerXor leLmbCtrlOption leLmbShiftOption leMakeCell leMakeHierReadonlyOrEditableMC leMarkNet leMergeShapes leModifyCorner leMoveCellViewOrigin leMoveCursor leMoveCursorToRefPoint lePasteFigs lePinModelInitFunction lePlot lePrintHierarchyTree leRaiseLSW leRegAreaEstimator leRegClusterBdyEstimator leRegUserLayerSelectionFilter leRegUserObjectSelectionFilter leRemapLSW leRemasterInstances leRemoveUserLayerSelectionFilter leRemoveUserObjectSelectionFilter leReplace leReplaceAnyInstMaster leResizeLSW leReturn leReturnToLevel leRulerCycleDisplayType leSaveMarkNet leSearchHierarchy leSelBoxOrStretch leSetAllGridObjectsVisible leSetAllLayerSelectable leSetAllLayerValid leSetAllLayerVisible leSetAllObjectsSelectable leSetAllObjectsVisible leSetAreaEstimatorParameters leSetEditFigGroup leSetEntryLayer leSetEnv leSetFormSnapMode leSetGlobalGridsVisible leSetInstSelectable leSetLSWBBox leSetLSWFilter leSetLayerAttributes leSetLayerSelectable leSetLayerValid leSetLayerVisible leSetLocalGridsVisible leSetObjectSelectable leSetObjectVisible leSetPinSelectable leSetRefPoint leSetRefPointInactive leSetSnapPatternVisible leSizeShape leSlice leSpaceBarFunc leSplitShape leStartRouter leStretchFig leStretchShape leToggleAllGravity leToggleDrdMode leToggleGravity leToggleKeepFirstName leToggleMagnifier leToggleMaintainConnections leToggleSmartSnap leUnRegAreaEstimator leUnRegClusterBdyEstimator leUnfreezeInst leUniquifyCellView leUnmapLSW leUnmarkNet leUnregUserLayerSelectionFilter leUnregUserObjectSelectionFilter leWECycleControlWire leWECycleSnap leWENoSnap leYankFigs leZoomToPoint leZoomToSelSet leftEdge leftshift leiDiscardEdits length leqp lessp let letrec letseq linRg lindex lineread linereadstring list listAlias listFunctions listToVector listVariables listp lmCheckTerm lmCheckView lmCloseLib lmDefTermProp lmDefViewProp lmDeleteTermProp lmDeleteViewProp lmGetValue lmLoadData lmOpenLib lmPrintLibTermProp lmPrintLibViewProp lmPrintTerm lmPrintTermProp lmPrintViewProp lmReset lmSimView lmgrAddMenuItems lmgrCreateMenu lmgrCreateMenuItem lmgrDefineInits lmgrDeleteMenuItems lmgrDisplayMessage lmgrGetObject lmgrInsertMenuItems lmgrLogShowPopup lmgrManageMenuItems lmgrMenuSubsInPopup lmgrQueryNamedObjects lmgrSensitizeMenuItems lmgrSetObject lmgrVerbose ln loCellSubstitutionMap loHiAbout loLayerMap loLibraryMap loMapParameters loSchematicParams loSetAnnotateLPP loSetVal loSplitViaFunctionMap load loadContext loadPort loadTopContextForms loadi loadpull loadstring log log10 logRg lowerCase lowerLeft lsb lshift lsprintf lxAbutGetNeighbors lxChain lxCheck lxCheckAgainstSource lxCheckLib lxCmdOptions lxCmdShiftOptions lxComputeViaParams lxCreateBndFile lxDeleteSynchronousCloneFamily lxEditPinPlacement lxEditPlacementStyle lxGenFromSource lxGenerateFinish lxGenerateGetAvailablePinLPPs lxGenerateStart lxGetCloneFamilyName lxGetEditedSyncClone lxGetLXInfo lxGetOtherClonesInFamily lxGetPermutedInstTerms lxGetPinNets lxGetSyncClone lxGetValidViaDefs lxHiAbout lxHiAlign lxHiAutoPlace lxHiBackAnnotateAllActiveDummies lxHiBackAnnotateSelectedDummies lxHiChain lxHiCheck lxHiClone lxHiConnectInstPin lxHiCreateInstFromSch lxHiCreateMPP lxHiDefineDeviceCorr lxHiEditComponentTypes lxHiLockSelected lxHiMoveAutomatically lxHiProbe lxHiReInitDesign lxHiSetOptions lxHiStack lxHiSwapComps lxHiUnlockSelected lxHiUpdateBinding lxHiUpdateCellViewPair lxHiUpdateComponentsAndNets lxHiUpdateLayoutConstraints lxHiUpdateLayoutParameters lxHiUpdateSchematicParameters lxHiVerifyDesign lxHiVerifyStatus lxLaunchLayoutGXL lxLaunchLayoutXL lxMakePrBoundarySelectable lxMakePrBoundaryUnselectable lxMovePorts lxPermPermutePins lxPlcAppendPlaceSetupFieldValue lxPlcGetPlaceSetupFieldValue lxPlcIsPlaceSetupFieldEnabled lxPlcReplacePlaceSetupField lxPlcSetPlaceSetupFieldEnableState lxPlcSetPlaceSetupFieldValue lxProbeRemoveAll lxRemoveSynchronousCloneFromFamily lxRunCmdInVXL lxSelectSynchronousFamily lxSelectedDeleteNetRouting lxSelectedExtendChain lxSelectedExtendSelection lxSelectedLock lxSelectedLockNet lxSelectedRemoveIgnore lxSelectedRoute lxSelectedRouteNet lxSelectedSelectAttachedNets lxSelectedSelectExternalNets lxSelectedSelectInternalNets lxSelectedSelectNetsShapes lxSelectedUnlock lxSelectedUnlockNet lxSelectedUpdateFromSource lxSelectedUpdateIgnore lxSetAreaEstimationOptions lxSetBoundaryOptions lxSetCloneFamilyName lxSetConfigRef lxSetConnRef lxSetGenerateOptions lxSetNetPinSpecs lxSetPreserveFloorplanningOptions lxSetUpdateOptions lxShowHideIncompleteNets lxToggleLocalAbutment lxToggleShowAllIncompleteNets lxToggleShowIncompleteNets lxTpTemplateLoadAll lxUpdateAllPhysBinding lxUpdateBinding lxUpdateComponentsAndNets lxUpdateComponentsAndNetsFinish lxUpdateComponentsAndNetsStart lxUpdatePhysBinding lxUpdatePlacementStatus lxVerifyCloneFamily mag makeInstance makeNamespace makeSymbol makeTable makeTempFileName makeVector map mapc mapcan mapcar mapcon mapinto maplist max mbGetAction mbRegisterAction mbRegisterCustomMenu mbRegisterHierMenu mbRegisterMenuItem mbSetContextData mbUnregisterAction measureTime member memoryAllocated memq memv menuTrigger mgAbutAllCB mgAbutCB mgAddBodyContact mgAddCopyDummies mgAddDummyBottomCB mgAddDummyLeftCB mgAddDummyRCBottomCB mgAddDummyRCLeftCB mgAddDummyRCRightCB mgAddDummyRCTopCB mgAddDummyRightCB mgAddDummyTopCB mgAddEmptyRCCB mgAddGuardRingCB mgCreateModgenAsLayout mgCreateOrEdit mgDeleteAllBodyContacts mgDeleteAllDummies mgDeleteCB mgDeleteEmptyRowColumnCB mgEditGuardRingCB mgExecNoConObs mgExitCB mgFlattenModgens mgFlipHorizontalCB mgFlipVerticalCB mgGen mgGetBoxLPPArea mgGetConstraintFromFG mgGetLayerSpacing mgGetModgenFGFromConstraint mgGetRegUserProc mgHilightEmptyRowColumnCB mgIsInBackAnnotation mgPatternCB mgRegUserProc mgRotateLeftCB mgRotateMXCB mgRotateMYCB mgRotateR270CB mgRotateR90CB mgRotateRightCB mgRouteCB mgRoutePToTCB mgRouteStructuredCB mgSelectRowColCB mgSwapCB mgUnAbutCB mgUnRegUserProc mgUnRouteCB mgUpdateCB mgUpdateEmptyRowColumnHilightCB mgUpdateHoriAlignCB mgUpdateVertAlignCB min minus minusp mod modelFile modf modulo monitor mouseAddPt mouseAddSelectPt mouseFinishPt mousePopUp mouseSingleSelectPt mouseSubSelectPt mouseUndoPt mprocedure msgHelp mspDisplaySetPartSetupForm mspEditIEProps mspsMapNetName nc nc_freq nc_gain nclAnalogAdjCellPins nclAnalogAdjCellSides nclAnalogAutoPlaceCB nclAnalogFixDRCs nclAnalogQuickPlace nclAnalogQuickPlaceLikeSchemCB nclCPExit nclCPSaveConstraint nclCPToolBarSelect nclCreateXSym nclRegPostPlacementTrigger nclRegPrePlacementTrigger nclRunConstraintValidation nclSetAspectRatioRange nclToggleCAEMode nclUnregPostPlacementTrigger nclUnregPrePlacementTrigger nconc ncons needNCells negativep neq nequal netlist newWindow newline next nextMethodp nf nfmin nindex nlDisplayOption nlError nlGetCdf nlGetCellName nlGetCurrentSwitchMaster nlGetDesign nlGetFormatter nlGetGlobalNets nlGetId nlGetLibName nlGetModelName nlGetNetlistDir nlGetNetlister nlGetNumberOfBits nlGetOption nlGetOptionNameList nlGetPCellParamSource nlGetParamList nlGetParamStringValue nlGetSignalList nlGetSimName nlGetSimTerminalNets nlGetSwitchViewList nlGetTerminalList nlGetTerminalNets nlGetTerminalSignalName nlGetToolName nlGetTopCellName nlGetTopLibName nlGetTopViewName nlIncludeDbDSPFTextFile nlIncludeSrcFile nlIncludeVerilogFile nlIncludeVerilogaFile nlInfo nlInitialize nlIsModelNameInherited nlMapGlobalNet nlObjError nlPrintComment nlPrintComments nlPrintFooter nlPrintHeader nlPrintHeaderComments nlPrintIndentString nlPrintInst nlPrintInstComments nlPrintInstEnd nlPrintInstName nlPrintInstParameters nlPrintInstSignals nlPrintModelName nlPrintString nlPrintStringNoFold nlPrintSubcktBegin nlPrintSubcktEnd nlPrintSubcktFooter nlPrintSubcktFooterComments nlPrintSubcktHeader nlPrintSubcktHeaderComments nlPrintSubcktName nlPrintSubcktParameters nlPrintSubcktTerminalList nlPrintTopCellFooter nlPrintTopCellFooterComments nlPrintTopCellHeader nlPrintTopCellHeaderComments nlSetOption nlSetPcellName nlTranslateFlatIEPathName nlWarning nlambda nmpAsciiToSysVerilog nmpCDBAFlatToCDBA nmpCDBAToCDBAFlat nmpCDBAToConcept nmpCDBAToDef nmpCDBAToGcf nmpCDBAToGenesis nmpCDBAToIdent nmpCDBAToLef nmpCDBAToPrint nmpCDBAToSdf nmpCDBAToSpectre nmpCDBAToSpectreHDL nmpCDBAToSpef nmpCDBAToSpf nmpCDBAToSpice nmpCDBAToSysVerilog nmpCDBAToVHDL nmpCDBAToVHDL87 nmpCDBAToVHDLAMS nmpCDBAToVerilog nmpCDBAToVerilogA nmpCDBAToVerilogAMS nmpConceptToCDBA nmpConceptToDef nmpConceptToGcf nmpConceptToGenesis nmpConceptToIdent nmpConceptToLef nmpConceptToPrint nmpConceptToSdf nmpConceptToSpectre nmpConceptToSpectreHDL nmpConceptToSpef nmpConceptToSpf nmpConceptToSpice nmpConceptToSysVerilog nmpConceptToVHDL nmpConceptToVHDL87 nmpConceptToVHDLAMS nmpConceptToVerilog nmpConceptToVerilogA nmpConceptToVerilogAMS nmpDefToCDBA nmpDefToConcept nmpDefToGcf nmpDefToGenesis nmpDefToIdent nmpDefToLef nmpDefToPrint nmpDefToSdf nmpDefToSpectre nmpDefToSpectreHDL nmpDefToSpef nmpDefToSpf nmpDefToSpice nmpDefToSysVerilog nmpDefToVHDL nmpDefToVHDL87 nmpDefToVHDLAMS nmpDefToVerilog nmpDefToVerilogA nmpDefToVerilogAMS nmpGcfToCDBA nmpGcfToConcept nmpGcfToDef nmpGcfToGenesis nmpGcfToIdent nmpGcfToLef nmpGcfToPrint nmpGcfToSdf nmpGcfToSpectre nmpGcfToSpectreHDL nmpGcfToSpef nmpGcfToSpf nmpGcfToSpice nmpGcfToSysVerilog nmpGcfToVHDL nmpGcfToVHDL87 nmpGcfToVHDLAMS nmpGcfToVerilog nmpGcfToVerilogA nmpGcfToVerilogAMS nmpGenesisToCDBA nmpGenesisToConcept nmpGenesisToDef nmpGenesisToGcf nmpGenesisToIdent nmpGenesisToLef nmpGenesisToPrint nmpGenesisToSdf nmpGenesisToSpectre nmpGenesisToSpectreHDL nmpGenesisToSpef nmpGenesisToSpf nmpGenesisToSpice nmpGenesisToSysVerilog nmpGenesisToVHDL nmpGenesisToVHDL87 nmpGenesisToVHDLAMS nmpGenesisToVerilog nmpGenesisToVerilogA nmpGenesisToVerilogAMS nmpGetSpaceNames nmpIdentToCDBA nmpIdentToConcept nmpIdentToDef nmpIdentToGcf nmpIdentToGenesis nmpIdentToLef nmpIdentToPrint nmpIdentToSdf nmpIdentToSpectre nmpIdentToSpectreHDL nmpIdentToSpef nmpIdentToSpf nmpIdentToSpice nmpIdentToSysVerilog nmpIdentToVHDL nmpIdentToVHDL87 nmpIdentToVHDLAMS nmpIdentToVerilog nmpIdentToVerilogA nmpIdentToVerilogAMS nmpIsLegalCDBA nmpIsLegalConcept nmpIsLegalDef nmpIsLegalGcf nmpIsLegalGenesis nmpIsLegalLef nmpIsLegalPrint nmpIsLegalSdf nmpIsLegalSpectre nmpIsLegalSpectreHDL nmpIsLegalSpef nmpIsLegalSpf nmpIsLegalSpice nmpIsLegalSysVerilog nmpIsLegalVHDL nmpIsLegalVHDL87 nmpIsLegalVHDLAMS nmpIsLegalVerilog nmpIsLegalVerilogA nmpIsLegalVerilogAMS nmpLefToCDBA nmpLefToConcept nmpLefToDef nmpLefToGcf nmpLefToGenesis nmpLefToIdent nmpLefToPrint nmpLefToSdf nmpLefToSpectre nmpLefToSpectreHDL nmpLefToSpef nmpLefToSpf nmpLefToSpice nmpLefToSysVerilog nmpLefToVHDL nmpLefToVHDL87 nmpLefToVHDLAMS nmpLefToVerilog nmpLefToVerilogA nmpLefToVerilogAMS nmpPrintToCDBA nmpPrintToConcept nmpPrintToDef nmpPrintToGcf nmpPrintToGenesis nmpPrintToIdent nmpPrintToLef nmpPrintToSdf nmpPrintToSpectre nmpPrintToSpectreHDL nmpPrintToSpef nmpPrintToSpf nmpPrintToSpice nmpPrintToSysVerilog nmpPrintToVHDL nmpPrintToVHDL87 nmpPrintToVHDLAMS nmpPrintToVerilog nmpPrintToVerilogA nmpPrintToVerilogAMS nmpSdfToCDBA nmpSdfToConcept nmpSdfToDef nmpSdfToGcf nmpSdfToGenesis nmpSdfToIdent nmpSdfToLef nmpSdfToPrint nmpSdfToSpectre nmpSdfToSpectreHDL nmpSdfToSpef nmpSdfToSpf nmpSdfToSpice nmpSdfToSysVerilog nmpSdfToVHDL nmpSdfToVHDL87 nmpSdfToVHDLAMS nmpSdfToVerilog nmpSdfToVerilogA nmpSdfToVerilogAMS nmpSpectreHDLToCDBA nmpSpectreHDLToConcept nmpSpectreHDLToDef nmpSpectreHDLToGcf nmpSpectreHDLToGenesis nmpSpectreHDLToIdent nmpSpectreHDLToLef nmpSpectreHDLToPrint nmpSpectreHDLToSdf nmpSpectreHDLToSpectre nmpSpectreHDLToSpef nmpSpectreHDLToSpf nmpSpectreHDLToSpice nmpSpectreHDLToSysVerilog nmpSpectreHDLToVHDL nmpSpectreHDLToVHDL87 nmpSpectreHDLToVHDLAMS nmpSpectreHDLToVerilog nmpSpectreHDLToVerilogA nmpSpectreHDLToVerilogAMS nmpSpectreToCDBA nmpSpectreToConcept nmpSpectreToDef nmpSpectreToGcf nmpSpectreToGenesis nmpSpectreToIdent nmpSpectreToLef nmpSpectreToPrint nmpSpectreToSdf nmpSpectreToSpectreHDL nmpSpectreToSpef nmpSpectreToSpf nmpSpectreToSpice nmpSpectreToSysVerilog nmpSpectreToVHDL nmpSpectreToVHDL87 nmpSpectreToVHDLAMS nmpSpectreToVerilog nmpSpectreToVerilogA nmpSpectreToVerilogAMS nmpSpefToCDBA nmpSpefToConcept nmpSpefToDef nmpSpefToGcf nmpSpefToGenesis nmpSpefToIdent nmpSpefToLef nmpSpefToPrint nmpSpefToSdf nmpSpefToSpectre nmpSpefToSpectreHDL nmpSpefToSpf nmpSpefToSpice nmpSpefToSysVerilog nmpSpefToVHDL nmpSpefToVHDL87 nmpSpefToVHDLAMS nmpSpefToVerilog nmpSpefToVerilogA nmpSpefToVerilogAMS nmpSpfToCDBA nmpSpfToConcept nmpSpfToDef nmpSpfToGcf nmpSpfToGenesis nmpSpfToIdent nmpSpfToLef nmpSpfToPrint nmpSpfToSdf nmpSpfToSpectre nmpSpfToSpectreHDL nmpSpfToSpef nmpSpfToSpice nmpSpfToSysVerilog nmpSpfToVHDL nmpSpfToVHDL87 nmpSpfToVHDLAMS nmpSpfToVerilog nmpSpfToVerilogA nmpSpfToVerilogAMS nmpSpiceToCDBA nmpSpiceToConcept nmpSpiceToDef nmpSpiceToGcf nmpSpiceToGenesis nmpSpiceToIdent nmpSpiceToLef nmpSpiceToPrint nmpSpiceToSdf nmpSpiceToSpectre nmpSpiceToSpectreHDL nmpSpiceToSpef nmpSpiceToSpf nmpSpiceToSysVerilog nmpSpiceToVHDL nmpSpiceToVHDL87 nmpSpiceToVHDLAMS nmpSpiceToVerilog nmpSpiceToVerilogA nmpSpiceToVerilogAMS nmpSysVerilogToAscii nmpSysVerilogToCDBA nmpSysVerilogToConcept nmpSysVerilogToDef nmpSysVerilogToGcf nmpSysVerilogToGenesis nmpSysVerilogToIdent nmpSysVerilogToLef nmpSysVerilogToPrint nmpSysVerilogToSdf nmpSysVerilogToSpectre nmpSysVerilogToSpectreHDL nmpSysVerilogToSpef nmpSysVerilogToSpf nmpSysVerilogToSpice nmpSysVerilogToVHDL nmpSysVerilogToVHDL87 nmpSysVerilogToVHDLAMS nmpSysVerilogToVerilog nmpSysVerilogToVerilogA nmpSysVerilogToVerilogAMS nmpVHDL87ToCDBA nmpVHDL87ToConcept nmpVHDL87ToDef nmpVHDL87ToGcf nmpVHDL87ToGenesis nmpVHDL87ToIdent nmpVHDL87ToLef nmpVHDL87ToPrint nmpVHDL87ToSdf nmpVHDL87ToSpectre nmpVHDL87ToSpectreHDL nmpVHDL87ToSpef nmpVHDL87ToSpf nmpVHDL87ToSpice nmpVHDL87ToSysVerilog nmpVHDL87ToVHDL nmpVHDL87ToVHDLAMS nmpVHDL87ToVerilog nmpVHDL87ToVerilogA nmpVHDL87ToVerilogAMS nmpVHDLAMSToCDBA nmpVHDLAMSToConcept nmpVHDLAMSToDef nmpVHDLAMSToGcf nmpVHDLAMSToGenesis nmpVHDLAMSToIdent nmpVHDLAMSToLef nmpVHDLAMSToPrint nmpVHDLAMSToSdf nmpVHDLAMSToSpectre nmpVHDLAMSToSpectreHDL nmpVHDLAMSToSpef nmpVHDLAMSToSpf nmpVHDLAMSToSpice nmpVHDLAMSToSysVerilog nmpVHDLAMSToVHDL nmpVHDLAMSToVHDL87 nmpVHDLAMSToVerilog nmpVHDLAMSToVerilogA nmpVHDLAMSToVerilogAMS nmpVHDLToCDBA nmpVHDLToConcept nmpVHDLToDef nmpVHDLToGcf nmpVHDLToGenesis nmpVHDLToIdent nmpVHDLToLef nmpVHDLToPrint nmpVHDLToSdf nmpVHDLToSpectre nmpVHDLToSpectreHDL nmpVHDLToSpef nmpVHDLToSpf nmpVHDLToSpice nmpVHDLToSysVerilog nmpVHDLToVHDL87 nmpVHDLToVHDLAMS nmpVHDLToVerilog nmpVHDLToVerilogA nmpVHDLToVerilogAMS nmpVerilogAMSToCDBA nmpVerilogAMSToConcept nmpVerilogAMSToDef nmpVerilogAMSToGcf nmpVerilogAMSToGenesis nmpVerilogAMSToIdent nmpVerilogAMSToLef nmpVerilogAMSToPrint nmpVerilogAMSToSdf nmpVerilogAMSToSpectre nmpVerilogAMSToSpectreHDL nmpVerilogAMSToSpef nmpVerilogAMSToSpf nmpVerilogAMSToSpice nmpVerilogAMSToSysVerilog nmpVerilogAMSToVHDL nmpVerilogAMSToVHDL87 nmpVerilogAMSToVHDLAMS nmpVerilogAMSToVerilog nmpVerilogAMSToVerilogA nmpVerilogAToCDBA nmpVerilogAToConcept nmpVerilogAToDef nmpVerilogAToGcf nmpVerilogAToGenesis nmpVerilogAToIdent nmpVerilogAToLef nmpVerilogAToPrint nmpVerilogAToSdf nmpVerilogAToSpectre nmpVerilogAToSpectreHDL nmpVerilogAToSpef nmpVerilogAToSpf nmpVerilogAToSpice nmpVerilogAToSysVerilog nmpVerilogAToVHDL nmpVerilogAToVHDL87 nmpVerilogAToVHDLAMS nmpVerilogAToVerilog nmpVerilogAToVerilogAMS nmpVerilogToCDBA nmpVerilogToConcept nmpVerilogToDef nmpVerilogToGcf nmpVerilogToGenesis nmpVerilogToIdent nmpVerilogToLef nmpVerilogToPrint nmpVerilogToSdf nmpVerilogToSpectre nmpVerilogToSpectreHDL nmpVerilogToSpef nmpVerilogToSpf nmpVerilogToSpice nmpVerilogToSysVerilog nmpVerilogToVHDL nmpVerilogToVHDL87 nmpVerilogToVHDLAMS nmpVerilogToVerilogA nmpVerilogToVerilogAMS nodeset noise noiseSummary normalQQ not nprocedure nrDialogAccept nrListColumnMove nrListColumnSort nrListItemAction nrListItemExpand nrListItemRename nrResizeWindow nrSetCurrentWindow nrSetFileFilter nrSetWindowVisibility nrUpdateMenu nth nthcdr nthelem null numOpenFiles numberp ocnAmsSetOSSNetlister ocnCloseSession ocnDisplay ocnDspfFile ocnGetAdjustedPath ocnGetInstancesModelName ocnHelp ocnPrint ocnPspiceFile ocnResetResults ocnSetAttrib ocnSetSilentMode ocnSetXLMode ocnSpefFile ocnWriteLsspToFile ocnYvsYplot ocnxlAddOrUpdateOutput ocnxlAddRelxSetup ocnxlBeginTest ocnxlConjugateGradientOptions ocnxlCorner ocnxlCornerVars ocnxlDisableCorner ocnxlDisableCornerForTest ocnxlDisableRelxSetup ocnxlDisableSweepParam ocnxlDisableSweepVar ocnxlDisableTest ocnxlEnableCorner ocnxlEnableCornerForTest ocnxlEnableSweepParam ocnxlEnableSweepVar ocnxlEnableTest ocnxlEndTest ocnxlEndXLMode ocnxlExportOutputView ocnxlFeasibilityAnalysisOptions ocnxlGetBestPointParams ocnxlGetCorners ocnxlGetCurrentHistory ocnxlGetCurrentHistoryId ocnxlGetHistory ocnxlGetJobId ocnxlGetOverwriteHistory ocnxlGetOverwriteHistoryName ocnxlGetPointId ocnxlGetReferenceHistory ocnxlGetRunDistributeOptions ocnxlGetSession ocnxlGetSpecs ocnxlGetTests ocnxlGlobalOptimizationOptions ocnxlHistoryPrefix ocnxlJobSetup ocnxlLoadCurrentEnvironment ocnxlLoadSetupState ocnxlLocalOptimizationOptions ocnxlMCIterNum ocnxlMTSBlock ocnxlMTSEnable ocnxlMainSimSession ocnxlModelGroup ocnxlMonteCarloOptions ocnxlOutputAreaGoal ocnxlOutputExpr ocnxlOutputMatlabScript ocnxlOutputOceanScript ocnxlOutputOpRegion ocnxlOutputSignal ocnxlOutputSummary ocnxlOutputTerminal ocnxlParametricSet ocnxlPreRunScript ocnxlProjectDir ocnxlPutGreaterthanSpec ocnxlPutInfoSpec ocnxlPutLessthanSpec ocnxlPutMaxSpec ocnxlPutMinSpec ocnxlPutRangeSpec ocnxlPutTargetSpec ocnxlPutToleranceSpec ocnxlRemoveSpec ocnxlRenameCurrentHistory ocnxlResultsLocation ocnxlRun ocnxlRunCalibration ocnxlRunSetupSummary ocnxlSamplingOptions ocnxlSaveSetupAs ocnxlSelectTest ocnxlSensitivityOptions ocnxlSensitivityVars ocnxlSetAllParameterPSetsDisabled ocnxlSetAllParametersDisabled ocnxlSetAllVariablePSetsDisabled ocnxlSetAllVarsDisabled ocnxlSetCalibration ocnxlSetMCdut ocnxlSetOverwriteHistory ocnxlSetOverwriteHistoryName ocnxlSetPreRunScriptEnabled ocnxlSetReferenceHistory ocnxlSetRelxAnalysisEnabled ocnxlSetRunDistributeOptions ocnxlSetupLocation ocnxlSimResultsLocation ocnxlSizeOverCornersOptions ocnxlStartingPoint ocnxlSweepParam ocnxlSweepVar ocnxlSweepsAndCornersOptions ocnxlTargetCellView ocnxlUpdatePointVariable ocnxlWaitUntilDone ocnxlWorstCaseCornersOptions ocnxlWriteDatasheet ocnxlYieldEstimationOptions ocnxlYieldImprovementOptions odcRegBlockage odcRegBoundary odcRegCPA odcRegInstance odcRegLabel odcRegMarker odcRegModgen odcRegPin odcRegRow odcRegRuler odcRegShapeCircle odcRegShapeDonut odcRegShapeEllipse odcRegShapeMPP odcRegShapePath odcRegShapePathSeg odcRegShapePolygon odcRegShapeRect odcRegTextDisplay odcRegVia odcRegisterCustomFunc oddp off onep openResults openportp option or otherp outfile outportp outputParams outputs outstring outstringp overshoot pairp parCacheFind parCacheGet parCacheListFilters parCacheListModels parCachePurge parCacheSave parDelete parFilterCreate parFind parModelCreateCustom parModelCreateNetC parModelCreateNetK parModelCreateNetL parModelCreateNetR parModelListSimParams parModelListSimSweeps parModelUpdateSimParams parModelUpdateSimSweeps parObjectListFilters parObjectListModels parRemoveMembers parResetAllParams parResetParams parSetNote parUpdateMembers parUpdateParams paramAnalysis paramRun parseString path pavg pcColinearPoints pcConcatOrient pcDefineCondition pcDefineInheritParam pcDefinePCell pcDefineParamCell pcDefineParamLabel pcDefineParamLayer pcDefineParamPath pcDefineParamPolygon pcDefineParamProp pcDefineParamRect pcDefineParamRefPointObject pcDefinePathRefPointObject pcDefineRepeat pcDefineSteppedObject pcDefineStretchLine pcDeleteCondition pcDeleteParam pcDeleteParamLayer pcDeleteParamProp pcDeleteParamShape pcDeleteRefPoint pcDeleteRepeat pcDeleteSteppedObject pcExprToProp pcExprToString pcFilterPoints pcFix pcGetBendAngle pcGetCodeParamNames pcGetCodeParamValue pcGetConditions pcGetInheritParamDefn pcGetInheritParams pcGetOffsetPath pcGetOffsetPolygon pcGetParamLabelDefn pcGetParamLabels pcGetParamLayerDefn pcGetParamLayers pcGetParamProps pcGetParamShapeDefn pcGetParamShapes pcGetParameters pcGetPathRefPoint pcGetRefPointDefn pcGetRefPoints pcGetRepeatDefn pcGetRepeats pcGetStepDirection pcGetSteppedObjectDefn pcGetSteppedObjects pcGetStretchDefn pcGetStretchSummary pcGetStretches pcGrowBox pcGrowPoints pcHICompileToSkill pcHIDefineCondition pcHIDefineInheritedParameter pcHIDefineLabel pcHIDefineLayer pcHIDefineParamCell pcHIDefineParamRefPointObject pcHIDefineParameterizedShape pcHIDefinePathRefPointObject pcHIDefineProp pcHIDefineRepeat pcHIDefineSteppedObject pcHIDefineStretch pcHIDeleteCondition pcHIDeleteLayer pcHIDeleteParameterizedShape pcHIDeleteProp pcHIDeleteRefPointObject pcHIDeleteRepeat pcHIDeleteSteppedObject pcHIDisplayCondition pcHIDisplayInheritedParameter pcHIDisplayLayer pcHIDisplayParameterizedShape pcHIDisplayParams pcHIDisplayProp pcHIDisplayRefPointObject pcHIDisplayRepeat pcHIDisplaySteppedObject pcHIEditParameters pcHIModifyCondition pcHIModifyLabel pcHIModifyLayer pcHIModifyParams pcHIModifyRefPointObject pcHIModifyRepeat pcHIModifySteppedObject pcHIModifyStretchLine pcHIQualifyStretchLine pcHIRedefineStretchLine pcHISummarizeParams pcModifyParam pcRedefineStretchLine pcRestrictStretchToObjects pcRound pcSetFTermWidth pcSkillGen pcStepAlongShape pcTechFile pcUserAdjustParameters pcUserGenerateArray pcUserGenerateInstance pcUserGenerateInstancesOfMaster pcUserGenerateLPP pcUserGeneratePin pcUserGenerateProperty pcUserGenerateShape pcUserGenerateTerminal pcUserInitRepeat pcUserPostProcessCellView pcUserPostProcessObject pcUserPreProcessCellView pcUserSetTermNetName pcdbClose pcdbGetIgnoredInstMasterGen pcdbGetInstGen pcdbGetInstMasterGen pcdbInstMasterCell pcdbInstMasterCellFixed pcdbInstMasterLib pcdbInstMasterLibFixed pcdbInstMasterView pcdbInstMasterViewFixed pcdbInstName pcdbInstWidth pcdbNextInst pcdbNextInstMaster pcdbOpen pcdbSave pcdbViewHasPcdbInfo pcfix pcreCompile pcreExecute pcreGenCompileOptBits pcreGenExecOptBits pcreListCompileOptBits pcreListExecOptBits pcreMatchAssocList pcreMatchList pcreMatchp pcreObjectp pcrePrintLastMatchErr pcreReplace pcreSubstitute pcround peak peakToPeak period_jitter pfile phase phaseDeg phaseDegUnwrapped phaseMargin phaseNoise phaseRad phaseRadUnwrapped piCellNameMap piLayerMap piPostTranslate piPreTranslate piTextMap pipoDisplay pir plist plot plotStyle plus plusp pmNoise pn poCellNameMap poLayerMap poParamCellNameMap poPostTranslate poPreTranslate poTextMap popf portp postArrayDec postArrayInc postArraySet postInstallTrigger postdecrement postincrement pow pp pprint preArrayDec preArrayInc preArraySet preXY predecrement preincrement prependInstallPath prependPath print printFunctions printGraph printObject printVariables printViolations printf printlev println printself printstruct prms probeTrigger procedure procedurep profile profileReset profileSummary prog prog1 prog2 progn psConfigLoaded psLoadCdsPlotInit psQueryPaperSize psQueryPaperSizes psQueryPlotters psQueueStatus psd psdbb pstddev pteCancelForm pteClearSearchHistory pteCloseLayerSetEdition pteCollapse pteCollapseAll pteContextMenu pteDeleteLayerSet pteDeselect pteDeselectAll pteDiscardLayerSetEdition pteDockWindow pteEditLayerSet pteEditLayerSetValidity pteExpand pteExpandAll pteExportLayerSet pteFindNext pteFindPrev pteGetCurrentPanel pteGetLSAtPosition pteGetLayerPath pteGetNextLayerSets pteGetPrevLayerSets pteGetSelection pteHideAllTools pteImportLayerSet pteIsSelectable pteIsVisible pteLoadConfig pteLoadFromTechFile pteLoadGDSNumber pteLoadLSWInfo pteMapWindow pteMoveLayerSelection pteOpenForm ptePropagateSelectability ptePropagateVisibility pteRegisterUserLSManagerTrigger pteRegisterUserSelectionTrigger pteReloadLayerSet pteSaveAsLayerSet pteSaveConfig pteSaveGDSNumber pteSaveLSWInfo pteSaveLayerSet pteSaveLayerSetList pteSaveToTechFile pteSelect pteSelectAll pteSetActiveLpp pteSetAllLSEnable pteSetAllLayerSetMember pteSetAllSelectable pteSetAllStipple pteSetAllValidity pteSetAllVisible pteSetBindkeys pteSetConfig pteSetLSActive pteSetLSEnable pteSetLSPosition pteSetLSSelectable pteSetLSVisible pteSetLayerSetMember pteSetNoneLayerSetMember pteSetNoneSelectable pteSetNoneStipple pteSetNoneValidity pteSetNoneVisible pteSetOnlySelectable pteSetOnlyVisible pteSetOption pteSetOptionString pteSetRoutingDirection pteSetSearchMatchCase pteSetSearchMatchType pteSetSearchOperator pteSetSearchText pteSetSelectable pteSetStipple pteSetValidity pteSetVisible pteSetWindowSynchro pteShowAllTools pteShowRoutingLPP pteShowUsedLPP pteShowValidLPP pteToggleAllLayerSetMember pteToggleAllSelectable pteToggleAllStipple pteToggleAllTools pteToggleAllValidity pteToggleAllVisible pteToggleLSActive pteToggleLayerSetEdition pteToggleLayerSetValidityEdition pteTogglePanels pteTogglePropagateAllSelectable pteTogglePropagateAllVisible pteToggleShowRoutingLPP pteToggleShowUsedLPP pteToggleShowValidLPP pteToggleToolbars pteToggleWindowSynchro pteUnRegisterUserLSManagerTrigger pteUnRegisterUserSelectionTrigger pteUndockWindow pteUnmapWindow pteUnsetLSActive pushf putc putd putprop putpropq putpropqq pv pvi pvr pzFrequencyAndRealFilter pzPlot pzSummary pzbode pzfilter quote quotient random range rapidIIPN rapidIPNCurves rdbLoadResults rdbReloadResults rdbSetCurrentDirectory rdbShowDialog rdbUnloadResults rdbWriteToFormat rdeCreateChamferFill rdeCreateWireChamfer rdeDone rdeEval rdeGetVar rdeHide rdeInspect rdeOpenCurrentDesign rdeReplay rdeSequencer rdeSetVar rdeShow rdeSource read readTable readstring real realp regExitAfter regExitBefore relxOption remExitProc remainder remd remdq remoteDir remove removeDependent removeFromExportList removeLabel removeMethod removeShadowImport remprop remq renameFile report restore restoreFloat resultParam results resultsDir resume resumeJob return reverse rexCompile rexExecute rexMagic rexMatchAssocList rexMatchList rexMatchp rexReplace rexSubstitute rightEdge rightshift rindex riseTime risetime rms rmsNoise rmsVoltage rn rodAddMPPChopHole rodAddPoints rodAddSubPart rodAddToX rodAddToY rodAlign rodAssignHandleToParameter rodCheck rodCheckAllMPPsInCellView rodCheckMPPs rodCoordBisect rodCoordCreate rodCoordDefineGrid rodCoordFix rodCoordGetGrid rodCoordIsOnGrid rodCoordPartition rodCoordSnap rodCoordToFloat rodCoordToInt rodCoordToString rodCreateHandle rodCreatePath rodCreatePolygon rodCreateRect rodDeleteHandle rodDeleteSubPart rodFillBBoxWithRects rodFillWithRects rodGetBBox rodGetHandle rodGetNamedShapes rodGetObj rodGetSubPart rodIsFigNameUnused rodIsHandle rodIsObj rodNameObject rodNameShape rodPointX rodPointY rodSubPoints rodUnAlign rodUnNameShape root rotatef round round2 rplaca rplacd rshift rteCheckAntenna rteCheckDataForRouting rteCheckRoutability rteComposeTrunks rteCoverObstructionHilite rteCoverObstructionUnHilite rteCreateBlockRingScheme rteCreateCellRowsScheme rteCreateCoreRingScheme rteCreatePadRingScheme rteCreatePinToTrunkScheme rteCreateStripesScheme rteCreateViasScheme rteDecomposeTrunks rteDeleteRoutedNets rteFixAntenna rteFixViolations rteGeomAnd rteGeomAndNot rteGeomNot rteGeomOr rteGeomSize rteGeomXor rteOptimizeRoute rtePowerRouteBlockRing rtePowerRouteCellRow rtePowerRouteCoreRing rtePowerRoutePadRing rtePowerRoutePinToTrunk rtePowerRouteStripes rtePowerRouteTieShield rtePowerRouteTrimStripes rtePowerRouteViaInsertion rteSearchAndRepair rteSetvar run runsim s11 s12 s21 s22 sample save saveContext saveFloat saveGraphImage saveOption saveSubckt scanf schAddSelectPt schCheck schCheckHier schCheckHierConfig schCloneSymbol schCmdOption schComputePinRef schCopy schCreateInst schCreateInstBox schCreateNetExpression schCreateNoteLabel schCreateNoteShape schCreatePin schCreateSheet schCreateSymbolLabel schCreateSymbolPin schCreateSymbolShape schCreateWire schCreateWireLabel schDelete schDeleteIndex schDeleteSheet schDeselectAllFig schDirectEdit schDrawSymbolPin schEditPinOrder schEditSheetSize schExistsEditCap schExtendSelSet schExtendSelectPt schExtractConn schExtractStatus schGetBundleDisplayMode schGetCellViewListInSearchScope schGetCheckGroups schGetEnv schGetMatchingObjects schGetPinOrder schGetPostCheckTriggers schGetPreCheckTriggers schGetSignalTypeIntegrity schGetWireColor schGetWireLineStyle schGlueLabel schHDLReturn schHdlPrintFile schHdlPrintVars schHiAbout schHiAddCPFNetSets schHiAlternateView schHiCellViewProperty schHiChangeEditMode schHiCheck schHiCheckAndSave schHiCheckHier schHiCloneSymbol schHiComputePinRef schHiCopy schHiCreateBlockInst schHiCreateInst schHiCreateInstBox schHiCreateKanjiSymbol schHiCreateMappingSchematic schHiCreateNetExpression schHiCreateNoteLabel schHiCreateNoteShape schHiCreatePatchcord schHiCreatePin schHiCreateSheet schHiCreateSymbolLabel schHiCreateSymbolPin schHiCreateSymbolShape schHiCreateWire schHiCreateWireLabel schHiCreateWireStubs schHiDefaultAction schHiDelete schHiDeleteIndex schHiDeleteSheet schHiDescend schHiDescendEdit schHiDescendRead schHiDisplayOptions schHiDrawSymbolPin schHiEditInPlace schHiEditPinOrder schHiEditSheetSize schHiEditText schHiEditTitleBlock schHiEditorOptions schHiEnvSaveLoad schHiExtractConn schHiFind schHiFindMarker schHiFollowPin schHiFontUpdate schHiGotoSheet schHiGridOptions schHiHiliteLabel schHiInstToView schHiMousePopUp schHiMove schHiNetExprAvailProps schHiNetExprEvalNames schHiNewCellView schHiObjectProperty schHiOpenCellView schHiOpenOtherView schHiOpenSymbolOrSchematicView schHiPinListToView schHiPlot schHiPlotQueueStatus schHiRegisterWireStubs schHiRemoveCPFNetSets schHiRenumberAllSheet schHiRenumberInstances schHiRenumberSheet schHiReplace schHiResetInvisibleLabels schHiReturn schHiReturnToTop schHiRotate schHiRouteFlightLine schHiSRC schHiSaveCellView schHiSelectAll schHiSelectByProperty schHiSetSymbolOrigin schHiShowScope schHiSolder schHiStretch schHiSymStretch schHiTree schHiUpdatePinOrder schHiUpdatePinsFromView schHiVHDLProperty schHiVIC schHiVICAndSave schHiViewToView schHiZoomToSelSet schInhConFind schInhConSet schInstToView schInstallHDL schIsHDLCapEnabled schIsIndexCV schIsSchEditOk schIsSheetCV schIsSymEditOk schIsTextEditable schIsViewCapEnabled schIsWireLabel schLayoutToPinList schMouseApplyOrFinish schMove schNetExprAvailProps schNetExprEvalNames schPinListToSchem schPinListToSchemGen schPinListToSymbol schPinListToSymbolGen schPinListToVerilog schPinListToView schPlot schRegPostCheckTrigger schRegPreCheckTrigger schRegisterCheckGroup schRegisterCheckRule schRegisterFixedMenu schRegisterPopUpMenu schRenumberAllSheet schRenumberInstances schRenumberSheet schReplaceProperty schReportCheckFailure schSRC schSaveCurrentPlotOptions schSchemToPinList schSelectAllFig schSelectPoint schSetAndLoadTsgTemplateType schSetBundleDisplayMode schSetCmdOption schSetEnv schSetSelectOptions schSetSignalTypeIntegrity schSetSymbolOrigin schSetTextDisplayBBox schSetWireColor schSetWireLineStyle schShiftCmdOption schSingleSelectBox schSingleSelectPt schSnapToConn schSolder schStretch schSubSelectBox schSymbolToPinList schSync schUnregPostCheckTrigger schUnregPreCheckTrigger schUnregisterFixedMenu schUnregisterPopUpMenu schUpdateUserSRCErrorAndWarn schVIC schVerilogToPinList schViewToView schZoomFit schemeTopLevelEnv selectResult set setContext setCurrentWindow setDevCheckOptions setFnWriteProtect setPrompts setSG setSaveContextVersion setShellEnvVar setSkillPath setSlotValue setVarWriteProtect setarray setcar setcdr setf setf_arrayref setf_bottomEdge setf_caaar setf_caadr setf_caar setf_cadar setf_caddr setf_cadr setf_car setf_cdaar setf_cdadr setf_cdar setf_cddar setf_cdddr setf_cddr setf_cdr setf_get setf_getSG setf_getSGq setf_getShellEnvVar setf_getd setf_getq setf_last setf_leftEdge setf_lowerLeft setf_nth setf_nthcdr setf_nthedr setf_nthelem setf_rightEdge setf_slotValue setf_topEdge setf_upperRight setf_xCoord setf_yCoord setguard setof setofs setplist setq setqbitfield setqbitfield1 settlingTime setup sevAboutTool sevActivateSelectedAnas sevActiveSelectedAna sevAddExpression sevAddMenuItemLists sevAnnotateResults sevBALMTool sevBPMTool sevChangeOutsOnSchematic sevChooseDesign sevChooseEnvironmentOptions sevChooseSimulator sevChooseTemperature sevCircuitCond sevConvergence sevCopyCellViewVariables sevCopyVariablesToCellView sevCornersTool sevCreateMainWindow sevDebug sevDeleteResults sevDeleteSelectedAnas sevDeleteSelectedOuts sevDeleteSelectedSubckts sevDeleteSelectedVars sevDeleteSelections sevDevChecking sevDirectPlotMenu sevDisplayViolations sevEditModels sevEditOptions sevEditPlottingOptions sevEditSelectedAnas sevEditSelectedOuts sevEditSelectedVars sevEditSimulationFile sevEditStimulus sevEnvironment sevEvaluateAndPlotExpressions sevExportOutputsToCSV sevExportOutputsToFile sevExportOutputsToTxt sevFindSelectedVars sevGetExpressions sevIcon sevImportOutputsFromCSV sevImportOutputsFromFile sevImportOutputsFromTxt sevInvokeNCBrowse sevInvokeSimvision sevInvokeSimvisionDebugger sevIsContinuable sevKmodelTool sevLMGTool sevLoadState sevMTSMode sevMTSOptions sevMenuItems sevMonteCarloTool sevMpuTool sevNetlistAndDebug sevNetlistAndRun sevNetlistFile sevNoAnaSelections sevNoDesign sevNoEnvironment sevNoLog sevNoOutSelections sevNoOutputLog sevNoPlottableExpressions sevNoPlottableOutputs sevNoPlottableSignals sevNoResults sevNoVarSelections sevNoViolationsFound sevNonActiveSelectedAna sevNonMixedSignal sevOpenCalculator sevOpenDRLBrowser sevOpenEncap sevOpenJobMonitor sevOpenPlotWindow sevOpenPrintWindow sevOpenSchematic sevOptimizationTool sevPCMTool sevPKGTool sevParametricTool sevParasiticsDisplayed sevParasiticsNotDisplayed sevPlotAllOutputs sevPlotSignals sevPrintResults sevQuit sevReset sevReturnVariablesWithEmptyValues sevRun sevRunEngine sevSaveOceanScript sevSaveOptions sevSaveResults sevSaveState sevSelectResults sevSession sevSetConnectModules sevSetEngineOptions sevSetMTSMode sevSetMainWindowPulldownMenus sevSetMenuItemLists sevSetPropertyForSelectedOuts sevSetSchematicPulldownMenus sevSetSimDataDir sevSetSolver sevSetTopSaveDir sevSetTypeInWindowPulldownMenus sevSetupSimulationFiles sevSetupStimuli sevSimulator sevStartSession sevStopEngine sevTopSaveDir sevViewCompilerLog sevViewElabLog sevViewNcVerilogLog sevViewNetlisterLog sevViewSimLog sevViewSimulatorOutput sevWhatsNew sh shadow shadowImport sharedInitialize shell simAddProbeCapByName simAddProbeCapByScreen simAddProbeCapForBusBit simCheckExist simCheckHeader simCheckVariables simCheckViewConfig simCleanRun simDateStamp simDeleteRunDirFile simDesignVarCdsNameExtName simDesignVarExtNameCdsName simDrain simEditFileWithName simExecute simFindFile simFlattenWithArgs simGetLoginName simGetTermList simIfNoProcedure simIlSleep simInWithArgs simInitControl simInitEnv simInitEnvWithArgs simInitRaw simInitRunDir simInitSimulator simInstCdsNameExtName simInstExtNameCdsName simJobMonitor simLoadNetlisterFiles simLoadSimulatorFiles simNetCdsNameExtName simNetExtNameCdsName simNetlistWithArgs simNoNetlist simOutWithArgs simPostNameConvert simPreNameConvert simPrintEnvironment simPrintError simPrintErrorLine simPrintMessage simPrintTermList simReadNetCapFile simRep simRunDirInfile simRunDirLoad simRunDirOutfile simRunNetAndSim simRunNetAndSimWithArgs simRunNetAndSimWithCmd simSetDef simSetDefWithNoWarn simStringsToList simSubProbeCapByName simSubProbeCapByScreen simVertToHoriz simViewFileWithArgs simWaveOpen simin simout simplifyFilename simulator sin sinh skDisableMessage skDisableMessageBlock skEnableMessageBlock skIgnoreMessage skTabulate skTabulateSKILL skUnignoreMessage skillDebugger skillDevStatus sklint slewRate slewrate slotBoundp slotUnbound slotValue smgStart soiEnableDrcDfm solver sort sortcar sp spcinGuiDisplay spectralPower spectrumMeas spectrumMeas spectrumMeasurement spm sprintf sqrt srandom ssb sscanf sstatus stacktrace startFinder status stddev step stepend stepout stimulusFile store strcat strcmp stringToFunction stringToSymbol stringToTime stringp strlen strncat strncmp strpbrk sub1 subclassesOf subclassp subst substring superclassesOf suspendJob sweepNames sweepValues sweepVarValues swindow swindowp sxtd symbolToString symbolp symeval symstrp system tableToList tablep tailp tan tangent tanh tcDisplayAttachTechForm tcDisplayCompTechForm tcDisplayDiscardTechForm tcDisplayDumpTechForm tcDisplayLoadTechForm tcDisplayNewTechForm tcDisplaySaveTechForm tcDisplayTechGraphForm tcDumpTechFile tcLoadTechFile tcNewLibDisplayRefTechForm tcQcInstallDevices tcRegPostDumpTrigger tcRegPostLoadTrigger tcRegPostSetRefTrigger tcRegPreDumpTrigger tcRegPreLoadTrigger tcUnregPostDumpTrigger tcUnregPostLoadTrigger tcUnregPostSetRefTrigger tcUnregPreDumpTrigger tcUnregPreLoadTrigger tconc techBindTechFile techCloseTechFile techCopyTechFile techCreateArraySiteDef techCreateCustomViaDef techCreateCustomViaDefByName techCreateCustomViaVariant techCreateDerivedLayer techCreateElectricalRuleTable techCreateLP techCreateLayer techCreatePurpose techCreatePurposeDef techCreateScalarSiteDef techCreateSnapPatternDef techCreateSpacingRuleTable techCreateStdViaDef techCreateStdViaVariant techCreateViaSpec techDeleteDeviceClass techDeleteLP techDeleteLayer techDeletePurpose techDeletePurposeDef techDeleteSiteDef techDeleteTechFile techDeleteTechLibName techDeleteTwoLayerProp techDeleteViaDef techDeleteViaSpec techFindLayer techFindPurposeDef techFindSiteDefByName techFindSnapPatternDefByLP techFindSnapPatternDefByName techFindViaDefByName techFindViaSpec techFindViaVariantByName techGetCellViewSiteDefs techGetCurrentDensityRuleTable techGetCurrentDensityRuleTables techGetCurrentDensityRules techGetDBUPerUU techGetDefaultTechName techGetDerivedLayer techGetDeviceCParam techGetDeviceCellView techGetDeviceClass techGetDeviceClassProp techGetDeviceClassViewList techGetDeviceFParam techGetDeviceInClass techGetDeviceProp techGetDeviceTechFile techGetElectricalRule techGetElectricalRuleTable techGetElectricalRuleTableEntry techGetElectricalRuleTables techGetElectricalRules techGetEquivLayers techGetExtractCAP techGetExtractDIODE techGetExtractDevices techGetExtractMOS techGetExtractRES techGetInstDeviceClass techGetIntegrationColorModel techGetLP techGetLPAttr techGetLPPacketName techGetLPPriorityInContext techGetLabelLayers techGetLayerAbbrev techGetLayerFunction techGetLayerFunctions techGetLayerMaskNumber techGetLayerMfgResolution techGetLayerMfgResolutions techGetLayerName techGetLayerNum techGetLayerNumColorMasks techGetLayerProp techGetLayerRoutingDirections techGetLayerRoutingGrid techGetLayerRoutingGrids techGetLeLswLayers techGetLxExtractLayers techGetLxNoOverlapLayers techGetMPPTemplateByName techGetMPPTemplateNames techGetMfgGridResolution techGetOpenTechFiles techGetOrderedElectricalRule techGetOrderedElectricalRules techGetOrderedSpacingRule techGetOrderedSpacingRules techGetOuterViaLayers techGetParam techGetParams techGetPermission techGetPermissions techGetPrGenViaParams techGetPrGenViaRules techGetPrMastersliceLayers techGetPrNonDefaultParams techGetPrNonDefaultRules techGetPrRoutingDirection techGetPrRoutingLayers techGetPrRoutingOffset techGetPrRoutingPitch techGetPrStackVias techGetPrViaParams techGetPrViaRules techGetPrViaType techGetPrViaTypes techGetPurposeAbbrev techGetPurposeName techGetPurposeNum techGetSpacingRule techGetSpacingRuleTable techGetSpacingRuleTableEntry techGetSpacingRuleTables techGetSpacingRules techGetStampLabelLayers techGetStdViaDefCutColoring techGetTechCutColoring techGetTechFile techGetTechFileDdId techGetTechFileName techGetTechLibName techGetTimeStamp techGetTrimLayerPairs techGetTwoLayerProp techGetUserUnit techGetViaLayers techGetViaSpecTableEntries techGetViaSpecTableEntriesByName techGetViaSpecTableEntry techGetViaStackLimit techGetViaStackLimits techGetViewTypeUnits techIsDBUPerUUSet techIsDevice techIsLPValidBase techIsLeLswLayer techIsLxExtractLayer techIsLxNoOverlapLayer techIsMfgGridResolutionSet techIsPrMastersliceLayer techIsPrRoutingLayer techIsPrStackVia techIsPrViaDevice techIsReadPermission techIsStdViaDefCutColoringSet techIsUserUnitSet techIsViaLayer techMakeVirtuosoIccInfo techManagerOpenDisplayToolBox techManagerOpenTechToolBox techManagerToolBox techOpenDefaultTechFile techOpenTechFile techPurgeTechFile techRefreshTechFile techReopenTechFile techSaveTechFile techSetDBUPerUU techSetDeviceClassProp techSetDeviceProp techSetElectricalRule techSetElectricalRuleTableEntry techSetEquivLayer techSetEquivLayers techSetEvaluate techSetExtractCAP techSetExtractDIODE techSetExtractMOS techSetExtractRES techSetIntegrationColorModel techSetLPAttr techSetLPPacketName techSetLPPriorityInContext techSetLabelLayer techSetLabelLayers techSetLayerAbbrev techSetLayerFunction techSetLayerFunctions techSetLayerMaskNumber techSetLayerMfgResolution techSetLayerMfgResolutions techSetLayerName techSetLayerNumColorMasks techSetLayerProp techSetLayerRoutingGrid techSetLayerRoutingGrids techSetLeLswLayer techSetLeLswLayers techSetLxExtractLayer techSetLxExtractLayers techSetLxNoOverlapLayer techSetLxNoOverlapLayers techSetMPPTemplate techSetMfgGridResolution techSetOrderedElectricalRule techSetOrderedSpacingRule techSetParam techSetPrGenViaRule techSetPrMastersliceLayer techSetPrMastersliceLayers techSetPrNonDefaultRule techSetPrRoutingLayer techSetPrRoutingLayers techSetPrRoutingOffset techSetPrRoutingPitch techSetPrStackVia techSetPrStackVias techSetPrViaRule techSetPrViaType techSetPrViaTypes techSetPrecision techSetPurposeAbbrev techSetPurposeName techSetReadPermission techSetReadWritePermission techSetSpacingRule techSetSpacingRuleTableEntry techSetStampLabelLayer techSetStampLabelLayers techSetStdViaDefCutColoring techSetTechCutColoring techSetTechLibName techSetTimeStamp techSetTwoLayerProp techSetUserUnit techSetViaDefResistancePerCut techSetViaSpecTableEntry techSetViaStackLimit techSetViaStackLimits techTruncateTechFile techUnattachTechFile techVerifyTechFileId temp textFontMap thd theEnvironment throw timeToString timeToTm times tmToTime tokenPrintCapabilities topEdge toplevel totalNoise tracef tracelevlimit tracelevunlimit tracep tracev tran transCdlOutDisplay treeSaveHierarchy treeSaveScreen truename truncate tsg type typep unalias unbreakpt unbreakptMethod uncount undrawEnterFun unimportSymbol uninstallDebugger unityGainFreq unless unprofile unsetShellEnvVar untrace untracep untracev unuseNamespace unwatch unwindProtect updateDependent updateInstanceForDifferentClass updateInstanceForRedefinedClass updateReturnPopupMenuItem upperCase upperRight useNamespace userAppTrigger userMenuTrigger userPostInstallTriggers v value vcdFile vcdInfoFile vcpfeCreateEstimatedRows vcpfePlaceConstraintGroup vcpfeRunCustomDigitalPlacer vdb vdrCreateVoltageLabel vdrCreateVoltageLabelOnNets vdrDeleteLabels vdrGenerateLabelsGUI vecFile vector vectorToList vectorp vfoAbut vfoAllocateProtocolObj vfoAllocateShapeData vfoChopInstance vfoConvertToPolygon vfoCreateObstruction vfoCreateShapeData vfoDeleteObstruction vfoDrawFluidShape vfoGRCreateDeviceClass vfoGRGeometry vfoGRGetCommonQPtr vfoGRGetCreateFormFieldProp vfoGRGetCreateFormIdentifier vfoGRGetCreateFormPointer vfoGRGetExtraArgument vfoGRGetQueuePointer vfoGRMaximizeShapes vfoGRNewCreateForm vfoGRRegCreateFormUpdateCallback vfoGRSetCreateFormAllFieldsInvisible vfoGRSetCreateFormFieldProp vfoGRSetExtraArgument vfoGRSmoothen vfoGetDeviceClassParam vfoGetDeviceFormalParam vfoGetFileListWithLoadSequence vfoGetImplementationClassName vfoGetParam vfoGetProtocolClassName vfoGetVersion vfoGrCreateCDF vfoInstallFluidDeviceFiles vfoMergeInstances vfoReInstallAllFluidGuardRingDevices vfoReInstallGuardRingDevice vfoSetParam vfoSetParams vfoSetProtocolClassName vfoSfDraw vfoSfFinalize vfoSfInitialize vfoSfOuterEdgeCornerContRemoval vfoSmoothen vfoSupportsAbut? vfoSupportsChop? vfoSupportsConvertToPolygon? vfoSupportsCreateObstruction? vfoSupportsDeleteObstruction? vfoSupportsMerge? vfoSupportsUpdateModelShape? vfoTransformFluidShape vfoUpdateModelShape vfpAlignPins vfpCPHGenPhysicalHier vfpCPHGenPhysicalHierNoPropFile vfpCPHLoadFloorplanFile vfpCreateBoundaryPinsForSelectedShapes vfpHiPushPreRoutesDown vfpLoadPhysicalView vfpPinConnectivitySetting vfpPushPreRoutesDown vfpReportIOPadLocation vfpSbDefineObstruction vfpSbDeleteObstruction vfpSbEditIOPin vfpSbEditSoftBlockType vfpSbSetPolygonalBoundary vfpSbSetRectangularBoundary vfreq vh vhdlHiImport vhdlHiInvokeToolBox vhdlImport vhdlPinListToVHDL vhdlRegisterSimulator vhdlToPinList vhmsCompilationFailure vhmsDefaultEdit vhmsGetCellParameters vhmsPinListToVHDLAMS vhmsSaveFile vhmsSymbolToPinListGen vhmsToPinList vhmsUpdateCellCDFParams vi viaRegisterCreateViaInitCallback viaRegisterPostViaEngineCallback viaRegisterPreViaEngineCallback viaSetDefaultCutClasses viaUnregisterCreateViaInitCallback viaUnregisterPostViaEngineCallback viaUnregisterPreViaEngineCallback vicOpenVlogCallBack view vii vil vim vivaInitBindkeys vm vmsUpdateCellViews vosHiDisplayNetlist vosLaunchIrunSimulation vp vpaOptimizePins vr vsaDbType vsaDefVariable vsaEMGetQRCDirAndRunName vsaEMGetSimDirAndAnalysisType vsaEMInitUserCallBack vsaEMUserCallBack vsaError vsaGetNode vsaGetR vsaGetVariable vsaIRGetSimDirAndAnalysisType vsaIRUserCallBack vsaNetlistProc vsaNodeGetIR vsaRegisterEMDataFile vsaRegisterLayerMapFile vsaRegisterQrcTechFile vsaResGetIavg vsaResGetIpeak vsaResGetIrms vsaResGetLayer vsaResGetX vsaResGetY vsaWarn vswr vtime vvDisplayBrowser vvDisplayCalculator wait warn watch waveVsWave weCWHoldWidth weGatherBusWires weGetPathSegWidth weHiEditBus weScaleMagnifierOrDecreaseWidth weScaleMagnifierOrIncreaseWidth weScrollOrCycleDownWireViaAlignment weScrollOrCycleUpWireViaAlignment weSetPathSegWidth when where whereIs which while window windowp write writeTable wtypep xCoord xLimit xcons xdifference xmax xmin xoasInDoTranslate xoasInGetField xoasInSetField xoasOutDoTranslate xoasOutGetField xoasOutSetField xoasisInOnCancel xoasisInOnCompletion xoasisInOnTranslate xoasisOutOnCancel xoasisOutOnCompletion xoasisOutOnTranslate xor xpcDumpCache xpcEnableExpressPcell xplus xquotient xstGetField xstInDoTranslate xstInGetField xstInGetVMLibs xstInOnCancel xstInOnCompletion xstInOnTranslate xstInSaveVMLib xstInSetField xstOutDoTranslate xstOutOnCancel xstOutOnCompletion xstOutOnTranslate xstSetField xtimes xval yCoord yLimit ymax ymin ypm zerop zm zpm zref zxtd");
    var indentKeys = makeKeywords("then else");
    var atomKeys = makeKeywords("t nil");

    function stateStack(indent, type, prev) { // represents a state stack object
        this.indent = indent;
        this.type = type;
        this.prev = prev;
    }

    function pushStack(state, indent, type) {
        state.indentStack = new stateStack(indent, type, state.indentStack);
    }

    function popStack(state) {
        state.indentStack = state.indentStack.prev;
    }

    return {
        startState: function () {
            return {
                indentStack: null,
                indentation: 0,
                multiline: false
            };
        },

        token: function (stream, state) {
            if (state.indentStack == null && stream.sol()) {
                // update indentation, but only if indentStack is empty
                state.indentation = stream.indentation();
            }

            // skip spaces
            if (stream.eatSpace()) {
                return null;
            }
            var returnType = null;
            var ch = stream.next();

            if (state.multiline){
                if(ch == "*" && stream.peek() == "/"){
                    state.multiline = false;
                    stream.next();
                }
                returnType = COMMENT;
            }else if (ch == "\"") {
                var next, escaped = false;
                while ((next = stream.next()) != null) {
                    if (next == "\"" && !escaped) {
                        break;
                    }
                    escaped = !escaped && next == "\\";
                }
                returnType = STRING;
            }else if (ch == "/") {
                if(stream.peek() == "*"){
                    state.multiline = true;
                    stream.next();
                    returnType = COMMENT;
                }else{
                    returnType = "operator";
                }
            }else if (ch == ";") {
                stream.skipToEnd();
                returnType = COMMENT;
            }else if (ch == "'") {
                if(!stream.eatWhile(/\w/)){  // 'symbol
                    stream.eatWhile(/[^\)]/);  // '(...)
                    stream.next();
                }
                returnType = ATOM;
            }else if (ch == "?") {
                stream.eatWhile(/\w/);
                returnType = "operator";
            }else if (/\d/.test(ch)) {
                stream.eatWhile(/[\d\.]/);
                returnType = NUMBER;
            }else if (isOperatorChar.test(ch)) {
                stream.eatWhile(isOperatorChar);
                returnType = "operator";
            }else if (ch == "(" || ch == "[" || ch == "{") {
                returnType = BRACKET;
                pushStack(state, stream.column() + 1, ch);
            } else if (ch == ")" || ch == "]" || ch == "}") {
                returnType = BRACKET;
                if (state.indentStack != null && state.indentStack.type == (ch == ")" ? "(" : (ch == "]" ? "[" : "{"))) {
                    popStack(state);
                }
            }else {
                stream.eatWhile(/\w/);
                if (keywords && keywords.propertyIsEnumerable(stream.current())) {
                    returnType = BUILTIN;
                } else if (atomKeys && atomKeys.propertyIsEnumerable(stream.current())) {
                    returnType = ATOM;
                } else if (indentKeys && indentKeys.propertyIsEnumerable(stream.current())) {
                    returnType = BUILTIN;
                } else returnType = "variable";
            }
            return returnType;
        },

        indent: function (state, textAfter) {
            var offset = 0;
            if(/^[\)\]\}]/.test(textAfter)){
                offset = -1;
            }

            for(var val of Object.keys(indentKeys)){
                var _regex = RegExp("^" + val);
                if(_regex.test(textAfter)){
                    offset = state.indentStack.prev.indent - state.indentStack.indent;
                    break;
                }
            }

            if (state.indentStack == null) return state.indentation + offset;
            return state.indentStack.indent + offset;
        },

        closeBrackets: {pairs: "()[]{}\"\""},
        blockCommentStart: "/*",
        blockCommentEnd: "*/",
        lineComment: ";",
        fold: "brace"
    };
});

CodeMirror.defineMIME("text/x-skill", {name: "Skill", mime: "text/x-skill", mode: "skill", ext: [".il"]});
});
