import requests, json, os
try:
    from urllib.parse import urlencode
except ImportError:
    from urllib import urlencode

from tornado import gen
from tornado.httpclient import AsyncHTTPClient, HTTPRequest

NO_DETAILS = "No details"
TORNADO_CLIENT_TIMEOUT_SEC = 24 * 3600.0

def _get_error_message(err_data):
    json_err = json.loads(err_data)
    if "detailedMessage" in json_err:
        return json_err["detailedMessage"]
    if "message" in json_err:
        return json_err["message"]
    return NO_DETAILS


@gen.coroutine
def async_pintercom_json_post(path, data):
    with open('%s/run/shared-secret.txt' % os.getenv("DIP_HOME"), 'r') as fp:
        secret = fp.read()
        secret = secret.strip()
    # force_instance avoids use of the instance cache
    # Also typically avoids AsyncHTTPClient(defaults={"connect_timeout" : 1}) is AsyncHTTPClient(defaults={"connect_timeout" : 5})
    client = AsyncHTTPClient(force_instance=True, defaults={
        "connect_timeout": TORNADO_CLIENT_TIMEOUT_SEC,
        "request_timeout": TORNADO_CLIENT_TIMEOUT_SEC
    })
    port = os.getenv('DKU_BACKEND_PORT')
    resp = yield client.fetch(
        HTTPRequest(
            url="http://127.0.0.1:%s/dip/api/pintercom/%s" % (port, path),
            method="POST",
            body=urlencode(data),
            headers={
                "X-DKU-IPythonSharedSecret": secret,
            }
        ),
        raise_error=False,
    )
    if resp.code == 200 or resp.code == 204:
        res = None
        if len(resp.body) > 0:
            res = json.loads(resp.body)
        client.close()
        raise gen.Return(res)
    err_msg = NO_DETAILS
    if resp.body:
        try:
            err_msg = _get_error_message(resp.body).encode("utf8")
        except Exception:
            pass
    if resp.error and hasattr(resp.error, "message") and resp.error.message:
        # enrich with base error message: typically 'Not found' (for 404) or 'Timeout during request'
        err_msg = "%s, %s" % (resp.error.message, err_msg)
    client.close()
    raise Exception("Failed privileged call (%s): %s" % (path, err_msg))


def pintercom_json_post(path, data, file = None):
    with open('%s/run/shared-secret.txt' % os.getenv("DIP_HOME"), 'r') as fp:
        secret = fp.read()
        secret = secret.strip()
    port = os.getenv('DKU_BACKEND_PORT')
    if file:
        resp = requests.post(
            "http://127.0.0.1:%s/dip/api/pintercom/%s" % (port, path), data,
            headers = {"X-DKU-IPythonSharedSecret": secret},
            files = dict(notebook = file))
    else:
        resp = requests.post(
            "http://127.0.0.1:%s/dip/api/pintercom/%s" % (port, path), data,
            headers = {"X-DKU-IPythonSharedSecret": secret})
    if resp.status_code==200 or resp.status_code == 204:
        if len(resp.text) > 0:
            return json.loads(resp.text)
        else:
            return None
    else:
        err_data = resp.text
        if err_data:
            raise Exception("Failed privileged call (%s): %s" % (path, _get_error_message(err_data).encode("utf8")))
        else:
            raise Exception("Failed privileged call (%s): %s" % (path, NO_DETAILS))

def tintercom_json_post(path, ticket, data):
    port = os.getenv('DKU_BACKEND_PORT')
    resp = requests.post(
        "http://127.0.0.1:%s/dip/api/tintercom/%s" % (port, path), data,
        headers = {"X-DKU-APITicket": ticket})
    if resp.status_code==200 or resp.status_code == 204:
        return json.loads(resp.text)
    else:
        err_data = resp.text
        if err_data:
            raise Exception("Failed privileged call (%s): %s" % (path, _get_error_message(err_data).encode("utf8")))
        else:
            raise Exception("Failed privileged call (%s): %s" % (path, NO_DETAILS))

cached_session = requests.Session()

def authinfo_json_post(headers_dict):
    port = os.getenv('DKU_BACKEND_PORT')
    resp = cached_session.post(
        "http://127.0.0.1:%s/dip/publicapi/auth/info-from-browser-headers" % (port),
        data=json.dumps(headers_dict),
        params={"callOrigin" : "jupyter-server"})

    if resp.status_code==200 or resp.status_code == 204:
        return json.loads(resp.text)
    else:
        err_data = resp.text
        if err_data:
            raise Exception("Failed auth-info call: %s" % (_get_error_message(err_data).encode("utf8")))
        else:
            raise Exception("Failed auth-info call: %s" % (NO_DETAILS))