(function() {
    'use strict';

    const columnsForComputation = {
        templateUrl: 'static/dataiku/auto-feature-generation/columns-for-computation/columns-for-computation.component.html',
        bindings: {
            dataset: '<',
            computablesMap: '<',
            virtualInputs: '=',
            columnsData: "<",
            onToggle: "<",
            isLastDataset: '<',
            onColumnChange: '<',
            relationships : '<'
        },
        controller: function(AutoFeatureGenerationRecipeService) {
            const $ctrl = this;
            $ctrl.$onInit = () => {
                $ctrl.datasetId = $ctrl.dataset.id;
                $ctrl.datasetLabel = $ctrl.dataset.name;
                $ctrl.virtualInputsIndexes = AutoFeatureGenerationRecipeService.getMatchedVirtualInputs($ctrl.datasetId, $ctrl.virtualInputs);
                $ctrl.isPrimaryDataset = $ctrl.virtualInputsIndexes.includes(0);
                $ctrl.columns = AutoFeatureGenerationRecipeService.getColumns($ctrl.dataset.name, $ctrl.computablesMap);

                $ctrl.isOpen = $ctrl.columnsData && "isSectionOpen" in $ctrl.columnsData ? $ctrl.columnsData.isSectionOpen : true;
                const editedColumns = $ctrl.columnsData && "selectedColumns" in $ctrl.columnsData ? $ctrl.columnsData.selectedColumns : [];

                if (editedColumns && editedColumns.length > 0) {
                    $ctrl.allColumns = editedColumns;
                } else {
                    const savedColumns = AutoFeatureGenerationRecipeService.retrieveSavedColumns($ctrl.virtualInputsIndexes, $ctrl.virtualInputs);
                    $ctrl.allColumns = angular.copy($ctrl.columns.map(function(column) {
                        return AutoFeatureGenerationRecipeService.initialiseColumn(column, savedColumns);
                    }));
                }

                $ctrl.supportedVariableTypes = AutoFeatureGenerationRecipeService.SUPPORTED_VARIABLE_TYPES;

                $ctrl.VARIABLE_TYPES = AutoFeatureGenerationRecipeService.VARIABLE_TYPES;
            };


            $ctrl.primaryDatasetDesc = AutoFeatureGenerationRecipeService.primaryDatasetDesc;

            $ctrl.joinKeyTooltip = AutoFeatureGenerationRecipeService.JOIN_KEY_TOOLTIP;

            $ctrl.isJoinKey = function(column) {
                for (const relationship of $ctrl.relationships) {
                    for (const condition of relationship.on) {
                        if (condition.column1.name === column.name && $ctrl.virtualInputsIndexes.includes(condition.column1.table)) {
                            return true;
                        }
                        if(condition.column2.name === column.name && $ctrl.virtualInputsIndexes.includes(condition.column2.table)) {
                            return true;
                        }
                    }
                }
                return false;
            }

            const getEnrichmentDatasetRelationshipsToPrimary = function(isPrimaryDataset) {
                let relationshipTypes = [];
                for(const relationship of $ctrl.relationships) {
                    if((relationship.table1===0 || relationship.table2===0) &&
                    !isPrimaryDataset &&
                    ($ctrl.virtualInputsIndexes.includes(relationship.table1) || $ctrl.virtualInputsIndexes.includes(relationship.table2)) &&
                    relationship.type) {
                        relationshipTypes.push(relationship.type);
                    }
                }
                return relationshipTypes;
            }

            $ctrl.displayDatasetHelp = function() {
                const enrichmentDatasetRelationshipsToPrimary = getEnrichmentDatasetRelationshipsToPrimary($ctrl.isPrimaryDataset);
                if (enrichmentDatasetRelationshipsToPrimary.filter(element => element!==AutoFeatureGenerationRecipeService.RELATIONSHIP_TYPES.ONE_TO_MANY).length>0) {
                    $ctrl.getDatasetHelpText(enrichmentDatasetRelationshipsToPrimary);
                    return true;
                } return false;
           }

            $ctrl.getDatasetHelpText = function(relationshipTypes) {
                if (relationshipTypes.includes(AutoFeatureGenerationRecipeService.RELATIONSHIP_TYPES.ONE_TO_ONE) && relationshipTypes.includes(AutoFeatureGenerationRecipeService.RELATIONSHIP_TYPES.MANY_TO_ONE)) {
                    $ctrl.datasetRelationshipInfo = "The primary dataset has a many-to-1 and a 1-to-1 relationship with this dataset; original values will also be retrieved for selected columns.";
                } else {
                    const relationshipTypesFiltered = relationshipTypes.filter(element => element!==AutoFeatureGenerationRecipeService.RELATIONSHIP_TYPES.ONE_TO_MANY);
                    if (relationshipTypesFiltered.length) {
                        $ctrl.datasetRelationshipInfo = "The primary dataset has a "+ AutoFeatureGenerationRecipeService.relationshipNumDesc[relationshipTypesFiltered[0]] + " relationship with this dataset; original values will also be retrieved for selected columns.";
                    }
                }
            }


            $ctrl.updateColumnsForComputation = function() {
                const columnsForComputations = [];
                for (let column of $ctrl.allColumns) {
                    if (column.$selected) {
                        columnsForComputations.push({
                            name: column.name,
                            variableType: column.variableType
                        })
                    }
                }
                for (let virtualIndex of $ctrl.virtualInputsIndexes) {
                    $ctrl.virtualInputs[virtualIndex].selectedColumns = columnsForComputations;
                }
                $ctrl.onColumnChange($ctrl.datasetId, $ctrl.allColumns);
            }

            $ctrl.countSelectedColumns = function() {
                let columnsCount = 0;
                for (let column of $ctrl.allColumns) {
                    if (column.$selected) {
                        columnsCount++;
                    }
                }
                return columnsCount;
            }

            $ctrl.isSchemaCompatibleWithVariableType = function(schemaType, variableType) {
                return AutoFeatureGenerationRecipeService.SCHEMA_TYPES_BY_VARIABLE_TYPE[variableType].includes(schemaType);
            }

            $ctrl.setVariableType = function(newVariableType, column) {
                column.variableType = newVariableType;
                if (column.$selected) {
                    for (let virtualIndex of $ctrl.virtualInputsIndexes) {
                        const columnIndex = AutoFeatureGenerationRecipeService.getColumnIndex(column, $ctrl.virtualInputs[virtualIndex]);
                        if (columnIndex >= 0) {
                            $ctrl.virtualInputs[virtualIndex].selectedColumns[columnIndex].variableType = newVariableType;
                        }
                    }
                }
                $ctrl.onColumnChange($ctrl.datasetId, $ctrl.allColumns);
            }

            $ctrl.isSelected = function(column, type) {
                return column.variableType === type;
            }

            $ctrl.computeColumnsListHeight = function() {
                return AutoFeatureGenerationRecipeService.computeListHeight($ctrl.allColumns, 8, 36);
            }

            $ctrl.toggleSection = function() {
                $ctrl.isOpen = !$ctrl.isOpen;
                $ctrl.onToggle($ctrl.datasetId);
            }
        },
    }

    angular.module('dataiku.autoFeatureGeneration')
        .component('columnsForComputation', columnsForComputation);
})();
