(function() {
    "use strict";

    const datasetModalBody = {
        bindings: {
            columnsTabData : '<',
            recipe: '<',
            currentUiState: '<',
            updateRecipeStatus: '<',
            params: '=',
            computablesMap: '<',
            dismiss: '<',
            tableOneIndex: '<',
            tableTwoIndex: '<',
            editTimeSettings: '<'
        },
        templateUrl: "static/dataiku/auto-feature-generation/dataset-modal/dataset-modal-body.component.html",
        controller: function afgDatasetModalBodyController(AutoFeatureGenerationRecipeService, DatasetUtils, DataikuAPI, $stateParams, PartitionDeps, $rootScope) {
            const ctrl = this;
            ctrl.$onInit = () => {
                ctrl.params.virtualInputs = ctrl.params.virtualInputs || [];
                ctrl.creation = !ctrl.params.virtualInputs || !ctrl.params.virtualInputs.length;
                ctrl.timeWindowUnits = AutoFeatureGenerationRecipeService.TIME_UNITS;
                ctrl.CUTOFF_TIME_MODE = AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE;
                ctrl.TIME_INDEX_MODE = AutoFeatureGenerationRecipeService.TIME_INDEX_MODE;
                ctrl.EMPTY_TIME_WINDOW = AutoFeatureGenerationRecipeService.EMPTY_TIME_WINDOW;
                ctrl.relationship = {
                    table1Index: ctrl.tableOneIndex || 0,
                    table2Index: ctrl.tableTwoIndex,
                    hasDateColumns: {},
                    timeIndexColumn2: ctrl.TIME_INDEX_MODE.EMPTY.name,
                    timeWindow: ctrl.EMPTY_TIME_WINDOW
                };
                ctrl.primaryDatasetName = AutoFeatureGenerationRecipeService.getDatasetName(0, ctrl.params.virtualInputs, ctrl.recipe.inputs);
                initTimeSettings();
                if (ctrl.editTimeSettings) {
                    initRelationshipForTimeSettingsEdition();
                }
                ctrl.dateColumnsFromPrimaryDataset = AutoFeatureGenerationRecipeService.getDateColumnsFromDataset(ctrl.primaryDatasetName, ctrl.computablesMap);
                ctrl.relationship.timeIndexColumn = AutoFeatureGenerationRecipeService.autoSelectDateColumn(ctrl.relationship.timeIndexColumn, ctrl.dateColumnsFromPrimaryDataset);
            };

            ctrl.primaryDatasetTooltip = AutoFeatureGenerationRecipeService.PRIMARY_DATASET_TOOLTIP;

            ctrl.enrichmentDatasetTooltip = AutoFeatureGenerationRecipeService.ENRICHMENT_DATASET_TOOLTIP;

            ctrl.cutoffTimeTooltip = AutoFeatureGenerationRecipeService.CUTOFF_TIME_TOOLTIP;

            const initRelationshipForTimeSettingsEdition = function() {
                ctrl.relationship.dataset2 = AutoFeatureGenerationRecipeService.getDatasetName(ctrl.tableTwoIndex, ctrl.params.virtualInputs, ctrl.recipe.inputs);
                ctrl.computeDateColumns(ctrl.relationship.dataset2);
                ctrl.relationship.timeIndexColumn2 = ctrl.params.virtualInputs[ctrl.tableTwoIndex].timeIndexColumn;
                ctrl.relationship.timeIndexMode = ctrl.relationship.timeIndexColumn2 ? AutoFeatureGenerationRecipeService.TIME_INDEX_MODE.DATE_COLUMN.name : AutoFeatureGenerationRecipeService.TIME_INDEX_MODE.DEFAULT.name;
                if (ctrl.params.virtualInputs[ctrl.tableTwoIndex].timeWindows && ctrl.params.virtualInputs[ctrl.tableTwoIndex].timeWindows.length) {
                   ctrl.relationship.timeWindow = {
                       from: ctrl.params.virtualInputs[ctrl.tableTwoIndex].timeWindows[0].from,
                       to: ctrl.params.virtualInputs[ctrl.tableTwoIndex].timeWindows[0].to,
                       unit: ctrl.params.virtualInputs[ctrl.tableTwoIndex].timeWindows[0].windowUnit
                   }
                }
            }

            ctrl.isCutoffTimeDate = function(cutoffTimeMode) {
                return AutoFeatureGenerationRecipeService.isCutoffTimeDate(cutoffTimeMode);
            }

            ctrl.isTimeIndexDate = function(timeIndexMode) {
                return AutoFeatureGenerationRecipeService.isTimeIndexDate(timeIndexMode);
            }

            ctrl.setCutoffTimeTooltip = function() {
                return AutoFeatureGenerationRecipeService.setCutoffTimeTooltip(ctrl.dateColumnsFromPrimaryDataset);
            }

            ctrl.setEnrichmentDatasetTooltip = function() {
                return AutoFeatureGenerationRecipeService.setEnrichmentTooltip(ctrl.currentCutoffTimeMode, ctrl.relationship.timeIndexColumn);
            }

            ctrl.setTimeWindowTooltip = function(){
                return AutoFeatureGenerationRecipeService.setTimeWindowTooltip(ctrl.relationship, ctrl.currentCutoffTimeMode, ctrl.editTimeSettings, ctrl.validDataset);
            }

            ctrl.setTimeIndexDateColumnTooltip = function() {
                return AutoFeatureGenerationRecipeService.setTimeIndexDateColumnTooltip(ctrl.relationship, ctrl.currentCutoffTimeMode);
            }

            ctrl.setTimeIndexNoneTooltip = function() {
                return AutoFeatureGenerationRecipeService.setTimeIndexNoneTooltip(ctrl.relationship, ctrl.currentCutoffTimeMode, ctrl.editTimeSettings ? true : ctrl.validDataset);
            }

            ctrl.getTitleForNewDatasetModal = function(relationship) {
                const virtualInputs = ctrl.params.virtualInputs;
                if (!ctrl.editTimeSettings) {
                    if ((relationship) && (relationship.table1Index !== undefined) && (virtualInputs.length !== 0)) {
                        return "Add an enrichment dataset to " + AutoFeatureGenerationRecipeService.getDatasetName(relationship.table1Index, virtualInputs, ctrl.recipe.inputs);
                    }
                    return "Add a primary dataset";
                }
                return "Edit time settings for " + AutoFeatureGenerationRecipeService.getDatasetName(relationship.table2Index, virtualInputs, ctrl.recipe.inputs);
            };

            const initTimeSettings = function() {
                if(ctrl.params.virtualInputs.length) {
                    const primaryDatasetName = AutoFeatureGenerationRecipeService.getDatasetName(0, ctrl.params.virtualInputs, ctrl.recipe.inputs);
                    if (!AutoFeatureGenerationRecipeService.getDateColumnsFromDataset(primaryDatasetName, ctrl.computablesMap).length) {
                        ctrl.currentCutoffTimeMode = AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE.DEFAULT.name;
                        ctrl.relationship.timeIndexColumn = AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE.EMPTY.name;
                    } else {
                        ctrl.currentCutoffTimeMode = ctrl.params.cutoffTime.mode;
                    }
                }
            }

            ctrl.isCutoffTimeShown = function () {
                return AutoFeatureGenerationRecipeService.isCutoffTimeShown(ctrl.params.virtualInputs.length, ctrl.params.cutoffTime.mode);
            }

            ctrl.getDatasetColorClass = function(datasetIndex) {
                return AutoFeatureGenerationRecipeService.getDatasetColorClass(datasetIndex);
            }

            ctrl.showAddTimeWindowButton = function() {
                return AutoFeatureGenerationRecipeService.showAddTimeWindowButton(ctrl.relationship.timeWindow);
            }
            ctrl.showTimeWindowSettings = function() {
                return AutoFeatureGenerationRecipeService.showTimeWindowSettings(ctrl.relationship);
            }
            ctrl.disableTimeIndex = function() {
                return AutoFeatureGenerationRecipeService.disableTimeIndex(ctrl.relationship, ctrl.currentCutoffTimeMode, ctrl.editTimeSettings ? true : ctrl.validDataset);
            }
            ctrl.isEnrichmentSelected = function() {
                return AutoFeatureGenerationRecipeService.isEnrichmentSelected(ctrl.relationship, ctrl.editTimeSettings ? true : ctrl.validDataset);
            }
            ctrl.disableEnrichmentDataset = function() {
                return AutoFeatureGenerationRecipeService.disableEnrichmentDataset(ctrl.currentCutoffTimeMode, ctrl.relationship);
            }
            ctrl.addTimeWindow = function() {
                ctrl.relationship.timeWindow = {
                    "from": AutoFeatureGenerationRecipeService.DEFAULT_TIME_WINDOW.from,
                    "to" : AutoFeatureGenerationRecipeService.DEFAULT_TIME_WINDOW.to,
                    "unit": AutoFeatureGenerationRecipeService.DEFAULT_TIME_WINDOW.unit
                }
            }

            ctrl.removeTimeWindow = function() {
                ctrl.relationship.timeWindow = ctrl.EMPTY_TIME_WINDOW;
            }
            ctrl.disableTimeWindow = function () {
                if (!ctrl.relationship.timeIndexColumn2 || !AutoFeatureGenerationRecipeService.isTimeIndexDate(ctrl.relationship.timeIndexMode)) {
                    ctrl.relationship.timeWindow = ctrl.EMPTY_TIME_WINDOW;
                    return true;
                }
                return false;
            }

            ctrl.getCutoffTimeValue = function() {
                if (ctrl.params.virtualInputs.length &&
                ctrl.params.virtualInputs[0].timeIndexColumn &&
                ctrl.params.virtualInputs[0].timeIndexColumn!==AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE.EMPTY.name) {
                    ctrl.relationship.timeIndexColumn = ctrl.params.virtualInputs[0].timeIndexColumn;
                    return ctrl.params.virtualInputs[0].timeIndexColumn;
                }
                return AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE.DEFAULT.label;
            }

            const contextProjectKey = ctrl.context && ctrl.context.projectKey ? ctrl.context.projectKey : $stateParams.projectKey;

            const updateTimeSettingsWithNewInput = function() {
                ctrl.params.cutoffTime.mode = ctrl.currentCutoffTimeMode || AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE.EMPTY.name;
                if (ctrl.params.cutoffTime.mode===AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE.DEFAULT.name) {
                    for (let i = 0; i<ctrl.params.virtualInputs.length; i++) {
                        ctrl.params.virtualInputs[i].timeIndexColumn = AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE.EMPTY.name;
                    }
                }
            }

            const getPayloadData = function() {
                if (!ctrl.params) return;
                return angular.toJson(ctrl.params);
            };

            const getRelationshipConditionSuggestions = function() {
                const payload = getPayloadData();
                const recipeSerialized = angular.copy(ctrl.recipe);
                PartitionDeps.prepareRecipeForSerialize(recipeSerialized);
                return DataikuAPI.flow.recipes.autofeaturegeneration.getSuggestions($stateParams.projectKey, recipeSerialized, payload)
                    .success(function(suggestions) {
                        AutoFeatureGenerationRecipeService.updateRelationship(ctrl.params.relationships[ctrl.params.relationships.length - 1], suggestions);
                    })
                    .error(setErrorInScope.bind(ctrl));
            };

            const updateParametersWithNewInput = function() {
                let columnsForComputation = [];
                const payload = getPayloadData();
                const recipeSerialized = angular.copy(ctrl.recipe);
                PartitionDeps.prepareRecipeForSerialize(recipeSerialized);
                DataikuAPI.flow.recipes.autofeaturegeneration.getDefaultColumns($stateParams.projectKey, ctrl.newDatasetName, recipeSerialized, payload)
                    .success(function(defaultColumns) {
                        columnsForComputation = defaultColumns;
                    })
                    .error(setErrorInScope.bind(ctrl))
                    .finally(function() {
                        AutoFeatureGenerationRecipeService.addNewDatasetToRecipe(ctrl.newDatasetName, ctrl.enrichmentDatasetIndex, ctrl.recipe, ctrl.params, ctrl.isCreation, columnsForComputation, ctrl.relationship);
                        if (ctrl.params.virtualInputs.length > 1) {
                            getRelationshipConditionSuggestions();
                        }
                        // Update recipe status to get new schema and any column limit warnings
                        ctrl.updateRecipeStatus();
                        const inputDatasets = ctrl.recipe.inputs.main.items;
                        AutoFeatureGenerationRecipeService.updateColumnSections(ctrl.columnsTabData, inputDatasets.length);
                        updateTimeSettingsWithNewInput();
                        ctrl.currentUiState.currentStep = 'dataRelationships';
                        closeModal();
                    })
            }

            const isPrimaryDatasetValid = function(datasetName) {
                if (datasetName in ctrl.computablesMap) {
                     DatasetUtils.updateDatasetInComputablesMap(ctrl, datasetName, $stateParams.projectKey, contextProjectKey)
                        //Retrieve the configuration of the enrichment dataset and store it in ctrl.computablesMap
                        .then(() => {
                            isDatasetValid(datasetName);
                        })
                } else {
                    ctrl.error = 'Dataset ' + datasetName + ' does not seem to exist, try reloading the page.';
                }
            }

            ctrl.addNewDataset = function() {
                ctrl.isCreation = ctrl.creation;
                ctrl.enrichmentDatasetIndex = ctrl.isCreation ? null : ctrl.relationship.table1Index;
                ctrl.newDatasetName = ctrl.isCreation ? ctrl.relationship.dataset1 : ctrl.relationship.dataset2;
                 if (ctrl.newDatasetName in ctrl.computablesMap) {
                    DatasetUtils.updateDatasetInComputablesMap(ctrl, ctrl.newDatasetName, $stateParams.projectKey, contextProjectKey)
                    //Retrieve the configuration of the enrichment dataset and store it in ctrl.computablesMap
                    .then(() => {
                        if (!isDatasetValid(ctrl.newDatasetName)) {
                            ctrl.validDataset = false;
                            ctrl.relationship.timeIndexMode = AutoFeatureGenerationRecipeService.TIME_INDEX_MODE.EMPTY.name;
                            return;
                        }
                        ctrl.validDataset = true;
                        updateParametersWithNewInput();
                    });
                    } else {
                    ctrl.error = 'Dataset ' + ctrl.newDatasetName + ' does not seem to exist, try reloading the page.';
                }
            }

            const allDateColumns = {};
            ctrl.computeDateColumns = function(datasetName) {
                if (datasetName in ctrl.computablesMap) {
                    DatasetUtils.updateDatasetInComputablesMap(ctrl, datasetName, $stateParams.projectKey, contextProjectKey)
                        //Retrieve the configuration of the enrichment dataset and store it in ctrl.computablesMap
                        .then(() => {
                            if (!isDatasetValid(datasetName)) {
                                ctrl.validDataset = false;
                                ctrl.relationship.timeIndexMode = AutoFeatureGenerationRecipeService.TIME_INDEX_MODE.EMPTY.name;
                                return;
                            }
                            ctrl.validDataset = true;
                            const datasetSchema = DatasetUtils.getSchemaFromComputablesMap(ctrl.computablesMap, datasetName);
                            const allColumns = datasetSchema && datasetSchema.columns ? datasetSchema.columns : [];
                            allDateColumns[datasetName] = AutoFeatureGenerationRecipeService.getDateColumns(allColumns);
                            ctrl.relationship.hasDateColumns[datasetName] = allDateColumns[datasetName].length;
                            if (!ctrl.relationship.hasDateColumns[ctrl.relationship.dataset2] && ctrl.isCutoffTimeDate(ctrl.currentCutoffTimeMode)) {
                                ctrl.relationship.timeIndexMode = AutoFeatureGenerationRecipeService.TIME_INDEX_MODE.DEFAULT.name;
                                ctrl.relationship.timeWindow = AutoFeatureGenerationRecipeService.EMPTY_TIME_WINDOW;
                            }
                        });
                } else {
                    ctrl.error = 'Dataset ' + datasetName + ' does not seem to exist, try reloading the page.';
                }
            }

            ctrl.updateTimeSettings = function() {
                if (ctrl.currentCutoffTimeMode === AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE.DEFAULT.name) {
                    if (ctrl.relationship.dataset2) {
                        ctrl.relationship.timeIndexMode = AutoFeatureGenerationRecipeService.TIME_INDEX_MODE.DEFAULT.name;
                    } else {
                        ctrl.relationship.timeIndexMode = AutoFeatureGenerationRecipeService.TIME_INDEX_MODE.EMPTY.name;
                    }
                    ctrl.relationship.timeWindow = AutoFeatureGenerationRecipeService.EMPTY_TIME_WINDOW;
                } else if (ctrl.isCutoffTimeDate(ctrl.currentCutoffTimeMode) &&
                           ctrl.relationship.timeIndexColumn &&
                           ctrl.relationship.dataset2 &&
                           ctrl.validDataset) {
                    ctrl.relationship.timeIndexMode = AutoFeatureGenerationRecipeService.TIME_INDEX_MODE.DEFAULT.name;
                    ctrl.relationship.timeWindow = AutoFeatureGenerationRecipeService.EMPTY_TIME_WINDOW;
                }
            }

            ctrl.getDateColumnsFrom = function(datasetName) {
                // Try to auto select each time the list of available date columns is updated (e.g. when selected dataset changed)
                ctrl.relationship.timeIndexColumn2 = AutoFeatureGenerationRecipeService.autoSelectDateColumn(ctrl.relationship.timeIndexColumn2, allDateColumns[datasetName]);
                return allDateColumns[datasetName];
            }

            ctrl.isRelationshipValid = function() {
                return AutoFeatureGenerationRecipeService.isNewAfgRelationshipValid(ctrl.relationship, ctrl.creation, ctrl.currentCutoffTimeMode) &&
                AutoFeatureGenerationRecipeService.isTimeWindowValid(ctrl.relationship.timeWindow);
            };

            ctrl.isNewTimeSettingsValid = function() {
                return AutoFeatureGenerationRecipeService.isEnrichmentTimeIndexColumnValid(ctrl.relationship) &&
                AutoFeatureGenerationRecipeService.isTimeWindowValid(ctrl.relationship.timeWindow);
            }

            ctrl.saveNewTimeSettings = function() {
                ctrl.params.virtualInputs[ctrl.tableTwoIndex].timeIndexColumn = ctrl.relationship.timeIndexMode === AutoFeatureGenerationRecipeService.TIME_INDEX_MODE.DEFAULT.name ?
                                                                                null :
                                                                                ctrl.relationship.timeIndexColumn2;
                ctrl.params.virtualInputs[ctrl.tableTwoIndex].timeWindows = ctrl.relationship.timeWindow ? updateTimeWindowParam() : [];
                ctrl.updateRecipeStatus();
                closeModal();
            }

            const updateTimeWindowParam = function() {
                return  [{ to: ctrl.relationship.timeWindow.to,
                           from: ctrl.relationship.timeWindow.from,
                           windowUnit: ctrl.relationship.timeWindow.unit}];
            }

            DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey, "generate_features").then(function(data) {
                const primaryDatasetName = AutoFeatureGenerationRecipeService.getDatasetName(0, ctrl.params.virtualInputs, ctrl.recipe.inputs);
                const outputDatasetName = AutoFeatureGenerationRecipeService.getOutputDatasetName(ctrl.recipe);
                const primaryDataset = ctrl.computablesMap[primaryDatasetName];

                ctrl.availablePrimaryDatasets = AutoFeatureGenerationRecipeService.checkDatasetsUsability(data[0], primaryDataset, outputDatasetName, ctrl.recipe, true);
                ctrl.availableEnrichmentDatasets = AutoFeatureGenerationRecipeService.checkDatasetsUsability(data[0], primaryDataset, outputDatasetName, ctrl.recipe, ($rootScope.appConfig && $rootScope.appConfig.sparkEnabled) ? $rootScope.appConfig.sparkEnabled : false);
            });

            const closeModal = function() {
                ctrl.dismiss();
            }

            const isDatasetValid = function(datasetName) {
                if (!datasetName) {
                    return false;
                }
                const computable = ctrl.computablesMap[datasetName];
                if (!computable) {
                    ctrl.error = 'Dataset ' + datasetName + ' does not seem to exist, try reloading the page.';
                    return false;
                }
                if (!computable.dataset) {
                    ctrl.error = datasetName + ' is not a dataset';
                    return false;
                }
                if (!computable.dataset.schema || !computable.dataset.schema.columns.length) {
                    ctrl.error = 'Dataset ' + datasetName + ' has an empty schema';
                    return false;
                }
                ctrl.error = null;
                return true;
            }

            let previousSelectedDataset1;
            let previousSelectedDataset2;
            ctrl.$doCheck = () => {
                if (ctrl.relationship.dataset2 !== previousSelectedDataset2) {
                    ctrl.computeDateColumns(ctrl.relationship.dataset2);
                    if (ctrl.currentCutoffTimeMode === AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE.DEFAULT.name && ctrl.relationship.dataset2) {
                        ctrl.relationship.timeIndexMode = AutoFeatureGenerationRecipeService.TIME_INDEX_MODE.DEFAULT.name;
                    }
                    previousSelectedDataset2 = ctrl.relationship.dataset2;

                }
                if (ctrl.relationship.dataset1 !== previousSelectedDataset1) {
                    isPrimaryDatasetValid(ctrl.relationship.dataset1);
                    previousSelectedDataset1 = ctrl.relationship.dataset1;
                }
            }

        }
    };

    angular.module('dataiku.autoFeatureGeneration').component("datasetModalBody", datasetModalBody);
})();
