(function () {
  "use strict";

    angular.module("dataiku.homepage").factory("homepageService", homepageService);

    function homepageService(DataikuAPI, $rootScope, CreateModalFromTemplate, ProjectFolderContext) {

        let myItemsController = null;

        let myItemsListenerDestroyer = $rootScope.$on("myItemsUpdated", (evt, data) => {
            if (myItemsController) {
                myItemsController.myItems = data;
                myItemsController.updateDisplayedItems();
            }
        })

        $rootScope.$on('$destroy', function() {
            myItemsListenerDestroyer();
        });

        function registerMyItemsController(controller) {
            myItemsController = controller;
        }

        function fetchMyItems() {
            $rootScope.$broadcast("updateMyItems");
        }

        function broadcastRepaint() {
            $rootScope.$broadcast('repaintFatTable');
        }

        function newProject($scope) {
            CreateModalFromTemplate("/templates/projects/new-project.html", $scope, "NewProjectController", (modalScope) => {
                modalScope.setCurrentProjectFolderId(ProjectFolderContext.getCurrentProjectFolderId());
            });
        };

        function newProjectFromMacro($scope, runnable) {
             CreateModalFromTemplate('/templates/macros/runnable-modal.html', $scope, null, function(newScope) {
                newScope.runnable = runnable;
                newScope.mode = "PROJECT_CREATION";
            });
        }

        function newTutorial($scope) {
            CreateModalFromTemplate("/templates/projects/tutorials-samples.html", $scope, "NewLearningProjectController", function (newScope) {
                newScope.setCurrentProjectFolderId(ProjectFolderContext.getCurrentProjectFolderId());
                newScope.modalTitle = 'Learning projects';
                newScope.attachDownloadTo = $scope;
            }, true);
        };

        function newIndustrySolution($scope) {
            CreateModalFromTemplate("/templates/projects/new-solution.html", $scope, "NewSolutionProjectController", function (newScope) {
                newScope.setCurrentProjectFolderId(ProjectFolderContext.getCurrentProjectFolderId());
                newScope.attachDownloadTo = $scope;
            }, true);
        };

        function importProject($scope) {
            CreateModalFromTemplate("/templates/projects/import-project.html", $scope, "ImportProjectController", (newScope) => {
                newScope.setCurrentProjectFolderId(ProjectFolderContext.getCurrentProjectFolderId());
            });
        };

        const homepageService = {
            registerMyItemsController: registerMyItemsController,
            fetchMyItems: fetchMyItems,
            broadcastRepaint: broadcastRepaint,
            newProject,
            newProjectFromMacro,
            newTutorial,
            newIndustrySolution,
            importProject,
        };

    return homepageService;
  }
})();
