(function(){
    'use strict';

    const FACET_FIELDS_DISPLAY_NAMES = {
        'OBJECT_PROJECT_KEY': 'Project',
        'OBJECT_TYPE': 'Object type',
        'STATUS': 'Status'
    };

    const requestFilter = {
        bindings: {
            aggregations: '<',
            selectedFacets: '<',
            onUpdate: '&'
        },
        templateUrl: '/static/dataiku/inbox/components/request-center/request-filter/request-filter.component.html',
        controller: function($filter){
            const ctrl = this;
            ctrl.facetsShowAll = {};


            ctrl.$onChanges = function(changes){
                if(changes.selectedFacets){
                    ctrl.selectedFacets = angular.copy(ctrl.selectedFacets);
                }
                if (changes.aggregations) {
                    // sort aggregation values by number of hit in descending order for this option then alphabetically
                    ctrl.sortedAggregations = {};
                    for(let key in ctrl.aggregations) {
                        const sortedValues = [...ctrl.aggregations[key]].sort((a, b) => b.value - a.value || a.key.localeCompare(b.key));
                        ctrl.sortedAggregations[key] = sortedValues;
                    }
                }
            }

            ctrl.updateFilter = function(){
                ctrl.onUpdate({
                    $event: {
                        selectedFacets: ctrl.selectedFacets
                    }
                })
            }

            ctrl.formatFacetField = function(field){
                return FACET_FIELDS_DISPLAY_NAMES[field];
            }

            ctrl.formatFacetValue = function(value, facet) {
                if (facet === 'STATUS') {
                    switch (value) {
                        case "PENDING":
                            return 'Pending requests';
                        case "APPROVED":
                            return 'Approved requests';
                        case "REJECTED":
                            return 'Rejected requests';
                        default:
                            return value;
                    }
                }
                if (facet === 'OBJECT_TYPE') {
                    if (value === 'APP') {
                        return 'Application';
                    }
                    if (value === "PROFILE") {
                        return "Profile upgrade";
                    }
                    if (value === "INSTANCE") {
                        return "Instance access";
                    }
                    value = $filter('capitalize')(value.toLowerCase().replace(/_/g, " "));
                }
                return value;
            };

            ctrl.selectFacetElement = function(){
                ctrl.updateFilter();
            }

            ctrl.clearFacetSelection = function(facet){
                ctrl.selectedFacets[facet] = [];
                ctrl.updateFilter();
            }
        }
    }

    angular.module('dataiku.inbox')
    .component('requestFilter', requestFilter);
})();
