(function() {
    'use strict';

    const app = angular.module('dataiku.directives.simple_report');

    app.directive('selectAll', function() {
        return {
          restrict: 'A',
          link: function(scope, element) {
            element.on('keydown', function(event) {
              // Check if Ctrl+A is pressed
              if ((event.ctrlKey || event.metaKey) && event.which === 65) { // ASCII code for 'A'
                event.preventDefault();
                if (event.target) {
                  event.target.select();
                }                
                scope.$apply(); // Update the AngularJS scope if necessary
              }
            });
            
            // Clean up the event listener when the directive is destroyed
            scope.$on('$destroy', function() {
              element.off('keydown');
            });
          }
        };
      });
})();
