(function() {
    'use strict';

    const app = angular.module('dataiku.directives.simple_report');

    /**
     * Service responsible for parsing and errors returned by the backend.
     * (!) This service previously was in static/dataiku/js/simple_report/chart_logic.js
     */
    app.service('ChartSetErrorInScope', function() {
        function buildErrorValidityObject(message, showRevertEngineButton) {
            return {
                message,
                showRevertEngineButton,
                valid: false,
                type: 'COMPUTE_ERROR'
            };
        }

        function buildValidityForKnownError(data, status, headers) {
            const errorDetails = getErrorDetails(data, status, headers);
            if (errorDetails.errorType === 'com.dataiku.dip.pivot.backend.model.SecurityAbortedException') {
                return buildErrorValidityObject('Too many elements to draw. Please adjust chart settings (' + errorDetails.message + ')', false);
            } else if (errorDetails.errorType === 'ApplicativeException') {
                return buildErrorValidityObject(errorDetails.message, false);
            } else if (errorDetails.errorType === 'com.dataiku.dip.exceptions.EngineNotAvailableException') {
                return buildErrorValidityObject(errorDetails.message, true);
            }
            return undefined;
        }

        const svc = {
            buildValidityForKnownError: buildValidityForKnownError,
            defineInScope: function(scope) {
                if ('chartSetErrorInScope' in scope) {
                    return;
                } // already defined in a higher scope
                scope.validity = { valid: true };
                scope.setValidity = function(validity) {
                    scope.validity = validity;
                };
                scope.chartSetErrorInScope = function(data, status, headers) {
                    const validity = buildValidityForKnownError(data, status, headers);
                    if (validity) {
                        scope.validity = validity;
                    } else {
                        setErrorInScope.bind(scope)(data, status, headers);
                    }
                };
            }
        };

        return svc;
    });


})();

// eslint-disable-next-line no-redeclare
function ChartIAE(message) {
    this.message = message;
    this.name = 'ChartIAE';
}

ChartIAE.prototype = new Error;
