(function() {
    'use strict';

    angular.module('dataiku.charts')
        .factory('GroupedColumnsUtils', GroupedColumnsUtils);

    /**
     * (!) This service previously was in static/dataiku/js/simple_report/column-bars/column.js
     */
    function GroupedColumnsUtils(SVGUtils) {
        return {
            prepareData: function(chartDef, chartData, measureFilter, ignoreLabels = new Set()) {
                const xLabels = chartData.getAxisLabels('x');
                const colorLabels = chartData.getAxisLabels('color') || [null];
                const groupsData = [];

                xLabels.forEach(function(xLabel, x) {
                    const columns = [];
                    if (xLabel && ignoreLabels.has(xLabel.label)) {
                        return;
                    }
                    let cIndex = 0;
                    colorLabels.forEach(function(colorLabel, c) {
                        if (colorLabel && ignoreLabels.has(colorLabel.label)) {
                            return;
                        }
                        chartDef.genericMeasures.forEach(function(measure, measureIndex) {
                            if (measureFilter && !measureFilter(measure)) {
                                return;
                            }
                            const measureData = {
                                color: c,
                                measure: measureIndex,
                                x: x,
                                colorScaleIndex: cIndex
                            };

                            const subTextElementsData = SVGUtils.getLabelSubTexts(chartDef, measureIndex, measure.valuesInChartDisplayOptions, false).map(function(subTextElementData) {
                                return {
                                    ...subTextElementData,
                                    // add measure data at sub text level also, to retrieve it easily
                                    ...measureData
                                };
                            });
                            columns.push({
                                ...measureData,
                                textsElements: subTextElementsData,
                                valuesInChartDisplayOptions: measure.valuesInChartDisplayOptions
                            });
                        });
                        cIndex++;
                    });
                    groupsData.push({ x: x, columns: columns });
                });

                return groupsData;
            }
        };
    }
})();
