/* global describe, it, beforeEach, ChartFeaturesTestUtils */

describe('chart features stacked_areas', function () {

    const chartType = 'stacked_area';

    /* Get tests helpers */
    const { expectIdToBeVisible, expectIdToBeHidden, renderTemplate } = ChartFeaturesTestUtils;

    describe('variant normal', function () {

        const chartVariant = 'normal';

        /* Initialize each test */
        beforeEach(() => {
            ChartFeaturesTestUtils.initEachTest();
            ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
        });

        it('doesn\'t have along dimension option with compute mode NORMAL', function () {
            ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'NORMAL', false);
        })
    
        it('has along dimension option with compute mode PERCENTAGE', function () {
            ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'PERCENTAGE');
        })
    
        it('has along dimension option with compute mode CUMULATIVE_PERCENTAGE', function () {
            ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'CUMULATIVE_PERCENTAGE');
        })
    
        it('doesn\'t have along dimension option with compute mode CUMULATIVE', function () {
            ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'CUMULATIVE', false);
        })
    
        it('has along dimension option with compute mode AVG_RATIO', function () {
            ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'AVG_RATIO');
        })

        it('doesn\'t have regression line options', function () {
            renderTemplate(`/templates/simple_report/types/options-${chartType}.html`);
            expectIdToBeHidden('qa_charts_regression-line-form');
        })
    
    });

    describe('variant stacked_100', function () {

        const chartVariant = 'stacked_100';

        /* Initialize each test */
        beforeEach(() => {
            ChartFeaturesTestUtils.initEachTest();
            ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
        });

        it('doesn\'t have along dimension option with compute mode NORMAL', function () {
            ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'NORMAL', false);
        })
    
        it('has along dimension option with compute mode PERCENTAGE', function () {
            ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'PERCENTAGE');
        })
    
        it('has along dimension option with compute mode CUMULATIVE_PERCENTAGE', function () {
            ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'CUMULATIVE_PERCENTAGE');
        })
    
        it('doesn\'t have along dimension option with compute mode CUMULATIVE', function () {
            ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'CUMULATIVE', false);
        })
    
        it('has along dimension option with compute mode AVG_RATIO', function () {
            ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'AVG_RATIO');
        })

        it('doesn\'t have regression line options', function () {
            renderTemplate(`/templates/simple_report/types/options-${chartType}.html`);
            expectIdToBeHidden('qa_charts_regression-line-form');
        })
    
    });
});
