import json
import logging

from .json_writer_common import AzureMLJSONWriter

logger = logging.getLogger(__name__)


class AzureMLJSONWriterInputDataShapedWithColumnsAndData(AzureMLJSONWriter):
    NAME = "INPUT_AZUREML_JSON_INPUTDATA_DATA"

    def __init__(self, client):
        super(AzureMLJSONWriterInputDataShapedWithColumnsAndData, self).__init__(client)

    def build_request_payload(self, input_df):
        payload = {
            "input_data": {
                "columns": list(input_df.columns),
                "data": input_df.values.tolist()
            }
        }
        payload = json.dumps(payload)
        return payload
