from govern.models import Artifact, EnrichedArtifact
import copy

class Handler:
    def __init__(self, hookPhase, newEnrichedArtifact, existingEnrichedArtifact, client):
        """
        Instantiate a new Govern hook handler.

        :param str hookPhase: The hook phase: CREATE, DELETE or UPDATE
        :param dict newEnrichedArtifact: With hookPhase CREATE or UPDATE, a Python dict of the artifact to create/update. None if DELETE.
        :param dict existingEnrichedArtifact: With hookPhase UPDATE or DELETE, a Python dict of the artifact before update/deletion. None if CREATE.
        :param :class:`~dataikuapi.govern_client.GovernClient` client: An instance of :class:`~dataikuapi.govern_client.GovernClient` to access the Govern API
        """

        self.hookPhase = hookPhase
        self.artifact = Artifact(copy.deepcopy(newEnrichedArtifact['artifact'])) if newEnrichedArtifact is not None and 'artifact' in newEnrichedArtifact else None
        self.newEnrichedArtifact = EnrichedArtifact(newEnrichedArtifact) if newEnrichedArtifact is not None else None
        self.existingEnrichedArtifact = EnrichedArtifact(existingEnrichedArtifact) if existingEnrichedArtifact is not None else None
        self.client = client
        self.fieldMessages = {}
        self.message = ''
        self.artifactIdsToUpdate = []
        self.status = 'SUCCESS'

instance = None

def get_handler():
    """
    Return the current instance of :class:`govern.core.Handler`,
    previously set using :meth:`set_handler`

    :return: the instance of :class:`govern.core.Handler` that was previously set with :meth:`set_handler`
    """
    if instance is not None:
        return instance
    raise Exception("Handler not set")

def set_handler(handler):
    """
    Set the current instance of :class:`govern.core.Handler`

    :return: None
    """
    global instance
    instance = handler
