#' Retrieves data from a path in a managed folder
#'
#' @param name the id of the folder
#' @param path the path in the folder to retrieve
#' @param as desired type of output: \code{raw}, \code{text} or
#'   \code{parsed}. this attempts to automatically figure out which one is most appropriate, based on the content-type.
#'   See \code{httr::content} documentation for more details.
#' @return
#' For "raw", a raw vector.
#'
#' For "text", a character vector of length 1. The character vector is always
#' re-encoded to UTF-8. If this encoding fails (usually because the page
#' declares an incorrect encoding), this method will return \code{NA}.
#'
#' For "parsed", a parsed R object.
#' See \code{httr::content} documentation for more information
#'
#' @export
#' @importFrom httr POST
dkuManagedFolderDownloadPath <- function(name, path, as = NULL) {
    getPathURL = dku_intercom__get_jek_or_backend_url("/managed-folders/download-path")
    ref = dku__resolve_smart_name(name)

    resp = POST(getPathURL,body = list(projectKey=dku__ref_to_pkey(ref), lookup=dku__ref_to_name(ref), path=path),
        encode="form",  dku__get_auth_headers(), dku_intercom__get_httr_config())

    dku__check_api_error(resp, "Failed to download Box path")
    
    return(content(resp, as=as))
}
