/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.metastore;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.glue.catalog.metastore.AWSCredentialsProviderFactory;
import com.amazonaws.glue.catalog.metastore.AWSGlueMultipleCatalogDecorator;
import com.amazonaws.glue.catalog.metastore.DefaultAWSCredentialsProviderFactory;
import com.amazonaws.glue.catalog.metastore.GlueClientFactory;
import com.amazonaws.glue.catalog.metastore.LakeFormationCredentialsProviderFactory;
import com.amazonaws.glue.catalog.util.MetastoreClientUtils;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.glue.AWSGlue;
import com.amazonaws.services.glue.AWSGlueClientBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.log4j.Logger;

public final class AWSGlueClientFactory
implements GlueClientFactory {
    private static final Logger logger = Logger.getLogger(AWSGlueClientFactory.class);
    private final Configuration conf;

    public AWSGlueClientFactory(Configuration conf) {
        Preconditions.checkNotNull((Object)conf, (Object)"Configuration cannot be null");
        this.conf = conf;
    }

    @Override
    public AWSGlue newClient() throws MetaException {
        try {
            AWSGlueClientBuilder glueClientBuilder = (AWSGlueClientBuilder)AWSGlueClientBuilder.standard().withCredentials(this.getAWSCredentialsProvider(this.conf));
            String regionStr = AWSGlueClientFactory.getProperty("aws.region", this.conf);
            String glueEndpoint = AWSGlueClientFactory.getProperty("aws.glue.endpoint", this.conf);
            if (StringUtils.isNotBlank((CharSequence)glueEndpoint)) {
                logger.info((Object)("Setting glue service endpoint to " + glueEndpoint));
                glueClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(glueEndpoint, null));
            } else if (StringUtils.isNotBlank((CharSequence)regionStr)) {
                logger.info((Object)("Setting region to : " + regionStr));
                glueClientBuilder.setRegion(regionStr);
            } else {
                Region currentRegion = Regions.getCurrentRegion();
                if (currentRegion != null) {
                    logger.info((Object)("Using region from ec2 metadata : " + currentRegion.getName()));
                    glueClientBuilder.setRegion(currentRegion.getName());
                } else {
                    logger.info((Object)"No region info found, using SDK default region: us-east-1");
                }
            }
            glueClientBuilder.setClientConfiguration(this.buildClientConfiguration(this.conf));
            return this.decorateGlueClient((AWSGlue)glueClientBuilder.build());
        }
        catch (Exception e) {
            String message = "Unable to build AWSGlueClient: " + e;
            logger.error((Object)message);
            throw new MetaException(message);
        }
    }

    private AWSGlue decorateGlueClient(AWSGlue originalGlueClient) {
        if (Strings.isNullOrEmpty((String)AWSGlueClientFactory.getProperty("aws.glue.catalog.separator", this.conf))) {
            return originalGlueClient;
        }
        return new AWSGlueMultipleCatalogDecorator(originalGlueClient, AWSGlueClientFactory.getProperty("aws.glue.catalog.separator", this.conf));
    }

    @VisibleForTesting
    AWSCredentialsProvider getAWSCredentialsProvider(Configuration conf) {
        if (MetastoreClientUtils.isLakeFormationCatalog(conf)) {
            return new LakeFormationCredentialsProviderFactory().buildAWSCredentialsProvider(conf);
        }
        Class<AWSCredentialsProviderFactory> providerFactoryClass = conf.getClass("aws.catalog.credentials.provider.factory.class", DefaultAWSCredentialsProviderFactory.class).asSubclass(AWSCredentialsProviderFactory.class);
        AWSCredentialsProviderFactory provider = (AWSCredentialsProviderFactory)ReflectionUtils.newInstance(providerFactoryClass, (Configuration)conf);
        return provider.buildAWSCredentialsProvider(conf);
    }

    private String createUserAgent() {
        try {
            String ugi = UserGroupInformation.getCurrentUser().getUserName();
            return "ugi=" + ugi;
        }
        catch (IOException e) {
            logger.error((Object)("Unable to resolve current user name " + e.getMessage()));
            throw new RuntimeException(e);
        }
    }

    private ClientConfiguration buildClientConfiguration(Configuration conf) {
        ClientConfiguration clientConfiguration = new ClientConfiguration().withUserAgent(this.createUserAgent()).withMaxErrorRetry(conf.getInt("aws.glue.max-error-retries", 5)).withMaxConnections(conf.getInt("aws.glue.max-connections", 50)).withConnectionTimeout(conf.getInt("aws.glue.connection-timeout", 10000)).withSocketTimeout(conf.getInt("aws.glue.socket-timeout", 50000));
        return clientConfiguration;
    }

    private static String getProperty(String propertyName, Configuration conf) {
        return Strings.isNullOrEmpty((String)System.getProperty(propertyName)) ? conf.get(propertyName) : System.getProperty(propertyName);
    }
}

