/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.rdd.RDD;

public class JavaKMeansExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaKMeansExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        String path = "data/mllib/kmeans_data.txt";
        JavaRDD data = jsc.textFile(path);
        JavaRDD parsedData = data.map((Function & Serializable)s -> {
            String[] sarray = s.split(" ");
            double[] values = new double[sarray.length];
            for (int i = 0; i < sarray.length; ++i) {
                values[i] = Double.parseDouble(sarray[i]);
            }
            return Vectors.dense((double[])values);
        });
        parsedData.cache();
        int numClusters = 2;
        int numIterations = 20;
        KMeansModel clusters = KMeans.train((RDD)parsedData.rdd(), (int)numClusters, (int)numIterations);
        System.out.println("Cluster centers:");
        for (Vector center : clusters.clusterCenters()) {
            System.out.println(" " + center);
        }
        double cost = clusters.computeCost(parsedData.rdd());
        System.out.println("Cost: " + cost);
        double WSSSE = clusters.computeCost(parsedData.rdd());
        System.out.println("Within Set Sum of Squared Errors = " + WSSSE);
        clusters.save(jsc.sc(), "target/org/apache/spark/JavaKMeansExample/KMeansModel");
        KMeansModel sameModel = KMeansModel.load((SparkContext)jsc.sc(), (String)"target/org/apache/spark/JavaKMeansExample/KMeansModel");
        jsc.stop();
    }
}

