/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class InstanceBlock$
implements scala.Serializable {
    public static InstanceBlock$ MODULE$;
    private final double DefaultBlockSizeInMB;

    static {
        new InstanceBlock$();
    }

    public double DefaultBlockSizeInMB() {
        return this.DefaultBlockSizeInMB;
    }

    public long org$apache$spark$ml$feature$InstanceBlock$$getBlockMemUsage(long numCols, long numRows, long nnz, boolean allUnitWeight) {
        int doubleBytes = 8;
        long arrayHeader = 12L;
        long denseSize = Matrices$.MODULE$.getDenseSize(numCols, numRows);
        long sparseSize = Matrices$.MODULE$.getSparseSize(nnz, numRows + 1L);
        long matrixSize = package$.MODULE$.min(denseSize, sparseSize);
        if (allUnitWeight) {
            return matrixSize + (long)doubleBytes * numRows + arrayHeader * 2L;
        }
        return matrixSize + (long)doubleBytes * numRows * 2L + arrayHeader * 2L;
    }

    public InstanceBlock fromInstances(Seq<Instance> instances) {
        double[] labels = (double[])((TraversableOnce)instances.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.label()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        double[] weights = instances.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)InstanceBlock$.$anonfun$fromInstances$2(x$4))) ? (double[])((TraversableOnce)instances.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5.weight()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()) : Array$.MODULE$.emptyDoubleArray();
        Matrix matrix = Matrices$.MODULE$.fromVectors((Seq)instances.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.features(), Seq$.MODULE$.canBuildFrom()));
        return new InstanceBlock(labels, weights, matrix);
    }

    public RDD<InstanceBlock> blokify(RDD<Instance> instances, int blockSize) {
        return instances.mapPartitions((Function1 & Serializable & scala.Serializable)x$7 -> x$7.grouped(blockSize).map((Function1 & Serializable & scala.Serializable)instances -> MODULE$.fromInstances((Seq<Instance>)instances)), instances.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InstanceBlock.class));
    }

    public Iterator<InstanceBlock> blokifyWithMaxMemUsage(Iterator<Instance> instanceIterator, long maxMemUsage) {
        Predef$.MODULE$.require(maxMemUsage > 0L);
        return new Iterator<InstanceBlock>(instanceIterator, maxMemUsage){
            private long numCols;
            private final Iterator instanceIterator$1;
            private final long maxMemUsage$1;

            public Iterator<InstanceBlock> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<InstanceBlock> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<InstanceBlock> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<InstanceBlock> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<InstanceBlock> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<InstanceBlock, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<InstanceBlock, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<InstanceBlock> filter(Function1<InstanceBlock, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<InstanceBlock, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<InstanceBlock> withFilter(Function1<InstanceBlock, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<InstanceBlock> filterNot(Function1<InstanceBlock, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<InstanceBlock, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, InstanceBlock, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<InstanceBlock, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<InstanceBlock> takeWhile(Function1<InstanceBlock, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<InstanceBlock>, Iterator<InstanceBlock>> partition(Function1<InstanceBlock, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<InstanceBlock>, Iterator<InstanceBlock>> span(Function1<InstanceBlock, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<InstanceBlock> dropWhile(Function1<InstanceBlock, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<InstanceBlock, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<InstanceBlock, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<InstanceBlock, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<InstanceBlock, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<InstanceBlock, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<InstanceBlock> find(Function1<InstanceBlock, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<InstanceBlock, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<InstanceBlock, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<InstanceBlock> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<InstanceBlock>, Iterator<InstanceBlock>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<InstanceBlock> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<InstanceBlock> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<InstanceBlock> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<InstanceBlock> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<InstanceBlock, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<InstanceBlock, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, InstanceBlock, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<InstanceBlock, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, InstanceBlock, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<InstanceBlock, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, InstanceBlock, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<InstanceBlock, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, InstanceBlock, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<InstanceBlock, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, InstanceBlock, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<InstanceBlock> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<InstanceBlock> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<InstanceBlock> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<InstanceBlock> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<InstanceBlock> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, InstanceBlock, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<InstanceBlock, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private long numCols() {
                return this.numCols;
            }

            private void numCols_$eq(long x$1) {
                this.numCols = x$1;
            }

            public boolean hasNext() {
                return this.instanceIterator$1.hasNext();
            }

            public InstanceBlock next() {
                ArrayBuilder buff = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Instance.class));
                long buffCnt = 0L;
                long buffNnz = 0L;
                boolean buffUnitWeight = true;
                long blockMemUsage = 0L;
                while (this.instanceIterator$1.hasNext() && blockMemUsage < this.maxMemUsage$1) {
                    Instance instance = (Instance)this.instanceIterator$1.next();
                    if (this.numCols() < 0L) {
                        this.numCols_$eq(instance.features().size());
                    }
                    Predef$.MODULE$.require(this.numCols() == (long)instance.features().size());
                    buff.$plus$eq((Object)instance);
                    buffUnitWeight = buffUnitWeight && instance.weight() == 1.0;
                    blockMemUsage = InstanceBlock$.MODULE$.org$apache$spark$ml$feature$InstanceBlock$$getBlockMemUsage(this.numCols(), ++buffCnt, buffNnz += (long)instance.features().numNonzeros(), buffUnitWeight);
                }
                return InstanceBlock$.MODULE$.fromInstances((Seq<Instance>)Predef$.MODULE$.wrapRefArray((Object[])buff.result()));
            }
            {
                this.instanceIterator$1 = instanceIterator$1;
                this.maxMemUsage$1 = maxMemUsage$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.numCols = -1L;
            }
        };
    }

    public RDD<InstanceBlock> blokifyWithMaxMemUsage(RDD<Instance> instances, long maxMemUsage) {
        Predef$.MODULE$.require(maxMemUsage > 0L);
        return instances.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> MODULE$.blokifyWithMaxMemUsage((Iterator<Instance>)iter, maxMemUsage), instances.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InstanceBlock.class));
    }

    public InstanceBlock apply(double[] labels, double[] weights, Matrix matrix) {
        return new InstanceBlock(labels, weights, matrix);
    }

    public Option<Tuple3<double[], double[], Matrix>> unapply(InstanceBlock x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.labels(), (Object)x$0.weights(), (Object)x$0.matrix()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$fromInstances$2(Instance x$4) {
        return x$4.weight() != 1.0;
    }

    private InstanceBlock$() {
        MODULE$ = this;
        this.DefaultBlockSizeInMB = 1.0;
    }
}

