/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.managedcommit;

import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.delta.managedcommit.Commit;
import org.apache.spark.sql.delta.managedcommit.CommitFailedException;
import org.apache.spark.sql.delta.managedcommit.CommitOwnerClient;
import org.apache.spark.sql.delta.managedcommit.CommitResponse;
import org.apache.spark.sql.delta.managedcommit.UpdatedActions;
import org.apache.spark.sql.delta.storage.ClosableIterator;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.util.FileNames$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dea\u0002\b\u0010!\u0003\r\t\u0001\b\u0005\u0006[\u0001!\tA\f\u0005\be\u0001\u0011\rQ\"\u00014\u0011\u00199\u0004A\"\u0001\u0012q!)q\u000e\u0001C!a\"9\u0011Q\u0002\u0001\u0005\u0012\u0005=\u0001bBA\u000e\u0001\u0011%\u0011Q\u0004\u0005\b\u0003S\u0001A\u0011CA\u0016\u0011\u001d\ti\u0003\u0001C!\u0003_A\u0011\"a\u0012\u0001#\u0003%\t!!\u0013\t\u0013\u0005}\u0003!%A\u0005\u0002\u0005\u0005\u0004bBA3\u0001\u0011E\u0011q\r\u0005\t\u0003o\u0002a\u0011C\t\u0002z!9\u0011\u0011\u0011\u0001\u0005\u0012\u0005\r%!K!cgR\u0014\u0018m\u0019;CCR\u001c\u0007NQ1dW\u001aLG\u000e\\5oO\u000e{W.\\5u\u001f^tWM]\"mS\u0016tGO\u0003\u0002\u0011#\u0005iQ.\u00198bO\u0016$7m\\7nSRT!AE\n\u0002\u000b\u0011,G\u000e^1\u000b\u0005Q)\u0012aA:rY*\u0011acF\u0001\u0006gB\f'o\u001b\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001i2e\n\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011*S\"A\b\n\u0005\u0019z!!E\"p[6LGoT<oKJ\u001cE.[3oiB\u0011\u0001fK\u0007\u0002S)\u0011!&F\u0001\tS:$XM\u001d8bY&\u0011A&\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0019!\u0013N\\5uIQ\tq\u0006\u0005\u0002\u001fa%\u0011\u0011g\b\u0002\u0005+:LG/A\u0005cCR\u001c\u0007nU5{KV\tA\u0007\u0005\u0002\u001fk%\u0011ag\b\u0002\u0005\u0019>tw-\u0001\u0006d_6l\u0017\u000e^%na2$\u0002\"\u000f\u001fE\u001dZ3\u0007.\u001c\t\u0003IiJ!aO\b\u0003\u001d\r{W.\\5u%\u0016\u001c\bo\u001c8tK\")Qh\u0001a\u0001}\u0005AAn\\4Ti>\u0014X\r\u0005\u0002@\u00056\t\u0001I\u0003\u0002B#\u000591\u000f^8sC\u001e,\u0017BA\"A\u0005!aunZ*u_J,\u0007\"B#\u0004\u0001\u00041\u0015A\u00035bI>|\u0007oQ8oMB\u0011q\tT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0005G>tgM\u0003\u0002L/\u00051\u0001.\u00193p_BL!!\u0014%\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015y5\u00011\u0001Q\u0003\u001dawn\u001a)bi\"\u0004\"!\u0015+\u000e\u0003IS!a\u0015&\u0002\u0005\u0019\u001c\u0018BA+S\u0005\u0011\u0001\u0016\r\u001e5\t\u000b]\u001b\u0001\u0019\u0001-\u0002-5\fg.Y4fI\u000e{W.\\5u)\u0006\u0014G.Z\"p]\u001a\u0004B!\u00171dG:\u0011!L\u0018\t\u00037~i\u0011\u0001\u0018\u0006\u0003;n\ta\u0001\u0010:p_Rt\u0014BA0 \u0003\u0019\u0001&/\u001a3fM&\u0011\u0011M\u0019\u0002\u0004\u001b\u0006\u0004(BA0 !\tIF-\u0003\u0002fE\n11\u000b\u001e:j]\u001eDQaZ\u0002A\u0002Q\nQbY8n[&$h+\u001a:tS>t\u0007\"B5\u0004\u0001\u0004Q\u0017AC2p[6LGOR5mKB\u0011\u0011k[\u0005\u0003YJ\u0013!BR5mKN#\u0018\r^;t\u0011\u0015q7\u00011\u00015\u0003=\u0019w.\\7jiRKW.Z:uC6\u0004\u0018AB2p[6LG\u000fF\u0005:cJ\u001cH/\u001e<\u0002\u0004!)Q\b\u0002a\u0001}!)Q\t\u0002a\u0001\r\")q\n\u0002a\u0001!\")q\u000b\u0002a\u00011\")q\r\u0002a\u0001i!)q\u000f\u0002a\u0001q\u00069\u0011m\u0019;j_:\u001c\bcA=\u007fG:\u0011!\u0010 \b\u00037nL\u0011\u0001I\u0005\u0003{~\tq\u0001]1dW\u0006<W-C\u0002\u0000\u0003\u0003\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003{~Aq!!\u0002\u0005\u0001\u0004\t9!\u0001\bva\u0012\fG/\u001a3BGRLwN\\:\u0011\u0007\u0011\nI!C\u0002\u0002\f=\u0011a\"\u00169eCR,G-Q2uS>t7/A\bxe&$XmQ8n[&$h)\u001b7f)-Q\u0017\u0011CA\n\u0003+\t9\"!\u0007\t\u000bu*\u0001\u0019\u0001 \t\u000b\u0015+\u0001\u0019\u0001$\t\u000b=+\u0001\u0019\u0001)\t\u000b\u001d,\u0001\u0019\u0001\u001b\t\u000b],\u0001\u0019\u0001=\u0002;%\u001cX*\u00198bO\u0016$7i\\7nSR$vNR*D_:4XM]:j_:$b!a\b\u0002&\u0005\u001d\u0002c\u0001\u0010\u0002\"%\u0019\u00111E\u0010\u0003\u000f\t{w\u000e\\3b]\")qM\u0002a\u0001i!9\u0011Q\u0001\u0004A\u0002\u0005\u001d\u0011\u0001D4f]\u0016\u0014\u0018\r^3V+&#E#A2\u0002#\t\f7m\u001b4jY2$vNV3sg&|g\u000eF\u00070\u0003c\t\u0019$!\u000e\u00028\u0005e\u0012Q\b\u0005\u0006{!\u0001\rA\u0010\u0005\u0006\u000b\"\u0001\rA\u0012\u0005\u0006\u001f\"\u0001\r\u0001\u0015\u0005\u0006/\"\u0001\r\u0001\u0017\u0005\t\u0003wA\u0001\u0013!a\u0001i\u0005a1\u000f^1siZ+'o]5p]\"I\u0011q\b\u0005\u0011\u0002\u0003\u0007\u0011\u0011I\u0001\u000eK:$g+\u001a:tS>tw\n\u001d;\u0011\ty\t\u0019\u0005N\u0005\u0004\u0003\u000bz\"AB(qi&|g.A\u000ecC\u000e\\g-\u001b7m)>4VM]:j_:$C-\u001a4bk2$H%N\u000b\u0003\u0003\u0017R3\u0001NA'W\t\ty\u0005\u0005\u0003\u0002R\u0005mSBAA*\u0015\u0011\t)&a\u0016\u0002\u0013Ut7\r[3dW\u0016$'bAA-?\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00131\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u00072bG.4\u0017\u000e\u001c7U_Z+'o]5p]\u0012\"WMZ1vYR$c'\u0006\u0002\u0002d)\"\u0011\u0011IA'\u0003!\u0011\u0017mY6gS2dGcC\u0018\u0002j\u0005-\u0014QNA8\u0003gBQ!P\u0006A\u0002yBQ!R\u0006A\u0002\u0019CQaT\u0006A\u0002ACa!!\u001d\f\u0001\u0004!\u0014a\u0002<feNLwN\u001c\u0005\u0007\u0003kZ\u0001\u0019\u00016\u0002\u0015\u0019LG.Z*uCR,8/\u0001\tsK\u001eL7\u000f^3s\u0005\u0006\u001c7NZ5mYR)q&a\u001f\u0002~!)q\n\u0004a\u0001!\"1\u0011q\u0010\u0007A\u0002Q\n\u0011CY1dW\u001aLG\u000e\\3e-\u0016\u00148/[8o\u000319W\r\u001e+bE2,\u0007+\u0019;i)\r\u0001\u0016Q\u0011\u0005\u0006\u001f6\u0001\r\u0001\u0015")
public interface AbstractBatchBackfillingCommitOwnerClient
extends CommitOwnerClient,
Logging {
    public long batchSize();

    public CommitResponse commitImpl(LogStore var1, Configuration var2, Path var3, Map<String, String> var4, long var5, FileStatus var7, long var8);

    public static /* synthetic */ CommitResponse commit$(AbstractBatchBackfillingCommitOwnerClient $this, LogStore logStore, Configuration hadoopConf, Path logPath, Map managedCommitTableConf, long commitVersion, Iterator actions, UpdatedActions updatedActions) {
        return $this.commit(logStore, hadoopConf, logPath, (Map<String, String>)managedCommitTableConf, commitVersion, (Iterator<String>)actions, updatedActions);
    }

    @Override
    default public CommitResponse commit(LogStore logStore, Configuration hadoopConf, Path logPath, Map<String, String> managedCommitTableConf, long commitVersion, Iterator<String> actions, UpdatedActions updatedActions) {
        Path tablePath = this.getTablePath(logPath);
        if (commitVersion == 0L) {
            throw new CommitFailedException(false, false, "Commit version 0 must go via filesystem.");
        }
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Attempting to commit version ").append(commitVersion).append(" on table ").append(tablePath).toString());
        FileSystem fs = logPath.getFileSystem(hadoopConf);
        if (this.batchSize() <= 1L) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Making sure commits are backfilled until ").append(commitVersion).append(" version for").append(" table ").append(tablePath.toString()).toString());
            this.backfillToVersion(logStore, hadoopConf, logPath, managedCommitTableConf, this.backfillToVersion$default$5(), this.backfillToVersion$default$6());
        }
        FileStatus fileStatus = this.writeCommitFile(logStore, hadoopConf, logPath, commitVersion, actions);
        long commitTimestamp = updatedActions.commitInfo().getTimestamp();
        CommitResponse commitResponse = this.commitImpl(logStore, hadoopConf, logPath, managedCommitTableConf, commitVersion, fileStatus, commitTimestamp);
        boolean mcToFsConversion = this.isManagedCommitToFSConversion(commitVersion, updatedActions);
        if (this.batchSize() <= 1L) {
            this.backfill(logStore, hadoopConf, logPath, commitVersion, fileStatus);
            Path targetFile = FileNames$.MODULE$.unsafeDeltaFile(logPath, commitVersion);
            FileStatus targetFileStatus = fs.getFileStatus(targetFile);
            Commit qual$1 = commitResponse.commit();
            FileStatus x$1 = targetFileStatus;
            long x$2 = qual$1.copy$default$1();
            long x$3 = qual$1.copy$default$3();
            Commit newCommit = qual$1.copy(x$2, x$1, x$3);
            commitResponse = commitResponse.copy(newCommit);
        } else if (commitVersion % this.batchSize() == 0L || mcToFsConversion) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Making sure commits are backfilled till ").append(commitVersion).append(" version for").append("table ").append(tablePath.toString()).toString());
            this.backfillToVersion(logStore, hadoopConf, logPath, managedCommitTableConf, this.backfillToVersion$default$5(), this.backfillToVersion$default$6());
        }
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Commit ").append(commitVersion).append(" done successfully on table ").append(tablePath).toString());
        return commitResponse;
    }

    public static /* synthetic */ FileStatus writeCommitFile$(AbstractBatchBackfillingCommitOwnerClient $this, LogStore logStore, Configuration hadoopConf, Path logPath, long commitVersion, Iterator actions) {
        return $this.writeCommitFile(logStore, hadoopConf, logPath, commitVersion, (Iterator<String>)actions);
    }

    default public FileStatus writeCommitFile(LogStore logStore, Configuration hadoopConf, Path logPath, long commitVersion, Iterator<String> actions) {
        String uuidStr = this.generateUUID();
        Path commitPath = FileNames$.MODULE$.unbackfilledDeltaFile(logPath, commitVersion, (Option<String>)new Some((Object)uuidStr));
        logStore.write(commitPath, actions, false, hadoopConf);
        return commitPath.getFileSystem(hadoopConf).getFileStatus(commitPath);
    }

    private boolean isManagedCommitToFSConversion(long commitVersion, UpdatedActions updatedActions) {
        boolean oldMetadataHasManagedCommits = updatedActions.oldMetadata().managedCommitOwnerName().nonEmpty();
        boolean newMetadataHasManagedCommits = updatedActions.newMetadata().managedCommitOwnerName().nonEmpty();
        return oldMetadataHasManagedCommits && !newMetadataHasManagedCommits && commitVersion > 0L;
    }

    public static /* synthetic */ String generateUUID$(AbstractBatchBackfillingCommitOwnerClient $this) {
        return $this.generateUUID();
    }

    default public String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public static /* synthetic */ void backfillToVersion$(AbstractBatchBackfillingCommitOwnerClient $this, LogStore logStore, Configuration hadoopConf, Path logPath, Map managedCommitTableConf, long startVersion, Option endVersionOpt) {
        $this.backfillToVersion(logStore, hadoopConf, logPath, (Map<String, String>)managedCommitTableConf, startVersion, (Option<Object>)endVersionOpt);
    }

    @Override
    default public void backfillToVersion(LogStore logStore, Configuration hadoopConf, Path logPath, Map<String, String> managedCommitTableConf, long startVersion, Option<Object> endVersionOpt) {
        this.getCommits(logPath, managedCommitTableConf, startVersion, endVersionOpt).commits().foreach((Function1 & Serializable & scala.Serializable)commit -> {
            this.backfill(logStore, hadoopConf, logPath, commit.version(), commit.fileStatus());
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void backfill$(AbstractBatchBackfillingCommitOwnerClient $this, LogStore logStore, Configuration hadoopConf, Path logPath, long version, FileStatus fileStatus) {
        $this.backfill(logStore, hadoopConf, logPath, version, fileStatus);
    }

    default public void backfill(LogStore logStore, Configuration hadoopConf, Path logPath, long version, FileStatus fileStatus) {
        Path targetFile = FileNames$.MODULE$.unsafeDeltaFile(logPath, version);
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Backfilling commit ").append(fileStatus.getPath()).append(" to ").append(targetFile.toString()).toString());
        try (ClosableIterator<String> commitContentIterator = logStore.readAsIterator(fileStatus, hadoopConf);){
            try {
                logStore.write(targetFile, commitContentIterator, false, hadoopConf);
                this.registerBackfill(logPath, version);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("The backfilled file ").append(targetFile).append(" already exists.").toString());
            }
        }
    }

    public static /* synthetic */ long backfillToVersion$default$5$(AbstractBatchBackfillingCommitOwnerClient $this) {
        return $this.backfillToVersion$default$5();
    }

    default public long backfillToVersion$default$5() {
        return 0L;
    }

    public static /* synthetic */ Option backfillToVersion$default$6$(AbstractBatchBackfillingCommitOwnerClient $this) {
        return $this.backfillToVersion$default$6();
    }

    default public Option<Object> backfillToVersion$default$6() {
        return None$.MODULE$;
    }

    public void registerBackfill(Path var1, long var2);

    public static /* synthetic */ Path getTablePath$(AbstractBatchBackfillingCommitOwnerClient $this, Path logPath) {
        return $this.getTablePath(logPath);
    }

    default public Path getTablePath(Path logPath) {
        return logPath.getParent();
    }

    public static void $init$(AbstractBatchBackfillingCommitOwnerClient $this) {
    }
}

